/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.model.preproc.DiffAlgorithmUtils;
import ro.amiq.dvt.model.preproc.DiffRegion;
import ro.amiq.dvt.model.preproc.Diff_Match_Patch;
import ro.amiq.dvt.model.preproc.IDiffAlgorithm;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocDiffWrapper;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum GoogleDiffAlgorithm implements IDiffAlgorithm
{
    INSTANCE;


    @Override
    public List<DiffRegion> computeIncrementalDiff(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) throws BadLocationException {
        ArrayList<DiffRegion> regions = new ArrayList<DiffRegion>();
        String pPrevDocumentContent = preprocDiffWrapper.getPPrevDocument().get();
        String pDocumentContent = preprocDiffWrapper.getPDocument().get();
        List<Diff_Match_Patch.Diff> diffs = this.computeDifferences(pPrevDocumentContent, pDocumentContent);
        int offset = 0;
        Diff_Match_Patch.Operation prevOp = null;
        String prevDeletedText = null;
        for (Diff_Match_Patch.Diff diff : diffs) {
            Diff_Match_Patch.Operation op = diff.operation;
            int textLength = diff.text.length();
            if (op == Diff_Match_Patch.Operation.EQUAL) {
                offset += textLength;
                prevOp = op;
                continue;
            }
            if (op == Diff_Match_Patch.Operation.DELETE) {
                int oldEndOffset = this.computeDiffEndOffset(offset, diff.text);
                DiffRegion diffRegion = new DiffRegion(offset, oldEndOffset, -textLength);
                regions.add(diffRegion);
                offset += textLength;
                prevOp = op;
                prevDeletedText = diff.text;
                continue;
            }
            if (prevOp == Diff_Match_Patch.Operation.DELETE) {
                DiffRegion prevRegion = (DiffRegion)regions.get(regions.size() - 1);
                regions.remove(regions.size() - 1);
                int oldStartOffset = prevRegion.getOldStartOffset() + this.computeCommonPrefixLength(prevDeletedText, diff.text);
                int shiftNoOfChars = prevRegion.getShiftNoOfChars() + textLength;
                DiffRegion diffRegion = new DiffRegion(oldStartOffset, prevRegion.getOldEndOffset(), shiftNoOfChars);
                regions.add(diffRegion);
                prevOp = op;
                continue;
            }
            DiffRegion diffRegion = new DiffRegion(offset, offset, textLength);
            regions.add(diffRegion);
            prevOp = op;
        }
        return regions;
    }

    @Override
    public List<PreprocDiffManager.PreprocMacro> computeFullDiff(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) throws BadLocationException {
        ArrayList<PreprocDiffManager.PreprocMacro> regions = new ArrayList<PreprocDiffManager.PreprocMacro>();
        IDocument pDocument = preprocDiffWrapper.getPDocument();
        IDocument gDocument = preprocDiffWrapper.getGDocument();
        DiffAlgorithmUtils.NonEmptyContentWrapper pNonEmptyContentWrapper = DiffAlgorithmUtils.computeNonEmptyStringContent(pDocument.get());
        DiffAlgorithmUtils.NonEmptyContentWrapper gNonEmptyContentWrapper = DiffAlgorithmUtils.computeNonEmptyStringContent(gDocument.get());
        List<Diff_Match_Patch.Diff> diffs = this.computeDifferences(pNonEmptyContentWrapper.getContent(), gNonEmptyContentWrapper.getContent());
        String lineSeparator = DVTStringUtil.LINE_SEPARATOR;
        int pNonEmptyLineIndex = 0;
        int gNonEmptyLineIndex = 0;
        Diff_Match_Patch.Operation prevOp = null;
        for (Diff_Match_Patch.Diff diff : diffs) {
            int pStartOffset;
            Diff_Match_Patch.Operation op = diff.operation;
            List<String> diffTextLines = Arrays.asList(diff.text.split(lineSeparator));
            int noDiffLines = diffTextLines.size();
            if (op == Diff_Match_Patch.Operation.EQUAL) {
                pNonEmptyLineIndex += noDiffLines;
                gNonEmptyLineIndex += noDiffLines;
                prevOp = op;
                continue;
            }
            int pEndOffset = pStartOffset = this.computeStartOffset(pDocument, pNonEmptyContentWrapper.getIndexMap(), pNonEmptyLineIndex, pNonEmptyContentWrapper.getNumberOfLines());
            int gStartOffset = this.computeStartOffset(gDocument, gNonEmptyContentWrapper.getIndexMap(), gNonEmptyLineIndex, gNonEmptyContentWrapper.getNumberOfLines());
            if (op == Diff_Match_Patch.Operation.DELETE) {
                pEndOffset = this.computeEndOffset(pDocument, pNonEmptyContentWrapper.getIndexMap(), pNonEmptyLineIndex, pNonEmptyContentWrapper.getNumberOfLines(), noDiffLines);
                PreprocDiffManager.PreprocMacro pRegion = new PreprocDiffManager.PreprocMacro(pStartOffset, pEndOffset, "", gStartOffset, gStartOffset);
                regions.add(pRegion);
                prevOp = op;
                pNonEmptyLineIndex += noDiffLines;
                continue;
            }
            if (prevOp == Diff_Match_Patch.Operation.DELETE) {
                PreprocDiffManager.PreprocMacro prevRegion = (PreprocDiffManager.PreprocMacro)regions.get(regions.size() - 1);
                regions.remove(regions.size() - 1);
                pStartOffset = prevRegion.getPStartOffset();
                pEndOffset = prevRegion.getPEndOffset();
            }
            int gEndOffset = this.computeEndOffset(gDocument, gNonEmptyContentWrapper.getIndexMap(), gNonEmptyLineIndex, gNonEmptyContentWrapper.getNumberOfLines(), noDiffLines);
            String gReplacement = gDocument.get(gStartOffset, gEndOffset - gStartOffset);
            PreprocDiffManager.PreprocMacro pRegion = new PreprocDiffManager.PreprocMacro(pStartOffset, pEndOffset, gReplacement, gStartOffset, gEndOffset);
            regions.add(pRegion);
            prevOp = op;
            gNonEmptyLineIndex += noDiffLines;
        }
        return regions;
    }

    private List<Diff_Match_Patch.Diff> computeDifferences(String text1, String text2) {
        Diff_Match_Patch patch = new Diff_Match_Patch();
        Diff_Match_Patch.LinesToCharsResult processedData = patch.diff_linesToChars(text1, text2);
        String processedText1 = processedData.chars1;
        String processedText2 = processedData.chars2;
        List<String> lineArray = processedData.lineArray;
        LinkedList<Diff_Match_Patch.Diff> diffs = patch.diff_main(processedText1, processedText2, false);
        patch.diff_charsToLines(diffs, lineArray);
        return diffs;
    }

    private int computeStartOffset(IDocument document, HashMap<Integer, Integer> indexMap, int nonEmptyLineIndex, int numberOfNonEmptyLines) throws BadLocationException {
        if (nonEmptyLineIndex >= numberOfNonEmptyLines) {
            return document.getLength();
        }
        return document.getLineOffset(indexMap.get(nonEmptyLineIndex).intValue());
    }

    private int computeEndOffset(IDocument document, HashMap<Integer, Integer> indexMap, int nonEmptyLineIndex, int numberOfNonEmptyLines, int noDiffLines) throws BadLocationException {
        if (nonEmptyLineIndex + noDiffLines > numberOfNonEmptyLines) {
            return document.getLength();
        }
        int matchingEndLineIndex = indexMap.get(nonEmptyLineIndex + noDiffLines - 1);
        if (matchingEndLineIndex == document.getNumberOfLines() - 1) {
            return document.getLength();
        }
        return document.getLineOffset(matchingEndLineIndex + 1) - 1;
    }

    private int computeCommonPrefixLength(String text1, String text2) {
        if (text1 == null || text2 == null) {
            return 0;
        }
        int minLength = Math.min(text1.length(), text2.length());
        int similarChars = 0;
        int i = 0;
        while (i < minLength) {
            if (text1.charAt(i) != text2.charAt(i)) break;
            ++similarChars;
            ++i;
        }
        return similarChars;
    }

    private int computeDiffEndOffset(int startOffset, String text) {
        int endOffset = startOffset + text.length();
        if (text.endsWith("\r\n")) {
            return endOffset - 2;
        }
        if (text.endsWith("\r") || text.endsWith("\n")) {
            return endOffset - 1;
        }
        return endOffset;
    }
}

