/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.ParserPath;

public abstract class PreprocConstCommon {
    private static final String INSPECT_VIEW_PREPROC_CODE_INFO_LINE = "Preprocessed code";
    private static final String INSPECT_VIEW_GENERATED_CODE_INFO_LINE = "Generated code";
    private static final String INSPECT_VIEW_EMPTY_PREPROC_REGION_INFO_LINE = "There is no preprocessed code associated with the\n// current generated code section";
    private static final String INSPECT_VIEW_EMPTY_GENERATED_REGION_INFO_LINE = "There is no generated code associated with the\n// current preprocessing code section";
    protected static final int INVALID_POSITION = -1;
    protected static final String DVT_PVLOG_G_PATH = "DVT_PVERILOG_G_FILE";
    protected static final String DVT_PVLOG_P_PATH = "DVT_PVERILOG_P_FILE";
    public static final String PVLOG_UNMAPPED_FILE_ERROR_MESSAGE = "The operation is not allowed on the current selection. Please place the cursor inside a PVerilog preprocessed/generated file.";

    public static String getInspectViewInfoLine(PreprocFileType fileType, boolean isEmptyRegion) {
        if (fileType == null) {
            return null;
        }
        switch (fileType) {
            case P_FILE: {
                return isEmptyRegion ? INSPECT_VIEW_EMPTY_GENERATED_REGION_INFO_LINE : INSPECT_VIEW_GENERATED_CODE_INFO_LINE;
            }
            case G_FILE: {
                return isEmptyRegion ? INSPECT_VIEW_EMPTY_PREPROC_REGION_INFO_LINE : INSPECT_VIEW_PREPROC_CODE_INFO_LINE;
            }
        }
        return null;
    }

    public static enum PreprocFileType {
        P_FILE,
        G_FILE;


        public PreprocFileType getMappedFileType() {
            return this == P_FILE ? G_FILE : P_FILE;
        }

        public String getPFilePath(IProject project, String filePath) {
            if (project == null || filePath == null) {
                return null;
            }
            if (this == P_FILE) {
                return filePath;
            }
            if (this == G_FILE) {
                return PreprocUtils.getInstance().getPPath(filePath, project);
            }
            return null;
        }

        public String getGFilePath(IProject project, String filePath) {
            if (project == null || filePath == null) {
                return null;
            }
            if (this == G_FILE) {
                return filePath;
            }
            if (this == P_FILE) {
                return PreprocUtils.getInstance().getGPath(filePath, project);
            }
            return null;
        }

        public String getMappedFilePath(IProject project, String filePath) {
            if (project == null || filePath == null) {
                return null;
            }
            if (this == P_FILE) {
                return PreprocUtils.getInstance().getGPath(filePath, project);
            }
            if (this == G_FILE) {
                return PreprocUtils.getInstance().getPPath(filePath, project);
            }
            return null;
        }

        public void onPVlogFileChange(IProject project, ParserPath filePath, String documentContent) {
            if (this == G_FILE) {
                PreprocUtils.getInstance().onGChange(project, filePath);
            } else {
                PreprocUtils.getInstance().onPChange(project, filePath, documentContent);
            }
        }
    }
}

