/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.preproc.CompilationPreprocMacroFinder;
import ro.amiq.dvt.model.preproc.CursorPreprocMacroFinder;
import ro.amiq.dvt.model.preproc.DiffAlgorithmFactory;
import ro.amiq.dvt.model.preproc.DiffAlgorithmUtils;
import ro.amiq.dvt.model.preproc.DiffRegion;
import ro.amiq.dvt.model.preproc.IDiffAlgorithm;
import ro.amiq.dvt.model.preproc.IPreprocFileChangeListener;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocDebugMode;
import ro.amiq.dvt.model.preproc.PreprocDiffWrapper;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum PreprocDiffManager implements IPreprocFileChangeListener
{
    INSTANCE;

    private Map<String, List<PreprocMacro>> replacementMap = new HashMap<String, List<PreprocMacro>>();
    private Map<String, IDocument> pPrevDocumentMap;

    @Override
    public void onGChange(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) {
        String pFilePath = PreprocUtils.getInstance().getPPath(preprocDiffWrapper.getGFilePath(), preprocDiffWrapper.getProject());
        preprocDiffWrapper.pFilePath(pFilePath);
        this.computeFullReplacementMap(preprocDiffWrapper, monitor);
    }

    private void computeFullReplacementMap(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) {
        try {
            if (preprocDiffWrapper.getProject() == null || preprocDiffWrapper.getPFilePath() == null || preprocDiffWrapper.getGFilePath() == null) {
                return;
            }
            String pContent = DVTFileUtils.getInstance().readFileContent(new File(preprocDiffWrapper.getPFilePath()));
            Document pDocument = new Document(pContent);
            String gContent = DVTFileUtils.getInstance().readFileContent(new File(preprocDiffWrapper.getGFilePath()));
            Document gDocument = new Document(gContent);
            if (monitor.isCanceled()) {
                return;
            }
            PreprocDiffWrapper newPreprocDiffWrapper = new PreprocDiffWrapper().pFilePath(preprocDiffWrapper.getPFilePath()).pDocument((IDocument)pDocument).gDocument((IDocument)gDocument).diffAlgorithmType(preprocDiffWrapper.getDiffAlgorithmType());
            if (!preprocDiffWrapper.isDebugActive()) {
                this.computeFullDiff(newPreprocDiffWrapper, monitor);
                return;
            }
            long startTime = System.currentTimeMillis();
            this.computeFullDiff(newPreprocDiffWrapper, monitor);
            long computationTime = System.currentTimeMillis() - startTime;
            this.printDebugInfo((IDocument)pDocument, new ParserPath(preprocDiffWrapper.getPFilePath()), preprocDiffWrapper.getProject(), PreprocDebugMode.FULL, computationTime);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void computeFullDiff(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) throws BadLocationException {
        IDiffAlgorithm diffAlgorithm = DiffAlgorithmFactory.INSTANCE.getAlgorithm(preprocDiffWrapper.getDiffAlgorithmType());
        if (diffAlgorithm == null) {
            return;
        }
        List<PreprocMacro> regionAssociation = diffAlgorithm.computeFullDiff(preprocDiffWrapper, monitor);
        if (regionAssociation == null) {
            return;
        }
        if (this.pPrevDocumentMap == null) {
            this.pPrevDocumentMap = new HashMap<String, IDocument>();
        }
        this.pPrevDocumentMap.put(preprocDiffWrapper.getPFilePath(), preprocDiffWrapper.getPDocument());
        this.replacementMap.put(preprocDiffWrapper.getPFilePath(), regionAssociation);
        CursorPreprocMacroFinder.getInstance().clearCaching(preprocDiffWrapper.getPFilePath());
    }

    @Override
    public void onPChange(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) {
        this.computeIncrementalReplacementMap(preprocDiffWrapper, monitor);
    }

    private void computeIncrementalReplacementMap(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) {
        try {
            String pContent = preprocDiffWrapper.getPDocumentContent();
            if (pContent == null) {
                pContent = DVTFileUtils.getInstance().readFileContent(new File(preprocDiffWrapper.getPFilePath()));
            }
            Document pDocument = new Document(pContent);
            PreprocDiffWrapper newPreprocDiffWrapper = new PreprocDiffWrapper().pFilePath(preprocDiffWrapper.getPFilePath()).pDocument((IDocument)pDocument).diffAlgorithmType(preprocDiffWrapper.getDiffAlgorithmType());
            if (!preprocDiffWrapper.isDebugActive()) {
                this.computeIncrementalDiff(newPreprocDiffWrapper, monitor);
                return;
            }
            long startTime = System.currentTimeMillis();
            this.computeIncrementalDiff(newPreprocDiffWrapper, monitor);
            long computationTime = System.currentTimeMillis() - startTime;
            this.printDebugInfo((IDocument)pDocument, new ParserPath(preprocDiffWrapper.getPFilePath()), preprocDiffWrapper.getProject(), PreprocDebugMode.INCREMENTAL, computationTime);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            String gFilePath = PreprocUtils.getInstance().getGPath(preprocDiffWrapper.getPFilePath(), preprocDiffWrapper.getProject());
            preprocDiffWrapper.gFilePath(gFilePath);
            this.computeFullReplacementMap(preprocDiffWrapper, monitor);
        }
    }

    private void computeIncrementalDiff(PreprocDiffWrapper preprocDiffWrapper, IProgressMonitor monitor) throws BadLocationException {
        IDiffAlgorithm diffAlgorithm = DiffAlgorithmFactory.INSTANCE.getAlgorithm(preprocDiffWrapper.getDiffAlgorithmType());
        if (diffAlgorithm == null) {
            return;
        }
        if (this.pPrevDocumentMap == null) {
            return;
        }
        IDocument pPrevDocument = this.pPrevDocumentMap.get(preprocDiffWrapper.getPFilePath());
        if (pPrevDocument == null) {
            return;
        }
        ParserPath pParserPath = new ParserPath(preprocDiffWrapper.getPFilePath());
        List<PreprocMacro> preprocList = this.replacementMap.get(pParserPath.path);
        if (preprocList == null) {
            return;
        }
        PreprocDiffWrapper newPreprocDiffWrapper = new PreprocDiffWrapper().pPrevDocument(pPrevDocument).pDocument(preprocDiffWrapper.getPDocument());
        List<DiffRegion> changedRegionsList = diffAlgorithm.computeIncrementalDiff(newPreprocDiffWrapper, monitor);
        if (changedRegionsList == null || changedRegionsList.isEmpty()) {
            return;
        }
        int i = changedRegionsList.size() - 1;
        while (i >= 0) {
            this.incrementalAdjustPreprocMacros(pParserPath.path, changedRegionsList.get(i), preprocDiffWrapper.getPDocument());
            --i;
        }
        this.checkPreprocMacrosAfterIncremental(preprocList, preprocDiffWrapper.getPDocument().getLength());
        this.pPrevDocumentMap.put(pParserPath.path, preprocDiffWrapper.getPDocument());
    }

    private void checkPreprocMacrosAfterIncremental(List<PreprocMacro> preprocMacroList, int length) throws BadLocationException {
        if (preprocMacroList.stream().anyMatch(preprocMacro -> this.isInvalidPreprocMacro((PreprocMacro)preprocMacro, length))) {
            throw new BadLocationException();
        }
    }

    private boolean isInvalidPreprocMacro(PreprocMacro preprocMacro, int documentLength) {
        return preprocMacro.pStartOffset < 0 || preprocMacro.pEndOffset < 0 || preprocMacro.pEndOffset < preprocMacro.pStartOffset || preprocMacro.pEndOffset > documentLength;
    }

    private void incrementalAdjustPreprocMacros(String filePath, DiffRegion changedRegion, IDocument document) throws BadLocationException {
        int shiftLength = changedRegion.getShiftNoOfChars();
        if (shiftLength == 0) {
            return;
        }
        List<PreprocMacro> preprocMacroList = this.replacementMap.get(filePath);
        if (preprocMacroList == null) {
            return;
        }
        if (shiftLength > 0) {
            this.incrementalAdjustPreprocMacrosAfterInsert(preprocMacroList, changedRegion);
        } else {
            this.incrementalAdjustPreprocMacrosAfterDelete(preprocMacroList, changedRegion, document);
        }
    }

    private void incrementalAdjustPreprocMacrosAfterInsert(List<PreprocMacro> preprocMacroList, DiffRegion changedRegion) {
        int insertOffset = changedRegion.getOldStartOffset();
        int shiftLength = changedRegion.getShiftNoOfChars();
        for (PreprocMacro preprocMacro : preprocMacroList) {
            if (insertOffset > preprocMacro.getPEndOffset()) continue;
            if (insertOffset >= preprocMacro.getPStartOffset()) {
                preprocMacro.pEndOffset += shiftLength;
                continue;
            }
            preprocMacro.shift(shiftLength);
        }
    }

    private void incrementalAdjustPreprocMacrosAfterDelete(List<PreprocMacro> preprocMacroList, DiffRegion changedRegion, IDocument document) throws BadLocationException {
        int deleteStartOffset = changedRegion.getOldStartOffset();
        int deleteEndOffset = changedRegion.getOldEndOffset();
        int shiftLength = changedRegion.getShiftNoOfChars();
        int size = preprocMacroList.size();
        int i = 0;
        while (i < size) {
            PreprocMacro preprocMacro = preprocMacroList.get(i);
            int startOffset = preprocMacro.getPStartOffset();
            int endOffset = preprocMacro.getPEndOffset();
            if (endOffset > deleteStartOffset) {
                if (startOffset >= deleteEndOffset) {
                    preprocMacro.shift(shiftLength);
                } else if (startOffset >= deleteStartOffset && endOffset <= deleteEndOffset && endOffset - deleteStartOffset + shiftLength <= 0) {
                    preprocMacroList.remove(i);
                    --i;
                    --size;
                } else if (startOffset <= deleteStartOffset && endOffset >= deleteEndOffset) {
                    preprocMacro.pEndOffset += shiftLength;
                } else if (startOffset >= deleteStartOffset) {
                    int newStartLine = document.getLineOfOffset(deleteStartOffset);
                    preprocMacro.pStartOffset = document.getLineOffset(newStartLine);
                    preprocMacro.pEndOffset += shiftLength;
                } else {
                    int newEndLine = document.getLineOfOffset(deleteStartOffset);
                    preprocMacro.pEndOffset = DiffAlgorithmUtils.computeLineEndingOffset(document, newEndLine);
                }
            }
            ++i;
        }
    }

    public PreprocMacro computePVlogMacroAtOffset(IProject project, String filePath, int offset) {
        PreprocConstCommon.PreprocFileType fileType = PreprocUtils.getInstance().getPreprocFileType(project, new ParserPath(filePath));
        if (fileType == null) {
            return null;
        }
        String pFilePath = fileType.getPFilePath(project, filePath);
        if (pFilePath == null) {
            return null;
        }
        return CursorPreprocMacroFinder.getInstance().findPreprocMacroAtOffset(new ParserPath(pFilePath), offset, fileType);
    }

    private IDocument getPDocument(String filePath) {
        if (filePath == null) {
            return null;
        }
        if (this.pPrevDocumentMap == null || !this.pPrevDocumentMap.containsKey(filePath)) {
            return null;
        }
        return this.pPrevDocumentMap.get(filePath);
    }

    public void setPrevDocument(String filePath, IDocument document) {
        if (filePath == null) {
            return;
        }
        this.pPrevDocumentMap.put(filePath, document);
    }

    public void clear(IProject project) {
        CompilationPreprocMacroFinder.getInstance().clearCaching();
        CursorPreprocMacroFinder.getInstance().clearCaching();
        Set<String> pFilePaths = PreprocUtils.getInstance().getPFilesFromProject(project);
        PreprocUtils.getInstance().clear(project);
        if (pFilePaths == null) {
            return;
        }
        for (String filePath : pFilePaths) {
            this.replacementMap.remove(filePath);
            this.pPrevDocumentMap.remove(filePath);
        }
    }

    public List<PreprocMacro> getPreprocMacros(String filePath) {
        if (filePath == null) {
            return null;
        }
        return this.replacementMap.get(filePath);
    }

    public List<PreprocMacro> setPreprocMacros(String filePath, List<PreprocMacro> preprocMacros) {
        if (filePath == null) {
            return null;
        }
        return this.replacementMap.put(filePath, preprocMacros);
    }

    public boolean hasPreprocMacros(ParserPath parserPath) {
        if (parserPath == null) {
            return false;
        }
        if (!this.replacementMap.containsKey(parserPath.path)) {
            return false;
        }
        List<PreprocMacro> preprocMacros = this.replacementMap.get(parserPath.path);
        return preprocMacros != null && !preprocMacros.isEmpty();
    }

    public Map<String, List<PreprocMacro>> getReplacementMap(IProject project) {
        HashMap<String, List<PreprocMacro>> projectReplacementMap = new HashMap<String, List<PreprocMacro>>();
        Set<String> pFilePaths = PreprocUtils.getInstance().getPFilesFromProject(project);
        if (pFilePaths == null) {
            return projectReplacementMap;
        }
        for (String filePath : pFilePaths) {
            projectReplacementMap.put(filePath, this.replacementMap.get(filePath));
        }
        return projectReplacementMap;
    }

    public void restore(Map<String, List<PreprocMacro>> projectReplacementMap) {
        this.replacementMap.putAll(projectReplacementMap);
        Set<String> pFilePaths = projectReplacementMap.keySet();
        this.restorePrevDocumentMap(pFilePaths);
    }

    private void restorePrevDocumentMap(Set<String> pFilePaths) {
        if (this.pPrevDocumentMap == null) {
            this.pPrevDocumentMap = new HashMap<String, IDocument>();
        }
        for (String filePath : pFilePaths) {
            String fileContent = DVTFileUtils.getInstance().readFileContent(new File(filePath));
            Document document = new Document(fileContent);
            this.pPrevDocumentMap.put(filePath, (IDocument)document);
        }
    }

    private void printDebugInfo(IDocument pDocument, ParserPath parserPath, IProject project, PreprocDebugMode debugMode, long computationTime) {
        try {
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append("==============================").append(System.lineSeparator()).append((Object)debugMode).append(" for ").append(parserPath.toString()).append(System.lineSeparator()).append("COMPUTATION TIME: ").append(computationTime).append(" ms").append(System.lineSeparator()).append("==============================").append(System.lineSeparator());
            List<PreprocMacro> preprocMacroList = this.replacementMap.get(parserPath.path);
            if (preprocMacroList == null || preprocMacroList.isEmpty()) {
                debugMessage.append("NO REGION ASSOCIATION!").append(System.lineSeparator());
            } else {
                for (PreprocMacro macro : preprocMacroList) {
                    int startOffset = macro.getPStartOffset();
                    int endOffset = macro.getPEndOffset();
                    debugMessage.append("Start Offset: " + startOffset).append(System.lineSeparator()).append("Start Line: " + pDocument.getLineOfOffset(startOffset) + 1).append(System.lineSeparator()).append("End Offset: " + endOffset).append(System.lineSeparator()).append("End Line: " + pDocument.getLineOfOffset(endOffset) + 1).append(System.lineSeparator()).append("==============================").append(System.lineSeparator());
                }
            }
            StringBuilder debugFileLocation = new StringBuilder();
            debugFileLocation.append(project.getLocation().toOSString()).append("/.dvt/");
            File debugFile = new File(debugFileLocation.toString(), "dvt_compile_preproc.log");
            DVTFileUtils.getInstance().writeStringToFile(debugFile, debugMessage.toString(), true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected Region getMappedFileRegion(String pFilePath, int currentOffset, PreprocConstCommon.PreprocFileType fileType) {
        if (pFilePath == null || fileType == null) {
            return null;
        }
        if (!this.replacementMap.containsKey(pFilePath)) {
            return null;
        }
        PreprocConstCommon.PreprocFileType mappedFileType = fileType.getMappedFileType();
        int mappedFileOffset = 0;
        int prevEndOffset = 0;
        List<PreprocMacro> preprocMacros = this.replacementMap.get(pFilePath);
        for (PreprocMacro preprocMacro : preprocMacros) {
            int startOffset = preprocMacro.getStartOffset(fileType);
            int endOffset = preprocMacro.getEndOffset(fileType);
            int mappedEndOffset = preprocMacro.getEndOffset(mappedFileType);
            if (currentOffset < startOffset) {
                return new Region(mappedFileOffset + (currentOffset - prevEndOffset), 0);
            }
            if (currentOffset <= endOffset) {
                return this.computeSelectionRegion(mappedFileType, preprocMacro, pFilePath);
            }
            mappedFileOffset = mappedEndOffset;
            prevEndOffset = endOffset;
        }
        return new Region(mappedFileOffset + (currentOffset - prevEndOffset), 0);
    }

    private Region computeSelectionRegion(PreprocConstCommon.PreprocFileType fileType, PreprocMacro preprocMacro, String pFilePath) {
        if (fileType == null || preprocMacro == null || pFilePath == null) {
            return null;
        }
        switch (fileType) {
            case P_FILE: {
                return this.computePSelectionRegion(preprocMacro, pFilePath);
            }
            case G_FILE: {
                return this.computeGSelectionRegion(preprocMacro);
            }
        }
        return null;
    }

    private Region computePSelectionRegion(PreprocMacro preprocMacro, String pFilePath) {
        return new Region(preprocMacro.getPStartOffset(), preprocMacro.getPLength() > 0 ? this.computeFirstLineLength(preprocMacro, pFilePath) : 0);
    }

    private int computeFirstLineLength(PreprocMacro preprocMacro, String pFilePath) {
        IDocument pDocument;
        block4: {
            try {
                pDocument = this.getPDocument(pFilePath);
                if (pDocument != null) break block4;
                return 0;
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return 0;
            }
        }
        int lineIndex = pDocument.getLineOfOffset(preprocMacro.getPStartOffset());
        int lineLength = pDocument.getLineLength(lineIndex);
        String lineDelimiter = pDocument.getLineDelimiter(lineIndex);
        if (lineDelimiter == null) {
            lineDelimiter = "";
        }
        return lineLength - lineDelimiter.length();
    }

    private Region computeGSelectionRegion(PreprocMacro preprocMacro) {
        int regionLength = preprocMacro.getReplacement().indexOf(DVTStringUtil.LINE_SEPARATOR);
        if (regionLength == -1) {
            regionLength = preprocMacro.getReplacement().length();
        }
        return new Region(preprocMacro.getGStartOffset(), regionLength);
    }

    public String getPreprocMacroCodeRegion(PreprocMacro preprocMacro, PreprocConstCommon.PreprocFileType fileType, String filePath) {
        if (preprocMacro == null || fileType == null || filePath == null) {
            return null;
        }
        if (fileType == PreprocConstCommon.PreprocFileType.G_FILE) {
            return preprocMacro.getReplacement();
        }
        if (fileType == PreprocConstCommon.PreprocFileType.P_FILE) {
            IDocument pDocument;
            block6: {
                try {
                    pDocument = this.pPrevDocumentMap.get(filePath);
                    if (pDocument != null) break block6;
                    return null;
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            int regionOffset = preprocMacro.getStartOffset(fileType);
            int regionLength = preprocMacro.getEndOffset(fileType) - regionOffset;
            return pDocument.get(regionOffset, regionLength);
        }
        return null;
    }

    public int getCompilationOffset(ParserPath parserPath, int offset) {
        return CompilationPreprocMacroFinder.getInstance().getCompilationOffset(parserPath, offset);
    }

    public int getCompilationLine(ParserPath parserPath, int compilationOffset) {
        IDocument pDocument;
        block5: {
            block4: {
                try {
                    if (parserPath != null) break block4;
                    return -1;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return -1;
                }
            }
            pDocument = this.getPDocument(parserPath.path);
            if (pDocument != null) break block5;
            return -1;
        }
        return pDocument.getLineOfOffset(compilationOffset) + 1;
    }

    public String getCompilationContent(ParserPath parserPath) {
        List<PreprocMacro> preprocMacros = this.getPreprocMacros(parserPath.path);
        if (preprocMacros == null || preprocMacros.isEmpty()) {
            return null;
        }
        IDocument pDocument = this.getPDocument(parserPath.path);
        if (pDocument == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(pDocument.get());
        int i = preprocMacros.size() - 1;
        while (i >= 0) {
            PreprocMacro preprocMacro = preprocMacros.get(i);
            if (preprocMacro != null) {
                String replacement = preprocMacro.getReplacement();
                if (replacement.isEmpty()) {
                    int endOffset = preprocMacro.getPEndOffset() + DVTStringUtil.LINE_SEPARATOR.length();
                    if (endOffset > pDocument.getLength()) {
                        endOffset = pDocument.getLength();
                    }
                    sb.replace(preprocMacro.getPStartOffset(), endOffset, "");
                } else {
                    if (preprocMacro.getPLength() == 0) {
                        replacement = String.valueOf(replacement) + DVTStringUtil.LINE_SEPARATOR;
                    }
                    sb.replace(preprocMacro.getPStartOffset(), preprocMacro.getPEndOffset(), replacement);
                }
            }
            --i;
        }
        return sb.toString();
    }

    public boolean isInsidePreprocMacro(ParserPath parserPath, int compilationOffset) {
        return CompilationPreprocMacroFinder.getInstance().isInsidePreprocMacro(parserPath, compilationOffset);
    }

    public int computePreprocErrorLength(ParserPath parserPath, int startOffset, int initialErrorLength) {
        if (parserPath == null) {
            return initialErrorLength;
        }
        if (!this.hasPreprocMacros(parserPath)) {
            return initialErrorLength;
        }
        PreprocMacro preprocMacro = CursorPreprocMacroFinder.getInstance().findPreprocMacroAtOffset(parserPath, startOffset, PreprocConstCommon.PreprocFileType.P_FILE);
        if (preprocMacro == null) {
            return initialErrorLength;
        }
        return this.computeFirstLineLength(preprocMacro, parserPath.path);
    }

    public static class PreprocMacro
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int pStartOffset;
        private int pEndOffset;
        private String replacement;
        private int gStartOffset;
        private int gEndOffset;

        public PreprocMacro(int startOffset, int endOffset, String replacement, int gStartOffset, int gEndOffset) {
            this.pStartOffset = startOffset;
            this.pEndOffset = endOffset;
            this.replacement = replacement;
            this.gStartOffset = gStartOffset;
            this.gEndOffset = gEndOffset;
        }

        public PreprocMacro(PreprocMacro preprocMacro) {
            this.pStartOffset = preprocMacro.pStartOffset;
            this.pEndOffset = preprocMacro.pEndOffset;
            this.replacement = preprocMacro.replacement;
            this.gStartOffset = preprocMacro.gStartOffset;
            this.gEndOffset = preprocMacro.gEndOffset;
        }

        public int getPStartOffset() {
            return this.pStartOffset;
        }

        public int getPEndOffset() {
            return this.pEndOffset;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public int getGStartOffset() {
            return this.gStartOffset;
        }

        public int getGEndOffset() {
            return this.gEndOffset;
        }

        public void setPEndOffset(int pEndOffset) {
            this.pEndOffset = pEndOffset;
        }

        public void shift(int shiftLength) {
            this.pStartOffset += shiftLength;
            this.pEndOffset += shiftLength;
        }

        public int getStartOffset(PreprocConstCommon.PreprocFileType fileType) {
            if (fileType == null) {
                return -1;
            }
            switch (fileType) {
                case P_FILE: {
                    return this.pStartOffset;
                }
                case G_FILE: {
                    return this.gStartOffset;
                }
            }
            return -1;
        }

        public int getEndOffset(PreprocConstCommon.PreprocFileType fileType) {
            if (fileType == null) {
                return -1;
            }
            switch (fileType) {
                case P_FILE: {
                    return this.pEndOffset;
                }
                case G_FILE: {
                    return this.gEndOffset;
                }
            }
            return -1;
        }

        protected int getGLength() {
            return this.gEndOffset - this.gStartOffset;
        }

        protected int getPLength() {
            return this.pEndOffset - this.pStartOffset;
        }

        public boolean isEmptyRegion(PreprocConstCommon.PreprocFileType fileType) {
            int endOffset;
            int startOffset = this.getStartOffset(fileType);
            return startOffset == (endOffset = this.getEndOffset(fileType));
        }
    }
}

