/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.util.Set;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.PVlogCompilePreprocDebugKind;
import ro.amiq.dvt.buildconfig.Svp2SvCommentMap;
import ro.amiq.dvt.buildconfig.Svp2SvDirectMap;
import ro.amiq.dvt.buildconfig.Svp2SvPathMap;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.preproc.DiffAlgorithmType;
import ro.amiq.dvt.model.preproc.IPVlogCommentScanContributor;
import ro.amiq.dvt.model.preproc.PreprocCompilationWrapper;
import ro.amiq.dvt.model.preproc.PreprocMode;
import ro.amiq.dvt.model.preproc.PreprocProjectScanMappingsUtils;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class PreprocMappingsUtils {
    private static IProject cachedProject;
    private static Svp2SvDirectMap cachedDirectMap;
    private static Svp2SvPathMap cachedPathMap;
    private static Svp2SvCommentMap cachedCommentMap;

    public static String resolvePVlogSubstitute(IProject project, String gFilePath) {
        if (!PreprocUtils.getInstance().isPreprocSupportEnabled(project)) {
            return null;
        }
        if (PreprocUtils.getInstance().isGFile(project, new ParserPath(gFilePath))) {
            if (PreprocMode.COMPILE_GENERATED == PreprocUtils.getInstance().getPreprocMode(project)) {
                return gFilePath;
            }
            return PreprocUtils.getInstance().getPPath(gFilePath, project);
        }
        IFileInfo fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(Path.fromOSString((String)gFilePath));
        if (fileInfo == null) {
            return null;
        }
        if (!fileInfo.exists() || fileInfo.isDirectory()) {
            return null;
        }
        PreprocMappingsUtils.resolveCaching(project);
        long startTime = System.currentTimeMillis();
        String substitute = PreprocMappingsUtils.findPVlogSubstitute(project, gFilePath);
        if (substitute == null) {
            return null;
        }
        PreprocMappingsUtils.resolveNewPToGMapping(project, substitute, gFilePath, startTime);
        if (PreprocMode.COMPILE_GENERATED.equals((Object)PreprocUtils.getInstance().getPreprocMode(project))) {
            return null;
        }
        return substitute;
    }

    private static String findPVlogSubstitute(IProject project, String gFilePath) {
        String substitute = PreprocMappingsUtils.resolveDirectMappingSubstitute(gFilePath);
        if (substitute != null) {
            return substitute;
        }
        substitute = PreprocMappingsUtils.resolveMapByPathPrefixSubstitute(gFilePath);
        if (substitute != null) {
            return substitute;
        }
        substitute = PreprocProjectScanMappingsUtils.INSTANCE.resolveMapByExtensionSubstitute(project, gFilePath);
        if (substitute != null) {
            return substitute;
        }
        substitute = PreprocProjectScanMappingsUtils.INSTANCE.resolveMapByPatternTagSubstitute(project, gFilePath);
        if (substitute != null) {
            return substitute;
        }
        substitute = PreprocMappingsUtils.resolveMapByCommentSubstitute(gFilePath);
        if (substitute != null) {
            return substitute;
        }
        return null;
    }

    private static void resolveNewPToGMapping(IProject project, String pFilePath, String gFilePath, long startTime) {
        DVTBuildConsoleRegistry.getConsole(project).print("Computing preprocessed files prerequisites for " + gFilePath + " ...");
        PreprocMappingsUtils.addPToGMapping(project, pFilePath, gFilePath);
        PreprocUtils.getInstance().diff(project, pFilePath, gFilePath);
        long computationTime = System.currentTimeMillis() - startTime;
        PreprocUtils.getInstance().addComputationTime(computationTime);
    }

    private static String resolveDirectMappingSubstitute(String gFilePath) {
        Set<String> candidates = cachedDirectMap.getSvpsFromFileAbsolutePath(gFilePath);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        return candidates.iterator().next();
    }

    private static String resolveMapByPathPrefixSubstitute(String gFilePath) {
        for (String pPrefix : cachedPathMap.keySet()) {
            String gPrefix = cachedPathMap.get(pPrefix);
            String substitute = DVTUtilsCommon.INSTANCE.resolveDirectorySubstitute(gFilePath, gPrefix, pPrefix);
            if (substitute == null) continue;
            return substitute;
        }
        return null;
    }

    private static String resolveMapByCommentSubstitute(String gFilePath) {
        if (!cachedCommentMap.hasPatterns()) {
            return null;
        }
        IPVlogCommentScanContributor commentScanContributor = PreprocUtils.getInstance().getCommentScanContributor(LanguageKind.VLOG);
        if (commentScanContributor == null) {
            return null;
        }
        return commentScanContributor.getMapByCommentSubstitute(gFilePath, cachedCommentMap);
    }

    private static void addPToGMapping(IProject project, String pFilePath, String gFilePath) {
        PreprocCompilationWrapper preprocCompilationWrapper = PreprocUtils.getInstance().getPreprocCompilationWrapper(project);
        if (preprocCompilationWrapper != null && preprocCompilationWrapper.getPToGMap() != null) {
            Svp2SvDirectMap svp2svDirectMap = preprocCompilationWrapper.getPToGMap();
            svp2svDirectMap.putWithErrorReporting(gFilePath, pFilePath);
            return;
        }
        Svp2SvDirectMap svp2svDirectMap = new Svp2SvDirectMap();
        String error = svp2svDirectMap.putWithErrorReporting(gFilePath, pFilePath);
        if (error != null) {
            return;
        }
        PreprocMappingsUtils.putPToGMap(project, svp2svDirectMap);
    }

    private static void putPToGMap(IProject project, Svp2SvDirectMap svp2SvMap) {
        Boolean debugActive = false;
        DiffAlgorithmType diffAlgorithmType = DiffAlgorithmType.GOOGLE;
        String runOnSaveConfig = BuildConfigManager.getPVerilogRunConfigOnSave(project);
        PVlogCompilePreprocDebugKind pvlogDebugKind = BuildConfigManager.getPVerilogCompilePreprocDebugKind(project);
        if (pvlogDebugKind != null) {
            debugActive = pvlogDebugKind.isDebugActive();
            diffAlgorithmType = pvlogDebugKind.getDiffAlgorithmType();
        }
        PreprocUtils.getInstance().putPToGMap(project, new PreprocCompilationWrapper(svp2SvMap, debugActive, diffAlgorithmType, runOnSaveConfig));
    }

    private static void resolveCaching(IProject project) {
        if (project == cachedProject) {
            return;
        }
        cachedProject = project;
        cachedDirectMap = BuildConfigManager.getSvp2SvDirectMap(project);
        cachedPathMap = BuildConfigManager.getSvp2SvPathMap(project);
        cachedCommentMap = BuildConfigManager.getSvp2SvCommentMap(project);
        PreprocProjectScanMappingsUtils.INSTANCE.resolveCaching(project);
    }

    public static void clearCache() {
        cachedProject = null;
        cachedDirectMap = null;
        cachedPathMap = null;
        cachedCommentMap = null;
        PreprocProjectScanMappingsUtils.INSTANCE.clearCaching();
    }

    public static enum PreprocMappingDirection {
        P_TO_G,
        G_TO_P;

    }
}

