/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.Svp2SvExtMap;
import ro.amiq.dvt.buildconfig.Svp2SvPatternTagMap;
import ro.amiq.dvt.model.preproc.PreprocMappingsUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public enum PreprocProjectScanMappingsUtils {
    INSTANCE;

    private Svp2SvExtMap cachedExtMap;
    private Svp2SvPatternTagMap cachedPatternTagMap;
    private Map<String, LinkedList<String>> scannedFileNamesMap;

    protected String resolveMapByExtensionSubstitute(IProject project, String gFilePath) {
        Map.Entry<String, Set<String>> pairExtensionsEntry = this.cachedExtMap.getSvpsFromFilename(gFilePath);
        if (pairExtensionsEntry == null || pairExtensionsEntry.getValue() == null) {
            return null;
        }
        Set<String> pairExtensions = pairExtensionsEntry.getValue();
        if (this.scannedFileNamesMap == null) {
            this.scanFileLocations(project);
        }
        String baseFileName = DVTFileUtils.getInstance().getBaseFileName(gFilePath);
        for (String extension : pairExtensions) {
            String fileName = String.valueOf(baseFileName) + "." + extension;
            if (!this.scannedFileNamesMap.containsKey(fileName)) continue;
            return this.scannedFileNamesMap.get(fileName).getFirst();
        }
        return null;
    }

    protected String resolveMapByPatternTagSubstitute(IProject project, String gFilePath) {
        String gFileName = DVTFileUtils.getInstance().getFileName(gFilePath);
        List<String> pairFileNames = this.cachedPatternTagMap.getPairFileNames(gFileName, PreprocMappingsUtils.PreprocMappingDirection.G_TO_P, Integer.MAX_VALUE);
        if (pairFileNames.isEmpty()) {
            return null;
        }
        if (this.scannedFileNamesMap == null) {
            this.scanFileLocations(project);
        }
        for (String pairFileName : pairFileNames) {
            if (!this.scannedFileNamesMap.containsKey(pairFileName)) continue;
            return this.scannedFileNamesMap.get(pairFileName).getFirst();
        }
        return null;
    }

    private void scanFileLocations(IProject project) {
        if (this.scannedFileNamesMap != null) {
            return;
        }
        this.scannedFileNamesMap = new HashMap<String, LinkedList<String>>();
        Set<Path> scanLocations = this.computeScanLocations(project);
        if (scanLocations == null || scanLocations.isEmpty()) {
            return;
        }
        HashSet<Path> perScanLocationSkippedPaths = new HashSet<Path>(1);
        FileVisitor<Path> fv = this.createFileVisitor(project, perScanLocationSkippedPaths);
        Set<Path> allSkippedPaths = this.getSkippedPaths(project);
        for (Path scanLocation : scanLocations) {
            if (scanLocation == null) continue;
            perScanLocationSkippedPaths.clear();
            boolean isEntirelySkipped = false;
            for (Path skippedPath : allSkippedPaths) {
                if (scanLocation.startsWith(skippedPath)) {
                    isEntirelySkipped = true;
                    break;
                }
                if (!skippedPath.startsWith(scanLocation)) continue;
                perScanLocationSkippedPaths.add(skippedPath);
            }
            if (isEntirelySkipped) continue;
            try {
                Files.walkFileTree(scanLocation, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, fv);
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private FileVisitor<Path> createFileVisitor(IProject project, final Set<Path> skippedPaths) {
        final IProgressMonitor progressMonitor = BuildConfigManager.getProgressMonitor(project);
        return new FileVisitor<Path>(){

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                String fileName = filePath.toFile().getName();
                LinkedList<String> pairFiles = PreprocProjectScanMappingsUtils.this.scannedFileNamesMap.getOrDefault(fileName, new LinkedList());
                pairFiles.add(filePath.toAbsolutePath().toString());
                PreprocProjectScanMappingsUtils.this.scannedFileNamesMap.putIfAbsent(fileName, pairFiles);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                for (Path skippedPath : skippedPaths) {
                    if (!dir.startsWith(skippedPath)) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        };
    }

    private Set<Path> computeScanLocations(IProject project) {
        ArrayList<String> scanLocations = new ArrayList<String>(BuildConfigManager.getPVerilogScanLocations(project));
        if (scanLocations.contains("DVT_PROJECT_LOC")) {
            scanLocations.remove("DVT_PROJECT_LOC");
            scanLocations.add(project.getLocation().toOSString());
        }
        Collections.sort(scanLocations);
        HashSet<Path> paths = new HashSet<Path>(1);
        String prevLocation = null;
        for (String location : scanLocations) {
            if (prevLocation != null && location.startsWith(prevLocation)) continue;
            paths.add(Paths.get(location, new String[0]).toAbsolutePath().normalize());
            prevLocation = location;
        }
        return paths;
    }

    private Set<Path> getSkippedPaths(IProject project) {
        Set<String> skippedScanLocations = BuildConfigManager.getPVerilogSkippedScanLocations(project);
        if (skippedScanLocations == null || skippedScanLocations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Path> skippedPaths = new HashSet<Path>(skippedScanLocations.size());
        for (String location : skippedScanLocations) {
            skippedPaths.add(Paths.get(location, new String[0]).toAbsolutePath().normalize());
        }
        return skippedPaths;
    }

    protected void resolveCaching(IProject project) {
        this.cachedExtMap = BuildConfigManager.getSvp2SvExtMap(project);
        this.cachedPatternTagMap = BuildConfigManager.getSvp2SvPatternTagMap(project);
    }

    protected void clearCaching() {
        this.cachedExtMap = null;
        this.cachedPatternTagMap = null;
        this.scannedFileNamesMap = null;
    }
}

