/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.buildconfig.Svp2SvDirectMap;
import ro.amiq.dvt.model.preproc.IPVlogCommentScanContributor;
import ro.amiq.dvt.model.preproc.PreprocConst;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocMode;
import ro.amiq.dvt.model.preproc.PreprocUtilsCommon;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class PreprocUtils
extends PreprocUtilsCommon {
    private PreprocUtils() {
        this.createCommentScanContributors();
    }

    public static PreprocUtils getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public List<ParserPath> collectUncompiledAutoLinkFilePaths(IProject project) {
        Svp2SvDirectMap svp2SvDirectMap = this.getPToGMap(project);
        if (svp2SvDirectMap == null) {
            return null;
        }
        Set<String> uncompiledFilesSet = PreprocMode.COMPILE_GENERATED.equals((Object)this.getPreprocMode(project)) ? svp2SvDirectMap.getAllSvps() : svp2SvDirectMap.getAllSvs();
        if (uncompiledFilesSet == null) {
            return null;
        }
        ArrayList<ParserPath> preprocAutoLinkFiles = new ArrayList<ParserPath>();
        for (String uncompiledFilePath : uncompiledFilesSet) {
            if (uncompiledFilePath == null || !this.isFileOutsideProject(project, uncompiledFilePath)) continue;
            preprocAutoLinkFiles.add(new ParserPath(uncompiledFilePath));
        }
        return preprocAutoLinkFiles;
    }

    private boolean isFileOutsideProject(IProject project, String filePath) {
        return !filePath.startsWith(project.getLocation().toOSString());
    }

    public void addDocumentPositions(IDocument document, String pFilePath, PreprocConstCommon.PreprocFileType fileType) {
        String positionCategory = PreprocConst.getPositionCategory(fileType);
        List<PreprocDiffManager.PreprocMacro> preprocMacros = PreprocDiffManager.INSTANCE.getPreprocMacros(pFilePath);
        if (preprocMacros == null) {
            return;
        }
        for (PreprocDiffManager.PreprocMacro preprocMacro : preprocMacros) {
            int startOffset = preprocMacro.getStartOffset(fileType);
            int endOffset = preprocMacro.getEndOffset(fileType);
            if (endOffset == startOffset && fileType == PreprocConstCommon.PreprocFileType.G_FILE) continue;
            try {
                DVTDocumentUtils.addDocumentPosition(document, positionCategory, (Object)new DVTPosition(startOffset, endOffset - startOffset));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    @Override
    protected void doRunOnSave(DVTEditor editor) {
        IProject project = editor.getProject();
        String runConfigOnSaveString = this.getPreprocCompilationWrapper(project).getRunOnSaveConfig();
        ILaunchConfigurationWorkingCopy runConfigOnSave = null;
        try {
            runConfigOnSave = this.resolveRunOnSaveTool(runConfigOnSaveString);
        }
        catch (Exception e) {
            new SimpleDVTNotification(editor, 256, "PVerilog").setText("Run on save error: " + e.getMessage()).create();
        }
        if (runConfigOnSave == null) {
            return;
        }
        try {
            IFile gFile;
            HashMap<String, String> env = runConfigOnSave.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            if (env == null) {
                env = new HashMap<String, String>();
            }
            String pFilePath = editor.getParserPath().getCanonicalPath();
            env.put("DVT_PVERILOG_P_FILE", pFilePath);
            String gFilePath = this.getGPath(pFilePath, project);
            env.put("DVT_PVERILOG_G_FILE", gFilePath);
            runConfigOnSave.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, env);
            String refreshScopeVal = runConfigOnSave.getAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, "");
            if (refreshScopeVal.isEmpty() && (gFile = DVTFileUtils.getInstance().findProjectFile(project, gFilePath)) != null) {
                runConfigOnSave.setAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, RefreshUtil.toMemento((IResource[])new IResource[]{gFile}));
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError("PVlog run on save: Unable to set path variables (DVT_PVERILOG_P_FILE, DVT_PVERILOG_P_FILE)", (Throwable)e);
        }
        if (PreprocMode.COMPILE_GENERATED == this.pvlogProjectModes.get(project)) {
            this.performedRunOnSaveGMode = true;
        }
        DebugUITools.launch((ILaunchConfiguration)runConfigOnSave, (String)"run");
    }

    private void createCommentScanContributors() {
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("ro.amiq.dvt.pvlogCommentScanContributor");
            if (extensionPoint == null) {
                return;
            }
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                if (extension != null) {
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                        if (configurationElement != null) {
                            if (!"pvlogCommentScanContributor".equals(configurationElement.getName())) {
                                DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + "ro.amiq.dvt.pvlogCommentScanContributor"));
                            } else {
                                Object createExecutableExtension = configurationElement.createExecutableExtension("class");
                                if (createExecutableExtension instanceof IPVlogCommentScanContributor) {
                                    this.addCommentScanContributor((IPVlogCommentScanContributor)createExecutableExtension);
                                }
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getEditorId() {
        return "ro.amiq.vlogdt.ui.editor.VlogEditor";
    }

    public ILaunchConfigurationWorkingCopy resolveRunOnSaveTool(String runConfigName) throws Exception {
        if (runConfigName == null || runConfigName.isEmpty()) {
            return null;
        }
        ILaunchConfigurationWorkingCopy result = null;
        try {
            ILaunchConfiguration[] launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            if (launchConfigurations == null || launchConfigurations.length == 0) {
                throw new Exception("Run configuration '" + runConfigName + "' does not exist.");
            }
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n = launchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config != null && config.getName().equalsIgnoreCase(runConfigName)) {
                    result = config.getWorkingCopy();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (result == null) {
            throw new Exception("Run configuration '" + runConfigName + "' does not exist.");
        }
        if (!result.supportsMode("run")) {
            throw new Exception("Run configuration '" + runConfigName + "' does not support run mode.");
        }
        return result;
    }

    private static class InstanceHolder {
        private static final PreprocUtils INSTANCE = new PreprocUtils();

        private InstanceHolder() {
        }
    }
}

