/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.preproc;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.Svp2SvDirectMap;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.preproc.IPVlogCommentScanContributor;
import ro.amiq.dvt.model.preproc.PreprocCompilationWrapper;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocDiffManager;
import ro.amiq.dvt.model.preproc.PreprocDiffWrapper;
import ro.amiq.dvt.model.preproc.PreprocMode;
import ro.amiq.dvt.model.reflection.IMacroInfo;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class PreprocUtilsCommon {
    protected Map<IProject, PreprocMode> pvlogProjectModes = new HashMap<IProject, PreprocMode>(1);
    private Map<IProject, PreprocCompilationWrapper> pToGMap = new HashMap<IProject, PreprocCompilationWrapper>(1);
    private Map<IProject, IMacroInfo> cachedDummyMacroInfo = new HashMap<IProject, IMacroInfo>(1);
    private long totalPreprocComputationTime;
    protected boolean performedRunOnSaveGMode;
    private Map<LanguageKind, IPVlogCommentScanContributor> commentScanContributorMap = new EnumMap<LanguageKind, IPVlogCommentScanContributor>(LanguageKind.class);

    public boolean isPreprocSupportEnabled(IProject project) {
        if (project == null) {
            return false;
        }
        PreprocMode preprocMode = this.pvlogProjectModes.get(project);
        return PreprocMode.COMPILE_PREPROC.equals((Object)preprocMode) || PreprocMode.COMPILE_GENERATED.equals((Object)preprocMode);
    }

    public void pverilogModeDirective(IProject project, PreprocMode preprocMode) {
        this.pvlogProjectModes.put(project, preprocMode);
    }

    public void pverilogCompilePreprocDirective(IProject project, PreprocMode preprocMode) {
        if (PreprocMode.COMPILE_GENERATED.equals((Object)this.pvlogProjectModes.get(project)) && PreprocMode.COMPILE_PREPROC.equals((Object)preprocMode)) {
            return;
        }
        this.pvlogProjectModes.put(project, preprocMode);
    }

    public PreprocMode getPreprocMode(IProject project) {
        return this.pvlogProjectModes.get(project);
    }

    public void notifyPVlogProject(IProject project) {
        if (this.pvlogProjectModes.containsKey(project)) {
            return;
        }
        this.pvlogProjectModes.put(project, PreprocMode.COMPILE_PREPROC);
    }

    public PreprocCompilationWrapper getPreprocCompilationWrapper(IProject project) {
        if (project == null || !this.pToGMap.containsKey(project)) {
            return null;
        }
        return this.pToGMap.get(project);
    }

    public void putPToGMap(IProject project, PreprocCompilationWrapper preprocCompilationWrapper) {
        this.pToGMap.put(project, preprocCompilationWrapper);
    }

    protected void removePToGMap(IProject project) {
        this.pToGMap.remove(project);
    }

    public Svp2SvDirectMap getPToGMap(IProject project) {
        PreprocCompilationWrapper preprocCompilationWrapper = this.getPreprocCompilationWrapper(project);
        if (preprocCompilationWrapper == null) {
            return null;
        }
        return preprocCompilationWrapper.getPToGMap();
    }

    public String getPPath(String gPath, IProject project) {
        Svp2SvDirectMap svp2SvDirectMap = this.getPToGMap(project);
        if (svp2SvDirectMap == null || svp2SvDirectMap.isEmpty()) {
            return null;
        }
        Set<String> pFiles = svp2SvDirectMap.getSvpsFromFileAbsolutePath(gPath);
        if (pFiles == null || pFiles.isEmpty()) {
            return null;
        }
        return (String)pFiles.toArray()[0];
    }

    public String getGPath(String pPath, IProject project) {
        Svp2SvDirectMap svp2SvDirectMap = this.getPToGMap(project);
        if (svp2SvDirectMap == null || svp2SvDirectMap.isEmpty()) {
            return null;
        }
        Set<String> gFiles = svp2SvDirectMap.getSvsFromFilename(pPath);
        if (gFiles == null || gFiles.isEmpty()) {
            return null;
        }
        return (String)gFiles.toArray()[0];
    }

    public void onPChange(IProject project, ParserPath parserPath, String pDocumentContent) {
        if (!this.isPFile(project, parserPath)) {
            return;
        }
        PreprocDiffWrapper preprocDiffWrapper = new PreprocDiffWrapper().pFilePath(parserPath.path).project(project).isDebugActive(this.pToGMap.get(project).isDebugActive()).pDocumentContent(pDocumentContent).diffAlgorithmType(this.pToGMap.get(project).getDiffAlgorithmType());
        PreprocDiffManager.INSTANCE.onPChange(preprocDiffWrapper, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean onGChange(IProject project, ParserPath parserPath) {
        if (!this.isGFile(project, parserPath)) {
            return false;
        }
        PreprocDiffWrapper preprocDiffWrapper = new PreprocDiffWrapper().gFilePath(parserPath.path).isDebugActive(this.pToGMap.get(project).isDebugActive()).project(project).diffAlgorithmType(this.pToGMap.get(project).getDiffAlgorithmType());
        PreprocDiffManager.INSTANCE.onGChange(preprocDiffWrapper, (IProgressMonitor)new NullProgressMonitor());
        return true;
    }

    public boolean isPFile(IProject project, ParserPath parserPath) {
        if (project == null || parserPath == null) {
            return false;
        }
        Svp2SvDirectMap svp2SvDirectMap = this.getPToGMap(project);
        if (svp2SvDirectMap == null) {
            return false;
        }
        Set<String> allSvps = svp2SvDirectMap.getAllSvps();
        if (allSvps == null) {
            return false;
        }
        return allSvps.contains(parserPath.path);
    }

    public boolean isPFile(IFile file) {
        if (file == null) {
            return false;
        }
        IProject project = file.getProject();
        if (project == null) {
            return false;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            return false;
        }
        return this.isPFile(project, parserPath);
    }

    public boolean isCompiledPFile(IProject project, ParserPath parserPath) {
        return this.isPFile(project, parserPath) && !this.shouldSkipCompilation(project, parserPath);
    }

    public boolean isGFile(IProject project, ParserPath parserPath) {
        if (project == null || parserPath == null) {
            return false;
        }
        Svp2SvDirectMap svp2SvDirectMap = this.getPToGMap(project);
        if (svp2SvDirectMap == null) {
            return false;
        }
        Set<String> allSvs = svp2SvDirectMap.getAllSvs();
        if (allSvs == null) {
            return false;
        }
        return allSvs.contains(parserPath.path);
    }

    public boolean isGFile(IFile file) {
        IProject project = file.getProject();
        if (project == null) {
            return false;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            return false;
        }
        return this.isGFile(project, parserPath);
    }

    public boolean isMappedFile(IProject project, ParserPath parserPath) {
        return this.isPFile(project, parserPath) || this.isGFile(project, parserPath);
    }

    public void diff(IProject project, String pFilePath, String gFilePath) {
        PreprocCompilationWrapper preprocCompilationWrapper = this.pToGMap.get(project);
        if (preprocCompilationWrapper == null) {
            return;
        }
        Svp2SvDirectMap svp2SvDirectMap = preprocCompilationWrapper.getPToGMap();
        if (svp2SvDirectMap == null) {
            return;
        }
        Set<String> mappedSvps = svp2SvDirectMap.getSvpsFromFileAbsolutePath(gFilePath);
        if (mappedSvps == null || !mappedSvps.contains(pFilePath)) {
            return;
        }
        PreprocDiffWrapper preprocDiffWrapper = new PreprocDiffWrapper().gFilePath(gFilePath).project(project).isDebugActive(preprocCompilationWrapper.isDebugActive()).diffAlgorithmType(this.pToGMap.get(project).getDiffAlgorithmType());
        PreprocDiffManager.INSTANCE.onGChange(preprocDiffWrapper, (IProgressMonitor)new NullProgressMonitor());
    }

    public Set<String> getPFilesFromProject(IProject project) {
        Svp2SvDirectMap svp2SvDirectMap = this.getPToGMap(project);
        if (svp2SvDirectMap == null) {
            return null;
        }
        return svp2SvDirectMap.getAllSvps();
    }

    public IMacroInfo getDummyMacroInfo(IRfSingleLangProject rfSingleLangProj) {
        if (rfSingleLangProj == null) {
            return null;
        }
        IProject project = rfSingleLangProj.getProject();
        if (project == null) {
            return null;
        }
        return this.cachedDummyMacroInfo.get(project);
    }

    public void putDummyMacroInfo(IRfSingleLangProject rfSingleLangProject, IMacroInfo dummyMacroInfo) {
        if (rfSingleLangProject == null || dummyMacroInfo == null) {
            return;
        }
        IProject project = rfSingleLangProject.getProject();
        if (project == null) {
            return;
        }
        this.cachedDummyMacroInfo.put(project, dummyMacroInfo);
    }

    protected void addComputationTime(long computationTime) {
        this.totalPreprocComputationTime += computationTime;
    }

    public void printPreprocSummary(IProject project) {
        if (!this.isPreprocSupportEnabled(project)) {
            return;
        }
        Svp2SvDirectMap svp2SvDirectMap = this.getPToGMap(project);
        if (svp2SvDirectMap == null) {
            return;
        }
        int nOfPreprocFiles = svp2SvDirectMap.getAllSvps().size();
        if (nOfPreprocFiles == 0) {
            return;
        }
        DVTBuildConsoleRegistry.getConsole(project).print("");
        DVTBuildConsoleRegistry.getConsole(project).printSection("Preprocessed files summary", DVTBuildConsoleCommon.MessageSink.REPORT);
        StringBuilder preprocInfo = new StringBuilder();
        preprocInfo.append("Number of files: " + nOfPreprocFiles + "\n");
        preprocInfo.append("Computation time: " + this.totalPreprocComputationTime + "ms\n");
        DVTBuildConsoleRegistry.getConsole(project).print(preprocInfo.toString(), DVTBuildConsoleCommon.MessageSink.REPORT);
    }

    public void showMappedFileRegion(IProject project, ParserPath parserPath, int offset) {
        if (project == null || parserPath == null) {
            return;
        }
        PreprocConstCommon.PreprocFileType fileType = this.getPreprocFileType(project, parserPath);
        if (fileType == null) {
            return;
        }
        String pFilePath = fileType.getPFilePath(project, parserPath.path);
        String mappedFilePath = fileType.getMappedFilePath(project, parserPath.path);
        IFile mappedFile = DVTFileUtils.getInstance().findProjectFile(project, mappedFilePath);
        if (mappedFile == null) {
            return;
        }
        Region region = PreprocDiffManager.INSTANCE.getMappedFileRegion(pFilePath, offset, fileType);
        if (region == null) {
            return;
        }
        DVTFileUtils.getInstance().openEditor(mappedFile, (IRegion)region);
    }

    public PreprocConstCommon.PreprocFileType getPreprocFileType(IProject project, ParserPath parserPath) {
        if (this.isPFile(project, parserPath)) {
            return PreprocConstCommon.PreprocFileType.P_FILE;
        }
        if (this.isGFile(project, parserPath)) {
            return PreprocConstCommon.PreprocFileType.G_FILE;
        }
        return null;
    }

    protected void clear(IProject project) {
        this.totalPreprocComputationTime = 0L;
        this.pvlogProjectModes.remove(project);
        this.cachedDummyMacroInfo.remove(project);
        this.removePToGMap(project);
    }

    public void resolveRunOnSave(DVTEditor editor) {
        if (this.shouldDoRunOnSave(editor)) {
            this.doRunOnSave(editor);
        }
    }

    private boolean shouldDoRunOnSave(DVTEditor editor) {
        if (editor == null) {
            return false;
        }
        IProject project = editor.getProject();
        if (project == null) {
            return false;
        }
        if (!this.isPreprocSupportEnabled(project)) {
            return false;
        }
        ParserPath parserPath = editor.getParserPath();
        if (parserPath == null || !this.isPFile(project, parserPath)) {
            return false;
        }
        PreprocCompilationWrapper preprocCompilationWrapper = this.getPreprocCompilationWrapper(project);
        if (preprocCompilationWrapper == null) {
            return false;
        }
        String runOnSaveConfig = preprocCompilationWrapper.getRunOnSaveConfig();
        return runOnSaveConfig != null && !runOnSaveConfig.isEmpty();
    }

    protected void addCommentScanContributor(IPVlogCommentScanContributor commentScanContributor) {
        if (commentScanContributor == null) {
            return;
        }
        LanguageKind languageKind = commentScanContributor.getLanguageKind();
        if (languageKind == null) {
            return;
        }
        this.commentScanContributorMap.putIfAbsent(languageKind, commentScanContributor);
    }

    protected IPVlogCommentScanContributor getCommentScanContributor(LanguageKind languageKind) {
        if (languageKind == null) {
            return null;
        }
        return this.commentScanContributorMap.get((Object)languageKind);
    }

    public boolean shouldSkipCompilation(IProject project, ParserPath path) {
        PreprocConstCommon.PreprocFileType preprocFileType = this.getPreprocFileType(project, path);
        if (preprocFileType == null) {
            return false;
        }
        PreprocMode preprocMode = this.pvlogProjectModes.get(project);
        if (preprocMode == PreprocMode.COMPILE_PREPROC) {
            return preprocFileType == PreprocConstCommon.PreprocFileType.G_FILE;
        }
        if (preprocMode == PreprocMode.COMPILE_GENERATED) {
            return preprocFileType == PreprocConstCommon.PreprocFileType.P_FILE;
        }
        return false;
    }

    public boolean getPerformedRunOnSaveGMode() {
        return this.performedRunOnSaveGMode;
    }

    public void setPerformedRunOnSaveGMode(boolean performedRosInGMode) {
        this.performedRunOnSaveGMode = performedRosInGMode;
    }

    public InputStream createPreprocCompilationInputStream(ParserPath parserPath) {
        String compilationContent = PreprocDiffManager.INSTANCE.getCompilationContent(parserPath);
        if (compilationContent == null) {
            return null;
        }
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(compilationContent.getBytes());
        return new BufferedInputStream(byteInputStream);
    }

    protected abstract void doRunOnSave(DVTEditor var1);
}

