/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.DVTProblemWaiver;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTPredefinedWaivers {
    private static final String DVT_SPECMAN_PATH = "DVT_SPECMAN_PATH";
    private static final String DVT_DISABLE_PREDEFINED_WAIVERS = "DVT_DISABLE_PREDEFINED_WAIVERS";

    public static List<DVTProblemWaiver> getWaivers(IProject project) {
        if (Boolean.parseBoolean(System.getenv(DVT_DISABLE_PREDEFINED_WAIVERS))) {
            return Collections.emptyList();
        }
        ArrayList<DVTProblemWaiver> result = new ArrayList<DVTProblemWaiver>();
        try {
            if (!project.hasNature("ro.amiq.edt.enature")) {
                return result;
            }
            String dvtSecmanPathVal = BuildConfigManager.getUserDefinedEnvVar(project, DVT_SPECMAN_PATH, BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.FIRST_INVOCATION);
            if (dvtSecmanPathVal == null) {
                return result;
            }
            String[] pieces = dvtSecmanPathVal.split(File.pathSeparator);
            int j = 0;
            while (j < pieces.length) {
                String piece = pieces[j];
                DVTProblemWaiver waiver = new DVTProblemWaiver();
                waiver.setName("[PREDEFINED] DVT_SPECMAN_PATH #" + (j + 1) + " Disable all problems reported inside " + piece);
                waiver.setSeverity(Severity.DISABLED);
                waiver.addMatchClause(DVTProblemMatcher.all().setPath(String.valueOf(piece) + "*"));
                result.add(waiver);
                ++j;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }
}

