/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemKind;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.ISourceProblem;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;

public class DVTProblem
implements Serializable {
    public static final String MACRO_STACK_TRACE = "ro.amiq.dvt.ui.editor.MacroStackTrace";
    public static final String MACRO_PLUGIN_ID = "ro.amiq.dvt.ui.editor.MacroPluginID";
    public static final String MACRO_PROJECT_NAME = "ro.amiq.dvt.ui.editor.MacroProjectName";
    public static final String MARKER_BUILDER_NAME = "MarkerBuilderName";
    private static final long serialVersionUID = 1L;
    public static final Comparator<DVTProblem> UID_COMPARATOR = new Comparator<DVTProblem>(){

        @Override
        public int compare(DVTProblem o1, DVTProblem o2) {
            return Long.signum(o1.getUid() - o2.getUid());
        }
    };
    public static final Comparator<DVTProblem> SEVERITY_COMPARATOR = new Comparator<DVTProblem>(){

        @Override
        public int compare(DVTProblem o1, DVTProblem o2) {
            return Long.signum((long)o1.getSeverity().ordinal() - (long)o2.getSeverity().ordinal());
        }
    };
    public static final Comparator<DVTProblem> MESSAGE_COMPARATOR = new Comparator<DVTProblem>(){

        @Override
        public int compare(DVTProblem o1, DVTProblem o2) {
            if (o1 == null || o1.getMessage() == null) {
                return -1;
            }
            if (o2 == null || o2.getMessage() == null) {
                return 1;
            }
            return o1.getMessage().compareTo(o2.getMessage());
        }
    };
    public static final Comparator<DVTProblem> LINE_COMPARATOR = new Comparator<DVTProblem>(){

        @Override
        public int compare(DVTProblem o1, DVTProblem o2) {
            return Long.signum((long)o1.getLine() - (long)o2.getLine());
        }
    };
    public static final Comparator<DVTProblem> PATH_COMPARATOR = new Comparator<DVTProblem>(){

        @Override
        public int compare(DVTProblem o1, DVTProblem o2) {
            if (o1 == null || o1.getPath() == null) {
                return -1;
            }
            if (o2 == null || o2.getPath() == null) {
                return 1;
            }
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    private transient IProject fProject;
    private transient DVTProblemKind fKind;
    private Severity fOriginalSeverity;
    private Severity fSeverity;
    private int fLine;
    private String fPath;
    private String[] fMessageParameters;
    private Map<String, Object> fAttributes;
    private boolean fToConsole;
    private long fUid;
    private int fFileIndex = -1;
    private int fInvocNumber = -1;
    private boolean fObsolete;
    private static long UID;
    private transient ISourceProblem fSourceProblem;

    public DVTProblem(IProject project, DVTProblemKind dvtProblemKind, String path, boolean toConsole, int line, String ... messageParameters) {
        this(project, dvtProblemKind, path, toConsole, line, -1, messageParameters);
    }

    public DVTProblem(IProject project, DVTProblemKind dvtProblemKind, String path, boolean toConsole, int line, int invocNumber, String ... messageParameters) {
        Assert.isNotNull((Object)project);
        this.fProject = project;
        this.fKind = dvtProblemKind;
        this.fOriginalSeverity = this.fSeverity = dvtProblemKind.getDefaultSeverity();
        this.fPath = DVTStringUtil.intern(Utils.canonicPath(path));
        this.fLine = line;
        this.fToConsole = toConsole;
        this.fMessageParameters = messageParameters;
        this.fUid = UID++;
        this.fInvocNumber = invocNumber;
    }

    public String getMessage() {
        return this.fKind.getMessage(this);
    }

    public String[] getMessageParameters() {
        return this.fMessageParameters;
    }

    public Severity getSeverity() {
        return this.fSeverity;
    }

    public int getLine() {
        return this.fLine;
    }

    public String getPath() {
        return this.fPath;
    }

    public DVTProblemKind getKind() {
        return this.fKind;
    }

    public String getId() {
        return this.fKind.getId();
    }

    public DVTProblemCategory getCategory() {
        return this.fKind.getCategory();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public Severity getOriginalSeverity() {
        return this.fOriginalSeverity;
    }

    public void setSeverity(Severity severity) {
        this.fSeverity = severity;
    }

    public void setAttribute(String key, Object value) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, Object>();
        }
        this.fAttributes.put(key, value);
    }

    public void addAttributes(Map<String, Object> attributes) {
        if (attributes == null) {
            return;
        }
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, Object>();
        }
        this.fAttributes.putAll(attributes);
    }

    public Object getAttribute(String key) {
        return this.fAttributes == null ? null : this.fAttributes.get(key);
    }

    public Map<String, Object> getAttributes() {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap<String, Object>();
        }
        return this.fAttributes;
    }

    public boolean isWaived() {
        return this.fOriginalSeverity != this.fSeverity;
    }

    public String toString() {
        String result = (Object)((Object)this.fOriginalSeverity) + (this.isWaived() ? "/" + (Object)((Object)this.fSeverity) : "") + " on project " + this.fProject.getName() + " : " + this.fKind.getCategory().getId() + " " + this.fKind.getId() + " : " + this.getMessage();
        if (this.fPath != null) {
            result = String.valueOf(result) + " in file " + this.getPath() + " at line " + this.getLine();
        }
        return result;
    }

    public boolean isPrintToConsole() {
        return this.fToConsole;
    }

    public long getUid() {
        return this.fUid;
    }

    public int getFileIndex() {
        return this.fFileIndex;
    }

    public void setFileIndex(int fileIndex) {
        this.fFileIndex = fileIndex;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.fProject.getName());
        s.writeObject(this.fKind.getCategory().getId());
        s.writeObject(this.fKind.getId());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        try {
            s.defaultReadObject();
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
        this.fProject = Utils.getProject((String)s.readObject());
        String catId = (String)s.readObject();
        DVTProblemCategory category = DVTProblemManager.getInstance().getCategory(catId);
        if (category == null) {
            throw new ClassNotFoundException("No such DVT Problem Category: " + catId);
        }
        String kindId = (String)s.readObject();
        this.fKind = category.getProblemKinds().get(kindId);
        if (this.fKind == null) {
            throw new ClassNotFoundException("No such DVT Problem Kind: " + kindId);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.fLine;
        result = 31 * result + (this.fPath == null ? 0 : this.fPath.hashCode());
        result = 31 * result + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DVTProblem other = (DVTProblem)obj;
        if (this.fLine != other.fLine) {
            return false;
        }
        if (this.fPath == null ? other.fPath != null : !this.fPath.equals(other.fPath)) {
            return false;
        }
        return !(this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage()));
    }

    public int getInvocationNumber() {
        return this.fInvocNumber;
    }

    public void setInvocationNumber(int invocNumber) {
        this.fInvocNumber = invocNumber;
    }

    public boolean isObsolete() {
        return this.fObsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.fObsolete = obsolete;
    }

    public void setToConsole(boolean toConsole) {
        this.fToConsole = toConsole;
    }

    public ISourceProblem getSourceProblem() {
        return this.fSourceProblem;
    }

    public void setSourceProblem(ISourceProblem source) {
        this.fSourceProblem = source;
    }

    public Severity getSeverityAfterWaive() {
        if (this.fSourceProblem != null) {
            return this.fSourceProblem.getSeverityAfterWaive();
        }
        return null;
    }

    public void setSeverityAfterWaive(Severity severity) {
        if (this.fSourceProblem != null) {
            this.fSourceProblem.setSeverityAfterWaive(severity);
        }
    }
}

