/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.problems.DVTProblemKind;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTProblemCategory {
    private String fId;
    private String fDescription;
    private String fMarkerId;
    private String fObsoleteMarkerId;
    private DVTProblemCategory fParent;
    private List<DVTProblemCategory> fChildren = new ArrayList<DVTProblemCategory>();
    private Map<String, DVTProblemKind> fProblemKinds = new HashMap<String, DVTProblemKind>();
    private LanguageKind fLanguageKind;

    public DVTProblemCategory(String id, String description, DVTProblemCategory parent, String markerId, LanguageKind languageKind) {
        this(id, description, parent, markerId, markerId, languageKind);
    }

    public DVTProblemCategory(String id, String description, DVTProblemCategory parent, String markerId, String obsoleteMarkerId, LanguageKind languageKind) {
        this.fId = id;
        this.fDescription = description;
        this.fParent = parent;
        this.fLanguageKind = languageKind;
        if (this.fParent != null) {
            this.fParent.fChildren.add(this);
        }
        this.fMarkerId = markerId;
        this.fObsoleteMarkerId = obsoleteMarkerId;
    }

    public DVTProblemCategory getParent() {
        return this.fParent;
    }

    public String getId() {
        return this.fId;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public List<DVTProblemCategory> getChildren() {
        return this.fChildren;
    }

    public String getMarkerId() {
        return this.fMarkerId;
    }

    public String getObsoleteMarkerId() {
        return this.fObsoleteMarkerId;
    }

    public void registerProblemKind(DVTProblemKind problemKind) {
        if (this.getProblemKinds().get(problemKind.getId()) != null) {
            DVTLogger.INSTANCE.logError("A DVTProblemKind with ID " + problemKind.getId() + " is already registered in category " + this.getId());
        } else {
            this.getProblemKinds().put(problemKind.getId(), problemKind);
        }
    }

    public Map<String, DVTProblemKind> getProblemKinds() {
        return this.fProblemKinds;
    }

    public DVTProblemMatcher getMatcher() {
        return DVTProblemMatcher.all().setCategory(this.fId);
    }

    public String toString() {
        return this.fId;
    }

    public LanguageKind getLanguageKind() {
        return this.fLanguageKind;
    }
}

