/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.utils.CompositeComparator;

public class DVTProblemComparator {
    public static final Map<DVTProblemCategory, Integer> PROBLEM_CATEGORIES_ORDER_MAP = DVTProblemComparator.initializeProblemCategoriesMap();
    public static final Comparator<DVTProblem> PROBLEM_CATEGORY_COMPARATOR = (p1, p2) -> {
        Integer o1 = PROBLEM_CATEGORIES_ORDER_MAP.get(p1.getCategory());
        Integer o2 = PROBLEM_CATEGORIES_ORDER_MAP.get(p2.getCategory());
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        return o1 - o2;
    };
    public static final Comparator<DVTProblem> PROBLEM_COMPARATOR = DVTProblemComparator.initializeProblemcomparator();

    static Map<DVTProblemCategory, Integer> initializeProblemCategoriesMap() {
        HashMap<DVTProblemCategory, Integer> result = new HashMap<DVTProblemCategory, Integer>();
        List<DVTProblemCategory> categoriesInOrder = Arrays.asList(DVTProblemCategories.BUILDCONFIG, EProblemCategories.E_SYNTAX, VlogProblemCategories.SVLOG_SYNTAX, VhdlProblemCategories.VHDL_SYNTAX, MSDLProblemCategories.MSDL_SYNTAX, EProblemCategories.E_SEMANTIC, VlogProblemCategories.SVLOG_SEMANTIC, VhdlProblemCategories.VHDL_SEMANTIC, MSDLProblemCategories.MSDL_SEMANTIC);
        int i = 0;
        while (i < categoriesInOrder.size()) {
            result.put(categoriesInOrder.get(i), i);
            ++i;
        }
        return result;
    }

    static Comparator<DVTProblem> initializeProblemcomparator() {
        CompositeComparator<DVTProblem> result = new CompositeComparator<DVTProblem>();
        result.add(DVTProblem.SEVERITY_COMPARATOR);
        result.add(PROBLEM_CATEGORY_COMPARATOR);
        result.add(DVTProblem.PATH_COMPARATOR);
        result.add(DVTProblem.LINE_COMPARATOR);
        result.add(DVTProblem.MESSAGE_COMPARATOR);
        return result;
    }
}

