/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import java.text.MessageFormat;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.Severity;

public class DVTProblemKind {
    protected String fMessage;
    private String fId;
    private Severity fSeverity;
    private DVTProblemCategory fCategory;

    public DVTProblemKind(String id, DVTProblemCategory category, Severity severity, String message) {
        this.fId = id;
        this.fSeverity = severity;
        this.fCategory = category;
        this.fMessage = message;
        this.fCategory.registerProblemKind(this);
    }

    public String getMessage(DVTProblem problem) {
        return String.valueOf(this.fId) + ": " + MessageFormat.format(this.fMessage, problem.getMessageParameters());
    }

    public String getId() {
        return this.fId;
    }

    public Severity getDefaultSeverity() {
        return this.fSeverity;
    }

    public DVTProblemCategory getCategory() {
        return this.fCategory;
    }

    public DVTProblemMatcher getMatcher() {
        return DVTProblemMatcher.all().setCategory(this.fCategory.getId()).setKind(this.fId);
    }

    public String toString() {
        return this.fId;
    }
}

