/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.DVTProblemWaiver;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.problems.MSDLProblemCategories;
import ro.amiq.dvt.model.problems.PFProblemCategories;
import ro.amiq.dvt.model.problems.PSSProblemCategories;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.model.problems.TclProblemCategories;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class DVTProblemManager {
    private static final String PROBLEMS_DB = "problems_db";
    public static final DVTProblemCategory ROOT_CATEGORY = new DVTProblemCategory("DVT", "DVT", null, "ro.amiq.dvt.ProblemMarker", null);
    private static final long CANCEL_SAVE_TIMEOUT = 500L;
    private static DVTProblemManager fInstance;
    private Map<String, DVTProblemCategory> fCategories = new HashMap<String, DVTProblemCategory>();
    private Map<IProject, ProjectProblems> fProblemsByProject = new HashMap<IProject, ProjectProblems>();
    private final Map<IProject, SaveProblemsThread> fSaveThreads = new HashMap<IProject, SaveProblemsThread>();

    private DVTProblemManager() {
        List<DVTProblemCategory> allCategories = Arrays.asList(ROOT_CATEGORY, DVTProblemCategories.BUILDCONFIG, DVTProblemCategories.MEMORY_MONITOR, DVTProblemCategories.EXTERNALTOOLS, EProblemCategories.E_PROBLEM, EProblemCategories.E_SEMANTIC, EProblemCategories.E_SYNTAX, EProblemCategories.E_NAME_CHECKING, EProblemCategories.SLN_PROBLEM, EProblemCategories.SLN_SEMANTIC, EProblemCategories.SLN_SYNTAX, EProblemCategories.SLN_NAME_CHECKING, VlogProblemCategories.SVLOG_PROBLEM, VlogProblemCategories.SVLOG_SEMANTIC, VlogProblemCategories.SVLOG_SYNTAX, VhdlProblemCategories.VHDL_PROBLEM, VhdlProblemCategories.VHDL_SYNTAX, VhdlProblemCategories.VHDL_SEMANTIC, VhdlProblemCategories.VHDL_NAME_CHECKING, PFProblemCategories.PF_PROBLEM, TclProblemCategories.TCL_PROBLEM, PSSProblemCategories.PSS_PROBLEM, PSSProblemCategories.PSS_SEMANTIC, PSSProblemCategories.PSS_SYNTAX, PSSProblemCategories.PSS_NAME_CHECKING, MSDLProblemCategories.MSDL_PROBLEM, MSDLProblemCategories.MSDL_SEMANTIC, MSDLProblemCategories.MSDL_SYNTAX, MSDLProblemCategories.MSDL_NAME_CHECKING);
        for (DVTProblemCategory dvtProblemCategory : allCategories) {
            this.registerCategory(dvtProblemCategory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTProblemManager getInstance() {
        Class<DVTProblemManager> clazz = DVTProblemManager.class;
        synchronized (DVTProblemManager.class) {
            if (fInstance == null) {
                fInstance = new DVTProblemManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fInstance;
        }
    }

    public synchronized void applyWaivers(IProject project) {
        try {
            try {
                ProjectProblems projectProblems = this.getProjectProblems(project);
                TestHelper.getInstance().fCompileWaiversApplicationTime = 0L;
                CompileWaiversManager.INSTANCE.clearCanonicalPathCache();
                for (Map<String, Collection<DVTProblem>> catProblems : projectProblems.fProblemsByCategoryAndPath.values()) {
                    for (Collection<DVTProblem> problems : catProblems.values()) {
                        for (DVTProblem problem : problems) {
                            CompileWaiversManager.INSTANCE.waive(problem, false, false);
                        }
                    }
                }
                this.save(project);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                ObjectionManager.getInstance().clear(Objection.APPLIED_COMPILE_WAIVERS);
            }
        }
        finally {
            ObjectionManager.getInstance().clear(Objection.APPLIED_COMPILE_WAIVERS);
        }
    }

    public synchronized void reload(IProject project) {
        this.fProblemsByProject.put(project, null);
    }

    public synchronized void clearWaivers(IProject project) {
        this.cleanUpDeadProjects();
        CompileWaiversManager.INSTANCE.cleanUpWaiversHitCount(project);
        this.getProjectProblems((IProject)project).fDisableWarnings = null;
        List<DVTProblemWaiver> waivers = CompileWaiversManager.INSTANCE.getWaivers(project);
        waivers.clear();
    }

    private synchronized void cleanUpDeadProjects() {
        Iterator<IProject> it = this.fProblemsByProject.keySet().iterator();
        while (it.hasNext()) {
            IProject project = it.next();
            if (project == null || project.isAccessible()) continue;
            it.remove();
        }
    }

    public synchronized void save(IProject project) {
        SaveProblemsThread saveThreadForProject = this.fSaveThreads.get(project);
        if (saveThreadForProject != null) {
            saveThreadForProject.fSaveMonitor.setCanceled(true);
            long timeoutTime = 500L + System.currentTimeMillis();
            while (System.currentTimeMillis() < timeoutTime) {
                if (this.fSaveThreads.get(project) == null) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.fSaveThreads.get(project) != null) {
                DVTLogger.INSTANCE.logInfo("Timeout while cancelling " + saveThreadForProject.getName());
            }
        }
        saveThreadForProject = new SaveProblemsThread(project);
        this.fSaveThreads.put(project, saveThreadForProject);
        saveThreadForProject.start();
    }

    public synchronized void reportProblem(DVTProblem problem) {
        this.reportProblem(problem, true);
    }

    public synchronized void reportProblem(DVTProblem problem, boolean reportToConsole) {
        try {
            IProject project = problem.getProject();
            Assert.isNotNull((Object)project);
            CompileWaiversManager.INSTANCE.waive(problem, problem.isPrintToConsole(), true);
            ProjectProblems projectProblems = this.getProjectProblems(project);
            if (projectProblems.fDisableWarnings == null) {
                projectProblems.fDisableWarnings = BuildConfigManager.isWarningMemoryConsumptionDebug(project);
            }
            if (projectProblems.fDisableWarnings.booleanValue() && problem.getSeverity() != Severity.ERROR) {
                return;
            }
            projectProblems.add(problem);
            if (reportToConsole) {
                this.reportProblemToConsole(problem);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private synchronized ProjectProblems getProjectProblems(IProject project) {
        ProjectProblems projectProblems = this.fProblemsByProject.get(project);
        if (projectProblems != null) {
            return projectProblems;
        }
        ObjectInputStream ois = null;
        try {
            String file = BuildConfigManager.getModelPersistenceLocation(project, PROBLEMS_DB, true, BuildConfigManagerCommon.PersistenceModeWrapper.regular());
            if (file != null && new File(file).canRead()) {
                ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                projectProblems = (ProjectProblems)ois.readObject();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        DVTUtilsCommon.INSTANCE.closeClosable(ois);
        if (projectProblems == null) {
            projectProblems = new ProjectProblems();
        }
        projectProblems.fDisableWarnings = BuildConfigManager.isWarningMemoryConsumptionDebug(project);
        this.fProblemsByProject.put(project, projectProblems);
        return projectProblems;
    }

    public synchronized void registerCategory(DVTProblemCategory category) {
        if (category == null) {
            return;
        }
        if (this.fCategories.get(category.getId()) != null) {
            DVTLogger.INSTANCE.logError("A DVTProblemCategory with ID " + category.getId() + " is already registered");
        } else {
            this.fCategories.put(category.getId(), category);
        }
    }

    public synchronized DVTProblemCategory getCategory(String id) {
        return this.fCategories.get(id);
    }

    public synchronized Collection<DVTProblemCategory> getAllCategories() {
        return this.fCategories.values();
    }

    private synchronized void reportProblemToConsole(DVTProblem problem) {
        if (problem.getSeverity() != Severity.WARNING && problem.getSeverity() != Severity.ERROR || !problem.isPrintToConsole()) {
            return;
        }
        IProject project = problem.getProject();
        DVTBuildConsoleRegistry.getConsole(project).printProblem(problem);
    }

    public synchronized void removeProblems(IProject project) {
        try {
            this.fProblemsByProject.put(project, new ProjectProblems());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public synchronized void removeProblemsWithPath(IProject project, String path) {
        try {
            Collection<DVTProblemCategory> categories = this.getAllCategories();
            for (DVTProblemCategory dvtProblemCategory : categories) {
                this.getProjectProblems(project).removeProblemsWithCategoryAndPath(dvtProblemCategory, path);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public synchronized void removeProblemsWithCategoryAndPath(IProject project, DVTProblemCategory category, String path) {
        try {
            this.getProjectProblems(project).removeProblemsWithCategoryAndPath(category, path);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public synchronized void removeProblemsWithCategory(IProject project, DVTProblemCategory category) {
        try {
            this.getProjectProblems(project).removeProblemsWithCategory(category);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public synchronized Map<String, Collection<DVTProblem>> getProblemsWithCategoryByFile(IProject project, DVTProblemCategory category) {
        try {
            return this.getProjectProblems(project).getProblemsWithCategoryByFile(category);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyMap();
        }
    }

    public synchronized Collection<DVTProblem> getProblemsWithCategoryAndPath(IProject project, DVTProblemCategory category, String path) {
        try {
            return this.getProjectProblems(project).getProblemsWithCategoryAndPath(category, path);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    public void removeProblems(IProject project, DVTProblemCategory category, String path, String builderName) {
        try {
            this.getProjectProblems(project).removeProblems(project, category, path, builderName);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public synchronized Collection<DVTProblem> getAllProblems(IProject project, DVTProblemMatcher matcher, Comparator<DVTProblem> comparator) {
        try {
            return this.getProjectProblems(project).getAllProblems(matcher, comparator);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    public synchronized Map<String, Map<String, Collection<DVTProblem>>> getAllProblemsUnsorted(IProject project) {
        try {
            return this.getProjectProblems(project).getAllProblems();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new LinkedHashMap<String, Map<String, Collection<DVTProblem>>>();
        }
    }

    public void clean(IProject project) {
        this.fProblemsByProject.remove(project);
    }

    private static class ProjectProblems
    implements Serializable {
        public Boolean fDisableWarnings;
        private static final long serialVersionUID = 2L;
        private transient Map<String, Map<String, Collection<DVTProblem>>> fProblemsByCategoryAndPath = new LinkedHashMap<String, Map<String, Collection<DVTProblem>>>();

        private ProjectProblems() {
        }

        private synchronized void removeProblemsWithCategory(DVTProblemCategory category) {
            this.fProblemsByCategoryAndPath.remove(category.getId());
        }

        private synchronized void removeProblemsWithCategoryAndPath(DVTProblemCategory category, String path) {
            Map<String, Collection<DVTProblem>> categoryProblems = this.fProblemsByCategoryAndPath.get(category.getId());
            if (categoryProblems != null) {
                categoryProblems.remove(path);
            }
        }

        private synchronized void removeProblems(IProject project, DVTProblemCategory category, String path, String builderName) {
            Map<String, Collection<DVTProblem>> categoryProblems = this.fProblemsByCategoryAndPath.get(category.getId());
            if (categoryProblems == null || categoryProblems.isEmpty()) {
                return;
            }
            Collection<DVTProblem> pathProblems = categoryProblems.get(path);
            if (pathProblems == null || pathProblems.isEmpty()) {
                return;
            }
            Iterator<DVTProblem> iterator = pathProblems.iterator();
            while (iterator.hasNext()) {
                DVTProblem problem = iterator.next();
                Object problemBuilderName = problem.getAttribute("MarkerBuilderName");
                if (problemBuilderName == null || !problemBuilderName.equals(builderName)) continue;
                iterator.remove();
            }
        }

        private synchronized Map<String, Collection<DVTProblem>> getProblemsWithCategoryByFile(DVTProblemCategory category) {
            Map<String, Collection<DVTProblem>> problemsWithCategoryByFile = this.fProblemsByCategoryAndPath.get(category.getId());
            if (problemsWithCategoryByFile == null) {
                return Collections.emptyMap();
            }
            return problemsWithCategoryByFile;
        }

        private synchronized Collection<DVTProblem> getProblemsWithCategoryAndPath(DVTProblemCategory category, String path) {
            Map<String, Collection<DVTProblem>> problemsWithCategory = this.fProblemsByCategoryAndPath.get(category.getId());
            if (problemsWithCategory == null) {
                return Collections.emptyList();
            }
            Collection<DVTProblem> problemsWithCategoryAndPath = problemsWithCategory.get(path);
            if (problemsWithCategoryAndPath == null) {
                return Collections.emptyList();
            }
            return problemsWithCategoryAndPath;
        }

        private synchronized void add(DVTProblem problem) {
            Collection<DVTProblem> categoryAndPathProblems;
            Map<String, Collection<DVTProblem>> categoryProblems = this.fProblemsByCategoryAndPath.get(problem.getCategory().getId());
            if (categoryProblems == null) {
                categoryProblems = new LinkedHashMap<String, Collection<DVTProblem>>();
                this.fProblemsByCategoryAndPath.put(problem.getCategory().getId(), categoryProblems);
            }
            if ((categoryAndPathProblems = categoryProblems.get(problem.getPath())) == null) {
                categoryAndPathProblems = new LinkedHashSet<DVTProblem>(1);
                categoryProblems.put(problem.getPath(), categoryAndPathProblems);
            }
            categoryAndPathProblems.add(problem);
        }

        private synchronized List<DVTProblem> getAllProblems(DVTProblemMatcher matcher, Comparator<DVTProblem> comparator) {
            ArrayList<DVTProblem> result = new ArrayList<DVTProblem>();
            if (matcher == null) {
                matcher = DVTProblemMatcher.all();
            }
            for (Map<String, Collection<DVTProblem>> m : this.fProblemsByCategoryAndPath.values()) {
                for (Collection<DVTProblem> c : m.values()) {
                    for (DVTProblem p : c) {
                        if (!matcher.matches(p)) continue;
                        result.add(p);
                    }
                }
            }
            Collections.sort(result, comparator == null ? DVTProblem.UID_COMPARATOR : comparator);
            return result;
        }

        private synchronized Map<String, Map<String, Collection<DVTProblem>>> getAllProblems() {
            return this.fProblemsByCategoryAndPath;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            Thread currentThread = Thread.currentThread();
            IProgressMonitor saveMonitor = null;
            if (currentThread instanceof SaveProblemsThread) {
                saveMonitor = ((SaveProblemsThread)currentThread).fSaveMonitor;
                if (saveMonitor == null) {
                    return;
                }
            } else {
                saveMonitor = new NullProgressMonitor();
            }
            if (this.fProblemsByCategoryAndPath == null) {
                return;
            }
            ArrayList<String> categories = new ArrayList<String>(this.fProblemsByCategoryAndPath.keySet());
            out.writeObject(categories);
            for (String problemCategory : categories) {
                Map<String, Collection<DVTProblem>> problemsByPath = this.fProblemsByCategoryAndPath.get(problemCategory);
                if (problemsByPath == null || problemsByPath.isEmpty()) {
                    out.writeInt(0);
                    continue;
                }
                out.writeInt(problemsByPath.size());
                for (Map.Entry<String, Collection<DVTProblem>> entry : problemsByPath.entrySet()) {
                    if (saveMonitor.isCanceled()) {
                        return;
                    }
                    String problemPath = entry.getKey();
                    Collection<DVTProblem> problems = entry.getValue();
                    out.writeObject(problemPath);
                    out.writeObject(problems);
                }
            }
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.fProblemsByCategoryAndPath = new LinkedHashMap<String, Map<String, Collection<DVTProblem>>>();
            List categories = (List)in.readObject();
            if (categories == null) {
                throw new StreamCorruptedException();
            }
            for (String category : categories) {
                LinkedHashMap<String, LinkedHashSet> problemsByPath = new LinkedHashMap<String, LinkedHashSet>();
                this.fProblemsByCategoryAndPath.put(category, problemsByPath);
                int size = in.readInt();
                int i = 0;
                while (i < size) {
                    String path = (String)in.readObject();
                    if (path == null) {
                        throw new StreamCorruptedException();
                    }
                    LinkedHashSet problemsForCategoryAndPath = (LinkedHashSet)in.readObject();
                    if (problemsForCategoryAndPath == null) {
                        throw new StreamCorruptedException();
                    }
                    problemsByPath.put(path, problemsForCategoryAndPath);
                    ++i;
                }
            }
        }
    }

    private class SaveProblemsThread
    extends Thread {
        private IProject project;
        private IProgressMonitor fSaveMonitor;

        public SaveProblemsThread(IProject project) {
            this.project = project;
            this.fSaveMonitor = new NullProgressMonitor();
        }

        @Override
        public void run() {
            this.save();
        }

        public void save() {
            block9: {
                String file;
                ObjectOutputStream oos;
                block8: {
                    this.setName("[Thread #" + this.getId() + "][DVTProblemManager.save() for " + this.project.getName() + "]");
                    oos = null;
                    file = BuildConfigManager.getModelPersistenceLocation(this.project, DVTProblemManager.PROBLEMS_DB, false, BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                    if (file != null) break block8;
                    DVTUtilsCommon.INSTANCE.closeClosable(oos);
                    DVTProblemManager.this.fSaveThreads.remove(this.project);
                    ObjectionManager.getInstance().clear(Objection.PROBLEM_SAVE);
                    return;
                }
                try {
                    oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    oos.writeObject(DVTProblemManager.this.fProblemsByProject.get(this.project));
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    DVTUtilsCommon.INSTANCE.closeClosable(oos);
                    DVTProblemManager.this.fSaveThreads.remove(this.project);
                    ObjectionManager.getInstance().clear(Objection.PROBLEM_SAVE);
                    break block9;
                }
                catch (IOException e) {
                    try {
                        DVTLogger.INSTANCE.logError("DVTProblemManager.save()", (Throwable)e);
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        DVTUtilsCommon.INSTANCE.closeClosable(oos);
                        DVTProblemManager.this.fSaveThreads.remove(this.project);
                        ObjectionManager.getInstance().clear(Objection.PROBLEM_SAVE);
                    }
                }
                DVTUtilsCommon.INSTANCE.closeClosable(oos);
                DVTProblemManager.this.fSaveThreads.remove(this.project);
                ObjectionManager.getInstance().clear(Objection.PROBLEM_SAVE);
            }
        }
    }
}

