/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategory;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class DVTProblemMatcher {
    private String fKind;
    private String fCategory;
    private String fPath;
    private StringMatcher fPathPattern;
    private Severity fSeverity;
    private String fAttribute;
    private String fMessage;
    private StringMatcher fMessagePattern;

    private DVTProblemMatcher() {
    }

    public static DVTProblemMatcher all() {
        return new DVTProblemMatcher();
    }

    public boolean matches(DVTProblem problem) {
        boolean b = this.severityMatches(problem) && this.kindMatches(problem) && this.categoryMatches(problem) && this.attributeMatches(problem) && this.pathMatches(problem) && this.messageMatches(problem);
        return b;
    }

    private boolean severityMatches(DVTProblem problem) {
        return this.fSeverity == null || this.fSeverity == problem.getSeverity();
    }

    private boolean kindMatches(DVTProblem problem) {
        return this.fKind == null || this.fKind.equals(problem.getKind().getId());
    }

    private boolean attributeMatches(DVTProblem problem) {
        return this.fAttribute == null || problem.getAttribute(this.fAttribute) != null;
    }

    private boolean categoryMatches(DVTProblem problem) {
        if (this.fCategory == null) {
            return true;
        }
        if (this.fCategory.equals(problem.getCategory().getId())) {
            return true;
        }
        DVTProblemCategory parentCategory = problem.getCategory();
        do {
            if (!(parentCategory = parentCategory.getParent()).getId().equals(this.fCategory)) continue;
            return true;
        } while (parentCategory != DVTProblemManager.ROOT_CATEGORY);
        return false;
    }

    private boolean messageMatches(DVTProblem problem) {
        return this.fMessagePattern == null || this.fMessagePattern.match(problem.getMessage().trim());
    }

    private boolean pathMatches(DVTProblem problem) {
        if (this.fPathPattern == null) {
            return true;
        }
        if (this.fPathPattern.match(problem.getPath())) {
            return true;
        }
        String problemCanonicalPath = CompileWaiversManager.INSTANCE.getCanonicalPathCache(problem.getPath());
        if (problemCanonicalPath == null) {
            problemCanonicalPath = Utils.canonicPath(problem.getPath());
            CompileWaiversManager.INSTANCE.putCanonicalPathCache(problem.getPath(), problemCanonicalPath);
        }
        return this.fPathPattern.match(problemCanonicalPath);
    }

    public DVTProblemMatcher setSeverity(Severity severity) {
        this.fSeverity = severity;
        return this;
    }

    public DVTProblemMatcher setKind(String kind) {
        this.fKind = kind;
        return this;
    }

    public DVTProblemMatcher setCategory(String category) {
        this.fCategory = category;
        return this;
    }

    public DVTProblemMatcher setPath(String path) {
        this.fPath = DVTStringUtil.translatePathPatternToOSPattern(path);
        if (this.fPath == null) {
            this.fPathPattern = null;
        } else {
            this.fPath = Utils.canonicPath(this.fPath);
            this.fPathPattern = new StringMatcher(this.fPath, false, false, true);
        }
        return this;
    }

    public DVTProblemMatcher setMessage(String message) {
        this.fMessage = message;
        this.fMessagePattern = this.fMessage == null ? null : new StringMatcher(this.fMessage, false, false);
        return this;
    }

    public DVTProblemMatcher setAttribute(String attribute) {
        this.fAttribute = attribute;
        return this;
    }

    public Severity getSeverity() {
        return this.fSeverity;
    }

    public String getKind() {
        return this.fKind;
    }

    public String getCategory() {
        return this.fCategory;
    }

    public String getPath() {
        return this.fPath;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String toString() {
        return (this.fSeverity == null ? "ANY_SEVERITY" : this.fSeverity) + " " + (this.fKind == null ? "ANY_KND" : this.fKind) + "/" + (this.fCategory == null ? "ANY_CAT" : this.fCategory) + " " + (this.fPath == null ? "ANY_PATH" : this.fPath) + " " + (this.fMessage == null ? "ANY_MSG" : this.fMessage);
    }
}

