/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.model.problems.DVTProblemWaiver;
import ro.amiq.dvt.model.problems.DVTProblemWaiversXMLParser1;
import ro.amiq.dvt.utils.XMLErrorHandler;

public abstract class DVTProblemWaiversXMLParser {
    private final File fFile;
    private DVTProblemWaiversXMLParser fFather;
    protected List<String> fMessages = new ArrayList<String>();
    protected List<InexistentFileWaiverProblem> fInexistentFileWarningMessages = new ArrayList<InexistentFileWaiverProblem>();
    protected List<UnresolvedEnvWaiverProblem> fUnresolvedVariableWarningMessages = new ArrayList<UnresolvedEnvWaiverProblem>();
    private IProject fProject;
    private static final String LAST_VERSION = "1";

    protected DVTProblemWaiversXMLParser(IProject project, File file) {
        this.fFile = file;
        this.fProject = project;
    }

    public abstract void save(List<DVTProblemWaiver> var1) throws Exception;

    public abstract List<DVTProblemWaiver> load() throws Exception;

    public File getFile() {
        return this.fFile;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public static DVTProblemWaiversXMLParser newParser(IProject project, File file, boolean useLastVersion) throws Exception {
        return DVTProblemWaiversXMLParser.newParser(project, null, file, useLastVersion);
    }

    protected static DVTProblemWaiversXMLParser newParser(IProject project, DVTProblemWaiversXMLParser father, File file, boolean useLastVersion) throws Exception {
        InfiniteRecursionException infiniteRecursion = new InfiniteRecursionException();
        DVTProblemWaiversXMLParser currFather = father;
        while (currFather != null) {
            infiniteRecursion.push(currFather.fFile);
            currFather = currFather.fFather;
        }
        infiniteRecursion.trigger();
        if (useLastVersion) {
            return DVTProblemWaiversXMLParser.newParser(project, father, file, LAST_VERSION);
        }
        String version = DVTProblemWaiversXMLParser.detectVersion(file);
        return DVTProblemWaiversXMLParser.newParser(project, father, file, version);
    }

    private static DVTProblemWaiversXMLParser newParser(IProject project, DVTProblemWaiversXMLParser father, File file, String version) throws Exception {
        DVTProblemWaiversXMLParser1 result = null;
        if (!LAST_VERSION.equals(version)) {
            throw new IllegalArgumentException("Unknown waivers file version " + version + ".");
        }
        result = new DVTProblemWaiversXMLParser1(project, file);
        result.fFather = father;
        if (father != null) {
            result.fMessages = father.fMessages;
        }
        return result;
    }

    private static String detectVersion(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList waiversNodes = document.getElementsByTagName("waivers");
        if (waiversNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)waiversNodes.item(0);
        return waiversNode.getAttribute("version");
    }

    public List<String> getMessages() {
        return this.fMessages;
    }

    public List<InexistentFileWaiverProblem> getInexistentFileWaiversMessages() {
        return this.fInexistentFileWarningMessages;
    }

    public List<UnresolvedEnvWaiverProblem> getUnresolvedVariableWarningMessages() {
        return this.fUnresolvedVariableWarningMessages;
    }

    public static class InexistentFileWaiverProblem
    extends WaiverProblem {
        private String includedFilePath;

        public InexistentFileWaiverProblem(File file, int line, String includedFilePath) {
            super(file, line);
            this.includedFilePath = includedFilePath;
        }

        public String getIncludedFilePath() {
            return this.includedFilePath;
        }

        @Override
        public String getMessage() {
            return "Included waiver file " + this.includedFilePath + " does not exist!";
        }
    }

    protected static class InfiniteRecursionException
    extends Exception {
        private boolean detected;
        private List<File> fStack = new ArrayList<File>();

        protected InfiniteRecursionException() {
        }

        public void push(File file) {
            if (this.fStack.contains(file)) {
                this.detected = true;
            }
            this.fStack.add(0, file);
        }

        public void trigger() throws InfiniteRecursionException {
            if (this.detected) {
                throw this;
            }
        }

        public List<File> getStack() {
            return this.fStack;
        }
    }

    public static class UnresolvedEnvWaiverProblem
    extends WaiverProblem {
        private String unresolvedEnvVariable;

        public UnresolvedEnvWaiverProblem(File file, int line, String unresolvedEnvVariable) {
            super(file, line);
            this.unresolvedEnvVariable = unresolvedEnvVariable;
        }

        public String getUnresolvedEnvVariable() {
            return this.unresolvedEnvVariable;
        }

        @Override
        public String getMessage() {
            return "Environment variable " + this.unresolvedEnvVariable + " could not be resolved!";
        }
    }

    public static abstract class WaiverProblem {
        private File file;
        private int line;

        protected WaiverProblem(File file, int line) {
            this.file = file;
            this.line = line;
        }

        public File getFile() {
            return this.file;
        }

        public int getLine() {
            return this.line;
        }

        public abstract String getMessage();
    }
}

