/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.problems;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversUtil;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.DVTProblemWaiver;
import ro.amiq.dvt.model.problems.DVTProblemWaiversXMLParser;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.PositionalXMLReader;
import ro.amiq.dvt.utils.XMLException;

public class DVTProblemWaiversXMLParser1
extends DVTProblemWaiversXMLParser {
    public static final String VERSION_ID = "1";
    private static final String TAG_WAIVERS = "waivers";
    private static final String ATTR_VERSION = "version";
    private static final String TAG_WAIVER = "waiver";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_SEVERITY = "severity";
    private static final String DEFAULT = "DEFAULT";
    private static final String TAG_DESCRIPTION = "description";
    private static final String TAG_MATCH = "match";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_MESSAGE = "message";
    private static final String ATTR_DEFAULT_SEVERITY = "default-severity";
    private static final String TAG_INCLUDE = "include";
    private static final String ATTR_FILE_OPTIONAL = "optional";

    public DVTProblemWaiversXMLParser1(IProject project, File file) {
        super(project, file);
    }

    @Override
    public void save(List<DVTProblemWaiver> waivers) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        Document document = builder.newDocument();
        Element elem = document.createElement(TAG_WAIVERS);
        document.appendChild(elem);
        elem.setAttribute(ATTR_VERSION, VERSION_ID);
        this.appendWaiverNodes(waivers, elem, document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendWaiverNodes(List<DVTProblemWaiver> waivers, Element root, Document document) {
        for (DVTProblemWaiver waiver : waivers) {
            Element elem = document.createElement(TAG_WAIVER);
            root.appendChild(elem);
            elem.setAttribute(ATTR_NAME, waiver.getName());
            String severity = waiver.getSeverity() == null ? DEFAULT : waiver.getSeverity().toString();
            elem.setAttribute(ATTR_SEVERITY, severity);
            this.appendDescriptionNode(waiver.getDescription(), elem, document);
            for (DVTProblemMatcher m : waiver.getMatchClauses()) {
                this.appendMatchNode(m, elem, document);
            }
        }
    }

    private void appendDescriptionNode(String description, Element root, Document document) {
        Element elem = document.createElement(TAG_DESCRIPTION);
        root.appendChild(elem);
        Text text = document.createTextNode(description);
        elem.appendChild(text);
    }

    private void appendMatchNode(DVTProblemMatcher m, Element root, Document document) {
        Element elem = document.createElement(TAG_MATCH);
        if (m.getPath() != null) {
            elem.setAttribute(ATTR_PATH, m.getPath());
        }
        if (m.getMessage() != null) {
            elem.setAttribute(ATTR_MESSAGE, m.getMessage());
        }
        if (m.getKind() != null) {
            elem.setAttribute(ATTR_ID, m.getKind());
        }
        if (m.getCategory() != null) {
            elem.setAttribute(ATTR_CATEGORY, m.getCategory());
        }
        root.appendChild(elem);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<DVTProblemWaiver> load() throws Exception {
        resultWaivers = new LinkedList<DVTProblemWaiver>();
        stream = new BufferedInputStream(new FileInputStream(this.getFile()));
        document = PositionalXMLReader.readXML(stream);
        stream.close();
        includeNodes = document.getElementsByTagName("include");
        i = 0;
        while (i < includeNodes.getLength()) {
            includeNode = (Element)includeNodes.item(i);
            includePath = includeNode.getAttribute("path");
            if (includePath == null || includePath.isEmpty()) {
                this.reportNoAttribute("include", "path");
            } else {
                variablePath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(includePath, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL, (DVTUtilsCommon.IEnvironmentProvider)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((DVTProblemWaiversXMLParser1)this));
                if (variablePath == null) {
                    lineNumber = includeNode.getUserData("lineNumber");
                    line = 0;
                    if (lineNumber instanceof String) {
                        line = Integer.parseInt((String)lineNumber);
                    }
                    this.reportEnvVariableNotResolved(includePath, line, this.getFile());
                } else {
                    includePath = variablePath;
                    includedFile = this.resolveIncludedFile(includePath, this.getFile().getParentFile().getAbsolutePath());
                    if (includedFile == null || !includedFile.exists()) {
                        lineNumber = includeNode.getUserData("lineNumber");
                        isOptional = Boolean.parseBoolean(includeNode.getAttribute("optional"));
                        line = 0;
                        if (lineNumber instanceof String) {
                            line = Integer.parseInt((String)lineNumber);
                        }
                        this.reportIncludedFileNotFound(includePath, line, isOptional, this.getFile());
                    } else {
                        try {
                            parser = DVTProblemWaiversXMLParser.newParser(this.getProject(), (DVTProblemWaiversXMLParser)this, includedFile, true);
                            CompileWaiversUtil.getInstance().createNode(includedFile, this.getFile().getAbsolutePath());
                            waivers = parser.load();
                            waivers.sort(DVTProblemWaiver.WAIVER_ORDER_COMPARATOR);
                            line = Integer.parseInt(includeNode.getUserData("lineNumber").toString());
                            waivers.forEach((Consumer<DVTProblemWaiver>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$1(int ro.amiq.dvt.model.problems.DVTProblemWaiver ), (Lro/amiq/dvt/model/problems/DVTProblemWaiver;)V)((int)line));
                            resultWaivers.addAll(waivers);
                            for (DVTProblemWaiversXMLParser.InexistentFileWaiverProblem inexistentfileWaiverMessage : parser.getInexistentFileWaiversMessages()) {
                                this.fInexistentFileWarningMessages.add(inexistentfileWaiverMessage);
                            }
                            for (DVTProblemWaiversXMLParser.UnresolvedEnvWaiverProblem unresolvedVariableWaiverMessage : parser.getUnresolvedVariableWarningMessages()) {
                                this.fUnresolvedVariableWarningMessages.add(unresolvedVariableWaiverMessage);
                            }
                        }
                        catch (DVTProblemWaiversXMLParser.InfiniteRecursionException e) {
                            this.reportInfiniteRecursion(e);
                        }
                        catch (SAXParseException e) {
                            throw new XMLException(e, includedFile.getAbsolutePath());
                        }
                    }
                }
            }
            ++i;
        }
        is = new BufferedInputStream(new FileInputStream(this.getFile()));
        doc = PositionalXMLReader.readXML(is);
        is.close();
        waiverNodes = doc.getElementsByTagName("waiver");
        i = 0;
        while (i < waiverNodes.getLength()) {
            block23: {
                block22: {
                    waiverNode = (Element)waiverNodes.item(i);
                    waiver = new DVTProblemWaiver();
                    waiver.setWaiverDefFile(this.getFile());
                    line = Integer.valueOf(waiverNode.getUserData("lineNumber").toString());
                    waiver.setWaiverDefLine(line == null ? -1 : line);
                    waiver.setWaiverDefRelativeIncludeLine(-1);
                    name = waiverNode.getAttribute("name");
                    waiver.setName(name == null ? "" : name);
                    waiverSeverity = waiverNode.getAttribute("severity");
                    if (waiverSeverity != null && !waiverSeverity.equals("")) break block22;
                    this.reportNoSeverity(name);
                    break block23;
                }
                if ("DEFAULT".equals(waiverSeverity = waiverSeverity.trim())) ** GOTO lbl81
                severity = Severity.from(waiverSeverity.trim());
                if (severity == null) {
                    this.reportUnknownWaiverSeverity(name, waiverSeverity);
                } else {
                    waiver.setSeverity(severity);
lbl81:
                    // 2 sources

                    if ((descriptionNodes = waiverNode.getElementsByTagName("description")).getLength() > 0) {
                        descriptionNode = (Element)descriptionNodes.item(0);
                        description = descriptionNode.getTextContent();
                        waiver.setDescription(description);
                    }
                    if ((matchNodes = waiverNode.getElementsByTagName("match")).getLength() == 0) {
                        matcher = DVTProblemMatcher.all();
                        matcher.setMessage(null);
                        matcher.setPath(null);
                        waiver.addMatchClause(matcher);
                    }
                    j = 0;
                    while (j < matchNodes.getLength()) {
                        matchNode = (Element)matchNodes.item(j);
                        matcher = DVTProblemMatcher.all();
                        matcher.setKind(matchNode.getAttribute("id").length() == 0 ? null : matchNode.getAttribute("id"));
                        message = matchNode.getAttribute("message").length() == 0 ? null : matchNode.getAttribute("message");
                        message = DVTStringUtil.unescapeXMLString(message, true);
                        matcher.setMessage(message);
                        path = matchNode.getAttribute("path").length() == 0 ? null : matchNode.getAttribute("path");
                        path = DVTStringUtil.unescapeXMLString(path, true);
                        if (path != null && (replacedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(path, DVTUtilsCommon.ReplaceSysvarsPolicy.RETURN_NULL, (DVTUtilsCommon.IEnvironmentProvider)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((DVTProblemWaiversXMLParser1)this))) == null) {
                            lineNumber = matchNode.getUserData("lineNumber");
                            matchLine = 0;
                            if (lineNumber instanceof String) {
                                matchLine = Integer.parseInt((String)lineNumber);
                            }
                            this.reportEnvVariableNotResolved(path, matchLine, this.getFile());
                        }
                        replacedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(path, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, (DVTUtilsCommon.IEnvironmentProvider)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/String;)Ljava/lang/String;, lambda$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((DVTProblemWaiversXMLParser1)this));
                        matcher.setPath(replacedPath);
                        matcher.setCategory(matchNode.getAttribute("category").length() == 0 ? null : matchNode.getAttribute("category"));
                        matcher.setSeverity(Severity.from(matchNode.getAttribute("default-severity")));
                        waiver.addMatchClause(matcher);
                        ++j;
                    }
                    resultWaivers.add(waiver);
                }
            }
            ++i;
        }
        return resultWaivers;
    }

    private File resolveIncludedFile(String includePath, String parentFilePath) {
        IPath projectLocation;
        if (Path.fromOSString((String)includePath).isAbsolute()) {
            return new File(includePath);
        }
        IPath iPath = projectLocation = this.getProject() == null ? null : this.getProject().getLocation();
        if (projectLocation == null) {
            return null;
        }
        File includedFile = new File(projectLocation.append(includePath).toOSString());
        if (includedFile.exists()) {
            return includedFile;
        }
        return new File(String.valueOf(parentFilePath) + System.getProperty("file.separator") + includePath);
    }

    private void reportInfiniteRecursion(DVTProblemWaiversXMLParser.InfiniteRecursionException e) {
        this.fMessages.add("Infinite recursion detected while loading waivers:");
        for (File file : e.getStack()) {
            this.fMessages.add("    " + file.getAbsolutePath());
        }
    }

    private void reportNoAttribute(String tag, String attr) {
        this.fMessages.add("Tag " + tag + " has no " + attr + " attribute specified.");
    }

    private void reportIncludedFileNotFound(String includedWaiverPath, int line, boolean isOptional, File file) {
        if (!isOptional) {
            this.fInexistentFileWarningMessages.add(new DVTProblemWaiversXMLParser.InexistentFileWaiverProblem(file, line, includedWaiverPath));
        }
    }

    private void reportEnvVariableNotResolved(String includedEnvVariable, int line, File file) {
        this.fUnresolvedVariableWarningMessages.add(new DVTProblemWaiversXMLParser.UnresolvedEnvWaiverProblem(file, line, includedEnvVariable));
    }

    private void reportUnknownWaiverSeverity(String waiverName, String unknownSeverity) {
        this.reportProblem("waiver " + waiverName + " has unknown severity " + unknownSeverity + "; valid are: " + Severity.valuesList());
    }

    private void reportNoSeverity(String waiverName) {
        this.reportProblem("waiver " + waiverName + " has no severity attribute.");
    }

    public void reportProblem(String message) {
        this.fMessages.add("Skipping waiver from '" + this.getFile().getAbsolutePath() + "' : " + message);
    }

    private /* synthetic */ String lambda$0(String envVarName) {
        return BuildConfigManager.getUserDefinedEnvVar(this.getProject(), envVarName, BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION);
    }

    private static /* synthetic */ void lambda$1(int n, DVTProblemWaiver x) {
        x.setWaiverDefRelativeIncludeLine(n);
    }

    private /* synthetic */ String lambda$2(String envVarName) {
        return BuildConfigManager.getUserDefinedEnvVar(this.getProject(), envVarName, BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION);
    }

    private /* synthetic */ String lambda$3(String envVarName) {
        return BuildConfigManager.getUserDefinedEnvVar(this.getProject(), envVarName, BuildConfigManagerCommon.EnvVarReplacementPriorityPolicy.LAST_INVOCATION);
    }
}

