/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.Serializable;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;

public class AutoDefineAPIWrapper
implements Comparable<AutoDefineAPIWrapper>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Hid hid;
    private int fileIndex;
    private IRfNamedElement scopeElement;
    private Object object;
    private IRfNamedElement scopeToDefine;

    public AutoDefineAPIWrapper(Hid hid, int fileIdex, IRfNamedElement scopeElement, Object object, IRfNamedElement scopeToDefine) {
        this.hid = hid;
        this.scopeElement = scopeElement;
        this.object = object;
        this.scopeToDefine = scopeToDefine;
        this.fileIndex = fileIdex;
    }

    public Hid getHid() {
        return this.hid;
    }

    public IRfNamedElement getScope() {
        return this.scopeElement;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public int compareTo(AutoDefineAPIWrapper o) {
        if (this.fileIndex != o.fileIndex) {
            return this.fileIndex - o.fileIndex;
        }
        Hid otherHid = o.getHid();
        if (this.hid == null || otherHid == null) {
            return 0;
        }
        HidAccess firstAccess = this.hid.getFirstAccess();
        HidAccess otherFirstAccess = otherHid.getFirstAccess();
        if (firstAccess != null && otherFirstAccess != null) {
            Hid firstHid = firstAccess.getFirstHid();
            Hid otherFirstHid = otherFirstAccess.getFirstHid();
            if (firstHid != null && otherFirstHid != null) {
                HidOccurrence occurrence = this.hid.getOccurrence();
                HidOccurrence anotherOccurrence = otherHid.getOccurrence();
                return occurrence.getOffset() - anotherOccurrence.getOffset();
            }
            if (firstHid != null) {
                return 1;
            }
            if (otherFirstHid != null) {
                return -1;
            }
        }
        HidOccurrence occurrence = this.hid.getOccurrence();
        HidOccurrence anotherOccurrence = otherHid.getOccurrence();
        return occurrence.getOffset() - anotherOccurrence.getOffset();
    }

    public IRfNamedElement getScopeToDefine() {
        return this.scopeToDefine;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.hid == null ? 0 : this.hid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AutoDefineAPIWrapper)) {
            return false;
        }
        AutoDefineAPIWrapper other = (AutoDefineAPIWrapper)obj;
        if (this.hid == null || other.getHid() == null) {
            return true;
        }
        return this.hid.getOccurrence().getOffset() == other.getHid().getOccurrence().getOffset();
    }
}

