/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public class AutolinkWithoutLinksRestorer {
    private Map<String, IRfSingleLangProject> fRfProjects;
    private IProject fProject;

    public AutolinkWithoutLinksRestorer(Map<String, IRfSingleLangProject> fRfProjects, IProject fProject) {
        this.fRfProjects = fRfProjects;
        this.fProject = fProject;
    }

    public void run() {
        try {
            IFile projectFile;
            boolean autolinkUsingLinks = BuildConfigManager.autolinkUsingLinks(this.fProject);
            DVTAutoLinkManager.getInstance().setProjectAutolinkUsingLinks(this.fProject, autolinkUsingLinks);
            if (autolinkUsingLinks) {
                return;
            }
            boolean descriptionContainsAutoLinked = DVTAutoLinkManager.getInstance().projectDescriptionContainsAutolink(this.fProject);
            if (descriptionContainsAutoLinked && (projectFile = this.fProject.getFile(".project")).isReadOnly()) {
                Utils.popMessage(4, "Cannot Update The DVT Auto-Linked", "The '.project' file of project " + this.fProject.getName() + " is readonly. " + "Make sure that the '.project' file is writable and run a full build to update the " + "DVT Auto-Linked" + " folder");
                return;
            }
            DVTAutoLinkManager.getInstance().removeAutolink(this.fProject);
            HashSet<String> compiledFiles = new HashSet<String>();
            List<BuildConfigProperty> includeProperties = BuildConfigManager.getIncludeProperties(this.fProject);
            for (BuildConfigProperty cmdFileCall : includeProperties) {
                compiledFiles.add(cmdFileCall.getValue());
            }
            for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
                Set<ParserPath> rawCompiledFilesSet = rfProject.getRawCompiledFilesSet();
                if (rawCompiledFilesSet == null) continue;
                Set compiledFilesInSingleLangProj = rawCompiledFilesSet.stream().map(e -> e.path).collect(Collectors.toSet());
                compiledFiles.addAll(compiledFilesInSingleLangProj);
            }
            this.restoreAutolinked(this.fProject, compiledFiles);
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
        }
    }

    private void restoreAutolinked(final IProject project, final Set<String> files) throws CoreException {
        DVTAutoLinkManager.getInstance().startWorkspaceOperation(project, true);
        DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

            @Override
            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                long time = System.currentTimeMillis();
                HashMap<String, List<IFile>> fileCandidates = new HashMap<String, List<IFile>>();
                HashMap<IPath, IPath> directorySymlinks = new HashMap<IPath, IPath>();
                DVTFileUtils.getInstance().cacheDirectories(project, files, fileCandidates, directorySymlinks);
                DVTLogger.INSTANCE.logDebug("AUTO_LINKED: Time to collect " + directorySymlinks.size() + " symlinked directories takes " + (System.currentTimeMillis() - time));
                Map<String, AutoLinkRoot> autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
                for (String path : files) {
                    IFile resource;
                    IFile parent = resource = AutolinkWithoutLinksRestorer.this.createAutoLinkedResource(project, Path.fromOSString((String)path), fileCandidates, directorySymlinks, cachedLinksMap, true, autoLinkedRoots);
                    while (parent != null && (parent = parent.getParent()) != null && PropertiesManager.getSessionProperty((IResource)parent, PropertyTypes.QN_IMPORTED_FILE) == null) {
                        PropertiesManager.addSessionProperty((IResource)parent, PropertyTypes.QN_IMPORTED_FILE, "Auto Link Manager");
                    }
                }
            }
        };
        DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, "Auto Link Manager", op, false);
        DVTAutoLinkManager.getInstance().endWorkspaceOperation(project, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFile createAutoLinkedResource(IProject project, IPath parserPath, Map<String, List<IFile>> fileCandidates, Map<IPath, IPath> directorySymlinks, Map<IPath, LinkDescription> cachedLinksMap, boolean autoLinkedResourcesEnable, Map<String, AutoLinkRoot> autoLinkedRoots) {
        try {
            String lastSegment = parserPath.lastSegment();
            if (lastSegment == null) {
                return null;
            }
            if (lastSegment.startsWith("__vlog__")) return null;
            if (lastSegment.startsWith("__sln__")) return null;
            if (lastSegment.startsWith("__edt__")) return null;
            if (lastSegment.startsWith("__vhdl__")) return null;
            if (lastSegment.startsWith("__pss__")) {
                return null;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file != null && file.getLocation() != null) {
                if (autoLinkedResourcesEnable) {
                    DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
                    return file;
                }
                if (!file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) return file;
                return null;
            }
            if (!autoLinkedResourcesEnable) {
                return null;
            }
            if (DVTAutoLinkManager.getInstance().hasError(project, 2)) return null;
            if (DVTAutoLinkManager.getInstance().hasError(project, 1)) {
                return null;
            }
            file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, fileCandidates, directorySymlinks);
            if (file == null || file.getLocation() == null) {
                file = DVTAutoLinkManager.getInstance().createAutoLink(project, parserPath, autoLinkedRoots, cachedLinksMap, false);
            } else {
                DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
            }
            if (file == null) return file;
            String resourcePath = file.getProjectRelativePath().toOSString();
            PropertiesManager.addParser2ResourceMapProperty(project, parserPath.toOSString(), resourcePath);
            return file;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            DVTAutoLinkManager.getInstance().reportError(project, 2);
            return null;
        }
    }

    public static void openRebuildDialog(final IProject project, final String title, final String message) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, message, 4, new String[]{"Rebuild Now", "Later"}, 0);
                if (dialog.open() == 0) {
                    DVTBuildUtils.runInternalBuilder(project);
                }
            }
        });
    }
}

