/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.IELDescription;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;

public class DummyInstance
implements IRfInstanceElement,
Serializable {
    private static final long serialVersionUID = 3L;
    public final String name;
    public final IRfDesignElement design;
    private final transient IRfFieldElement blockParameter;
    private final transient IHidObject blockParameterValue;

    public static DummyInstance of(String name, IRfDesignElement design) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (design == null) {
            throw new IllegalArgumentException("Design cannot be null");
        }
        return new DummyInstance(DVTStringUtil.intern(name), design, null, null);
    }

    public static DummyInstance of(String name, IRfDesignElement design, IRfFieldElement blockParameter, IHidObject blockParameterValue) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (design == null) {
            throw new IllegalArgumentException("Design cannot be null");
        }
        if (blockParameter == null) {
            throw new IllegalArgumentException("Block parameter cannot be null");
        }
        if (blockParameterValue == null) {
            throw new IllegalArgumentException("Block parameter value cannot be null");
        }
        return new DummyInstance(DVTStringUtil.intern(name), design, blockParameter, blockParameterValue);
    }

    private DummyInstance(String name, IRfDesignElement design, IRfFieldElement blockParameter, IHidObject blockParameterValue) {
        this.name = name;
        this.design = design;
        this.blockParameter = blockParameter;
        this.blockParameterValue = blockParameterValue;
    }

    @Override
    public IRfNamedElement getAssociatedType() {
        return this.design;
    }

    @Override
    public IRfNamedElement getGenericDesign(ElementPath instancePath) {
        return DesignUtils.toGenericDesignElement(this.getSpecializedDesign(instancePath));
    }

    @Override
    public IRfNamedElement getSpecializedDesign(ElementPath instancePath) {
        return this.design;
    }

    public boolean isGenerateInstance() {
        return DesignUtils.isBlock(this.design);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLowerCaseName() {
        return this.name.toLowerCase();
    }

    @Override
    public String getNameForNoDuplicateList() {
        return this.name;
    }

    @Override
    public boolean isEscaped() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Map<String, HidOperatorWrapper> getParameterOverrides(IRfDesignElement design, Map<String, IRfNamedElement> designParamMap, boolean markElabOperators, ConcurrentHashMap<IRfNamedElement, ConcurrentHashMap<IRfInstanceElement, List<HidOperatorWrapper>>> parameterOverridesCache) {
        if (this.blockParameter == null) {
            return null;
        }
        IHidBuilders blockBuilders = this.blockParameter.getHidBuilders();
        if (blockBuilders == null) {
            return null;
        }
        String blockParameterName = this.blockParameter.getName();
        Hid formalPart = blockBuilders.buildHid(this.blockParameter.getName(), this.blockParameter, HidOccurrence.DUMMY_OCCURRENCE, 0L);
        HidOperator override = blockBuilders.buildOperator(formalPart, Collections.singletonList(this.blockParameterValue), IHidOperatorConstants.OperatorType.ASSOCIATION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ".", new HidOperatorOccurrence(-1, -1, -1, HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER, null), HidQualifierCache.IS_GENERIC_VALUE_QUALIFIER);
        if (override == null) {
            return null;
        }
        OptimizedLinkedHashMap<String, HidOperatorWrapper> result = new OptimizedLinkedHashMap<String, HidOperatorWrapper>();
        boolean isCaseSensitive = !ELUtils.isVHDL(design);
        result.put(isCaseSensitive ? blockParameterName : blockParameterName.toLowerCase(), HidOperatorWrapper.of(override, null));
        return result;
    }

    public IRfFieldElement getBlockParameter() {
        return this.blockParameter;
    }

    public IHidObject getBlockParameterValue() {
        return this.blockParameterValue;
    }

    @Override
    public boolean hasSpecialization(ELSpecializationWrapper spec, ConcurrentHashMap<IELDescription, Set<ELSpecializationWrapper>> cache) {
        if (this.isGenerateInstance()) {
            return false;
        }
        return IRfInstanceElement.super.hasSpecialization(spec, cache);
    }

    @Override
    public boolean addSpecialization(ELSpecializationWrapper spec, ConcurrentHashMap<IELDescription, Set<ELSpecializationWrapper>> cache) {
        if (this.isGenerateInstance()) {
            return true;
        }
        return IRfInstanceElement.super.addSpecialization(spec, cache);
    }

    @Override
    public IRfDefElement getDeclaration() {
        return this.design.getDeclaration();
    }

    @Override
    public String getTooltipSignature(IRfScopeElement scope, ElementPath hierarchyPath, Hid hid, boolean useCharLimit) {
        return this.name;
    }

    @Override
    public String getComment() {
        return this.design.getComment();
    }

    @Override
    public Image getImage() {
        return this.design.getImage();
    }

    @Override
    public boolean checkEquals(Object obj) {
        return false;
    }

    @Override
    public String getSignature() {
        return this.design.getSignature();
    }

    @Override
    public boolean isPredefined() {
        return false;
    }

    @Override
    public Image testGetImage(String imageName) {
        return null;
    }

    @Override
    public Collection<? extends IRfDefElement> getDeclarations() {
        return this.design.getDeclarations();
    }

    @Override
    public IResource getFileAdapter() {
        return this.design.getFileAdapter();
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        return this.design.hasNoDefs(rawDefs);
    }

    @Override
    public int getLine() {
        return this.design.getLine();
    }

    @Override
    public IRfLibraryElement getEnclosingLibrary() {
        return this.design.getEnclosingLibrary();
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        return this.design.getEnclosingScope();
    }

    @Override
    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        IRfScopeElement enclosingScope = this.getEnclosingScope();
        return enclosingScope != null ? (T)enclosingScope.getEnclosingScope(clazz) : null;
    }

    @Override
    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        IRfScopeElement enclosingScope = this.getEnclosingScope();
        return enclosingScope != null ? enclosingScope.getEnclosingScope(classes) : null;
    }

    @Override
    public IRfSingleLangProject getRfProject() {
        return this.design.getRfProject();
    }

    @Override
    public LibraryPackageScope getLibPkgScope() {
        return this.design.getLibPkgScope();
    }

    @Override
    public List<? extends IRfInstanceElement> getBindInstances(long useCacheTimestamp) {
        return null;
    }

    @Override
    public List<Hid> getHids(HidQualifier[] qualifiers, boolean local) {
        return null;
    }

    @Override
    public List<IHidOperator> getHidOperators(HidOperatorQualifier[] qualifiers, boolean local) {
        return null;
    }

    @Override
    public boolean visitHidObject(IRfSingleLangProject project, IHidVisitor<?> visitor) {
        return false;
    }

    @Override
    public IHidHolder getHidHolder() {
        return null;
    }

    @Override
    public IRfNamedElement semanticGetMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement prevScope, boolean isFirst, boolean isLast, boolean recursiveCall) {
        return null;
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        return null;
    }

    @Override
    public String getNameForDiagram() {
        return this.name;
    }

    @Override
    public boolean isDirtyElement() {
        return false;
    }

    @Override
    public Collection<? extends IRfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        return null;
    }

    @Override
    public IRfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        return null;
    }

    @Override
    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
    }

    @Override
    public boolean hasLocalMembers() {
        return false;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        return null;
    }

    @Override
    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        return null;
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
    }

    @Override
    public boolean hasReferenceToIdentifierName(String name) {
        return false;
    }

    @Override
    public boolean isNonStandard() {
        return false;
    }

    @Override
    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public String getAssociatedTypeName() {
        return this.design.getName();
    }

    @Override
    public IRfNamedElement getAssociatedBaseType() {
        return this.design;
    }

    @Override
    public IRfDesignElement getInstantiatedDesign() {
        return this.design;
    }

    @Override
    public Class<? extends IRfNamedElement> getCustomClass() {
        return this.getClass();
    }

    @Override
    public String elementPathName() {
        return this.getName();
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        return null;
    }

    @Override
    public String getKindName() {
        return "";
    }

    @Override
    public LanguageKind getLanguageKind() {
        return this.design.getLanguageKind();
    }

    @Override
    public IRfNamedElement.ElementKind getKind() {
        return this.getLanguageKind() == LanguageKind.VLOG ? IRfNamedElement.ElementKind.VLOG_INSTANCE : IRfNamedElement.ElementKind.VHDL_INSTANCE;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.design.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DummyInstance other = (DummyInstance)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.design.equals(other.design);
    }
}

