/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import ro.amiq.dvt.elaboration.model.IELVertexId;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IndexedElementPath;
import ro.amiq.dvt.model.reflection.MultiIndexedElementPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidNameAndSelects;
import ro.amiq.dvt.utils.DVTStringUtil;

public class ElementPath
implements Serializable,
Comparable<ElementPath>,
IELVertexId,
IRfBreadcrumbElement {
    private static final long serialVersionUID = 2L;
    public static final ElementPath EMPTY_PATH = new ElementPath(null, null);
    public static final ElementPath $ROOT_NAME_PATH = new ElementPath(null, "$root");
    protected String segment;
    protected ElementPath parent;
    protected int length;

    protected ElementPath(ElementPath parent, String segment) {
        this.segment = DVTStringUtil.intern(segment);
        this.parent = parent == null || parent.isEmpty() ? null : parent;
        this.length = this.internalLength();
    }

    private int internalLength() {
        int parentLength = this.parent != null ? this.parent.length() : 0;
        int segmentLength = this.segment != null ? 1 : 0;
        return parentLength + segmentLength;
    }

    public static ElementPath create(ElementPath parent, String fullSegmentName) {
        if (fullSegmentName == null || fullSegmentName.isEmpty()) {
            return EMPTY_PATH;
        }
        char lastChar = fullSegmentName.charAt(fullSegmentName.length() - 1);
        if (lastChar != ']' && lastChar != ')') {
            return new ElementPath(parent, fullSegmentName);
        }
        char splitEndChar = lastChar;
        char splitChar = splitEndChar == ']' ? (char)'[' : '(';
        int splitIndex = fullSegmentName.indexOf(splitChar);
        int splitEndIndex = fullSegmentName.indexOf(splitEndChar);
        if (splitEndIndex > splitIndex) {
            try {
                String namePart = splitIndex > 0 ? fullSegmentName.substring(0, splitIndex) : "";
                ArrayList<Integer> indexParts = new ArrayList<Integer>(2);
                String newSubstring = fullSegmentName;
                while (!newSubstring.isEmpty()) {
                    indexParts.add(Integer.parseInt(newSubstring.substring(splitIndex + 1, splitEndIndex)));
                    newSubstring = newSubstring.substring(splitEndIndex + 1);
                    splitIndex = newSubstring.indexOf(splitChar);
                    splitEndIndex = newSubstring.indexOf(splitEndChar);
                    if (splitIndex == -1 || splitEndIndex <= splitIndex) break;
                }
                if (indexParts.size() == 1) {
                    return new IndexedElementPath(parent, namePart, (Integer)indexParts.get(0), splitChar);
                }
                int[] array = indexParts.stream().mapToInt(Integer::intValue).toArray();
                return new MultiIndexedElementPath(parent, namePart, array, splitChar);
            }
            catch (NumberFormatException numberFormatException) {
                return new ElementPath(parent, fullSegmentName);
            }
        }
        return new ElementPath(parent, fullSegmentName);
    }

    public static ElementPath create(List<String> pathSegments) {
        if (pathSegments.isEmpty()) {
            return EMPTY_PATH;
        }
        ElementPath path = null;
        for (String segment : pathSegments) {
            path = ElementPath.create(path, segment);
        }
        return path;
    }

    public static ElementPath create(String[] pathSegments) {
        if (pathSegments.length == 0) {
            return EMPTY_PATH;
        }
        ElementPath path = null;
        String[] stringArray = pathSegments;
        int n = pathSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            path = ElementPath.create(path, segment);
            ++n2;
        }
        return path;
    }

    public static final ElementPath usePrefix(ElementPath newPathPrefix, ElementPath originalPath, int replacementLength) {
        if (newPathPrefix == null) {
            return originalPath;
        }
        if (replacementLength > originalPath.length) {
            return originalPath;
        }
        ElementPath resultElementPath = originalPath.copy();
        int resultLength = resultElementPath.length;
        ElementPath parentElementPath = resultElementPath;
        while (resultLength - 1 > replacementLength) {
            parentElementPath = parentElementPath.parent;
            parentElementPath.length = parentElementPath.length + newPathPrefix.length - replacementLength;
            --resultLength;
        }
        parentElementPath.parent = newPathPrefix;
        resultElementPath.length = newPathPrefix.length + originalPath.length - replacementLength;
        return resultElementPath;
    }

    /*
     * Unable to fully structure code
     */
    public static ElementPath relativize(ElementPath elementPath, int length) {
        if (elementPath == null) {
            return ElementPath.EMPTY_PATH;
        }
        firstRelativePath = relativePath = elementPath.copy();
        if (length >= 1) ** GOTO lbl7
        return ElementPath.EMPTY_PATH;
lbl-1000:
        // 1 sources

        {
            firstRelativePath = firstRelativePath.parent;
lbl7:
            // 2 sources

            ** while (firstRelativePath.parent != null && --length > 0)
        }
lbl8:
        // 1 sources

        firstRelativePath.parent = null;
        return relativePath;
    }

    protected ElementPath copy() {
        if (this.parent == null) {
            return new ElementPath(null, this.segment);
        }
        return new ElementPath(this.parent.copy(), this.segment);
    }

    protected ElementPath copyNoRoot() {
        if (this.parent == null || "$root".equals(this.parent.segment)) {
            return new ElementPath(null, this.segment);
        }
        return new ElementPath(this.parent.copyNoRoot(), this.segment);
    }

    public ElementPath copyLowerCase() {
        if (this.parent == null) {
            return new ElementPath(null, this.segment.toLowerCase());
        }
        return new ElementPath(this.parent.copyLowerCase(), this.segment.toLowerCase());
    }

    public static final ElementPath join(ElementPath elementPathPrefix, List<String> childrenSegments) {
        for (String childSegment : childrenSegments) {
            elementPathPrefix = ElementPath.create(elementPathPrefix, childSegment);
        }
        return elementPathPrefix;
    }

    public static final ElementPath join(ElementPath elementPathPrefix, String childrenSegment) {
        if (elementPathPrefix == null || elementPathPrefix.isEmpty()) {
            return ElementPath.create(null, childrenSegment);
        }
        return ElementPath.create(elementPathPrefix, childrenSegment);
    }

    public static final ElementPath join(ElementPath elementPathPrefix, ElementPath elementDescription) {
        ElementPath resultElementPath;
        if (elementPathPrefix == null) {
            return elementDescription;
        }
        if (elementDescription.isEmpty()) {
            return elementPathPrefix;
        }
        ElementPath parentElementPath = resultElementPath = elementDescription.copy();
        while (parentElementPath.parent != null) {
            parentElementPath = parentElementPath.parent;
            parentElementPath.length += elementPathPrefix.length;
        }
        parentElementPath.parent = elementPathPrefix;
        resultElementPath.length = elementPathPrefix.length + elementDescription.length;
        return resultElementPath;
    }

    public static final ElementPath from(String elementPathString, String delimString) {
        if (elementPathString == null || delimString == null || delimString.isEmpty()) {
            return EMPTY_PATH;
        }
        return ElementPath.from(elementPathString, delimString.charAt(0), false);
    }

    public static final ElementPath from(String elementPathString, char delim, boolean splitOnPkgDelim) {
        if (elementPathString == null) {
            return EMPTY_PATH;
        }
        StringBuilder segment = new StringBuilder();
        ArrayList<String> pathSegments = new ArrayList<String>();
        int length = elementPathString.length();
        boolean escapedId = false;
        int i = 0;
        while (i < length) {
            char ch = elementPathString.charAt(i);
            if (!escapedId && ch == '\\') {
                escapedId = true;
            }
            if (Character.isWhitespace(ch)) {
                escapedId = false;
            } else if (!escapedId && (ch == delim || splitOnPkgDelim && ch == ':' && i > 0 && elementPathString.charAt(i - 1) == ':')) {
                if (ch == ':') {
                    segment.append(ch);
                }
                pathSegments.add(DVTStringUtil.intern(segment.toString()));
                segment.delete(0, segment.length());
            } else {
                segment.append(ch);
            }
            ++i;
        }
        if (segment.length() > 0) {
            pathSegments.add(DVTStringUtil.intern(segment.toString()));
        }
        return ElementPath.create(pathSegments);
    }

    public static final ElementPath from(List<HidNameAndSelects> hidSelects) {
        ArrayList<String> accessesSegments = new ArrayList<String>(hidSelects.size());
        for (HidNameAndSelects hidSelect : hidSelects) {
            StringBuilder sb = new StringBuilder().append(hidSelect.name);
            if (hidSelect.selects != null) {
                for (XComputedSelect select : hidSelect.selects) {
                    if (select.computedValues == null) {
                        return null;
                    }
                    sb.append('[');
                    sb.append(select.toNiceString());
                    sb.append(']');
                }
            }
            accessesSegments.add(sb.toString());
        }
        return ElementPath.create(accessesSegments);
    }

    public static final ElementPath upperPathOf(ElementPath elementPath) {
        return elementPath == null || elementPath.isEmpty() ? elementPath : elementPath.parent;
    }

    /*
     * Unable to fully structure code
     */
    public static final ElementPath firstPathOf(ElementPath elementPath) {
        if (elementPath != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            elementPath = elementPath.parent;
lbl4:
            // 2 sources

            ** while (elementPath.parent != null)
        }
lbl5:
        // 1 sources

        return elementPath;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int length() {
        return this.length;
    }

    public String firstSegment() {
        return this.parent != null ? this.parent.firstSegment() : this.lastSegment();
    }

    public String lastSegment() {
        return this.segment;
    }

    public String prevLastSegment() {
        return this.parent != null ? this.parent.lastSegment() : null;
    }

    public boolean hasRootPrefix() {
        String firstSegment = this.firstSegment();
        return "$root".equals(firstSegment);
    }

    public ElementPath toElaborationForm() {
        ElementPath result = this.copyNoRoot();
        if (result.length == this.length) {
            return this;
        }
        return result;
    }

    public ElementPath removeLastSegment() {
        if (this.isEmpty()) {
            return this;
        }
        return this.parent == null ? EMPTY_PATH : this.parent;
    }

    public ElementPath removeFirstSegment() {
        ElementPath resultElementPath;
        if (this.isEmpty()) {
            return this;
        }
        ElementPath parentElementPath = resultElementPath = this.copy();
        while (parentElementPath.parent != null && parentElementPath.parent.parent != null) {
            parentElementPath = parentElementPath.parent;
            --parentElementPath.length;
        }
        parentElementPath.parent = null;
        --resultElementPath.length;
        return resultElementPath;
    }

    public boolean endsWith(ElementPath suffixPath) {
        if (this.length == 0 && suffixPath.length == 0) {
            return true;
        }
        if (this.length == 0) {
            return false;
        }
        if (this.length < suffixPath.length) {
            return false;
        }
        ElementPath tempSufixPath = suffixPath;
        ElementPath tempThisPath = this;
        do {
            int[] index2;
            String name2;
            String name1;
            if (!Objects.equals(name1 = tempThisPath.getSegmentName(), name2 = tempSufixPath.getSegmentName())) {
                return false;
            }
            int[] index1 = tempThisPath.getSegmentIndices();
            if (!Arrays.equals(index1, index2 = tempSufixPath.getSegmentIndices())) {
                return false;
            }
            tempSufixPath = tempSufixPath.parent;
            tempThisPath = tempThisPath.parent;
        } while (tempSufixPath != null && tempThisPath != null);
        return true;
    }

    public boolean startsWith(ElementPath prefixPath) {
        if (this.length == 0 && prefixPath.length == 0) {
            return true;
        }
        if (this.length == 0) {
            return false;
        }
        if (this.length < prefixPath.length) {
            return false;
        }
        ElementPath tempThisPath = this;
        int i = 0;
        while (i < this.length - prefixPath.length) {
            tempThisPath = tempThisPath.parent;
            ++i;
        }
        ElementPath tempPrefixPath = prefixPath;
        do {
            int[] index2;
            String name2;
            String name1;
            if (!Objects.equals(name1 = tempThisPath.getSegmentName(), name2 = tempPrefixPath.getSegmentName())) {
                return false;
            }
            int[] index1 = tempThisPath.getSegmentIndices();
            if (!Arrays.equals(index1, index2 = tempPrefixPath.getSegmentIndices())) {
                return false;
            }
            tempPrefixPath = tempPrefixPath.parent;
            tempThisPath = tempThisPath.parent;
        } while (tempPrefixPath != null && tempThisPath != null);
        return true;
    }

    public boolean isPrefixOf(ElementPath relevantPath) {
        return relevantPath.startsWith(this);
    }

    public boolean isDirectParentOf(ElementPath pathElementPath) {
        if (pathElementPath == null || pathElementPath.isEmpty()) {
            return false;
        }
        return this.equals(pathElementPath.parent);
    }

    public String[] getSegments() {
        String[] segments = new String[this.length];
        ElementPath thisPath = this;
        int i = 0;
        while (i < this.length) {
            segments[this.length - i - 1] = thisPath.lastSegment();
            thisPath = thisPath.parent;
            ++i;
        }
        return segments;
    }

    public List<ElementPath> getSubPaths() {
        ArrayList<ElementPath> result = new ArrayList<ElementPath>(this.length);
        ElementPath iterator = this;
        while (iterator != null && !iterator.isEmpty()) {
            result.add(iterator);
            iterator = iterator.parent;
        }
        Collections.reverse(result);
        return result;
    }

    public String getSegment(int index) {
        if (index >= this.length) {
            return null;
        }
        ElementPath thisPath = this;
        int i = 0;
        while (i < this.length - index - 1) {
            thisPath = thisPath.parent;
            ++i;
        }
        return thisPath.lastSegment();
    }

    public int[] getSegmentIndices() {
        return null;
    }

    public String getSegmentName() {
        return this.segment;
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        return null;
    }

    @Override
    public String getName() {
        return this.lastSegment();
    }

    @Override
    public int compareTo(ElementPath other) {
        String otherSegmentName;
        int result;
        if (this == other) {
            return 0;
        }
        if (other == null) {
            throw new NullPointerException();
        }
        int ownLength = this.length;
        int otherLength = other.length;
        if (ownLength == 0 && otherLength == 0) {
            return 0;
        }
        if (ownLength == 0) {
            return -1;
        }
        if (otherLength == 0) {
            return 1;
        }
        ElementPath own = this;
        int i = Math.max(ownLength, otherLength);
        while (i > Math.min(ownLength, otherLength)) {
            if (i == own.length) {
                own = own.parent;
            }
            if (i == other.length) {
                other = other.parent;
            }
            --i;
        }
        if (own == null && other == null) {
            return 0;
        }
        if (own == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        if (own.parent != null && other.parent != null && (result = own.parent.compareTo(other.parent)) != 0) {
            return result;
        }
        String ownSegmentName = own.getSegmentName();
        int result2 = ownSegmentName.compareTo(otherSegmentName = other.getSegmentName());
        if (result2 != 0) {
            return result2;
        }
        int indexCompare = Arrays.compare(own.getSegmentIndices(), other.getSegmentIndices());
        if (indexCompare != 0) {
            return indexCompare;
        }
        return ownLength - otherLength;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.toString(".", result);
        return result.toString();
    }

    public String toString(String delim) {
        StringBuilder result = new StringBuilder();
        this.toString(delim, result);
        return result.toString();
    }

    private void toString(String delim, StringBuilder result) {
        if (this.parent == null) {
            if (this.segment != null) {
                result.append(this.lastSegment());
            }
            return;
        }
        this.parent.toString(delim, result);
        int resultLength = result.length();
        if (resultLength < 2 || result.charAt(resultLength - 2) != ':' || result.charAt(resultLength - 1) != ':') {
            result.append(delim);
        }
        result.append(this.lastSegment());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.segment == null ? 0 : this.segment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ElementPath)) {
            return false;
        }
        ElementPath other = (ElementPath)obj;
        if (this.length != other.length) {
            return false;
        }
        if (!Objects.equals(this.segment, other.segment)) {
            return false;
        }
        return Objects.equals(this.parent, other.parent);
    }
}

