/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.File;
import java.util.function.Supplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class GoToInfo
implements Comparable<GoToInfo> {
    public String filePath;
    public int offset;
    public int virtualOffset;
    public int line;
    public int endLine;
    public String text;
    public LanguageKind languageKind;

    public static GoToInfo of(String filePath, int offset, int virtualOffset, int line, String text, LanguageKind languageKind) {
        return GoToInfo.of(filePath, offset, virtualOffset, line, line, text, languageKind);
    }

    public static GoToInfo of(String filePath, int offset, int virtualOffset, int line, int endLine, String text, LanguageKind languageKind) {
        if (line < 0 || endLine < 0) {
            return null;
        }
        return new GoToInfo(filePath, offset, virtualOffset, line, endLine, text, languageKind);
    }

    public static GoToInfo dummyOf(String filePath, int offset, int virtualOffset, int line, int endLine, String text, LanguageKind languageKind) {
        return new GoToInfo(filePath, offset, virtualOffset, line, endLine, text, languageKind);
    }

    public static GoToInfo sourceOf(IRfNamedElement namedElement) {
        if (namedElement instanceof HierarchicalElement) {
            namedElement = ((HierarchicalElement)namedElement).getFirstSegment();
        }
        if (namedElement == null || namedElement instanceof DummyPort) {
            return null;
        }
        IRfDefElement defElem = namedElement.getDeclaration();
        return GoToInfo.sourceOf(defElem, namedElement.getName());
    }

    public static GoToInfo sourceOf(IRfDefElement defElem, String name) {
        ParserPath parserPath;
        IRfFileDef defFile;
        GoToInfo sourceInfo = new GoToInfo(null, -1, -1, -1, -1, null, null);
        if (defElem != null && (defFile = defElem.getDefFile()) != null && (parserPath = defFile.getParserPath()) != null) {
            sourceInfo.filePath = parserPath.path;
            sourceInfo.offset = defElem.getStartOffset();
            sourceInfo.virtualOffset = defElem.getStartOffset() == defElem.getEndOffset() ? 0 : -1;
            sourceInfo.line = defElem.getStartLine();
            sourceInfo.endLine = defElem.getEndLine();
            sourceInfo.text = name;
            sourceInfo.languageKind = defFile.getLanguageKind();
            return sourceInfo;
        }
        return null;
    }

    public static GoToInfo sourceOf(IHidOperator operator, String filePath, String text, LanguageKind languageKind) {
        if (operator == null) {
            return null;
        }
        HidOperatorOccurrence occurrence = operator.getOccurrence();
        return GoToInfo.of(filePath, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), text, languageKind);
    }

    public GoToInfo(String filePath, int offset, int virtualOffset, int line, int endLine, String text, LanguageKind languageKind) {
        this.filePath = DVTStringUtil.intern(filePath);
        this.offset = offset;
        this.virtualOffset = virtualOffset;
        this.line = line;
        this.text = text;
        this.endLine = endLine;
        this.languageKind = languageKind;
    }

    public static GoToInfoSupplier sourceSupplierFor(final String filePath, final LanguageKind languageKind) {
        return new GoToInfoSupplier(){

            @Override
            public GoToInfo get(HidOperatorOccurrence occurrence, String text) {
                return GoToInfo.of(filePath, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), text, languageKind);
            }
        };
    }

    public void open(IProject project, boolean activate) {
        IFile iFile;
        if (this.filePath == null) {
            return;
        }
        if (project != null && (iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, this.filePath)) != null) {
            DVTFileUtils.getInstance().openEditor(iFile, this.line, this.text, activate, this.languageKind == null ? null : this.languageKind.EDITOR_ID);
            return;
        }
        DVTFileUtils.getInstance().openEditor(new File(this.filePath), this.line, this.text, this.languageKind != null ? this.languageKind.EDITOR_ID : "org.eclipse.ui.DefaultTextEditor", activate);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + this.virtualOffset;
        result = 31 * result + this.line;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoToInfo other = (GoToInfo)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.virtualOffset != other.virtualOffset) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return "(" + this.offset + ", " + this.virtualOffset + ", " + this.line + ", " + this.filePath + "," + this.text + ")";
    }

    @Override
    public int compareTo(GoToInfo o) {
        if (this.filePath == null || o.filePath == null || this.filePath.equals(o.filePath)) {
            if (this.offset != o.offset) {
                return this.offset - o.offset;
            }
            return this.line - o.line;
        }
        return this.filePath.compareTo(o.filePath);
    }

    public static interface GoToInfoSupplier
    extends Supplier<GoToInfo> {
        public GoToInfo get(HidOperatorOccurrence var1, String var2);

        @Override
        default public GoToInfo get() {
            return null;
        }
    }
}

