/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.GoToInfoWithBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public abstract class GoToInfoWithBreadcrumbElementCommon
extends GoToInfo {
    public IRfBreadcrumbElement element;
    protected boolean includeSelf;

    protected GoToInfoWithBreadcrumbElementCommon(String filePath, int offset, int virtualOffset, int line, int endLine, String text, LanguageKind languageKind, IRfBreadcrumbElement element, boolean includeSelf) {
        super(filePath, offset, virtualOffset, line, endLine, text, languageKind);
        this.element = element;
        this.includeSelf = includeSelf;
    }

    public static GoToInfo sourceOf(IRfNamedElement destinationElement, IRfBreadcrumbElement bcElement) {
        GoToInfo info = GoToInfo.sourceOf(destinationElement);
        if (info == null) {
            return null;
        }
        IRfBreadcrumbElement element = bcElement == null ? destinationElement : bcElement;
        return new GoToInfoWithBreadcrumbElement(info.filePath, info.offset, info.virtualOffset, info.line, info.endLine, info.text, info.languageKind, element, bcElement != null);
    }

    @Override
    public void open(IProject project, boolean activate) {
        if (this.filePath == null) {
            return;
        }
        if (project == null || this.element == null) {
            super.open(project, activate);
            return;
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, this.filePath);
        if (iFile == null) {
            DVTFileUtils.getInstance().openEditor(new File(this.filePath), this.line, this.text, this.languageKind != null ? this.languageKind.EDITOR_ID : "org.eclipse.ui.DefaultTextEditor", activate);
            return;
        }
        IRfBreadcrumbElement toAppend = this.element instanceof ElementPath ? ElementPath.join(ElementPath.$ROOT_NAME_PATH, Arrays.asList(((ElementPath)this.element).getSegments())) : this.element;
        BreadcrumbInput bcInput = Utils.computeBreadcrumbInfo(iFile, toAppend, this.includeSelf);
        DVTFileUtils.getInstance().openEditor(iFile, this.line, this.text, activate, null);
        IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
        if (activeEditor instanceof DVTEditor && bcInput != null) {
            DesignPathManager.getInstance().updateFor((DVTEditor)activeEditor, bcInput.getElementPath());
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.element);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoToInfoWithBreadcrumbElementCommon other = (GoToInfoWithBreadcrumbElementCommon)obj;
        return Objects.equals(this.element, other.element);
    }
}

