/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.problems.LibraryPackageScope;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.utils.DVTStringUtil;

public class HierarchicalElement
implements IRfNamedElement {
    private final List<IRfNamedElement> segments;
    private int hardLimit = 0;

    public static final IRfNamedElement of(IRfNamedElement ... segments) {
        if (segments == null || segments.length == 0) {
            return null;
        }
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>(segments.length);
        IRfNamedElement[] iRfNamedElementArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            IRfNamedElement segment = iRfNamedElementArray[n2];
            if (segment == null) {
                return null;
            }
            if (segment instanceof HierarchicalElement) {
                HierarchicalElement.flattenSegments(((HierarchicalElement)segment).segments, result);
            } else {
                result.add(segment);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() == 1) {
            return (IRfNamedElement)result.get(0);
        }
        return new HierarchicalElement(result, segments.length);
    }

    private static final void flattenSegments(List<IRfNamedElement> original, List<IRfNamedElement> flattened) {
        for (IRfNamedElement segment : original) {
            if (segment instanceof HierarchicalElement) {
                HierarchicalElement.flattenSegments(((HierarchicalElement)segment).segments, flattened);
                continue;
            }
            flattened.add(segment);
        }
    }

    public static final IRfNamedElement upwardsOf(Hid last, IHidObject first, boolean allowUnresolved, int hardLimit) {
        if (last == null) {
            return null;
        }
        Hid lastHid = last;
        ArrayDeque<IRfNamedElement> result = new ArrayDeque<IRfNamedElement>();
        while (lastHid != null) {
            IRfNamedElement segment = lastHid.getElement();
            if (segment == null && !allowUnresolved) {
                return null;
            }
            if (segment == null) {
                segment = new UnresolvedSegment(lastHid);
            }
            if (segment instanceof IRfFieldElement var7_7) {
                fieldElement.setHidden(lastHid.hasQualifier(HidQualifierCache.HIDDEN));
            }
            result.addFirst(segment);
            if (lastHid.equals(first)) break;
            lastHid = lastHid.getParentHid();
        }
        if (result.size() == 1) {
            return (IRfNamedElement)result.getFirst();
        }
        return new HierarchicalElement(new ArrayList<IRfNamedElement>(result), hardLimit);
    }

    private HierarchicalElement(List<IRfNamedElement> segments, int hardLimit) {
        this.segments = segments;
        this.hardLimit = hardLimit;
    }

    public int getHardLimit() {
        return this.hardLimit;
    }

    public IRfNamedElement getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    public IRfNamedElement getFirstSegment() {
        return this.segments.get(0);
    }

    public int length() {
        return this.segments.size();
    }

    public IRfNamedElement getSubPart(int lowerLimit, int upperlimit) {
        if (lowerLimit > upperlimit || lowerLimit < 0 || upperlimit > this.segments.size()) {
            return null;
        }
        return HierarchicalElement.of(this.segments.subList(lowerLimit, upperlimit).toArray(new IRfNamedElement[0]));
    }

    public IRfNamedElement getFixedPart() {
        return this.getSubPart(0, this.hardLimit);
    }

    public IRfNamedElement getMovablePart() {
        return this.getSubPart(this.hardLimit, this.segments.size() - 1);
    }

    public List<IRfNamedElement> getSegments() {
        return this.segments;
    }

    public IRfNamedElement getSegmentsWithoutHidden() {
        ArrayList<Object> segmentsWithoutHidden = new ArrayList<Object>();
        for (IRfNamedElement segment : this.segments) {
            if (!(segment instanceof IRfFieldElement var4_4)) {
                segmentsWithoutHidden.add(segment);
                continue;
            }
            if (fieldElement.isHidden()) continue;
            segmentsWithoutHidden.add(fieldElement);
        }
        if (segmentsWithoutHidden.isEmpty()) {
            return null;
        }
        return HierarchicalElement.of(segmentsWithoutHidden.toArray(new IRfNamedElement[0]));
    }

    public boolean hasHiddenSegments() {
        return this.segments.stream().anyMatch(segment -> {
            void fieldElement;
            void var2_1;
            IRfFieldElement iRfFieldElement;
            IRfNamedElement iRfNamedElement = segment;
            return iRfNamedElement instanceof IRfFieldElement && (iRfFieldElement = (IRfFieldElement)iRfNamedElement) == (IRfFieldElement)var2_1 && fieldElement.isHidden();
        });
    }

    public String toString() {
        return DVTStringUtil.join(this.segments.toArray(), " . ");
    }

    @Override
    public String getKindName() {
        return "[unknown]";
    }

    @Override
    public IRfSingleLangProject getRfProject() {
        return this.getFirstSegment().getRfProject();
    }

    @Override
    public IRfScopeElement getEnclosingScope() {
        return this.getFirstSegment().getEnclosingScope();
    }

    @Override
    public <T extends IRfScopeElement> T getEnclosingScope(Class<T> clazz) {
        return this.getFirstSegment().getEnclosingScope(clazz);
    }

    @Override
    public IRfScopeElement getEnclosingScope(Set<?> classes) {
        return this.getFirstSegment().getEnclosingScope(classes);
    }

    public String getFullNameExcludingHiddenSegments() {
        ArrayList<Object> segmentsExcludingHidden = new ArrayList<Object>();
        for (IRfNamedElement segment : this.segments) {
            if (!(segment instanceof IRfFieldElement var4_4)) {
                segmentsExcludingHidden.add(segment);
                continue;
            }
            if (fieldElement.isHidden()) continue;
            segmentsExcludingHidden.add(fieldElement);
        }
        return DVTStringUtil.join(segmentsExcludingHidden, ".");
    }

    public String getFullName() {
        return DVTStringUtil.join(this.segments.toArray(), ".");
    }

    @Override
    public String getName() {
        return this.getFirstSegment().getName();
    }

    @Override
    public String getLowerCaseName() {
        String name = this.getName();
        return name == null ? null : name.toLowerCase();
    }

    @Override
    public String getNameForNoDuplicateList() {
        return this.getName();
    }

    @Override
    public String getNameForDiagram() {
        return this.getName();
    }

    @Override
    public boolean isEscaped() {
        return this.getLastSegment().isEscaped();
    }

    @Override
    public IRfDefElement getDeclaration() {
        return this.getFirstSegment().getDeclaration();
    }

    @Override
    public String getTooltipSignature(IRfScopeElement scope, ElementPath hierarchyPath, Hid hid, boolean useCharLimit) {
        return this.getLastSegment().getTooltipSignature(scope, hierarchyPath, hid, useCharLimit);
    }

    @Override
    public String getComment() {
        return this.getFirstSegment().getComment();
    }

    @Override
    public Image getImage() {
        return this.getLastSegment().getImage();
    }

    @Override
    public Collection<? extends IRfDefElement> getDeclarations() {
        return this.getFirstSegment().getDeclarations();
    }

    @Override
    public IResource getFileAdapter() {
        return this.getFirstSegment().getFileAdapter();
    }

    @Override
    public boolean hasNoDefs(boolean rawDefs) {
        return this.getFirstSegment().hasNoDefs(rawDefs);
    }

    @Override
    public int getLine() {
        return this.getFirstSegment().getLine();
    }

    @Override
    public IRfLibraryElement getEnclosingLibrary() {
        return this.getFirstSegment().getEnclosingLibrary();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchicalElement other = (HierarchicalElement)obj;
        if (this.segments.size() != other.segments.size()) {
            return false;
        }
        return Arrays.equals(this.segments.toArray(), other.segments.toArray());
    }

    @Override
    public List<? extends IRfNamedElement> getSignalsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfNamedElement getSignalWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfInstanceElement getInstanceWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfPackageElement> getPackagesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfPackageElement getPackageWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfDesignElement> getDesignsWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfDesignElement getDesignWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfConfiguration getConfigurationWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public List<? extends IRfNamedElement> getTypesWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public IRfNamedElement getTypeWithPrefix(String prefix, int matchType) {
        return null;
    }

    @Override
    public boolean checkEquals(Object obj) {
        return false;
    }

    @Override
    public String getSignature() {
        return null;
    }

    @Override
    public boolean isPredefined() {
        return false;
    }

    @Override
    public Image testGetImage(String imageName) {
        return this.getLastSegment().testGetImage(imageName);
    }

    public List<IRfInstanceElement> getBindInstances(long useCacheTimestamp) {
        return null;
    }

    @Override
    public List<Hid> getHids(HidQualifier[] qualifiers, boolean local) {
        return null;
    }

    @Override
    public List<IHidOperator> getHidOperators(HidOperatorQualifier[] qualifiers, boolean local) {
        return null;
    }

    @Override
    public boolean visitHidObject(IRfSingleLangProject project, IHidVisitor<?> visitor) {
        return false;
    }

    @Override
    public IHidHolder getHidHolder() {
        return null;
    }

    @Override
    public IRfNamedElement semanticGetMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement initialScope, IRfNamedElement prevScope, boolean isFirst, boolean isLast, boolean recursiveCall) {
        return null;
    }

    @Override
    public IRfNamedElement semanticGetLocalMember(String name, IHid hid, ParserPath parserPath, IRfNamedElement prevScope, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean recursiveCall) {
        return null;
    }

    @Override
    public LibraryPackageScope getLibPkgScope() {
        return null;
    }

    @Override
    public boolean isDirtyElement() {
        return false;
    }

    @Override
    public Collection<? extends IRfNamedElement> getMembers(boolean rawMembers, boolean unpackDuplicates) {
        return null;
    }

    @Override
    public IRfNamedElement getLocalMember(Set<Class<? extends IRfNamedElement>> classes, String name, IRfNamedElement exclude) {
        return null;
    }

    @Override
    public void getElementsWithPrefix(Collection<IRfNamedElement> result, String prefix, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) {
    }

    @Override
    public boolean hasLocalMembers() {
        return false;
    }

    @Override
    public IRfNamedElement getVisibleMemberInScope(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, Set<IRfNamedElement> visited, List<String> enumNameProposals, boolean isFirst, boolean isLast, boolean isOnlyType, boolean skipParents) {
        return null;
    }

    @Override
    public Class<? extends IRfNamedElement> getCustomClass() {
        return null;
    }

    @Override
    public IRfNamedElement getMember(String name, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, boolean skipParents) {
        return null;
    }

    @Override
    public <T extends IRfNamedElement> void getLocalMembers(Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
    }

    @Override
    public boolean hasReferenceToIdentifierName(String name) {
        return false;
    }

    @Override
    public boolean isNonStandard() {
        return false;
    }

    @Override
    public String elementPathName() {
        return null;
    }

    @Override
    public IRfNamedElement elementPathMember(String name, boolean isFirst, boolean isLast, boolean includeEnums, boolean isOnlyType, IRfNamedElement bindInstanceScope, Set<Class<? extends IRfNamedElement>> classes, IRfNamedElement exclude, ParserPath parserPath, int line) {
        return null;
    }

    public static class UnresolvedSegment
    extends DummyElement {
        private Hid unresolved;

        public UnresolvedSegment(String name) {
            super(name);
        }

        public UnresolvedSegment(Hid hid) {
            super(hid.getName());
            this.unresolved = hid;
        }
    }
}

