/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.Set;
import ro.amiq.dvt.model.reflection.DeltaFileWrapper;

public interface IIncrementalDeltaContainer {
    public Set<DeltaFileWrapper> getDeltaFilesParserPath(boolean var1);

    public String logDelta(LogOption var1);

    public static enum LogOption {
        BEFORE_INCREMENTAL_NAMED_ELEMENTS(1L),
        AFTER_INCREMENTAL_NAMED_ELEMENTS(2L),
        REMOVED_NAMED_ELEMENTS(4L),
        ADDED_NAME_ELEMENTS(8L),
        CHANGED_TYPE_NAMES(16L),
        ADDED_IMPORT_INFOS(32L),
        CHANGED_IMPORT_PACKAGE_NAMES(64L),
        PARSER_PATHS(128L),
        CLASSES_WITH_CHANGED_PARENT(256L),
        FIRST_LEVEL_ELEMENTS(512L),
        DELTA(1024L),
        CURRENT_FILES_SCOPE(2048L),
        CHANGED_MACROS(4096L),
        ALL(Long.MAX_VALUE);

        private long value;

        private LogOption(long value) {
            this.value = value;
        }

        private long getValue() {
            return this.value;
        }

        public LogOption include(LogOption option) {
            this.value |= option.getValue();
            return this;
        }

        public LogOption exclude(LogOption option) {
            this.value &= option.getValue() ^ 0xFFFFFFFFFFFFFFFFL;
            return this;
        }

        public boolean hasOption(LogOption option) {
            return (this.value & option.getValue()) != 0L;
        }
    }
}

