/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import ro.amiq.dvt.model.reflection.ElementPath;

class IndexedElementPath
extends ElementPath {
    private static final long serialVersionUID = 1L;
    private int segmentIndex;
    private char splitChar;

    public IndexedElementPath(ElementPath parent, String segmentName, int segmentIndex, char splitChar) {
        super(parent, segmentName);
        this.segmentIndex = segmentIndex;
        this.splitChar = splitChar;
    }

    @Override
    protected ElementPath copy() {
        if (this.parent == null) {
            return new IndexedElementPath(null, this.segment, this.segmentIndex, this.splitChar);
        }
        return new IndexedElementPath(this.parent.copy(), this.segment, this.segmentIndex, this.splitChar);
    }

    @Override
    protected ElementPath copyNoRoot() {
        if (this.parent == null || "$root".equals(this.parent.segment)) {
            return new IndexedElementPath(null, this.segment, this.segmentIndex, this.splitChar);
        }
        return new IndexedElementPath(this.parent.copyNoRoot(), this.segment, this.segmentIndex, this.splitChar);
    }

    @Override
    public ElementPath copyLowerCase() {
        if (this.parent == null) {
            return new IndexedElementPath(null, this.segment.toLowerCase(), this.segmentIndex, this.splitChar);
        }
        return new IndexedElementPath(this.parent.copyLowerCase(), this.segment.toLowerCase(), this.segmentIndex, this.splitChar);
    }

    @Override
    public String lastSegment() {
        char splitEndChar = this.splitChar == '(' ? (char)')' : ']';
        return this.segment + this.splitChar + this.segmentIndex + splitEndChar;
    }

    @Override
    public int[] getSegmentIndices() {
        return new int[]{this.segmentIndex};
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.segmentIndex;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexedElementPath other = (IndexedElementPath)obj;
        return this.segmentIndex == other.segmentIndex;
    }
}

