/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.Serializable;

public class LineInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final LineInfo INFINITE = new LineInfo(-1, -1, -1);
    public static final LineInfo UNKNOWN = new LineInfo(-1, -1, -1);
    public int realOffset;
    public int virtOffset;
    public int line;

    public LineInfo(int line, int realOffset, int virtOffset) {
        this.line = line;
        this.realOffset = realOffset;
        this.virtOffset = virtOffset;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.line;
        result = 31 * result + this.realOffset;
        result = 31 * result + this.virtOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineInfo other = (LineInfo)obj;
        if (this.line != other.line) {
            return false;
        }
        if (this.realOffset != other.realOffset) {
            return false;
        }
        return this.virtOffset == other.virtOffset;
    }

    public String toString() {
        return "[" + this.line + ':' + this.realOffset + ':' + this.virtOffset + ']';
    }

    public int getOffset() {
        if (this.virtOffset > 0) {
            return -1;
        }
        return this.realOffset;
    }

    public int getEndOffset(String name) {
        if (this.virtOffset > this.realOffset && this.virtOffset < this.realOffset + 200) {
            return this.virtOffset;
        }
        return this.realOffset + name.length();
    }
}

