/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.Arrays;
import ro.amiq.dvt.model.reflection.ElementPath;

class MultiIndexedElementPath
extends ElementPath {
    private static final long serialVersionUID = 1L;
    private int[] segmentIndices;
    private char splitChar;

    public MultiIndexedElementPath(ElementPath parent, String segmentName, int[] segmentIndices, char splitChar) {
        super(parent, segmentName);
        this.segmentIndices = segmentIndices;
        this.splitChar = splitChar;
    }

    @Override
    protected ElementPath copy() {
        if (this.parent == null) {
            return new MultiIndexedElementPath(null, this.segment, this.segmentIndices, this.splitChar);
        }
        return new MultiIndexedElementPath(this.parent.copy(), this.segment, this.segmentIndices, this.splitChar);
    }

    @Override
    protected ElementPath copyNoRoot() {
        if (this.parent == null || "$root".equals(this.parent.segment)) {
            return new MultiIndexedElementPath(null, this.segment, this.segmentIndices, this.splitChar);
        }
        return new MultiIndexedElementPath(this.parent.copyNoRoot(), this.segment, this.segmentIndices, this.splitChar);
    }

    @Override
    public ElementPath copyLowerCase() {
        if (this.parent == null) {
            return new MultiIndexedElementPath(null, this.segment.toLowerCase(), this.segmentIndices, this.splitChar);
        }
        return new MultiIndexedElementPath(this.parent.copyLowerCase(), this.segment.toLowerCase(), this.segmentIndices, this.splitChar);
    }

    @Override
    public String lastSegment() {
        char splitEndChar = this.splitChar == '(' ? (char)')' : ']';
        StringBuilder builder = new StringBuilder().append(this.segment);
        int[] nArray = this.segmentIndices;
        int n = this.segmentIndices.length;
        int n2 = 0;
        while (n2 < n) {
            Integer index = nArray[n2];
            builder.append(this.splitChar).append(index).append(splitEndChar);
            ++n2;
        }
        return builder.toString();
    }

    @Override
    public int[] getSegmentIndices() {
        return this.segmentIndices;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.segmentIndices);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiIndexedElementPath other = (MultiIndexedElementPath)obj;
        return Arrays.equals(this.segmentIndices, other.segmentIndices);
    }
}

