/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.persistence.PersistenceInputStream;
import ro.amiq.dvt.precompiled.PrecompiledDBUtilsCommon;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;

public class ParserPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String path;
    private byte[] md5;
    private long size;
    protected String canonical;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParserPath)) {
            return false;
        }
        return this.path.equals(((ParserPath)obj).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public ParserPath(String path) {
        this.path = DVTStringUtil.intern(Utils.canonicPath(path));
    }

    public ParserPath(ParserPath parserPath) {
        this.path = parserPath.path;
    }

    public byte[] getMd5() {
        return this.md5;
    }

    public long getSize() {
        return this.size;
    }

    public void setMd5(byte[] md5) {
        this.md5 = md5;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        return this.path;
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public int compareTo(ParserPath parserPath) {
        return this.path.compareTo(parserPath.path);
    }

    public ParserPathCanonical toCanonical() {
        ParserPathCanonical parserPathCanonical = new ParserPathCanonical(this);
        parserPathCanonical.canonical = this.getCanonicalPath();
        return parserPathCanonical;
    }

    public String getCanonicalPath() {
        try {
            if (this.canonical == null) {
                IPath filePath = Path.fromOSString((String)this.path);
                IFileInfo fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(filePath);
                if (fileInfo != null) {
                    this.canonical = fileInfo.getStringAttribute(64);
                    if (this.canonical == null) {
                        this.canonical = this.path;
                    } else {
                        IPath canonicalPath = Path.fromOSString((String)this.canonical);
                        if (!canonicalPath.isAbsolute()) {
                            this.canonical = filePath.removeLastSegments(1).append(this.canonical).toOSString();
                        }
                    }
                } else {
                    this.canonical = new File(this.path).getCanonicalPath();
                }
            }
        }
        catch (IOException iOException) {
            this.canonical = this.path;
        }
        return this.canonical;
    }

    public void resetCanonical() {
        this.canonical = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!(in instanceof PersistenceInputStream)) {
            return;
        }
        PersistenceBase persistence = ((PersistenceInputStream)in).getPersistence();
        if (((PersistenceInputStream)in).getPersistenceModeWrapper().persistenceMode != BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_LOAD) {
            return;
        }
        IProject project = persistence.getProject();
        String substitution = PrecompiledDBUtilsCommon.resolvePrecompiledParserPathSubstitution(project, this);
        if (substitution == null) {
            return;
        }
        if (!(DVTAutoLinkManager.getInstance().fetchFileInfo(Path.fromOSString((String)substitution)).exists() || this.path.contains("__vlog__") || this.path.contains("<predefined>"))) {
            DVTBuildConsoleRegistry.getConsole(project).print("Missing source for precompiled file: " + substitution, DVTBuildConsoleCommon.MessageSink.CONSOLE);
        }
        this.path = substitution;
        this.canonical = substitution;
    }

    public static class ParserPathCanonical
    extends ParserPath {
        private static final long serialVersionUID = 1L;
        private ParserPath parserPath;

        public ParserPathCanonical(ParserPath parserPath) {
            super(parserPath);
            this.parserPath = parserPath;
        }

        @Override
        public String getCanonicalPath() {
            return this.canonical;
        }

        @Override
        public ParserPathCanonical toCanonical() {
            return this;
        }

        @Override
        public int hashCode() {
            return this.canonical.hashCode();
        }

        @Override
        public byte[] getMd5() {
            return this.parserPath.md5;
        }

        @Override
        public long getSize() {
            return this.parserPath.size;
        }

        @Override
        public void setMd5(byte[] md5) {
            this.parserPath.md5 = md5;
        }

        @Override
        public void setSize(long size) {
            this.parserPath.size = size;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParserPathCanonical other = (ParserPathCanonical)obj;
            return !(this.canonical == null ? other.canonical != null : !this.canonical.equals(other.canonical));
        }
    }
}

