/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ListContainer;

public class RTLChecksUtil {
    public static final Set<HidFlatteningOption> FLATTENING_OPTIONS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
    public static final Set<HidFlatteningOption> PROCESS_HID_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));
    private Set<IHid> clockSignals = new HashSet<IHid>();
    private Set<IHid> resetSignals = new HashSet<IHid>();
    private Map<IHid, Set<IHid>> sequentialSampled = new IdentityHashMap<IHid, Set<IHid>>();
    private Map<IHid, Set<IHid>> sequentialDriven = new IdentityHashMap<IHid, Set<IHid>>();

    public void clear() {
        this.clockSignals.clear();
        this.resetSignals.clear();
        this.sequentialSampled.clear();
        this.sequentialDriven.clear();
    }

    public void addClockSignal(IHid clockSignal) {
        if (clockSignal == null) {
            return;
        }
        this.clockSignals.add(clockSignal);
    }

    public void addResetSignal(IHid resetSignal) {
        if (resetSignal == null) {
            return;
        }
        this.resetSignals.add(resetSignal);
    }

    public void addSequentialSampled(IHid clockSignal, Set<IHid> sampledValues) {
        if (clockSignal == null) {
            return;
        }
        Set<IHid> values = this.sequentialSampled.get(clockSignal);
        if (values == null) {
            this.sequentialSampled.put(clockSignal, sampledValues);
        } else {
            values.addAll(sampledValues);
        }
    }

    public boolean addSequentialDriven(IHid clockSignal, Set<IHid> drivenValues) {
        if (clockSignal == null) {
            return false;
        }
        Set<IHid> values = this.sequentialDriven.get(clockSignal);
        if (values == null) {
            this.sequentialDriven.put(clockSignal, drivenValues);
            return true;
        }
        if (values.containsAll(drivenValues)) {
            return false;
        }
        values.addAll(drivenValues);
        return true;
    }

    public static final boolean collectVLOGClockEventHids(IHidOperator operator, Set<IHid> edgeHids, List<IHidOperator> edgeOperators, AtomicBoolean useMixedControl) {
        if (operator == null || edgeHids == null) {
            return false;
        }
        if (!operator.hasOccurrence(HidOperatorQualifier.IS_EVENT_CONTROL)) {
            return false;
        }
        IHidObject lhValue = operator.getLHValue();
        if (HidUtils.isOperator(lhValue) && ((IHidOperator)lhValue).isRepeat()) {
            lhValue = ((IHidOperator)lhValue).getFirstRHValue();
        }
        if (!HidUtils.isOperator(lhValue)) {
            return false;
        }
        IHidOperator eventOperator = (IHidOperator)lhValue;
        if (eventOperator.isAnyEdgeEvent()) {
            edgeOperators.add(eventOperator);
            edgeHids.addAll(HidUtils.flattenToHids(eventOperator.getLHValue(), PROCESS_HID_FLATTENING));
            return true;
        }
        boolean hasChanges = false;
        Set<IHidOperator> flattened = HidUtils.flattenToOperators(eventOperator);
        boolean hasEdgeControl = false;
        boolean hasNonEdgeControl = false;
        block0: for (IHidOperator partOperator : flattened) {
            if (!partOperator.isAnyEdgeEvent()) {
                if (partOperator.getOperatorKind() != IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) continue;
                ListContainer<IHidObject> rhValues = partOperator.getRHValues();
                for (IHidObject rhValue : rhValues) {
                    if (!HidUtils.isHid(rhValue)) continue;
                    hasNonEdgeControl = true;
                    continue block0;
                }
                continue;
            }
            hasEdgeControl = true;
            edgeOperators.add(partOperator);
            for (IHid hid : HidUtils.flattenToHids(partOperator.getLHValue(), PROCESS_HID_FLATTENING)) {
                if (hid.getElement() == null) continue;
                edgeHids.add(hid);
                hasChanges = true;
            }
        }
        useMixedControl.set(hasEdgeControl & hasNonEdgeControl);
        return hasChanges;
    }
}

