/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfElementPathBase;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class RfDefElementPath
extends RfElementPathBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char SEPARATOR = ' ';
    public static final Pattern SPLIT_PATTERN = Pattern.compile(Character.toString(' '));
    public static final RfDefElementPath UNKNOWN_ELEMENT_PATH = new RfDefElementPath("ro.amiq.dvt.dvtnature");
    private String fNatureID;
    private String fName;
    private int fVirtualOffset = -1;

    public IRfBreadcrumbElement toDefElement(IProject project) {
        if (project == null) {
            return null;
        }
        IRfSingleLangProject rfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(project, this.fNatureID, false);
        if (rfProject == null) {
            return null;
        }
        if (!RfDefElementPath.hasEDTNature(this.fNatureID)) {
            return null;
        }
        IRfNamedElement moduleElement = ((IRfNamedElement)((Object)rfProject)).elementPathMember(this.fDefFileName, true, false, true, false, null, new HashSet<Class<? extends IRfNamedElement>>(Arrays.asList(this.fDefFileClass)), null, null, -1);
        if (moduleElement == null) {
            return null;
        }
        if (this.fDefFileClass != null && !this.fDefFileClass.equals(moduleElement.getClass())) {
            return null;
        }
        if (!(moduleElement instanceof IRfFileDef)) {
            return null;
        }
        if (this.fDefFileClass != null && !this.fDefFileClass.equals(moduleElement.getClass())) {
            return null;
        }
        IRfFileDef moduleElementDef = (IRfFileDef)((Object)moduleElement);
        IRfBreadcrumbElement defElement = moduleElementDef.getDefElementForBC(this.fName, this.fOffset, this.fVirtualOffset);
        if (defElement == null) {
            return null;
        }
        return defElement;
    }

    private RfDefElementPath(IRfDefElement element) {
        IRfNamedElement namedElement = element.getNamedElement();
        if (namedElement == null) {
            return;
        }
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return;
        }
        this.fNatureID = rfProject.getNature();
        if (!RfDefElementPath.hasEDTNature(this.fNatureID)) {
            return;
        }
        this.fOffset = element.getStartOffset();
        this.fName = element.getName();
        this.fVirtualOffset = element.getStartVirtualOffset();
        IRfFileDef defFile = element.getDefFile();
        if (!(defFile instanceof IRfNamedElement)) {
            return;
        }
        this.fDefFileName = ((IRfNamedElement)((Object)defFile)).getName();
        this.fDefFileClass = ((IRfNamedElement)((Object)defFile)).getClass();
    }

    private RfDefElementPath(String natureId) {
        this.fNatureID = natureId;
    }

    public String toString() {
        if (!RfDefElementPath.hasEDTNature(this.fNatureID)) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.fNatureID).append(' ');
        sb.append(this.fDefFileName).append(' ');
        sb.append(this.fDefFileClass.getName()).append(' ');
        sb.append(this.fName).append(' ');
        sb.append(this.fOffset);
        return sb.toString();
    }

    @Override
    public String toNiceString() {
        if (!RfDefElementPath.hasEDTNature(this.fNatureID)) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.fName).append("@").append(this.fOffset).append(" in ").append(this.fDefFileName);
        return sb.toString();
    }

    public static final RfDefElementPath path(IRfDefElement element) {
        return new RfDefElementPath(element);
    }

    public static final RfElementPathInProject pathInProject(RfDefElementPath elementPath, IProject project) {
        if (elementPath == null || project == null) {
            return null;
        }
        return new RfElementPathInProject(elementPath, project);
    }

    public static final RfElementPathInProject pathInProject(IRfDefElement element) {
        return RfDefElementPath.pathInProject(RfDefElementPath.path(element), DVTUtilsCommon.INSTANCE.getProject(element));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fVirtualOffset < 0 ? 0 : this.fVirtualOffset);
        result = 31 * result + (this.fOffset < 0 ? 0 : this.fOffset);
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fDefFileName == null ? 0 : this.fDefFileName.hashCode());
        result = 31 * result + (this.fDefFileClass == null ? 0 : this.fDefFileClass.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfDefElementPath other = (RfDefElementPath)obj;
        if (RfDefElementPath.hasEDTNature(this.fNatureID)) {
            if (this.fOffset != other.getOffset()) {
                return false;
            }
            if (this.fVirtualOffset != other.fVirtualOffset) {
                return false;
            }
            if (this.fName == null) {
                return false;
            }
            if (!this.fName.equals(other.fName)) {
                return false;
            }
            if (this.fDefFileName == null) {
                return false;
            }
            if (!this.fDefFileName.equals(other.getDefClassName())) {
                return false;
            }
            if (this.fDefFileClass == null) {
                return false;
            }
            return this.fDefFileClass.equals(other.getDefClass());
        }
        return false;
    }
}

