/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPathBase;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.search.ISearchQueryElement;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class RfElementPath
extends RfElementPathBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char SEPARATOR = ' ';
    private static final char PATH_SEPARATOR = '.';
    private static final String NO_PARSER_PATH = "no_available_path";
    public static final Pattern SPLIT_PATTERN = Pattern.compile(Character.toString(' '));
    public static final RfElementPath UNKNOWN_ELEMENT_PATH = new RfElementPath(Collections.emptyList(), "ro.amiq.dvt.dvtnature");
    private List<Segment> fSegments;
    private String fNatureID;
    private transient IRfNamedElement fCachedElement;
    private String fName;
    private int fVirtualOffset = -1;
    private ParserPath fParserPath;
    private int fLine = -1;

    public synchronized IRfNamedElement toNamedElement(IProject project) {
        if (this.fCachedElement != null) {
            if (!this.fCachedElement.hasNoDefs(false) || this.fCachedElement.isPredefined()) {
                return this.fCachedElement;
            }
            this.fCachedElement = null;
        }
        if (project == null) {
            return null;
        }
        IRfSingleLangProject rfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(project, this.fNatureID, false);
        if (rfProject == null) {
            return null;
        }
        if (RfElementPath.hasEDTNature(this.fNatureID)) {
            this.fCachedElement = (IRfNamedElement)((Object)rfProject);
            IRfNamedElement moduleElement = this.fCachedElement.elementPathMember(this.fDefFileName, true, false, true, false, null, new HashSet<Class<? extends IRfNamedElement>>(Arrays.asList(this.fDefFileClass)), null, null, -1);
            if (moduleElement == null) {
                IRfNamedElement pkg = rfProject.getPackage(this.fName);
                return pkg;
            }
            if (this.fDefFileClass != null && !this.fDefFileClass.equals(moduleElement.getClass())) {
                this.fCachedElement = null;
                return null;
            }
            if (!(moduleElement instanceof IRfFileDef)) {
                this.fCachedElement = null;
                return null;
            }
            IRfFileDef moduleElementDef = (IRfFileDef)((Object)moduleElement);
            IRfNamedElement namedElement = moduleElementDef.getNamedElement(this.fName, this.fOffset, this.fVirtualOffset);
            if (namedElement == null) {
                return null;
            }
            this.fCachedElement = namedElement;
            return namedElement;
        }
        if (this.fSegments == null || this.fSegments.isEmpty()) {
            this.fCachedElement = null;
            return null;
        }
        this.fCachedElement = (IRfNamedElement)((Object)rfProject);
        boolean isFirst = true;
        for (Segment segment : this.fSegments) {
            IRfNamedElement element;
            IRfNamedElement translatedType;
            HashSet<Class<? extends IRfNamedElement>> memberClasses = segment.fClass == null ? null : new HashSet<Class<? extends IRfNamedElement>>(Arrays.asList(segment.fClass));
            IRfNamedElement currentScope = this.fCachedElement;
            if (currentScope instanceof IRfTypeAliasElement && (translatedType = ((IRfTypeAliasElement)currentScope).getTranslatedType()) != null) {
                currentScope = translatedType;
            }
            if ((element = currentScope.elementPathMember(segment.fName, isFirst, false, true, false, null, memberClasses, null, this.fParserPath, this.fLine)) == null) {
                this.fCachedElement = null;
                return null;
            }
            this.fCachedElement = element;
            isFirst = false;
        }
        return this.fCachedElement;
    }

    private RfElementPath(IRfNamedElement element) {
        ArrayList<Segment> reverseSegments = new ArrayList<Segment>(16);
        IRfDefElement declaration = element.getDeclaration();
        if (declaration != null) {
            this.fVirtualOffset = declaration.getStartVirtualOffset();
        }
        this.fParserPath = element.getMacroParserPath();
        this.fLine = element.getLine();
        IRfNamedElement enclosing = element;
        while (enclosing != null && !(enclosing instanceof IRfSingleLangProject)) {
            reverseSegments.add(new Segment(enclosing));
            enclosing = (IRfNamedElement)enclosing.getEnclosingScope();
            if (!(enclosing instanceof IRfSingleLangProject)) continue;
            this.fNatureID = ((IRfSingleLangProject)((Object)enclosing)).getNature();
        }
        if (this.fNatureID == null && !(element instanceof ISearchQueryElement) && element.getLanguageKind() != null) {
            this.fNatureID = element.getLanguageKind().NATURE_ID;
        }
        if (RfElementPath.hasEDTNature(this.fNatureID) && element != null) {
            this.fOffset = element.getOffset();
            this.fName = element.getName();
            IRfDefElement elementDeclaration = element.getDeclaration();
            if (elementDeclaration == null) {
                return;
            }
            IRfFileDef defFile = elementDeclaration.getDefFile();
            if (!(defFile instanceof IRfNamedElement)) {
                return;
            }
            this.fDefFileName = ((IRfNamedElement)((Object)defFile)).getName();
            this.fDefFileClass = ((IRfNamedElement)((Object)defFile)).getClass();
            return;
        }
        if (reverseSegments.isEmpty()) {
            return;
        }
        if (this.fSegments == null) {
            this.fSegments = new ArrayList<Segment>(reverseSegments.size());
        }
        int i = reverseSegments.size() - 1;
        while (i >= 0) {
            this.fSegments.add((Segment)reverseSegments.get(i));
            --i;
        }
    }

    private RfElementPath(List<Segment> segments, String natureId) {
        this.fSegments = segments;
        this.fNatureID = natureId;
    }

    private RfElementPath(List<Segment> segments, String natureId, ParserPath parserPath, int line) {
        this.fSegments = segments;
        this.fNatureID = natureId;
        this.fParserPath = parserPath;
        this.fLine = line;
    }

    private RfElementPath(String name, int offset, Class moduleClass, String moduleName, String natureId) {
        this.fName = name;
        this.fOffset = offset;
        this.fDefFileClass = moduleClass;
        this.fDefFileName = moduleName;
        this.fNatureID = natureId;
    }

    public int size() {
        if (this.fSegments == null || this.fSegments.isEmpty()) {
            return 0;
        }
        return this.fSegments.size();
    }

    public String toString() {
        if (RfElementPath.hasEDTNature(this.fNatureID)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fNatureID).append(' ');
            sb.append(this.fDefFileName).append(' ');
            sb.append(this.fDefFileClass.getName()).append(' ');
            sb.append(this.fName).append(' ');
            sb.append(this.fOffset);
            return sb.toString();
        }
        if (this.fSegments == null || this.fSegments.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.fNatureID).append(' ');
        Iterator<Segment> iterator = this.fSegments.iterator();
        while (iterator.hasNext()) {
            Segment segment = iterator.next();
            sb.append(segment.fName);
            sb.append(' ');
            sb.append(segment.fClass == null ? "<ANY>" : segment.fClass.getName());
            if (!iterator.hasNext()) continue;
            sb.append(' ');
        }
        sb.append(' ').append(this.fParserPath == null ? NO_PARSER_PATH : this.fParserPath.toString());
        sb.append(' ').append(this.fLine);
        return sb.toString();
    }

    @Override
    public String toNiceString() {
        if (RfElementPath.hasEDTNature(this.fNatureID)) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fName);
            if (this.fOffset != -1) {
                sb.append("@").append(this.fOffset);
            }
            if (this.fDefFileName != null) {
                sb.append(" in ").append(this.fDefFileName);
            }
            return sb.toString();
        }
        if (this.fSegments == null || this.fSegments.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Segment> iterator = this.fSegments.iterator();
        while (iterator.hasNext()) {
            Segment segment = iterator.next();
            sb.append(segment.fName);
            if (!iterator.hasNext()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public String toElabNiceString() {
        if (RfElementPath.hasEDTNature(this.fNatureID)) {
            return "";
        }
        if (this.fSegments == null || this.fSegments.isEmpty()) {
            return "";
        }
        if (this.fSegments.size() == 1) {
            return this.fSegments.get((int)0).fName;
        }
        Segment elementSegment = this.fSegments.get(this.fSegments.size() - 1);
        Segment packageSegment = this.fSegments.get(this.fSegments.size() - 2);
        if (packageSegment == null) {
            return elementSegment.fName;
        }
        boolean isVHDL = LanguageKind.VHDL.NATURE_ID.endsWith(this.fNatureID);
        boolean isPackageOrClassScope = packageSegment.fClass != null && (IRfPackageElement.class.isAssignableFrom(packageSegment.fClass) || IRfClassElement.class.isAssignableFrom(packageSegment.fClass));
        return packageSegment.fName + (isPackageOrClassScope && !isVHDL ? "::" : ".") + elementSegment.fName;
    }

    public String getElementName() {
        if (this.fCachedElement != null && this.fCachedElement.getName() != null) {
            return this.fCachedElement.getName();
        }
        if (RfElementPath.hasEDTNature(this.fNatureID)) {
            return this.fName;
        }
        if (this.fSegments == null || this.fSegments.isEmpty()) {
            return "";
        }
        Segment lastSegment = this.fSegments.get(this.fSegments.size() - 1);
        if (lastSegment == null) {
            return "";
        }
        return lastSegment.fName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RfElementPath fromString(String s, Class<?> classs) {
        try {
            if (s == null) {
                return null;
            }
            String[] pieces = SPLIT_PATTERN.split(s);
            if (RfElementPath.hasEDTNature(pieces[0])) {
                if (pieces.length != 5) {
                    return null;
                }
                Class<?> clazz = classs.getClassLoader().loadClass(pieces[2]);
                return new RfElementPath(pieces[3], Integer.parseInt(pieces[4]), clazz, pieces[1], pieces[0]);
            }
            if (pieces.length % 2 == 0) {
                return null;
            }
            String natureId = pieces[0];
            int nofSegments = (pieces.length - 3) / 2;
            ArrayList<Segment> segments = new ArrayList<Segment>(nofSegments);
            int i = 0;
            while (true) {
                if (i >= nofSegments) {
                    ParserPath parserPath = null;
                    String parserPathString = pieces[pieces.length - 2];
                    if (parserPathString != null) {
                        parserPath = new ParserPath(parserPathString);
                    }
                    int line = Integer.parseInt(pieces[pieces.length - 1]);
                    return new RfElementPath(segments, natureId, parserPath, line);
                }
                String name = pieces[i * 2 + 1];
                Class<?> clazz = classs.getClassLoader().loadClass(pieces[i * 2 + 2]);
                segments.add(new Segment(name, clazz));
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RfElementPath fromString(String s) {
        try {
            if (s == null) {
                return null;
            }
            String[] pieces = SPLIT_PATTERN.split(s);
            if (pieces == null || pieces.length == 0) {
                return null;
            }
            if (RfElementPath.hasEDTNature(pieces[0])) {
                if (pieces.length != 5) {
                    return null;
                }
                return new RfElementPath(pieces[3], Integer.parseInt(pieces[4]), null, pieces[1], pieces[0]);
            }
            ArrayList<Segment> segments = new ArrayList<Segment>(pieces.length - 1);
            int i = 1;
            while (true) {
                if (i >= pieces.length) {
                    return new RfElementPath(segments, pieces[0]);
                }
                segments.add(new Segment(pieces[i], null));
                ++i;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RfElementPath fromName(String simpleName, String natureId) {
        block3: {
            try {
                if (simpleName != null && natureId != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return new RfElementPath(Arrays.asList(new Segment(simpleName, null)), natureId);
    }

    public static RfElementPath fromVLOGPredefined(String simpleName) {
        return RfElementPath.fromName(simpleName, LanguageKind.VLOG.NATURE_ID);
    }

    private List<Segment> getSegments() {
        return this.fSegments;
    }

    private String getNature() {
        return this.fNatureID;
    }

    private String getName() {
        return this.fName;
    }

    public static boolean isValid(RfElementPath elementPath) {
        if (elementPath == null) {
            return false;
        }
        if (RfElementPath.hasEDTNature(elementPath.getNature())) {
            return elementPath.getName() != null && elementPath.getDefClass() != null && elementPath.getDefClassName() != null;
        }
        return elementPath.getSegments() != null && !elementPath.getSegments().isEmpty();
    }

    @NotNull
    public static final RfElementPath path(IRfNamedElement element) {
        if (element == null) {
            return UNKNOWN_ELEMENT_PATH;
        }
        return new RfElementPath(element);
    }

    public static final RfElementPathInProject pathInProject(RfElementPath elementPath, IProject project) {
        if (elementPath == null || project == null) {
            return null;
        }
        return new RfElementPathInProject(elementPath, project);
    }

    public static final RfElementPathInProject pathInProject(IRfNamedElement element) {
        return RfElementPath.pathInProject(RfElementPath.path(element), DVTUtilsCommon.INSTANCE.getProject(element));
    }

    public int hashCode() {
        int result = 1;
        if (RfElementPath.hasEDTNature(this.fNatureID)) {
            result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
            result = 31 * result + (this.fOffset < 0 ? 0 : this.fOffset);
            result = 31 * result + (this.fDefFileName == null ? 0 : this.fDefFileName.hashCode());
            result = 31 * result + (this.fDefFileClass == null ? 0 : this.fDefFileClass.hashCode());
            result = 31 * result + (this.fVirtualOffset < 0 ? 0 : this.fVirtualOffset);
            return result;
        }
        if (this.fSegments == null || this.fSegments.isEmpty()) {
            return result;
        }
        int i = this.fSegments.size() - 1;
        while (i >= 0) {
            Segment segment = this.fSegments.get(i);
            result = 31 * result + (segment == null ? 0 : segment.hashCode());
            --i;
        }
        return result;
    }

    public static int segmentHashCode(Class<? extends IRfNamedElement> clazz, String name) {
        int result = 1;
        result = 31 * result + (clazz == null ? 0 : clazz.hashCode());
        result = 31 * result + (name == null ? 0 : name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RfElementPath other = (RfElementPath)obj;
        if (RfElementPath.hasEDTNature(this.fNatureID)) {
            if (this.fOffset != other.getOffset()) {
                return false;
            }
            if (this.fVirtualOffset != other.fVirtualOffset) {
                return false;
            }
            if (this.fName == null) {
                return false;
            }
            if (!this.fName.equals(other.getName())) {
                return false;
            }
            if (this.fDefFileName == null) {
                return false;
            }
            if (!this.fDefFileName.equals(other.getDefClassName())) {
                return false;
            }
            if (this.fDefFileClass == null) {
                return false;
            }
            return this.fDefFileClass.equals(other.getDefClass());
        }
        if (this.size() != other.size()) {
            return false;
        }
        return !(this.fSegments == null ? other.fSegments != null : !this.fSegments.equals(other.fSegments));
    }

    public static class Segment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Class<? extends IRfNamedElement> fClass;
        private String fName;

        public Segment() {
        }

        public Segment(IRfNamedElement element) {
            this.fClass = element.getCustomClass();
            this.fName = element.elementPathName();
        }

        public Segment(String name, Class clazz) {
            this.fClass = clazz;
            this.fName = name;
        }

        public int hashCode() {
            return RfElementPath.segmentHashCode(this.fClass, this.fName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Segment other = (Segment)obj;
            if (this.fClass != other.fClass) {
                return false;
            }
            return !(this.fName == null ? other.fName != null : !this.fName.equals(other.fName));
        }
    }
}

