/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.TimerTask;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.RfGUIUtilsCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.RfGUIUtilsDialog;
import ro.amiq.dvt.ui.editor.floatingwidgets.FIncrementalNotificationTimeoutDialog;
import ro.amiq.dvt.utils.DVTStringUtil;

public class RfGUIUtils
extends RfGUIUtilsCommon {
    @Override
    public void stopTimer() {
        super.stopTimer();
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            if (this.fDialog != null) {
                this.fDialog.close();
            }
        });
    }

    @Override
    public void runPoolingTask() {
        try {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                if (this.fStopped) {
                    return;
                }
                this.fTotalTime += (long)this.fTimeout;
                StringBuilder text = new StringBuilder();
                text.append(this.fHeader).append(" on '").append(this.fProject.getName()).append("' project takes longer than ").append(this.fTotalTime).append(" seconds!");
                if (this.fFooter != null) {
                    text.append(this.fFooter);
                }
                text = DVTStringUtil.textWrap(100, text.toString());
                this.fDialog = "Database Update".equals(this.fHeader) ? new FIncrementalNotificationTimeoutDialog("DVT " + this.fHeader, text.toString()) : new RfGUIUtilsDialog("DVT " + this.fHeader, text.toString());
                if (this.fDialog.open() == 0) {
                    this.fCancelChecking = this.fDialog.wasStopped();
                } else {
                    this.fTimer.schedule((TimerTask)new RfGUIUtilsCommon.PoolingTask(this), (long)this.fTimeout * 1000L);
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

