/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.ui.RfGUIUtilsDialog;

public abstract class RfGUIUtilsCommon {
    protected Timer fTimer;
    protected long fTotalTime;
    protected boolean fCancelChecking;
    protected IProject fProject;
    protected int fTimeout;
    protected RfGUIUtilsDialog fDialog;
    protected String fHeader;
    protected String fFooter;
    protected boolean fStopped;

    public void startTimer(int timeoutInSeconds, IProject project, String header, String footer) {
        this.fTotalTime = 0L;
        this.fCancelChecking = false;
        this.fStopped = false;
        this.fTimer = new Timer();
        this.fProject = project;
        this.fTimeout = timeoutInSeconds;
        this.fHeader = header;
        this.fFooter = footer;
        this.fTimer.schedule((TimerTask)new PoolingTask(), (long)this.fTimeout * 1000L);
    }

    public void resetTimer() {
        this.fTotalTime = 0L;
        this.fCancelChecking = false;
        this.fStopped = true;
    }

    public abstract void runPoolingTask();

    public void stopTimer() {
        this.fTimer.cancel();
        this.fStopped = true;
    }

    public boolean isCancelChecking() {
        return this.fCancelChecking;
    }

    class PoolingTask
    extends TimerTask {
        PoolingTask() {
        }

        @Override
        public void run() {
            RfGUIUtilsCommon.this.runPoolingTask();
        }
    }
}

