/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManagerCommon;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.views.BCXmlTopSaverViewType;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManager;
import ro.amiq.dvt.ui.views.DVTXmlSaveConfig;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IGUISearchContributor;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.ISearchContributor;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.NamedElementAndConfigInfo;
import ro.amiq.dvt.ui.views.lazy.views.macros.CDTMacroWrapper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class RfMixedLangManager
extends RfMixedLangManagerCommon {
    private static final List<ISearchContributor> fSearchContributors = RfMixedLangManager.getSearchContributors();
    private static final List<IGUISearchContributor> fGUISearchContributors = RfMixedLangManager.getGUISearchContributors();
    protected static final List<IReflectionContributor> fReflectionContributors = RfMixedLangManager.getReflectionContributors();
    private static final Object fSyncInstance = new Object();
    private static volatile RfMixedLangManager fInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RfMixedLangManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new RfMixedLangManager();
            }
        }
        return fInstance;
    }

    @Override
    public IProject getProject() {
        return RfGUIReferencesUtils.getCurrentProject();
    }

    @Override
    public RfMixedLangProject getRfMixedLangProject(IProject project, boolean restore) {
        if (project == null || !project.isAccessible()) {
            return null;
        }
        RfMixedLangProject rfMixedLangProject = this.getOrCreateRfMixedLangProject(project);
        if (restore) {
            rfMixedLangProject.restore();
        }
        return rfMixedLangProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RfMixedLangProject getOrCreateRfMixedLangProject(IProject project) {
        Map map = this.fMixedLangProjects;
        synchronized (map) {
            List<IReflectionContributor> contributors = this.getEnabledContributors(project);
            RfMixedLangProject result = (RfMixedLangProject)this.fMixedLangProjects.get(project);
            if (result != null) {
                result.createAndRemoveSingleLangProjects(contributors);
                return result;
            }
            result = new RfMixedLangProject(project);
            result.createAndRemoveSingleLangProjects(contributors);
            this.fMixedLangProjects.put(project, result);
            return result;
        }
    }

    public IRfSingleLangProject getRfSingleLangProject(IProject project, String natureID, boolean restore) {
        if (!project.isAccessible()) {
            return null;
        }
        RfMixedLangProject rfMixedLangProject = this.getRfMixedLangProject(project, restore);
        return rfMixedLangProject.getSingleLangProject(natureID);
    }

    private static List<ISearchContributor> getSearchContributors() {
        ArrayList<ISearchContributor> delegates = new ArrayList<ISearchContributor>();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("ro.amiq.dvt.searchContributors");
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!"searchContributor".equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + "ro.amiq.dvt.searchContributors"));
                    }
                    ISearchContributor buildContributor = (ISearchContributor)configurationElement.createExecutableExtension("class");
                    delegates.add(buildContributor);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return delegates;
    }

    private static List<IGUISearchContributor> getGUISearchContributors() {
        ArrayList<IGUISearchContributor> delegates = new ArrayList<IGUISearchContributor>();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("ro.amiq.dvt.guiSearchContributors");
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!"guiSearchContributor".equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + "ro.amiq.dvt.searchContributors"));
                    }
                    IGUISearchContributor buildContributor = (IGUISearchContributor)configurationElement.createExecutableExtension("class");
                    delegates.add(buildContributor);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return delegates;
    }

    public List<ISearchContributor> getEnabledSearchContributors(IProject project) {
        if (fSearchContributors == null) {
            return Collections.emptyList();
        }
        ArrayList<ISearchContributor> result = new ArrayList<ISearchContributor>(3);
        for (ISearchContributor searchContributor : fSearchContributors) {
            if (!searchContributor.isEnabled(project)) continue;
            result.add(searchContributor);
        }
        return result;
    }

    public List<IGUISearchContributor> getEnabledGUISearchContributors(IProject project) {
        if (fGUISearchContributors == null) {
            return Collections.emptyList();
        }
        ArrayList<IGUISearchContributor> result = new ArrayList<IGUISearchContributor>(3);
        for (IGUISearchContributor searchContributor : fGUISearchContributors) {
            if (!searchContributor.isEnabled(project)) continue;
            result.add(searchContributor);
        }
        return result;
    }

    private RfMixedLangManager() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(event -> {
            block5: {
                try {
                    DVTFileUtils.getInstance().manageLinkedResourceCreation(event.getDelta(), "DVT Auto-Linked");
                    IResource resource = event.getResource();
                    if (!(resource instanceof IProject)) break block5;
                    IProject project = (IProject)resource;
                    if (event.getType() != 2 && event.getType() != 4) break block5;
                    RfMixedLangProject rfMixedLangProject = (RfMixedLangProject)this.fMixedLangProjects.get(project);
                    if (rfMixedLangProject == null) {
                        return;
                    }
                    try {
                        FIncrementalNotificationTracker.INSTANCE.unregisterProject(project);
                        rfMixedLangProject.removeMixedLangProject();
                        DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifyProjectClose(project);
                    }
                    catch (Exception e1) {
                        DVTLogger.INSTANCE.logError((Throwable)e1);
                    }
                    this.removeRfMixedLangProject(project);
                    DVTProblemManager.getInstance().clean(project);
                }
                catch (Exception e2) {
                    DVTLogger.INSTANCE.logError((Throwable)e2);
                }
            }
        });
    }

    @Override
    public HistoryItem createHistoryItem(DVTXmlSaveConfig config, IProject project, HistoryItemType historyItemType) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            HistoryItem result = contributor.createHistoryItem(config, project, historyItemType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public HistoryItem getHistoryItemFromBCXmlString(String bcXMLString, IProject project, HistoryItemType historyItemType) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            HistoryItem result = contributor.getHistoryItemFromBCXmlString(bcXMLString, project, historyItemType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public NamedElementAndConfigInfo getNamedElementAndConfigFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            NamedElementAndConfigInfo result = contributor.getNamedElementAndConfigFromHistoryItem(historyItem, project, viewType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public HistoryItemType getHistoryItemTypeFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            HistoryItemType result = contributor.getHistoryItemTypeFromHistoryItem(historyItem, project, viewType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (project == null) {
            return;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            LanguageKind languageKind = element.getLanguageKind();
            String currentLanguageNature = languageKind.NATURE_ID;
            String nature = contributor.getNature();
            if (!contributor.isEnabled(project) || !nature.equals(currentLanguageNature)) continue;
            contributor.gotoSelectedMember(project, element);
        }
    }

    public void gotoElement(IProject project, Object element) {
        if (project == null) {
            return;
        }
        String currentLanguageNature = null;
        if (element instanceof IDVTElementWrapper) {
            currentLanguageNature = ((IDVTElementWrapper)element).getLanguageKind().NATURE_ID;
        } else if (element instanceof IRfNamedElement) {
            currentLanguageNature = ((IRfNamedElement)element).getLanguageKind().NATURE_ID;
        } else if (element instanceof CDTMacroWrapper) {
            currentLanguageNature = ((CDTMacroWrapper)element).getLanguageKind().NATURE_ID;
        } else if (element instanceof HistoryItem) {
            currentLanguageNature = ((HistoryItem)element).getLanguage().NATURE_ID;
        } else if (element instanceof IRfVHBreadcrumbElement) {
            currentLanguageNature = ((IRfVHBreadcrumbElement)element).getNamedElement().getLanguageKind().NATURE_ID;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            if (!contributor.isEnabled(project) || !contributor.getNature().equals(currentLanguageNature)) continue;
            contributor.gotoElement(project, element);
        }
    }

    public IMembersLabelProvider getMembersLabelProvider(IProject project, IDVTElementWrapper wrapper) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            String currentLanguageNature = wrapper.getLanguageKind().NATURE_ID;
            if (!contributor.isEnabled(project) || !contributor.getNature().equals(currentLanguageNature)) continue;
            return contributor.getMembersLabelProvider();
        }
        return null;
    }

    public MembersViewInput getMembersInput(IProject project, IDVTElementWrapper wrapper, StringMatcher stringMatcher, IMembersLabelProvider defaultLabelProvider, boolean applyContentFilters) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            String currentLanguageNature = wrapper.getLanguageKind().NATURE_ID;
            if (!contributor.isEnabled(project) || !contributor.getNature().equals(currentLanguageNature)) continue;
            return contributor.getMembersInput(wrapper, stringMatcher, defaultLabelProvider, applyContentFilters);
        }
        return null;
    }

    public Comparator<IDVTElementWrapper> getMembersCategoryComparator(IProject project, IDVTElementWrapper element) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            String currentLanguageNature = element.getLanguageKind().NATURE_ID;
            if (!contributor.isEnabled(project) || !contributor.getNature().equals(currentLanguageNature)) continue;
            return contributor.getMembersCategoryComparator();
        }
        return null;
    }

    @Override
    public List<? extends DVTRfNameTypeScopeHelper> getDefOfScopeElement(IRfNamedElement element) {
        if (element == null || element.getRfProject() == null || element.getRfProject().getProject() == null) {
            return null;
        }
        IProject project = element.getRfProject().getProject();
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            List<? extends DVTRfNameTypeScopeHelper> result = contributor.getDefOfScopeElement(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<ISearchContributor> getAllSearchContributors() {
        return fSearchContributors;
    }

    public static List<IReflectionContributor> getReflectionContributors() {
        ArrayList<IReflectionContributor> delegates = new ArrayList<IReflectionContributor>();
        try {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            if (extensionRegistry == null) {
                return delegates;
            }
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("ro.amiq.dvt.reflectionContributors");
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!"reflectionContributor".equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + "ro.amiq.dvt.reflectionContributors"));
                    }
                    IReflectionContributor buildContributor = (IReflectionContributor)configurationElement.createExecutableExtension("class");
                    delegates.add(buildContributor);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return delegates;
    }

    @Override
    protected List<IReflectionContributor> getReflectionContributor() {
        return fReflectionContributors;
    }

    @Override
    protected void notifyIncrementalElaboration() {
        DVTViewManager.getInstanceByCurrentWorkbenchWindow().notifyViewsWithBuildEvents(BuildEvents.INCREMENTAL_BUILD, DVTPlugin.getSelectionManager().getLastSelectedProject(), Collections.singleton("ro.amiq.dvt.ui.views.LazyDesignHierarchyView"));
    }

    public IRfNamedElement getElementAtExactCursor() {
        List<IReflectionContributor> contributors = this.getEnabledContributors(this.getProject());
        for (IReflectionContributor contributor : contributors) {
            IRfNamedElement result = contributor.getElementAtExactCursor();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String computeTraceTextAtLine(IResource resource, int lineNumber) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(this.getProject());
        for (IReflectionContributor contributor : contributors) {
            String result = contributor.computeTraceTextAtLine(resource, lineNumber);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public DVTSourceViewerConfiguration getDebugSourceViewerConfigurationForLang(LanguageKind lang, IProject project, LineBreakpoint breakpoint, SourceViewer viewer) {
        if (lang == null || project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            if (!lang.NATURE_ID.equals(contributor.getNature())) continue;
            return contributor.getDebugSourceViewerConfiguration(breakpoint, (ISourceViewer)viewer);
        }
        return null;
    }

    public void installPartitionerForDocument(LanguageKind lang, IProject project, IDocument document) {
        if (lang == null || project == null) {
            return;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            if (!lang.NATURE_ID.equals(contributor.getNature())) continue;
            contributor.installPartitionerForDocument(lang, document);
            break;
        }
    }
}

