/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.model.CHRoot;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.QFileCompileInfo;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.views.BCXmlTopSaverViewType;
import ro.amiq.dvt.ui.views.DVTXmlSaveConfig;
import ro.amiq.dvt.ui.views.HistoryItemType;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTRfNameTypeScopeHelper;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.NamedElementAndConfigInfo;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public abstract class RfMixedLangManagerCommon {
    protected Map<IProject, RfMixedLangProject> fMixedLangProjects = new HashMap<IProject, RfMixedLangProject>();
    protected Map<IProject, Map<String, PersistenceBase>> fPersistenceMap = new ConcurrentHashMap<IProject, Map<String, PersistenceBase>>();
    public static final String DVT_REFLECTION_EXTENSION_POINT_ID = "ro.amiq.dvt.reflectionContributors";
    public static final String DVT_REFLECTION_CONTRIBUTOR_ELEMENT = "reflectionContributor";
    public static final String DVT_SEARCH_EXTENSION_POINT_ID = "ro.amiq.dvt.searchContributors";
    public static final String DVT_SEARCH_CONTRIBUTOR_ELEMENT = "searchContributor";
    public static final String DVT_GUI_SEARCH_EXTENSION_POINT_ID = "ro.amiq.dvt.guiSearchContributors";
    public static final String DVT_GUI_SEARCH_CONTRIBUTOR_ELEMENT = "guiSearchContributor";

    protected void removeRfMixedLangProject(IProject project) {
        if (this.fMixedLangProjects.containsKey(project)) {
            this.fMixedLangProjects.get(project).close();
            this.fMixedLangProjects.remove(project);
            this.fPersistenceMap.remove(project);
        }
    }

    public DVTSourceViewerConfiguration getSourceViewerConfigurationForFile(String fileNature, IProject project) {
        if (fileNature == null || project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            if (!fileNature.equals(contributor.getNature())) continue;
            return contributor.getSourceViewerConfiguration();
        }
        return null;
    }

    public void reset() {
        this.fMixedLangProjects.clear();
    }

    public PersistenceBase getPersistence(IProject project, String nature) {
        PersistenceBase persistence;
        if (project == null || nature == null) {
            return null;
        }
        Map<String, PersistenceBase> persistenceByNature = this.fPersistenceMap.get(project);
        if (persistenceByNature == null) {
            persistenceByNature = new HashMap<String, PersistenceBase>();
            this.fPersistenceMap.put(project, persistenceByNature);
        }
        if ((persistence = persistenceByNature.get(nature)) == null) {
            List<IReflectionContributor> contributors = this.getEnabledContributors(project);
            for (IReflectionContributor contributor : contributors) {
                if (!nature.equals(contributor.getNature())) continue;
                persistence = contributor.makePersistence(project);
                persistenceByNature.put(nature, persistence);
            }
        }
        return persistence;
    }

    public Map<String, PersistenceBase> getPersistenceMap(IProject project) {
        return this.fPersistenceMap.get(project);
    }

    public IELMemory getELMemory(IProject project) {
        if (project == null) {
            return null;
        }
        ELManager elManager = this.getELManager(project);
        if (elManager == null) {
            return null;
        }
        return elManager.getMemory();
    }

    public ELManager getELManager(IProject project) {
        if (project == null) {
            return null;
        }
        RfMixedLangProject mixedLangProj = this.getRfMixedLangProject(project, false);
        if (mixedLangProj == null) {
            return null;
        }
        return mixedLangProj.getELManager();
    }

    public void elaborate(IProject project, boolean reportToConsole, boolean hideImplicitTopsWarning) {
        if (project == null) {
            return;
        }
        RfMixedLangProject mixedLangProj = this.getRfMixedLangProject(project, false);
        if (mixedLangProj == null) {
            return;
        }
        if (!DVTNature.hasNature(project, "ro.amiq.vlogdt.VlogNature") && !DVTNature.hasNature(project, "ro.amiq.vhdldt.VhdlNature")) {
            return;
        }
        DesignPathManager.getInstance().freeze(project);
        try {
            mixedLangProj.elaborate(reportToConsole, hideImplicitTopsWarning, false, false);
        }
        finally {
            mixedLangProj.collectLinterElabSpecs();
            DesignPathManager.getInstance().unfreeze(project);
        }
    }

    public synchronized void incrementalElaborate(IProject project, IncrementalElaborationKind kind) {
        boolean updateView;
        if (project == null) {
            return;
        }
        RfMixedLangProject mixedLangProj = this.getRfMixedLangProject(project, false);
        if (mixedLangProj == null) {
            return;
        }
        if (!DVTNature.hasNature(project, "ro.amiq.vlogdt.VlogNature") && !DVTNature.hasNature(project, "ro.amiq.vhdldt.VhdlNature")) {
            return;
        }
        DesignPathManager.getInstance().freeze(project);
        try {
            if (kind == IncrementalElaborationKind.ADAPTIVE) {
                mixedLangProj.elaborateIncrementalAdaptive();
            } else if (kind == IncrementalElaborationKind.FULL) {
                mixedLangProj.elaborate(false, true, true, false);
            } else if (kind == IncrementalElaborationKind.NONE) {
                mixedLangProj.elaborateIncrementalNone();
            }
        }
        catch (Throwable throwable) {
            boolean updateView2;
            mixedLangProj.collectLinterElabSpecs();
            DesignPathManager.getInstance().unfreeze(project);
            ELManager manager = mixedLangProj.getELManager();
            boolean bl = updateView2 = kind == IncrementalElaborationKind.FULL || manager != null && manager.hasDirtyMemory();
            if (updateView2) {
                this.notifyIncrementalElaboration();
            }
            throw throwable;
        }
        mixedLangProj.collectLinterElabSpecs();
        DesignPathManager.getInstance().unfreeze(project);
        ELManager manager = mixedLangProj.getELManager();
        boolean bl = updateView = kind == IncrementalElaborationKind.FULL || manager != null && manager.hasDirtyMemory();
        if (updateView) {
            this.notifyIncrementalElaboration();
        }
    }

    public boolean isCompiledAs(IProject project, ParserPath parserPath, String dvtNature) {
        RfMixedLangProject rfMixedLangProject = this.fMixedLangProjects.get(project);
        if (rfMixedLangProject == null) {
            return false;
        }
        return rfMixedLangProject.isCompiledAs(parserPath, dvtNature);
    }

    public boolean isCompiledAs(IFile file, String dvtNature) {
        RfMixedLangProject rfMixedLangProject = this.fMixedLangProjects.get(file.getProject());
        if (rfMixedLangProject == null) {
            return false;
        }
        return rfMixedLangProject.isCompiledAs(file, dvtNature);
    }

    public boolean validContentType(IProject project, IDocument document, int offset) {
        return RfSearchUtils.validContentType(project, document, offset);
    }

    public boolean hasValidPartitioner(IProject project, IDocument document) {
        return RfSearchUtils.hasValidPartitioner(project, document);
    }

    public void installPartitionerForFile(IFile file, IDocument document) {
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        RfSearchUtils.installPartitionerForFile(file.getProject(), document, parserPath);
    }

    public boolean hasHits(IFile file, String[] names, Matcher matcher, boolean isRegexp) {
        if (file == null) {
            return false;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(file.getProject());
        for (IReflectionContributor contributor : contributors) {
            if (!contributor.hasHits(file, names, matcher, isRegexp)) continue;
            return true;
        }
        return false;
    }

    public void clearBacklogElements(IProject project) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            contributor.clearBacklogElements(project);
        }
    }

    public IReflectionContributor getEnabledContributor(IProject project, LanguageKind languageKind) {
        if (languageKind == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            if (!languageKind.equals((Object)LanguageKind.from(contributor.getNature()))) continue;
            return contributor;
        }
        return null;
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo changedElement, IDocument document, IProject project) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            contributor.cbIncrementalBuild(monitor, changedElement, document, project);
        }
    }

    public Map<IReflectionContributor, Set<FileCompileInfo>> getBacklogElements(IProject project) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        LinkedHashMap<IReflectionContributor, Set<FileCompileInfo>> result = new LinkedHashMap<IReflectionContributor, Set<FileCompileInfo>>();
        for (IReflectionContributor contributor : contributors) {
            Set<FileCompileInfo> changedElements = contributor.getChangedElements(project);
            if (changedElements == null) continue;
            result.put(contributor, changedElements);
        }
        return result;
    }

    public boolean hasHits(ParserPath file, IProject project, String[] names, Matcher matcher, boolean isRegexp) {
        if (file == null) {
            return false;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            if (!contributor.hasHits(file, project, names, matcher, isRegexp)) continue;
            return true;
        }
        return false;
    }

    public IRfNamedElementAndScope getRfElement(IFile file, IDocument document, int offset, boolean validateContentType) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(file.getProject());
        for (IReflectionContributor contributor : contributors) {
            IRfNamedElementAndScope result = contributor.getRfElement(file, document, offset, validateContentType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public IRfNamedElementAndScope getRfElement(IFile file, IDocument document, int offset) {
        return this.getRfElement(file, document, offset, true);
    }

    public List<? extends IDVTFileInstance> getFileInstances(IProject project, ParserPath parserPath) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            List<? extends IDVTFileInstance> result = contributor.getFileInstances(project, parserPath);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<QFileCompileInfo> getQFileCompileInfos(IProject project, ParserPath path, boolean recursive, boolean inclComps) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            if (!"ro.amiq.vhdldt.VhdlNature".equals(contributor.getNature())) continue;
            return contributor.getQFileCompileInfos(project, path, recursive, inclComps);
        }
        return null;
    }

    public IRfNamedElement getNamedElementForDH(IRfNamedElement element) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(element.getRfProject().getProject());
        for (IReflectionContributor contributor : contributors) {
            IRfNamedElement result = contributor.getDHTransformedNamedElement(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public HistoryItem createHistoryItem(DVTXmlSaveConfig config, IProject project, HistoryItemType historyItemType) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            HistoryItem result = contributor.createHistoryItem(config, project, historyItemType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<IReflectionContributor> getEnabledContributors(IProject project) {
        List<IReflectionContributor> fReflectionContributors = this.getReflectionContributor();
        if (fReflectionContributors == null) {
            return Collections.emptyList();
        }
        ArrayList<IReflectionContributor> result = new ArrayList<IReflectionContributor>(3);
        for (IReflectionContributor reflectionContributor : fReflectionContributors) {
            if (!reflectionContributor.isEnabled(project)) continue;
            result.add(reflectionContributor);
        }
        return result;
    }

    public HistoryItem getHistoryItemFromBCXmlString(String bcXMLString, IProject project, HistoryItemType historyItemType) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            HistoryItem result = contributor.getHistoryItemFromBCXmlString(bcXMLString, project, historyItemType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public NamedElementAndConfigInfo getNamedElementAndConfigFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            NamedElementAndConfigInfo result = contributor.getNamedElementAndConfigFromHistoryItem(historyItem, project, viewType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public HistoryItemType getHistoryItemTypeFromHistoryItem(HistoryItem historyItem, IProject project, BCXmlTopSaverViewType viewType) {
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            HistoryItemType result = contributor.getHistoryItemTypeFromHistoryItem(historyItem, project, viewType);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<? extends DVTRfNameTypeScopeHelper> getDefOfScopeElement(IRfNamedElement element) {
        if (element == null || element.getRfProject() == null || element.getRfProject().getProject() == null) {
            return null;
        }
        IProject project = element.getRfProject().getProject();
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            List<? extends DVTRfNameTypeScopeHelper> result = contributor.getDefOfScopeElement(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public CHRoot makeSubRoot(ICHDiagram input, DProgressMonitor monitor) throws DCanceledException {
        IProject project = input.getProject();
        if (project == null) {
            return null;
        }
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            CHRoot result = contributor.makeSubRoot(input, monitor);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void updateInvocationsInfo(IProject project, Map<String, BCFileInstance> buildConfigFiles) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(project);
        for (IReflectionContributor contributor : contributors) {
            contributor.restoreInvocationsInfo(project, buildConfigFiles);
        }
    }

    public IHidObject parsePattern(String pattern, String defaultKeywordSet, Map<String, String> extensionKeywordsetMap, IBuildConfigParserConstants.ToolCompat toolCompat, boolean isAssert, IRfSingleLangProject rfProject) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(this.getProject());
        for (IReflectionContributor contributor : contributors) {
            IHidObject result = contributor.parsePattern(pattern, defaultKeywordSet, extensionKeywordsetMap, toolCompat, isAssert, rfProject);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int getStatementLine(IFile resource, DVTEditor textEditor, IRfNamedElement namedElement, IRfDefElement container, int line, int offset) {
        List<IReflectionContributor> contributors = this.getEnabledContributors(resource.getProject());
        for (IReflectionContributor contributor : contributors) {
            int result = contributor.getStatementLine(resource, textEditor, namedElement, container, line, offset);
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    protected abstract IProject getProject();

    protected abstract void notifyIncrementalElaboration();

    protected abstract List<IReflectionContributor> getReflectionContributor();

    protected abstract RfMixedLangProject getRfMixedLangProject(IProject var1, boolean var2);
}

