/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProjectCommon;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.utils.DVTFileUtils;

public class RfMixedLangProject
extends RfMixedLangProjectCommon {
    public RfMixedLangProject(IProject project) {
        super(project);
    }

    @Override
    public void createAndRemoveSingleLangProjects(List<IReflectionContributor> contributors) {
        HashSet naturesToRemove = new HashSet(this.fRfProjects.keySet());
        for (IReflectionContributor contributor : contributors) {
            String contributorNature = contributor.getNature();
            if (naturesToRemove.remove(contributorNature)) continue;
            IRfSingleLangProject rfSingleLangProject = contributor.makeRfProject(this.fProject, this.getMixedLangManager());
            this.fRfProjects.put(rfSingleLangProject.getNature(), rfSingleLangProject);
        }
        for (String natureToRemove : naturesToRemove) {
            ((IRfSingleLangProject)this.fRfProjects.get(natureToRemove)).clean(true);
            this.fRfProjects.remove(natureToRemove);
        }
    }

    public synchronized void changeBuildConfig() {
        try {
            for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
                rfProject.clean(true);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.setProjectState(RfProjectState.NEW);
        this.restore();
        if (this.isState(RfProjectState.NOT_RESTORED)) {
            for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
                rfProject.clean(true);
            }
            new Job("Change current build config"){

                protected IStatus run(IProgressMonitor monitor) {
                    BuildEventManager.getInstance().notifyFullBuild(RfMixedLangProject.this.fProject);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    @Override
    protected RfMixedLangProject getMixedLangManager() {
        return this;
    }

    @Override
    protected boolean checkRestoreInhibited() {
        IPath workspaceIPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (workspaceIPath == null) {
            return false;
        }
        File dontRestoreFile = workspaceIPath.append("dvt_dont_restore").toFile();
        if (!dontRestoreFile.exists()) {
            return false;
        }
        long dontRestoreTimestamp = 0L;
        try {
            dontRestoreTimestamp = Integer.parseInt(DVTFileUtils.getInstance().readFileContent(dontRestoreFile).trim());
        }
        catch (Exception exception) {}
        if ((dontRestoreTimestamp + 60L) * 1000L < System.currentTimeMillis()) {
            DVTLogger.INSTANCE.logInfo("Removing expired restore lock file '" + dontRestoreFile.getAbsolutePath() + "'");
            if (dontRestoreFile.exists() && !dontRestoreFile.delete()) {
                DVTLogger.INSTANCE.logInfo("Failed to remove restore lock file '" + dontRestoreFile.getAbsolutePath() + "'");
            }
            return false;
        }
        DVTLogger.INSTANCE.logInfo("Will not restore project '" + this.fProject.getName() + "' (lock file '" + dontRestoreFile.getAbsolutePath() + "')");
        return true;
    }

    public IEditorPart getEditor(ParserPath parserPath) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            DVTEditor editorCandidate = rfProject.getEditor(parserPath);
            if (editorCandidate == null) continue;
            return editorCandidate;
        }
        return null;
    }

    @Override
    public synchronized void restore() {
        super.restore();
    }

    @Override
    protected void scheduleRestoreJob(Job restoreJob) {
        restoreJob.schedule();
    }

    public boolean xHasEncryptedCode(IRfScopeElement element) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!rfProject.xHasEncryptedCode(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isXVMFactoryInitDone() {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!rfProject.isXVMFactoryInitDone()) continue;
            return true;
        }
        return false;
    }

    public void initXvmFactory() {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (rfProject.getLanguageKind() != LanguageKind.VLOG) continue;
            rfProject.initXvmFactory();
        }
    }

    @Override
    public boolean tryToAcquireRestoreDbLocationLock() {
        return true;
    }
}

