/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.ActiveBuildConfig;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTBuildCancelManager;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELLayeredConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.core.ELSpecialization;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.core.IELProject;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversUtil;
import ro.amiq.dvt.model.floatingwidgets.FDirtyScriptingEditorResource;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.persistence.PersistenceCancelException;
import ro.amiq.dvt.model.persistence.PersistenceUtils;
import ro.amiq.dvt.model.persistence.VersionChangedException;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemKinds;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.AutolinkWithoutLinksRestorer;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IIncrementalDeltaListener;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.MaxSizeReachedException;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfGUIUtils;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.RfProjectState;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollector;
import ro.amiq.dvt.ui.reportissue.IncrementalBuildThreadDumpHandler;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.benchmark.StopWatch;

public abstract class RfMixedLangProjectCommon {
    public static final String DVT_DONT_RESTORE_FILENAME = "dvt_dont_restore";
    protected static final int DONT_RESTORE_TIMEOUT_SECONDS = 60;
    protected static final String CLOSE_PROJECT = "Close Project";
    private static final String FAILED_TO_DESERIALIZE_BC_ERROR = "Error: Failed to deserialize active build config.";
    public static final Object FAMILY_PROJECT_RESTORE = new Object();
    protected final Map<String, IRfSingleLangProject> fRfProjects = new HashMap<String, IRfSingleLangProject>(4);
    protected final IProject fProject;
    private Collection<IIncrementalDeltaListener> incrementalDeltaListeners;
    private transient IProgressMonitor fBuildProgressMonitor;
    private transient RfGUIUtils fGUIUtils;
    private transient boolean isBuildDone;
    private transient ELManager elabManager;
    private transient ELConstantsManager elabConstantsManager;
    private transient ELManager nonElabManager;
    private transient ELLayeredConstantsManager nonElabConstantsManager;
    private transient Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> linterElabSpecs;

    protected RfMixedLangProjectCommon(IProject project) {
        this.fProject = project;
        this.fGUIUtils = new RfGUIUtils();
        this.incrementalDeltaListeners = new ArrayList<IIncrementalDeltaListener>();
        this.elabConstantsManager = new ELConstantsManager();
        this.nonElabConstantsManager = new ELLayeredConstantsManager(this.elabConstantsManager);
        this.nonElabManager = new ELManager((RfMixedLangProject)this, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newNonElabConfig(), this.nonElabConstantsManager, EnumSet.noneOf(ElaborationDebugZone.class));
    }

    protected void parseBuildConfig() {
        BuildConfigManager.parse(this.fProject, false);
    }

    public void clean() {
        try {
            for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
                rfProject.clean(true);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setProjectState(RfProjectState state) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            rfProject.setProjectState(state);
        }
    }

    public synchronized Collection<IRfSingleLangProject> getSingleLangProjects() {
        return this.fRfProjects.values();
    }

    public synchronized IRfSingleLangProject getSingleLangProject(String natureID) {
        return this.fRfProjects.get(natureID);
    }

    public synchronized void setSingleLangProject(String natureID, IRfSingleLangProject project) {
        this.fRfProjects.put(natureID, project);
    }

    public void close() {
        this.fRfProjects.clear();
    }

    public List<IRfNamedElement> getSortCandidatesForContentAssist(IRfSingleLangProject rfProject, IRfNamedElement[] sortedCandidates, String prefix) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        for (IRfSingleLangProject projectCandidate : this.fRfProjects.values()) {
            if (projectCandidate == rfProject) continue;
            projectCandidate.getSortCandidatesForContentAssist(sortedCandidates, prefix);
        }
        return result;
    }

    public List<IRfDesignElement> getDesignsWithPrefix(IRfSingleLangProject rfProject, String prefix, int matchType) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        ArrayList<IRfDesignElement> result = new ArrayList<IRfDesignElement>();
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            Collection<? extends IRfLibraryElement> libraries;
            if (project == rfProject || (libraries = project.getLibraries()) == null || libraries.isEmpty()) continue;
            for (IRfLibraryElement iRfLibraryElement : libraries) {
                List<? extends IRfDesignElement> libraryDesigns = iRfLibraryElement.getDesignsWithPrefix(prefix, matchType);
                if (libraryDesigns == null) continue;
                result.addAll(libraryDesigns);
            }
        }
        return result;
    }

    public IRfDesignElement getDesignWithPrefix(IRfSingleLangProject rfProject, String prefix, int matchType) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            Collection<? extends IRfLibraryElement> libraries;
            if (project == rfProject || (libraries = project.getLibraries()) == null || libraries.isEmpty()) continue;
            for (IRfLibraryElement iRfLibraryElement : libraries) {
                IRfDesignElement design = iRfLibraryElement.getDesignWithPrefix(prefix, matchType);
                if (design == null) continue;
                return design;
            }
        }
        return null;
    }

    public List<IRfPackageElement> getPackagesWithPrefix(IRfSingleLangProject rfProject, String prefix, int matchType) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        ArrayList<IRfPackageElement> result = new ArrayList<IRfPackageElement>();
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            Collection<? extends IRfLibraryElement> libraries;
            if (project == rfProject || (libraries = project.getLibraries()) == null) continue;
            for (IRfLibraryElement iRfLibraryElement : libraries) {
                List<? extends IRfPackageElement> libraryPackages = iRfLibraryElement.getPackagesWithPrefix(prefix, matchType);
                if (libraryPackages == null || libraryPackages.isEmpty()) continue;
                result.addAll(libraryPackages);
            }
        }
        return result;
    }

    public IRfPackageElement getPackageWithPrefix(IRfSingleLangProject rfProject, String prefix, int matchType) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            Collection<? extends IRfLibraryElement> libraries;
            if (project == rfProject || (libraries = project.getLibraries()) == null) continue;
            for (IRfLibraryElement iRfLibraryElement : libraries) {
                IRfPackageElement libraryPackage = iRfLibraryElement.getPackageWithPrefix(prefix, matchType);
                if (libraryPackage == null) continue;
                return libraryPackage;
            }
        }
        return null;
    }

    public List<IRfLibraryElement> getLibraries(IRfSingleLangProject rfProject) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            Collection<? extends IRfLibraryElement> libraries;
            if (project == rfProject || (libraries = project.getLibraries()) == null) continue;
            result.addAll(libraries);
        }
        return result;
    }

    public List<IRfDesignElement> getAllSelectedTops() {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        ELManager manager = this.getELManager();
        if (manager == null) {
            return null;
        }
        return manager.getTopDesigns();
    }

    public List<IRfLibraryElement> getLibrariesWithPrefix(IRfSingleLangProject rfProject, String prefix, int matchType) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            List<? extends IRfLibraryElement> libraries;
            if (project == rfProject || (libraries = project.getLibrariesWithPrefix(prefix, matchType)) == null) continue;
            result.addAll(libraries);
        }
        return result;
    }

    public IRfLibraryElement getLibraryWithPrefix(IRfSingleLangProject rfProject, String prefix, int matchType) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            IRfLibraryElement library;
            if (project == rfProject || (library = project.getLibraryWithPrefix(prefix, matchType)) == null) continue;
            return library;
        }
        return null;
    }

    public IRfFileDef getFile(IRfSingleLangProject rfProject, IFile file) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            IRfFileDef fileDef;
            if (project == rfProject || (fileDef = project.getFile((IResource)file)) == null) continue;
            return fileDef;
        }
        return null;
    }

    public IRfFileDef getFile(IRfSingleLangProject rfProject, ParserPath parserPath) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            IRfFileDef fileDef;
            if (project == rfProject || (fileDef = project.getFile(parserPath)) == null) continue;
            return fileDef;
        }
        return null;
    }

    public void restoreMixedLangProject(IProgressMonitor monitor) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return;
        }
        this.restoreMixedLangProjectElab(monitor);
    }

    private void restoreMixedLangProjectElab(IProgressMonitor monitor) {
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            project.restoreMixedLangProjectPreElab(monitor);
        }
        if (this.fRfProjects.get("ro.amiq.vlogdt.VlogNature") != null || this.fRfProjects.get("ro.amiq.vhdldt.VhdlNature") != null) {
            this.elaborate(false, true, false, true);
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            project.restoreMixedLangProjectPostElab(monitor);
        }
    }

    public void removeMixedLangProject() {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            project.removeMixedLangProject();
        }
    }

    public boolean hasValidBuildConfig() {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return false;
        }
        String activeBuildConfig = BuildConfigManager.getActiveBuildConfigName(this.fRfProjects.values().iterator().next().getProject());
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            if (!(activeBuildConfig == null ? project.getBuildConfig() != null : !activeBuildConfig.equals(project.getBuildConfig()))) continue;
            return false;
        }
        return true;
    }

    public boolean isMixed() {
        return this.fRfProjects.size() > 1;
    }

    public boolean isState(RfProjectState ... testStates) {
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            boolean result = false;
            RfProjectState[] rfProjectStateArray = testStates;
            int n = testStates.length;
            int n2 = 0;
            while (n2 < n) {
                RfProjectState testState = rfProjectStateArray[n2];
                if (project.getProjectState() == testState) {
                    result = true;
                }
                ++n2;
            }
            if (result) continue;
            return false;
        }
        return true;
    }

    public boolean isBuildDone() {
        return this.isBuildDone;
    }

    public void setBuildDone(boolean done) {
        this.isBuildDone = done;
    }

    public boolean isCompiledAs(ParserPath file, String dvtNature) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return false;
        }
        IPath location = Path.fromOSString((String)file.path);
        if (location == null) {
            return false;
        }
        IRfSingleLangProject project = this.fRfProjects.get(dvtNature);
        if (project == null) {
            return false;
        }
        Set<ParserPath> compiledFiles = project.getCompiledFilesSet();
        if (compiledFiles != null && !compiledFiles.isEmpty()) {
            for (ParserPath compiledFile : compiledFiles) {
                String extension;
                if (compiledFile.path == null || (extension = location.getFileExtension()) == null || !extension.equals(Path.fromOSString((String)compiledFile.path).getFileExtension())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCompiledAs(IFile file, String dvtNature) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return false;
        }
        IPath location = file.getLocation();
        if (location == null) {
            return false;
        }
        IRfSingleLangProject project = this.fRfProjects.get(dvtNature);
        if (project == null) {
            return false;
        }
        Set<ParserPath> compiledFiles = project.getCompiledFilesSet();
        if (compiledFiles != null && !compiledFiles.isEmpty()) {
            for (ParserPath compiledFile : compiledFiles) {
                if (compiledFile.path == null || !location.getFileExtension().equals(Path.fromOSString((String)compiledFile.path).getFileExtension())) continue;
                return true;
            }
        }
        return false;
    }

    public void syncCancelSave() {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            project.syncCancelSave();
        }
    }

    public IRfNamedElement getVisibleMemberInScope(IRfSingleLangProject rfProject, Set<IRfNamedElement> visited, Set<Class<? extends IRfNamedElement>> classes, String name, boolean isFirst, boolean isLast, boolean isOnlyType, IRfNamedElement exclude) {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return null;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            Collection<? extends IRfLibraryElement> libraries;
            if (project == rfProject || (libraries = project.getLibraries()) == null) continue;
            for (IRfLibraryElement iRfLibraryElement : libraries) {
                IRfNamedElement element = iRfLibraryElement.getVisibleMemberInScope(name, classes, exclude, visited, null, isFirst, isLast, isOnlyType, false);
                if (element == null) continue;
                return element;
            }
        }
        return null;
    }

    public <T extends IRfNamedElement> void getMembers(IRfSingleLangProject rfProject, Collection<T> result, Class<T> clazz, String prefix, List<String> enumPrefixProposals, int matchType, int local, boolean isFirst, IRfNamedElement.AccessModifier accessModifier, IRfElementFilter elementFilter) throws MaxSizeReachedException {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            Collection<? extends IRfLibraryElement> libraries;
            if (project == rfProject || (libraries = project.getLibraries()) == null) continue;
            for (IRfLibraryElement iRfLibraryElement : libraries) {
                iRfLibraryElement.getMembers(result, clazz, prefix, enumPrefixProposals, matchType, local, isFirst, accessModifier, elementFilter);
            }
        }
    }

    public boolean isLinting() {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return false;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            if (!project.isLintingEnabled()) continue;
            return true;
        }
        return false;
    }

    public void stopLintTracking() {
        if (this.fRfProjects == null || this.fRfProjects.isEmpty()) {
            return;
        }
        for (IRfSingleLangProject project : this.fRfProjects.values()) {
            project.stopLintTracking();
        }
    }

    public void setPFModel(DVTPFModel powerFormatModel) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            rfProject.setPFModel(powerFormatModel);
        }
    }

    public DVTPFModel getPFModel() {
        IRfSingleLangProject vlogRfPRoject = this.fRfProjects.get("ro.amiq.vlogdt.VlogNature");
        if (vlogRfPRoject == null) {
            return null;
        }
        return vlogRfPRoject.getPFModel();
    }

    public List<IRfLibraryElement> getAllLibraries() {
        ArrayList<IRfLibraryElement> result = new ArrayList<IRfLibraryElement>();
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            Collection<? extends IRfLibraryElement> libraries = rfProject.getLibraries();
            if (libraries == null) continue;
            result.addAll(libraries);
        }
        return result;
    }

    void elaborate(boolean reportToConsole, boolean hideImplicitTopsWarning, boolean incremental, boolean restore) {
        int semanticCheckTimeout = BuildConfigManager.getSemanticChecksTimeout(this.fProject);
        semanticCheckTimeout = semanticCheckTimeout == 0 ? Integer.MAX_VALUE : semanticCheckTimeout;
        AtomicBoolean threadDumpCollectorRunning = new AtomicBoolean();
        if (semanticCheckTimeout != Integer.MAX_VALUE && !BuildConfigManager.isDisableProfileElab(this.fProject) && !IncrementalBuildThreadDumpHandler.INSTANCE.isRunning()) {
            threadDumpCollectorRunning.set(DVTThreadDumpCollector.with().prefix("elaboration").path("elaboration").interval(500L).delay((long)semanticCheckTimeout * 1000L).start());
        }
        FIncrementalNotificationTracker.INSTANCE.removeDirtyFiles(this.fProject, FNotificationDirtyReason.ELABORATION);
        boolean useTimer = !this.isLinting() && !FIncrementalNotificationTracker.INSTANCE.isUpdating(this.fProject);
        try {
            try {
                long time = 0L;
                this.fGUIUtils.resetTimer();
                if (useTimer) {
                    this.fGUIUtils.startTimer(semanticCheckTimeout, this.fProject, "Elaboration", " You can change the timeout threshold by adding or modifying the +dvt_semantic_checks_timeout directive in the build config file.");
                }
                DVTThreadDumpCollector.logEvent("Start (MIXED - ELAB) build stage...");
                time = System.currentTimeMillis();
                StopWatch.reset("[BUILD]  elab").start();
                this.preElaborationSetup(incremental, true);
                this.cleanElaborationManagers();
                if (incremental || restore) {
                    this.cleanElaborationInfoFromDesigns();
                }
                RfMixedLangProject mixedLangProject = this.getMixedLangManager();
                ELManagerConfiguration config = ELManagerConfiguration.newElabConfig(mixedLangProject.getProject());
                this.elabManager = new ELManager(mixedLangProject, IELMemory.ELMemoryType.STANDARD, ELBuildPhase.ELABORATION_MAIN, config, mixedLangProject.getElabConstantsManager(), BuildConfigManager.getElaborationDebug(this.fProject));
                this.elabManager.elaborate(this.fProject, reportToConsole, hideImplicitTopsWarning, (IProgressMonitor)(this.fBuildProgressMonitor != null ? this.fBuildProgressMonitor : new NullProgressMonitor()));
                StopWatch.stop("[BUILD]  elab");
                if (reportToConsole) {
                    this.consolePrint("Performing mixed post full build step (MIXED - ELAB) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                }
                DVTThreadDumpCollector.logEvent("Finish (MIXED - ELAB) build stage...");
                if (useTimer) {
                    this.fGUIUtils.stopTimer();
                }
                if (useTimer) {
                    this.fGUIUtils.startTimer(semanticCheckTimeout, this.fProject, "Unelaborated Checking", " You can change the timeout threshold by adding or modifying the +dvt_semantic_checks_timeout directive in the build config file.");
                }
                DVTThreadDumpCollector.logEvent("Start (MIXED - UNEL) build stage...");
                time = System.currentTimeMillis();
                this.preUnelaborationSetup(incremental, true, null);
                this.checkUnelaborated(true, incremental);
                if (reportToConsole) {
                    this.consolePrint("Performing mixed post full build step (MIXED - UNEL) [" + (System.currentTimeMillis() - time) + " ms] ...", true);
                }
                DVTThreadDumpCollector.logEvent("Finish (MIXED - UNEL) build stage...");
                if (useTimer) {
                    this.fGUIUtils.stopTimer();
                }
                this.updateElaborationMarkers(false, reportToConsole);
            }
            catch (BuildCancelException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (this.elabManager != null) {
                    this.nonElabManager.setMemory(this.elabManager.getMemory());
                }
                if (threadDumpCollectorRunning.get()) {
                    DVTThreadDumpCollector.stop();
                }
                if (useTimer) {
                    this.fGUIUtils.stopTimer();
                }
            }
        }
        finally {
            if (this.elabManager != null) {
                this.nonElabManager.setMemory(this.elabManager.getMemory());
            }
            if (threadDumpCollectorRunning.get()) {
                DVTThreadDumpCollector.stop();
            }
            if (useTimer) {
                this.fGUIUtils.stopTimer();
            }
        }
    }

    void elaborateIncrementalAdaptive() {
        if (this.elabManager == null) {
            return;
        }
        try {
            try {
                String debugPrefix = "DEBUG MIXED: ";
                this.fGUIUtils.resetTimer();
                long totalTime = System.currentTimeMillis();
                this.elabManager.logger.debug(ElaborationDebugZone.INCREMENTAL, "\nINCREMENTAL START", new Object[0]);
                int semanticCheckTimeout = BuildConfigManager.getIncrementalCompileTimeout(this.fProject);
                semanticCheckTimeout = semanticCheckTimeout == 0 ? Integer.MAX_VALUE : semanticCheckTimeout;
                Set<IRfNamedElement> unelaboratedCandidates = Collections.newSetFromMap(new IdentityHashMap());
                LinkedHashSet<IRfPackageElement> dirtyPackages = new LinkedHashSet<IRfPackageElement>(4);
                LinkedHashSet<IRfNamedElement> dirtyNonDesignElements = new LinkedHashSet<IRfNamedElement>(4);
                if (!this.isLinting()) {
                    this.fGUIUtils.startTimer(semanticCheckTimeout, this.fProject, "Elaboration", " You can change the timeout threshold by adding or modifying the  +dvt_incremental_compile_timeout  directive in the build config file.");
                }
                long time = System.currentTimeMillis();
                this.preElaborationSetup(true, false);
                ArrayList<IRfInstanceElement> dirtyInstances = new ArrayList<IRfInstanceElement>(4);
                ArrayList<IRfDesignElement> dirtyDesigns = new ArrayList<IRfDesignElement>(4);
                boolean hasRemovedDescriptions = this.hasIncrementalRemovedDescriptions();
                this.analyzeDeltaForElaboration(dirtyInstances, dirtyDesigns, dirtyPackages, dirtyNonDesignElements);
                this.elaborateIncrementalAdaptive(dirtyDesigns, dirtyInstances, dirtyPackages, dirtyNonDesignElements, hasRemovedDescriptions, unelaboratedCandidates);
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Incremental elaboration [" + (System.currentTimeMillis() - time) + " ms]");
                if (!this.isLinting()) {
                    this.fGUIUtils.stopTimer();
                }
                if (!this.isLinting()) {
                    this.fGUIUtils.startTimer(semanticCheckTimeout, this.fProject, "Unelaborated Checking", " You can change the timeout threshold by adding or modifying the  +dvt_incremental_compile_timeout  directive in the build config file.");
                }
                time = System.currentTimeMillis();
                HashMap<ParserPath, Set<IRfNamedElement>> unelaboratedElementsMap = new HashMap<ParserPath, Set<IRfNamedElement>>();
                for (IRfNamedElement changedDesign : unelaboratedCandidates) {
                    if (!(changedDesign instanceof IRfDesignElement)) continue;
                    RfMixedLangProjectCommon.recursiveCollectUnelaboratedDesigns((IRfDesignElement)changedDesign, unelaboratedElementsMap);
                }
                this.preUnelaborationSetup(true, false, unelaboratedElementsMap);
                this.checkUnelaboratedIncremental(true, unelaboratedCandidates, dirtyPackages, dirtyNonDesignElements);
                DVTLogger.INSTANCE.logDebug(String.valueOf(debugPrefix) + "Incremental check unelaborated [" + (System.currentTimeMillis() - time) + " ms]");
                if (!this.isLinting()) {
                    this.fGUIUtils.stopTimer();
                }
                this.updateElaborationMarkers(false, false);
                this.elabManager.logger.debug(ElaborationDebugZone.INCREMENTAL, "\nINCREMENTAL DONE in " + (System.currentTimeMillis() - totalTime) + " ms", new Object[0]);
            }
            catch (BuildCancelException e) {
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                if (this.hasCanceledGUITimer()) {
                    this.elabManager.setDirtyMemory(true);
                }
                if (!this.isLinting()) {
                    this.fGUIUtils.stopTimer();
                }
            }
        }
        finally {
            if (this.hasCanceledGUITimer()) {
                this.elabManager.setDirtyMemory(true);
            }
            if (!this.isLinting()) {
                this.fGUIUtils.stopTimer();
            }
        }
    }

    public Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> getLinterElabSpecs() {
        return this.linterElabSpecs;
    }

    public void collectLinterElabSpecs() {
        if (!this.isLinting()) {
            return;
        }
        this.linterElabSpecs = new IdentityHashMap<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>>();
        if (this.elabManager == null || this.elabManager.getMemory() == null) {
            return;
        }
        IELMemory mem = this.elabManager.getMemory();
        mem.visitBindings(new IELMemory.IELMemoryVisitor(){

            @Override
            public boolean visitBindings(ElementPath path, ELInstance instance) {
                IRfNamedElement binding = instance.getBinding(false);
                if (!(binding instanceof IELDesign)) {
                    return true;
                }
                ELParamValues paramValues = instance.getParamValues();
                ELSpecialization newSpec = ELSpecialization.packedOf((IELDesign)binding, paramValues);
                ELSpecializationWrapper newSpecWrapper = ELSpecializationWrapper.of(newSpec, false, instance.getHierarchyPath());
                Map specs = RfMixedLangProjectCommon.this.linterElabSpecs.computeIfAbsent(binding, key -> new HashMap());
                ELSpecializationWrapper existingOrNull = specs.putIfAbsent(newSpecWrapper, newSpecWrapper);
                if (existingOrNull != null) {
                    existingOrNull.addPaths(newSpecWrapper.paths);
                }
                return true;
            }
        });
    }

    private static void recursiveCollectUnelaboratedDesigns(IRfDesignElement design, Map<ParserPath, Set<IRfNamedElement>> unelaboratedElementsMap) {
        Collection<? extends IRfBlockElement> collection;
        Collection<? extends IRfInstanceElement> localInstances;
        if (design == null) {
            return;
        }
        IRfDefElement declaration = design.getDeclaration();
        if (declaration != null) {
            Set changed = unelaboratedElementsMap.computeIfAbsent(declaration.getParserPath(), key -> Collections.newSetFromMap(new IdentityHashMap()));
            changed.add(design);
        }
        if ((localInstances = design.getLocalInstances()) != null) {
            for (IRfInstanceElement iRfInstanceElement : localInstances) {
                IRfDefElement localInstanceDeclaration = design.getDeclaration();
                if (localInstanceDeclaration == null) continue;
                Set changed = unelaboratedElementsMap.computeIfAbsent(localInstanceDeclaration.getParserPath(), key -> Collections.newSetFromMap(new IdentityHashMap()));
                changed.add(iRfInstanceElement);
            }
        }
        if ((collection = design.getLocalGenerateBlocks()) != null) {
            for (IRfBlockElement iRfBlockElement : collection) {
                RfMixedLangProjectCommon.recursiveCollectUnelaboratedDesigns(iRfBlockElement, unelaboratedElementsMap);
            }
        }
    }

    private void elaborateIncrementalAdaptive(List<IRfDesignElement> dirtyDesigns, List<IRfInstanceElement> dirtyInstances, Set<IRfPackageElement> dirtyPackages, Set<IRfNamedElement> dirtyNonDesignElements, boolean hasRemovedDescriptions, Set<IRfNamedElement> unelaboratedCandidates) {
        ArrayList<ELInstance> elaboratedCandidates = new ArrayList<ELInstance>();
        ArrayList<ElementPath> updatedElaboratedPaths = new ArrayList<ElementPath>();
        IProgressMonitor progressMonitor = this.fBuildProgressMonitor != null ? this.fBuildProgressMonitor : new NullProgressMonitor();
        this.resolveConfigurations();
        this.elabManager.elaborateIncrementalStart(dirtyDesigns, dirtyInstances, dirtyPackages, dirtyNonDesignElements, hasRemovedDescriptions, unelaboratedCandidates, elaboratedCandidates, updatedElaboratedPaths, progressMonitor);
        this.preElaborationIncrementalSetup(elaboratedCandidates);
        this.elabManager.elaborateIncrementalEnd(dirtyDesigns, unelaboratedCandidates, elaboratedCandidates, dirtyNonDesignElements, updatedElaboratedPaths, progressMonitor);
    }

    private void cleanElaborationInfoFromDesigns() {
        List<IRfLibraryElement> libs = this.getAllLibraries();
        if (libs == null || libs.isEmpty()) {
            return;
        }
        for (IRfLibraryElement lib : libs) {
            lib.cleanElaborationInfoFromDesigns();
        }
    }

    public static void cleanElaborationInfoFromPackages(IRfPackageElement pkg) {
        pkg.cleanElaborationInfo();
        if (pkg.getEnclosingLibrary() instanceof IELDesign) {
            ((IELDesign)((Object)pkg.getEnclosingLibrary())).cleanElaborationInfo();
        }
    }

    public static void recursiveCleanElaborationInfoFromDesign(IRfDesignElement design) {
        Collection<? extends IRfBlockElement> localGenerateBlocks;
        if (design instanceof IELDesign) {
            ((IELDesign)((Object)design)).cleanElaborationInfo();
        }
        if ((localGenerateBlocks = design.getLocalGenerateBlocks()) != null) {
            for (IRfBlockElement iRfBlockElement : localGenerateBlocks) {
                RfMixedLangProjectCommon.recursiveCleanElaborationInfoFromDesign(iRfBlockElement);
            }
        }
    }

    private void analyzeDeltaForElaboration(Collection<IRfInstanceElement> dirtyInstances, Collection<IRfDesignElement> dirtyDesigns, Collection<IRfPackageElement> dirtyPackages, Collection<IRfNamedElement> dirtyNonDesignElements) {
        Set<IRfNamedElement> changedNonDesignElements;
        List<IRfDesignElement> changedDesigns;
        List<IRfInstanceElement> changedInstances;
        Map<LanguageKind, List<IRfInstanceElement>> changedInstancesPerLanguage = this.getIncrementalDeltaInstances();
        Map<LanguageKind, List<IRfDesignElement>> changedDesignsPerLanguage = this.getIncrementalDeltaDesigns();
        Map<LanguageKind, List<IRfPackageElement>> changedPackagesPerLanguage = this.getIncrementalChangedPackages();
        Map<LanguageKind, Set<IRfNamedElement>> changedNonDesignElementsPerLanguage = this.getIncrementalChangedNonDesignElements();
        List<IRfPackageElement> changedPackages = changedPackagesPerLanguage.get((Object)LanguageKind.VLOG);
        if (changedPackages != null) {
            dirtyPackages.addAll(changedPackages);
        }
        if ((changedPackages = changedPackagesPerLanguage.get((Object)LanguageKind.VHDL)) != null) {
            dirtyPackages.addAll(changedPackages);
        }
        if ((changedInstances = changedInstancesPerLanguage.get((Object)LanguageKind.VLOG)) != null) {
            dirtyInstances.addAll(changedInstances);
        }
        if ((changedInstances = changedInstancesPerLanguage.get((Object)LanguageKind.VHDL)) != null) {
            dirtyInstances.addAll(changedInstances);
        }
        if ((changedDesigns = changedDesignsPerLanguage.get((Object)LanguageKind.VLOG)) != null) {
            dirtyDesigns.addAll(changedDesigns);
        }
        if (dirtyDesigns.isEmpty()) {
            for (IRfInstanceElement instance : dirtyInstances) {
                IRfScopeElement enclosingScope = instance.getEnclosingScope(DVTRfUtils.MEMBERS_DESIGN);
                if (!(enclosingScope instanceof IRfDesignElement)) continue;
                dirtyDesigns.add((IRfDesignElement)enclosingScope);
            }
        }
        if ((changedDesigns = changedDesignsPerLanguage.get((Object)LanguageKind.VHDL)) != null) {
            dirtyDesigns.addAll(changedDesigns);
        }
        if ((changedNonDesignElements = changedNonDesignElementsPerLanguage.get((Object)LanguageKind.VLOG)) != null) {
            dirtyNonDesignElements.addAll(changedNonDesignElements);
        }
        if ((changedNonDesignElements = changedNonDesignElementsPerLanguage.get((Object)LanguageKind.VHDL)) != null) {
            dirtyNonDesignElements.addAll(changedNonDesignElements);
        }
    }

    void elaborateIncrementalNone() {
        if (this.elabManager == null) {
            return;
        }
        ArrayList<IRfInstanceElement> dirtyInstances = new ArrayList<IRfInstanceElement>(4);
        LinkedHashSet<IRfPackageElement> dirtyPackages = new LinkedHashSet<IRfPackageElement>(4);
        ArrayList<IRfDesignElement> dirtyDesigns = new ArrayList<IRfDesignElement>(4);
        ArrayList dirtyBlocks = new ArrayList(4);
        LinkedHashSet<IRfNamedElement> dirtyNonDesignElements = new LinkedHashSet<IRfNamedElement>(4);
        this.analyzeDeltaForElaboration(dirtyInstances, dirtyDesigns, dirtyPackages, dirtyNonDesignElements);
        boolean isDirty = !dirtyPackages.isEmpty() || !dirtyInstances.isEmpty() || !dirtyDesigns.isEmpty() || !dirtyBlocks.isEmpty() || this.hasIncrementalStructuralDesignChanges();
        this.elabManager.setDirtyMemory(isDirty);
        if (isDirty) {
            this.preElaborationSetup(true, false);
        }
        this.updateElaborationMarkers(false, false);
    }

    private void consolePrint(String message, boolean isReport) {
        DVTBuildConsoleRegistry.getConsole(this.getProject()).print(message, isReport ? DVTBuildConsoleCommon.MessageSink.REPORT : DVTBuildConsoleCommon.MessageSink.CONSOLE);
    }

    public void cleanElaborationManagers() {
        if (this.elabManager != null) {
            this.elabManager.deepCleanMemory();
        }
        this.elabManager = null;
        this.nonElabManager.resetMemory(IELMemory.ELMemoryType.STANDARD);
        this.elabConstantsManager.deepClean();
        this.nonElabConstantsManager.deepClean();
        this.linterElabSpecs = null;
    }

    public ELManager getELManager() {
        return this.elabManager;
    }

    public ELManager getNonELManager() {
        return this.nonElabManager;
    }

    public boolean hasCanceledGUITimer() {
        return this.fGUIUtils != null && this.fGUIUtils.isCancelChecking();
    }

    @Deprecated
    public boolean hasElaborationEnabled() {
        return true;
    }

    private boolean hasIncrementalStructuralDesignChanges() {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject) || !((IELProject)((Object)rfProject)).hasIncrementalStructuralDesignChanges()) continue;
            return true;
        }
        return false;
    }

    private void preElaborationSetup(boolean cleanMarkers, boolean isFullBuild) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).preElaborationSetup(cleanMarkers, isFullBuild);
        }
    }

    private void preElaborationIncrementalSetup(List<ELInstance> elaboratedCandidates) {
        HashMap<ParserPath, Set<IRfNamedElement>> elaboratedElementsMap = new HashMap<ParserPath, Set<IRfNamedElement>>();
        for (ELInstance candidate : elaboratedCandidates) {
            IRfDefElement declaration;
            IRfNamedElement binding = candidate.getBinding(false);
            if (binding == null || (declaration = binding.getDeclaration()) == null) continue;
            Set changed = elaboratedElementsMap.computeIfAbsent(declaration.getParserPath(), key -> Collections.newSetFromMap(new IdentityHashMap()));
            changed.add(binding);
            IRfNamedElement entityBinding = candidate.getBinding(true);
            if (entityBinding == null || entityBinding == binding || (declaration = entityBinding.getDeclaration()) == null) continue;
            changed = elaboratedElementsMap.computeIfAbsent(declaration.getParserPath(), key -> Collections.newSetFromMap(new IdentityHashMap()));
            changed.add(entityBinding);
        }
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).preElaborationIncrementalSetup(elaboratedElementsMap);
        }
    }

    private void preUnelaborationSetup(boolean cleanMarkers, boolean isFullBuild, Map<ParserPath, Set<IRfNamedElement>> unelaboratedElementsMap) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).preUnelaborationSetup(cleanMarkers, isFullBuild, unelaboratedElementsMap);
        }
    }

    private void updateElaborationMarkers(boolean updateStatistics, boolean reportToConsole) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).updateElaborationMarkers(updateStatistics, reportToConsole);
        }
    }

    private void checkUnelaboratedIncremental(boolean triggerError, Set<IRfNamedElement> unelaboratedCandidates, Set<IRfPackageElement> dirtyPackages, Set<IRfNamedElement> dirtyNonDesignElements) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).checkUnelaboratedIncremental(triggerError, unelaboratedCandidates, dirtyPackages, dirtyNonDesignElements);
        }
    }

    private void checkUnelaborated(boolean triggerError, boolean incremental) {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).checkUnelaborated(triggerError, incremental);
        }
    }

    private Map<LanguageKind, List<IRfInstanceElement>> getIncrementalDeltaInstances() {
        EnumMap<LanguageKind, List<IRfInstanceElement>> collected = new EnumMap<LanguageKind, List<IRfInstanceElement>>(LanguageKind.class);
        collected.put(LanguageKind.VLOG, new ArrayList());
        collected.put(LanguageKind.VHDL, new ArrayList());
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).collectIncrementalDeltaInstances(collected);
        }
        return collected;
    }

    private Map<LanguageKind, List<IRfPackageElement>> getIncrementalChangedPackages() {
        EnumMap<LanguageKind, List<IRfPackageElement>> collected = new EnumMap<LanguageKind, List<IRfPackageElement>>(LanguageKind.class);
        collected.put(LanguageKind.VLOG, new ArrayList());
        collected.put(LanguageKind.VHDL, new ArrayList());
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).collectIncrementalChangedPackages(collected);
        }
        return collected;
    }

    private Map<LanguageKind, Set<IRfNamedElement>> getIncrementalChangedNonDesignElements() {
        EnumMap<LanguageKind, Set<IRfNamedElement>> collected = new EnumMap<LanguageKind, Set<IRfNamedElement>>(LanguageKind.class);
        collected.put(LanguageKind.VLOG, new HashSet());
        collected.put(LanguageKind.VHDL, new HashSet());
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).collectIncrementalChangedNonDesignElements(collected);
        }
        return collected;
    }

    private Map<LanguageKind, List<IRfDesignElement>> getIncrementalDeltaDesigns() {
        EnumMap<LanguageKind, List<IRfDesignElement>> collected = new EnumMap<LanguageKind, List<IRfDesignElement>>(LanguageKind.class);
        collected.put(LanguageKind.VLOG, new ArrayList());
        collected.put(LanguageKind.VHDL, new ArrayList());
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).collectIncrementalDeltaDesigns(collected);
        }
        return collected;
    }

    private Map<LanguageKind, List<IRfDesignElement>> getIncrementalDeltaBlocks() {
        EnumMap<LanguageKind, List<IRfDesignElement>> collected = new EnumMap<LanguageKind, List<IRfDesignElement>>(LanguageKind.class);
        collected.put(LanguageKind.VLOG, new ArrayList());
        collected.put(LanguageKind.VHDL, new ArrayList());
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            ((IELProject)((Object)rfProject)).collectIncrementalDeltaBlocks(collected);
        }
        return collected;
    }

    private boolean hasIncrementalRemovedDescriptions() {
        boolean result = false;
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            if (!(rfProject instanceof IELProject)) continue;
            result |= ((IELProject)((Object)rfProject)).hasIncrementalRemovedDescriptions();
        }
        return result;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void resolveConfigurations() {
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            rfProject.resolveConfigurations();
        }
    }

    public List<IRfConfiguration> resolveBuildConfigTopProperties(List<BuildConfigProperty> buildConfigTopProperties, boolean reportToConsole) {
        if (buildConfigTopProperties == null || buildConfigTopProperties.isEmpty()) {
            return null;
        }
        HashMap resolvedConfigs = new HashMap();
        ArrayList<IRfConfiguration> result = new ArrayList<IRfConfiguration>();
        block0: for (BuildConfigProperty property : buildConfigTopProperties) {
            int index;
            boolean specifiedLibrary;
            IRfConfiguration resolved = null;
            String configName = property.getValue();
            String libraryName = null;
            boolean isConfigOnly = false;
            if (configName.endsWith(":config")) {
                configName = configName.substring(0, configName.length() - ":config".length());
                isConfigOnly = true;
            }
            boolean bl = specifiedLibrary = (index = configName.indexOf(46)) > 0;
            if (specifiedLibrary) {
                libraryName = configName.substring(0, index);
                configName = configName.substring(index + 1);
            }
            for (IRfSingleLangProject project : this.fRfProjects.values()) {
                IRfConfiguration projectResolved = RfMixedLangProjectCommon.resolveBuildConfigTopProperty(project, configName, libraryName, isConfigOnly);
                if (projectResolved == null) continue;
                resolved = projectResolved;
                break;
            }
            if (resolved == null) {
                this.reportConfigError(property, reportToConsole);
                continue;
            }
            if (resolvedConfigs.get(configName) == null) {
                resolvedConfigs.put(configName, new ArrayList());
            }
            List visitedConfigNames = (List)resolvedConfigs.get(configName);
            for (IRfConfiguration solvedConfig : visitedConfigNames) {
                if (solvedConfig.getEnclosingLibrary() != resolved.getEnclosingLibrary()) continue;
                this.reportConfigDuplicateTop(property);
                continue block0;
            }
            visitedConfigNames.add(resolved);
            result.add(resolved);
        }
        DVTProblemsUiUpdaterRegistry.get(DVTProblemCategories.BUILDCONFIG.getId()).update(this.getProject());
        return result;
    }

    static IRfConfiguration resolveBuildConfigTopProperty(IRfSingleLangProject project, String configName, String libraryName, boolean isConfigOnly) {
        if (configName == null || project == null) {
            return null;
        }
        if (libraryName != null) {
            IRfLibraryElement library = project.getLibraryWithPrefix(libraryName, 9);
            if (library == null) {
                return null;
            }
            return project.resolveDesignOrConfigInLibrary(library, configName, isConfigOnly);
        }
        Collection<? extends IRfLibraryElement> libraries = project.getLibraries();
        if (libraries == null) {
            return null;
        }
        for (IRfLibraryElement iRfLibraryElement : libraries) {
            IRfConfiguration candidate = project.resolveDesignOrConfigInLibrary(iRfLibraryElement, configName, isConfigOnly);
            if (candidate == null) continue;
            return candidate;
        }
        return null;
    }

    private void reportConfigError(BuildConfigProperty topConfigProperty, boolean reportToConsole) {
        String activeConfigName = topConfigProperty.getValue();
        int line = (Integer)topConfigProperty.getAttribute("ATTRIBUTE_LINE");
        String file = (String)topConfigProperty.getAttribute("ATTRIBUTE_FILE");
        String message = "BUILD_CONFIG: ".concat("Cannot find design element name '" + activeConfigName + "' specified by -top/+nctop+ directive");
        DVTProblem problem = new DVTProblem(this.fProject, DVTProblemKinds.BUILDCONFIG_ERROR, file, reportToConsole, line, message);
        DVTProblemManager.getInstance().reportProblem(problem);
    }

    private void reportConfigDuplicateTop(BuildConfigProperty topConfigProperty) {
        String activeConfigName = topConfigProperty.getValue();
        int line = (Integer)topConfigProperty.getAttribute("ATTRIBUTE_LINE");
        String file = (String)topConfigProperty.getAttribute("ATTRIBUTE_FILE");
        String message = "BUILD_CONFIG: ".concat("Duplicate design element name '" + activeConfigName + "' specified by -top/+nctop+ directive");
        DVTProblem problem = new DVTProblem(this.fProject, DVTProblemKinds.BUILDCONFIG_WARNING, file, false, line, message);
        DVTProblemManager.getInstance().reportProblem(problem);
    }

    public void setBuildProgressMonitor(IProgressMonitor buildProgressMonitor) {
        this.fBuildProgressMonitor = buildProgressMonitor;
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            rfProject.setBuildProgressMonitor(buildProgressMonitor);
        }
    }

    public IProgressMonitor getBuildProgressMonitor() {
        return this.fBuildProgressMonitor;
    }

    @NotNull
    public ELConstantsManager getElabConstantsManager() {
        return this.elabConstantsManager;
    }

    @NotNull
    public ELConstantsManager getNonElabConstantsManager() {
        return this.nonElabConstantsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncrementalDeltaListener(IIncrementalDeltaListener listener) {
        Collection<IIncrementalDeltaListener> collection = this.incrementalDeltaListeners;
        synchronized (collection) {
            this.incrementalDeltaListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncrementalDeltaListener(IIncrementalDeltaListener listener) {
        Collection<IIncrementalDeltaListener> collection = this.incrementalDeltaListeners;
        synchronized (collection) {
            this.incrementalDeltaListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIncrementalDeltaListeners(Collection<? extends IRfNamedElement> added, Collection<? extends IRfNamedElement> removed, Collection<? extends IRfNamedElement> modified, Collection<ParserPath> changedFiles) {
        Collection<IIncrementalDeltaListener> collection = this.incrementalDeltaListeners;
        synchronized (collection) {
            for (IIncrementalDeltaListener iIncrementalDeltaListener : this.incrementalDeltaListeners) {
                iIncrementalDeltaListener.changedElements(added, removed, modified, changedFiles);
            }
        }
    }

    protected abstract void createAndRemoveSingleLangProjects(List<IReflectionContributor> var1);

    protected abstract boolean checkRestoreInhibited();

    protected abstract RfMixedLangProject getMixedLangManager();

    protected abstract void scheduleRestoreJob(Job var1);

    public boolean hasNature(String natureId) {
        try {
            return this.fProject != null && this.fProject.hasNature(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void restore() {
        if (!this.isState(RfProjectState.NEW)) {
            return;
        }
        boolean dontRestore = DVTUtilsCommon.INSTANCE.readClearBooleanSessionProperty(this.fProject, DVTStartupConstants.QN_DVT_DONT_RESTORE);
        if (dontRestore) {
            for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
                RfProjectState state = rfProject.getProjectState();
                if (state != RfProjectState.NEW) continue;
                rfProject.setProjectState(RfProjectState.NOT_RESTORED);
            }
            return;
        }
        if (this.checkRestoreInhibited()) {
            return;
        }
        if (!this.deserializeBuildConfig()) {
            return;
        }
        if (!this.tryToAcquireRestoreDbLocationLock()) {
            this.setProjectState(RfProjectState.NOT_RESTORED);
            return;
        }
        for (IRfSingleLangProject rfProject : this.fRfProjects.values()) {
            RfProjectState state = rfProject.getProjectState();
            if (state != RfProjectState.NEW || !rfProject.preRestore()) continue;
            rfProject.setProjectState(RfProjectState.PRE_RESTORED);
        }
        if (!this.isState(RfProjectState.PRE_RESTORED)) {
            this.setProjectState(RfProjectState.NOT_RESTORED);
            return;
        }
        Utils.workaroundProgessViewBug();
        RestoreJob restoreJob = new RestoreJob();
        this.scheduleRestoreJob(restoreJob);
    }

    private boolean deserializeBuildConfig() {
        ActiveBuildConfig deserializedBuildConfig;
        block7: {
            try {
                ActiveBuildConfig activeBuildConfig = BuildConfigManagerCommon.getBuildConfigMap().get(this.fProject);
                Path buildConfigsDefaultDirPath = (Path)this.fProject.getLocation().append(".dvt").append(".build_config_dict");
                deserializedBuildConfig = BuildConfigManager.loadBuildConfig(buildConfigsDefaultDirPath, activeBuildConfig.getName(), this.fProject);
                if (deserializedBuildConfig != null) break block7;
                this.setProjectState(RfProjectState.NOT_RESTORED);
                return false;
            }
            catch (Exception e) {
                this.setProjectState(RfProjectState.BC_FAILED);
                if (e instanceof InvalidClassException || e instanceof InvalidObjectException || e instanceof ClassNotFoundException || e instanceof ClassCastException || e instanceof OptionalDataException || e instanceof EOFException || e instanceof VersionChangedException || e instanceof StreamCorruptedException) {
                    PersistenceUtils.openRebuildDialog(this.getProject());
                } else if (e instanceof PersistenceCancelException || e instanceof FileNotFoundException) {
                    DVTLogger.INSTANCE.logDebug("[PERSISTENCE " + (this.getProject() != null ? this.getProject().getName() : "") + "] " + "Failed to read RfProject (" + e.getMessage() + ")");
                } else {
                    DVTLogger.INSTANCE.logError("Failed to read RfProject for " + this.getProject().getName(), (Throwable)e);
                }
                return false;
            }
        }
        BuildConfigManagerCommon.getBuildConfigMap().put(this.fProject, deserializedBuildConfig);
        DVTBuildConsoleRegistry.getConsole(this.fProject).buildConfigEnded();
        this.addPfNotification(deserializedBuildConfig);
        BuildConfigManager.updateActiveBuildConfigFileMappings(deserializedBuildConfig.getCachedInfo());
        return true;
    }

    private void addPfNotification(ActiveBuildConfig deserializedBuildConfig) {
        if (!this.hasNature("ro.amiq.dvt.pfnature")) {
            return;
        }
        List<Invocation> invocations = deserializedBuildConfig.getCachedInfo();
        if (invocations == null) {
            return;
        }
        for (Invocation invocation : invocations) {
            List<BuildConfigProperty> properties = invocation.getProperties();
            if (properties == null) continue;
            for (BuildConfigProperty p : properties) {
                if (p.getKind() != 19) continue;
                FIncrementalNotificationTracker.INSTANCE.addDirtyResource(this.getProject(), new FDirtyScriptingEditorResource(FNotificationDirtyReason.TCL_FILE_RESTORED));
                Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.paint(false, FWidgetType.DB_OUT_OF_SYNC));
                return;
            }
        }
    }

    public void cleanIncrementalDeltaContainer() {
        for (IRfSingleLangProject rfProject : this.getSingleLangProjects()) {
            rfProject.cleanIncrementalDeltaContainer();
        }
    }

    public abstract boolean tryToAcquireRestoreDbLocationLock();

    private class RestoreJob
    extends Job {
        public RestoreJob() {
            super("Restoring project: " + RfMixedLangProjectCommon.this.fProject.getName());
            this.setUser(true);
            this.setPriority(30);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().buildRule();
            this.setRule(rule);
            this.setProperty(DVTMixedLangBuilder.BUILD_KIND_QNAME, "FULL_BUILD");
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_MANUAL_BUILD || family == ResourcesPlugin.FAMILY_AUTO_BUILD || family == FAMILY_PROJECT_RESTORE;
        }

        protected IStatus run(IProgressMonitor monitor) {
            JobChangeAdapter projectCloseListner;
            block7: {
                projectCloseListner = new JobChangeAdapter(){

                    public void scheduled(IJobChangeEvent event) {
                        Job job = event.getJob();
                        if (job == null) {
                            return;
                        }
                        if (job.getName() == null || !job.getName().startsWith(RfMixedLangProjectCommon.CLOSE_PROJECT)) {
                            return;
                        }
                        if (job.getRule() == null) {
                            return;
                        }
                        if (job.getRule().contains((ISchedulingRule)((RestoreJob)RestoreJob.this).RfMixedLangProjectCommon.this.fProject)) {
                            RestoreJob.this.cancel();
                        }
                    }
                };
                Job.getJobManager().addJobChangeListener((IJobChangeListener)projectCloseListner);
                monitor.beginTask("", -1);
                monitor.subTask("Load from dictionary");
                RfMixedLangProjectCommon.this.setBuildProgressMonitor(monitor);
                while (!Utils.isPluginInitializationDone()) {
                    Thread.sleep(100L);
                }
                boolean updateMixedMode = false;
                ObjectionManager.getInstance().clear(Objection.PRE_RESTORE);
                AutolinkWithoutLinksRestorer restorer = new AutolinkWithoutLinksRestorer(RfMixedLangProjectCommon.this.fRfProjects, RfMixedLangProjectCommon.this.fProject);
                restorer.run();
                CompileWaiversUtil.getInstance().resetLastSelectedFile(RfMixedLangProjectCommon.this.fProject);
                ObjectionManager.getInstance().clear(Objection.BUILD_START);
                ObjectionManager.getInstance().clear(Objection.RESTORE_START);
                for (IRfSingleLangProject rfProject : RfMixedLangProjectCommon.this.fRfProjects.values()) {
                    RfProjectState state = rfProject.getProjectState();
                    if (state != RfProjectState.PRE_RESTORED) continue;
                    rfProject.setProjectState(RfProjectState.RESTORED);
                    rfProject.restore(monitor);
                    updateMixedMode = true;
                }
                if (updateMixedMode) break block7;
                IStatus iStatus = Status.OK_STATUS;
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)projectCloseListner);
                DVTBuildCancelManager.INSTANCE.updateBuildStatus(monitor.isCanceled() ? IBuildDoneListener.BuildFinishReason.RESTORE_CANCEL : IBuildDoneListener.BuildFinishReason.RESTORE_SUCCES, RfMixedLangProjectCommon.this.fProject.getName());
                monitor.done();
                RfMixedLangProjectCommon.this.setBuildProgressMonitor(null);
                ObjectionManager.getInstance().clear(Objection.RESTORE_DONE);
                return iStatus;
            }
            try {
                try {
                    RfMixedLangProjectCommon.this.restoreMixedLangProject(monitor);
                    BuildEventManager.getInstance().notifyFullBuild(RfMixedLangProjectCommon.this.fProject);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    Job.getJobManager().removeJobChangeListener((IJobChangeListener)projectCloseListner);
                    DVTBuildCancelManager.INSTANCE.updateBuildStatus(monitor.isCanceled() ? IBuildDoneListener.BuildFinishReason.RESTORE_CANCEL : IBuildDoneListener.BuildFinishReason.RESTORE_SUCCES, RfMixedLangProjectCommon.this.fProject.getName());
                    monitor.done();
                    RfMixedLangProjectCommon.this.setBuildProgressMonitor(null);
                    ObjectionManager.getInstance().clear(Objection.RESTORE_DONE);
                }
            }
            catch (Throwable throwable) {
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)projectCloseListner);
                DVTBuildCancelManager.INSTANCE.updateBuildStatus(monitor.isCanceled() ? IBuildDoneListener.BuildFinishReason.RESTORE_CANCEL : IBuildDoneListener.BuildFinishReason.RESTORE_SUCCES, RfMixedLangProjectCommon.this.fProject.getName());
                monitor.done();
                RfMixedLangProjectCommon.this.setBuildProgressMonitor(null);
                ObjectionManager.getInstance().clear(Objection.RESTORE_DONE);
                throw throwable;
            }
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)projectCloseListner);
            DVTBuildCancelManager.INSTANCE.updateBuildStatus(monitor.isCanceled() ? IBuildDoneListener.BuildFinishReason.RESTORE_CANCEL : IBuildDoneListener.BuildFinishReason.RESTORE_SUCCES, RfMixedLangProjectCommon.this.fProject.getName());
            monitor.done();
            RfMixedLangProjectCommon.this.setBuildProgressMonitor(null);
            ObjectionManager.getInstance().clear(Objection.RESTORE_DONE);
            return Status.OK_STATUS;
        }
    }
}

