/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.assertion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.assertion.AssertTMAbstractTransition;
import ro.amiq.dvt.model.reflection.assertion.AssertTMBinaryTransition;
import ro.amiq.dvt.model.reflection.assertion.AssertTMOppositeTransition;
import ro.amiq.dvt.model.reflection.assertion.AssertTMState;
import ro.amiq.dvt.model.reflection.assertion.AssertTMTransition;
import ro.amiq.dvt.model.reflection.assertion.IAssertTMState;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.fast.IdentityHSet;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.XGlobalCache;

public class AssertTM {
    public static final boolean DVT_ENABLE_SV_INTERP_ASSERTIONS_DEBUG = Boolean.parseBoolean(System.getenv("DVT_ENABLE_SV_INTERP_ASSERTIONS_DEBUG"));
    private final IRfAssertExpectElement assertElement;
    private int stateUniqueId;
    private int cursorUniqueId;
    public IHidOperator clockingEvent;
    public IHidOperator lastClockingEvent;
    public final IHidBuilders hidBuilders;
    private AssertTMState head;
    private AssertTMState success;
    private AssertTMState failure;
    public final Set<IAssertTMState> states = new HashSet<IAssertTMState>();
    public final Set<AssertTMCursor> cursors;
    public final Map<IAssertTMState, AssertTMAbstractTransition> transitionTable;
    public Set<IHid> hids;
    private boolean isAlwaysBlockScoped;
    public IHidObject disableIffCondition;

    public static AssertTM of(IRfAssertExpectElement assertElement) {
        AssertTM assertTM = new AssertTM(assertElement);
        assertTM.head = AssertTMState.createHead(assertTM);
        assertTM.states.add(assertTM.getHead());
        assertTM.success = AssertTMState.createExecuteState(AssertTMState.AssertStateKind.SUCCESS, assertTM);
        assertTM.getSuccess().setAdditionalText("FINAL");
        assertTM.failure = AssertTMState.createExecuteState(AssertTMState.AssertStateKind.FAIL, assertTM);
        assertTM.getFailure().setAdditionalText("FINAL");
        return assertTM;
    }

    public AssertTM(IRfAssertExpectElement assertElement) {
        this.assertElement = assertElement;
        this.hidBuilders = assertElement.getHidBuilders();
        this.cursors = new IdentityHSet<AssertTMCursor>(16);
        this.transitionTable = new LinkedHashMap<IAssertTMState, AssertTMAbstractTransition>();
    }

    public int getStateUniqueId() {
        ++this.stateUniqueId;
        if (this.stateUniqueId == Integer.MAX_VALUE) {
            throw new BuildCancelException("Unable to compute associated internal model for assert '" + this.assertElement + "'");
        }
        return this.stateUniqueId;
    }

    public int getCursorUniqueId() {
        ++this.cursorUniqueId;
        if (this.cursorUniqueId == Integer.MAX_VALUE) {
            throw new BuildCancelException("Unable to compute associated internal model for assert '" + this.assertElement + "'");
        }
        return this.cursorUniqueId;
    }

    public IAssertTMState addTransition(IAssertTMState prevState, IAssertTMState nextState, AssertTMState nextFailState, AssertTM assertTM) {
        return this.addTransition(prevState, nextState, nextFailState, null, assertTM);
    }

    public IAssertTMState addTransition(IAssertTMState prevState, IAssertTMState nextState, AssertTMState nextFailState, IHidOperator operator, AssertTM assertTM) {
        AssertTMAbstractTransition transition = this.transitionTable.get(prevState);
        if (transition == null) {
            transition = this.createTransition(operator, prevState, nextFailState);
        }
        if (!(prevState == null || nextState == null || prevState.getKind() != AssertTMState.AssertStateKind.DELAY && prevState.getKind() != AssertTMState.AssertStateKind.DELAY_RANGE || nextState.getKind() != AssertTMState.AssertStateKind.DELAY && nextState.getKind() != AssertTMState.AssertStateKind.DELAY_RANGE)) {
            return this.collapseDelayStates((AssertTMState.AssertTMStateDelay)prevState, (AssertTMState.AssertTMStateDelay)nextState, assertTM);
        }
        transition.addNextState(nextState);
        return nextState;
    }

    private IAssertTMState collapseDelayStates(AssertTMState.AssertTMStateDelay firstState, AssertTMState.AssertTMStateDelay secondState, AssertTM assertTM) {
        AssertTMAbstractTransition transition;
        IAssertTMState prevState = firstState.getPrevState();
        IAssertTMState newState = null;
        if (firstState.getKind() == AssertTMState.AssertStateKind.DELAY && secondState.getKind() == AssertTMState.AssertStateKind.DELAY) {
            int totalDelay = firstState.getCycleCount() + secondState.getCycleCount();
            HidImplicit delayImplicit = this.hidBuilders.buildImplicit(String.valueOf(totalDelay), -1);
            HidOperator cycleDelayConstOperator = this.hidBuilders.buildCycleDelayConstOperator(delayImplicit, Collections.emptyList(), IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, HidOperatorOccurrence.DUMMY_OCCURRENCE);
            newState = this.createState(cycleDelayConstOperator, prevState, assertTM);
        }
        if (firstState.getKind() == AssertTMState.AssertStateKind.DELAY_RANGE && secondState.getKind() == AssertTMState.AssertStateKind.DELAY) {
            AssertTMState.AssertTMStateDelay aux = firstState;
            firstState = secondState;
            secondState = aux;
        }
        if (firstState.getKind() == AssertTMState.AssertStateKind.DELAY && secondState.getKind() == AssertTMState.AssertStateKind.DELAY_RANGE) {
            int delay = firstState.getCycleCount();
            int startCycleCount = delay + secondState.getCycleCount();
            String endCycleCountStr = AssertTMState.combineEndCount(firstState, secondState);
            HidImplicit startCycleDelayImplicit = this.hidBuilders.buildImplicit(String.valueOf(startCycleCount), -1);
            HidImplicit endCycleDelayImplicit = this.hidBuilders.buildImplicit(endCycleCountStr, -1);
            HidOperator cycleDelayRangeOperator = this.hidBuilders.buildCycleDelayRangeOperator(startCycleDelayImplicit, Arrays.asList(endCycleDelayImplicit), IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, HidOperatorOccurrence.DUMMY_OCCURRENCE);
            newState = this.createState(cycleDelayRangeOperator, prevState, assertTM);
        }
        if (firstState.getKind() == AssertTMState.AssertStateKind.DELAY_RANGE && secondState.getKind() == AssertTMState.AssertStateKind.DELAY_RANGE) {
            int startCycleCount = firstState.getCycleCount() + secondState.getCycleCount();
            String endCycleCountStr = AssertTMState.combineEndCount(firstState, secondState);
            HidImplicit startCycleDelayImplicit = this.hidBuilders.buildImplicit(String.valueOf(startCycleCount), -1);
            HidImplicit endCycleDelayImplicit = this.hidBuilders.buildImplicit(endCycleCountStr, -1);
            HidOperator cycleDelayRangeOperator = this.hidBuilders.buildCycleDelayRangeOperator(startCycleDelayImplicit, Arrays.asList(endCycleDelayImplicit), IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, HidOperatorOccurrence.DUMMY_OCCURRENCE);
            newState = this.createState(cycleDelayRangeOperator, prevState, assertTM);
        }
        if ((transition = this.transitionTable.remove(firstState)) == null) {
            throw new IllegalStateException(DVTStringUtil.appendString("Unable to collapse delays states when converting '", this.assertElement, "'"));
        }
        transition.addNextState(newState);
        this.transitionTable.put(prevState, transition);
        this.states.remove(firstState);
        this.states.remove(secondState);
        return newState;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IAssertTMState createState(IHidObject object, IAssertTMState prevState, AssertTM assertTM) {
        void var4_9;
        if (HidUtils.isOperator(object) && ((IHidOperator)object).isCycleDelayConst()) {
            AssertTMState assertTMState = AssertTMState.createConstDelay((IHidOperator)object, this.lastClockingEvent, prevState, assertTM);
        } else if (HidUtils.isOperator(object) && ((IHidOperator)object).isCycleDelayRange()) {
            AssertTMState assertTMState = AssertTMState.createRangeDelay((IHidOperator)object, this.lastClockingEvent, prevState, assertTM);
        } else if (HidUtils.isOperator(object) && ((IHidOperator)object).isSequenceRepetition()) {
            IHidObject lhValue = ((IHidOperator)object).getLHValue();
            if (HidUtils.isHidImplicit(lhValue)) {
                IAssertTMState iAssertTMState = AssertTMState.createConstAbbrev((IHidOperator)object, this.lastClockingEvent, prevState, assertTM);
            } else {
                if (!HidUtils.isOperator(lhValue)) throw new UnknownHidObjectEvaluationException(object);
                IAssertTMState iAssertTMState = AssertTMState.createRangeAbbrev((IHidOperator)object, this.lastClockingEvent, prevState, assertTM);
            }
        } else {
            AssertTMState assertTMState = AssertTMState.createAtom(object, prevState, assertTM);
        }
        this.states.add((IAssertTMState)var4_9);
        return var4_9;
    }

    public AssertTMAbstractTransition createTransition(IHidOperator operator, IAssertTMState prevState, AssertTMState nextFailState) {
        AssertTMAbstractTransition transition = operator != null && operator.isAssertBinary() ? new AssertTMBinaryTransition(operator, prevState, nextFailState) : (operator != null && operator.isNotOperator() ? new AssertTMOppositeTransition(operator, prevState, nextFailState) : new AssertTMTransition(operator, prevState, nextFailState));
        this.transitionTable.put(prevState, transition);
        return transition;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        HashSet<IAssertTMState> visitedStates = new HashSet<IAssertTMState>();
        ArrayDeque<IAssertTMState> queue = new ArrayDeque<IAssertTMState>();
        queue.add(this.getHead());
        while (!queue.isEmpty()) {
            IAssertTMState currentState = (IAssertTMState)queue.pop();
            AssertTMAbstractTransition transition = this.transitionTable.get(currentState);
            if (transition == null) continue;
            String transitionText = transition.getOperatorText();
            for (IAssertTMState aState : transition.getNextStates()) {
                sb.append(indent).append(currentState).append(transitionText).append(aState).append(System.lineSeparator());
                if (aState == null || visitedStates.contains(aState)) continue;
                visitedStates.add(aState);
                queue.addLast(aState);
            }
        }
        return sb.toString();
    }

    public IHidOperator getClockingEvent() {
        return this.clockingEvent;
    }

    public void handleClockingEvent(IHidOperator clockingEvent) {
        if (this.clockingEvent == null) {
            this.clockingEvent = clockingEvent;
        }
        this.lastClockingEvent = clockingEvent;
    }

    public AssertTMCursor spawnCursor(XThread xThread, AssertTMCursor parentCursor, BigDecimal simTime, AssertTMCursor.AssertTMCursorKind kind) {
        AssertTMCursor cursor = null;
        if (kind == AssertTMCursor.AssertTMCursorKind.NOT) {
            cursor = new AssertTMCursorNot(this, parentCursor, xThread, parentCursor.getStartSimTime(), kind);
        } else if (kind == AssertTMCursor.AssertTMCursorKind.OR || kind == AssertTMCursor.AssertTMCursorKind.AND) {
            cursor = new AssertTMCursorBinary(this, parentCursor, xThread, parentCursor.getStartSimTime(), kind);
        } else {
            if (kind == AssertTMCursor.AssertTMCursorKind.INTERSECT) {
                throw new UnsupportedOperationException("Unsupported concurrent assertion operator intersect");
            }
            cursor = new AssertTMCursor(this, parentCursor, xThread, this.isAlwaysBlockScoped ? null : simTime, kind);
        }
        if (parentCursor != null) {
            if (parentCursor.kind == AssertTMCursor.AssertTMCursorKind.NOT && !parentCursor.childrenCursors.isEmpty()) {
                throw new UnsupportedOperationException("Not cursor should have only one child cursor");
            }
            if (parentCursor instanceof AssertTMCursorBinary && parentCursor.childrenCursors.size() >= 2) {
                throw new UnsupportedOperationException("Binary cursor should have exactly two children cursors");
            }
            parentCursor.childrenCursors.add(cursor);
        }
        this.cursors.add(this.isAlwaysBlockScoped || parentCursor != null ? cursor : cursor.nextState());
        return cursor;
    }

    public void removeCursor(AssertTMCursor cursor) {
        cursor.removeChildren();
        this.cursors.remove(cursor);
    }

    public void evaluateDisableIffExpression(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        if (this.disableIffCondition == null) {
            return;
        }
        if (!(evaluator instanceof XValueHolder)) {
            return;
        }
        boolean prevEvalAssert = guardian.setEvalAssert(this.isAlwaysBlockScoped);
        try {
            boolean isDisabledIff;
            ELParamValueScope valueScope = ELUtils.evaluate(this.disableIffCondition, evaluator, BitVectorContext.of(BitVectorContext.NO_CONTEXT, null), guardian);
            if (ELUtils.isUnsuccessfulEval(valueScope)) {
                throw new XStopThreadException();
            }
            IELParamValue value = XUtils.getValue(valueScope);
            DVTNumber dvtNumber = value.getDVTNumber();
            if (dvtNumber == null || dvtNumber == DVTNumber.UNDEFINED) {
                throw new XStopThreadException();
            }
            if (dvtNumber.hasMask(MaskType.X, MaskType.Z)) {
                return;
            }
            boolean bl = isDisabledIff = !ELUtils.isFalse(value);
            if (isDisabledIff) {
                guardian.getFactory().registerAssertResult(((XValueHolder)evaluator).getInstanceScope().getInstancePath(), this.assertElement, AssertResult.DISABLED);
                if (guardian.isAddExtraDebugInfo()) {
                    XGlobalCache.TimeScale timeScale = XUtils.getTimeScale((XValueHolder)evaluator);
                    BigDecimal currentSimTime = guardian.getFactory().getCurrentSimTime();
                    BigInteger simTimeInteger = currentSimTime == null ? BigInteger.ZERO : currentSimTime.divide(timeScale.unit).setScale(0, RoundingMode.HALF_UP).toBigInteger();
                    String precisionText = XUtils.reverseTimeUnitExponent(timeScale.getPrecision(), false);
                    guardian.logWarning("Assertion disabled '" + this.assertElement + "' at " + simTimeInteger + precisionText);
                }
                throw new XStopThreadException();
            }
        }
        finally {
            guardian.setEvalAssert(prevEvalAssert);
        }
    }

    public void setHids(Set<IHid> hids) {
        this.hids = hids;
    }

    public String printState() {
        if (this.clockingEvent == null || this.transitionTable.isEmpty() || this.cursors.isEmpty()) {
            return "";
        }
        IdentityHashMap<IAssertTMState, List<AssertTMCursor>> statesCursors = new IdentityHashMap<IAssertTMState, List<AssertTMCursor>>();
        for (AssertTMCursor cursor : this.cursors) {
            IAssertTMState state = cursor.getCurrentState();
            ArrayList<AssertTMCursor> cursors = (ArrayList<AssertTMCursor>)statesCursors.get(state);
            if (cursors == null) {
                cursors = new ArrayList<AssertTMCursor>();
                statesCursors.put(state, cursors);
            }
            cursors.add(cursor);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(DVTStringUtil.appendString("*** Warning: Concurrent Assert State: '", this.assertElement.getName(), System.lineSeparator()));
        HashSet<IAssertTMState> visitedStates = new HashSet<IAssertTMState>();
        ArrayDeque<IAssertTMState> queue = new ArrayDeque<IAssertTMState>();
        queue.add(this.getHead());
        while (!queue.isEmpty()) {
            IAssertTMState currentState = (IAssertTMState)queue.pop();
            AssertTMAbstractTransition transition = this.transitionTable.get(currentState);
            if (transition == null) continue;
            String transitionText = transition.getOperatorText();
            for (IAssertTMState aState : transition.getNextStates()) {
                sb.append("    ").append(currentState);
                sb.append(AssertTM.getCursorsState(statesCursors, currentState));
                sb.append(transitionText).append(aState);
                sb.append(System.lineSeparator());
                if (aState == null || visitedStates.contains(aState)) continue;
                visitedStates.add(aState);
                queue.addLast(aState);
            }
        }
        IRfDefElement declaration = this.assertElement.getDeclaration();
        if (declaration != null) {
            int lineNumber = declaration.getStartLine();
            ParserPath path = declaration.getParserPath();
            sb.append(DVTStringUtil.appendString("    ", "at line ", lineNumber, " in ", path, System.lineSeparator()));
        }
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append("Cursors hierarchy:").append(System.lineSeparator());
        for (AssertTMCursor cursor : this.cursors) {
            if (cursor.parentCursor != null) continue;
            sb.append(cursor.getCursorHierarchy(0)).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static String getCursorsState(Map<IAssertTMState, List<AssertTMCursor>> cursorsStates, IAssertTMState state) {
        List<AssertTMCursor> cursors = cursorsStates.get(state);
        if (cursors == null || cursors.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int idx = 0;
        while (idx < cursors.size()) {
            AssertTMCursor assertTMCursor = cursors.get(idx);
            sb.append("C(").append(assertTMCursor.getStartSimTime()).append(")");
            if (idx != cursors.size() - 1) {
                sb.append(" ; ");
            }
            ++idx;
        }
        sb.append("}");
        return sb.toString();
    }

    public void setAlwaysBlockScoped(boolean isAlwaysBlockScoped) {
        this.isAlwaysBlockScoped = isAlwaysBlockScoped;
    }

    public IRfAssertExpectElement getAssertElement() {
        return this.assertElement;
    }

    public boolean isAlwaysBlockScoped() {
        return this.isAlwaysBlockScoped;
    }

    public AssertTMState getHead() {
        return this.head;
    }

    public AssertTMState getFailure() {
        return this.failure;
    }

    public AssertTMState getSuccess() {
        return this.success;
    }

    public static enum AssertResult {
        DISABLED,
        FINISH,
        FAILED,
        ERROR;

    }

    public static class AssertResultHolder {
        public int disabledCount;
        public int finishedCount;
        public int failedCount;
        public int errorCount;
    }

    public static class AssertTMCursor {
        protected final int uniqueId;
        protected final AssertTMCursor parentCursor;
        protected AtomicBoolean childResult;
        protected final List<AssertTMCursor> childrenCursors;
        private BigDecimal startSimTime;
        protected final AssertTMCursorKind kind;
        private final AssertTM assertTM;
        protected final XThread xThread;
        private IAssertTMState previousState;
        private IAssertTMState currentState;
        private int delayCounter;
        private int abbrevDelayCounter;
        private AtomicBoolean abbrevRangeResult;
        private int flags;

        protected AssertTMCursor(AssertTM assertTM, AssertTMCursor parentCursor, XThread xThread, BigDecimal startSimTime, AssertTMCursorKind kind) {
            this.uniqueId = assertTM.getCursorUniqueId();
            this.kind = kind;
            this.parentCursor = parentCursor;
            this.assertTM = assertTM;
            this.xThread = xThread;
            this.startSimTime = startSimTime;
            this.currentState = parentCursor != null ? parentCursor.getCurrentState() : assertTM.getHead();
            this.childrenCursors = new ArrayList<AssertTMCursor>();
        }

        public IAssertTMState getCurrentState() {
            return this.currentState;
        }

        public BigDecimal getStartSimTime() {
            return this.startSimTime;
        }

        public AssertTMCursor getParentCursor() {
            return this.parentCursor;
        }

        public AssertTMCursor nextState() {
            AssertTMAbstractTransition transition;
            int cycleCount;
            if (this.hasFlag(8)) {
                this.removeFlag(8);
                return this;
            }
            AssertTMAbstractTransition nextTransition = this.assertTM.transitionTable.get(this.currentState);
            if (nextTransition == null) {
                return this;
            }
            if (this.currentState.getKind() == AssertTMState.AssertStateKind.DELAY) {
                if (this.delayCounter < ((AssertTMState.AssertTMStateDelay)this.currentState).getCycleCount()) {
                    return this;
                }
                this.delayCounter = 0;
            }
            if (this.currentState.getKind() == AssertTMState.AssertStateKind.DELAY_RANGE) {
                if (this.delayCounter < ((AssertTMState.AssertTMStateRangeDelay)this.currentState).getCycleCount()) {
                    return this;
                }
                if (this.hasFlag(2) && ((AssertTMState.AssertTMStateRangeDelay)this.currentState).isDelayBelowLimit(this.delayCounter)) {
                    this.removeFlag(2);
                    return this;
                }
            }
            if (this.previousState != null && this.previousState.getKind() == AssertTMState.AssertStateKind.DELAY_RANGE && this.currentState.getKind() != AssertTMState.AssertStateKind.DELAY_RANGE) {
                this.delayCounter = 0;
            }
            this.previousState = this.currentState;
            if (this.previousState != null && this.previousState.getKind() == AssertTMState.AssertStateKind.ABBREV) {
                AssertTMState.AssertTMAbbrevDelay abbrevDelayState = (AssertTMState.AssertTMAbbrevDelay)this.previousState;
                cycleCount = abbrevDelayState.getCycleCount();
                if (this.abbrevDelayCounter < cycleCount) {
                    this.currentState = abbrevDelayState.getOriginState();
                    return this;
                }
                this.abbrevDelayCounter = 0;
            }
            if (this.previousState != null && this.previousState.getKind() == AssertTMState.AssertStateKind.ABBREV_RANGE) {
                boolean isAbbrevPass;
                AssertTMState.AssertTMAbbrevRangeDelay abbrevRangeDelay = (AssertTMState.AssertTMAbbrevRangeDelay)this.previousState;
                cycleCount = abbrevRangeDelay.getCycleCount();
                if (this.abbrevDelayCounter < cycleCount) {
                    this.setFlag(16);
                    this.currentState = abbrevRangeDelay.getOriginState();
                    return this;
                }
                boolean bl = isAbbrevPass = this.abbrevRangeResult != null && this.abbrevRangeResult.get();
                if (!isAbbrevPass && abbrevRangeDelay.isDelayBelowLimit(this.abbrevDelayCounter)) {
                    this.removeFlag(16);
                    this.currentState = abbrevRangeDelay.getOriginState();
                    return this;
                }
                this.abbrevDelayCounter = 0;
                this.abbrevRangeResult = null;
            }
            if (this.parentCursor != null) {
                if (nextTransition instanceof AssertTMOppositeTransition) {
                    this.currentState = ((AssertTMOppositeTransition)nextTransition).getBranchState();
                    return this;
                }
                if (nextTransition instanceof AssertTMBinaryTransition) {
                    int idx = this.parentCursor.childrenCursors.indexOf(this);
                    AssertTMBinaryTransition binaryTransition = (AssertTMBinaryTransition)nextTransition;
                    if (idx == 0) {
                        this.currentState = binaryTransition.getLeftState();
                    } else if (idx == 1) {
                        this.currentState = binaryTransition.getRightState();
                    } else {
                        this.xThread.localTerminate(true);
                        throw new XStopThreadException();
                    }
                    return this;
                }
            }
            this.currentState = nextTransition.getNextState();
            if (this.currentState.getKind() == AssertTMState.AssertStateKind.ABBREV && this.abbrevDelayCounter + 1 >= ((AssertTMState.AssertTMAbbrevDelay)this.currentState).getCycleCount()) {
                this.abbrevDelayCounter = 0;
                transition = this.assertTM.transitionTable.get(this.currentState);
                this.currentState = transition.getNextState();
            }
            if (this.currentState.getKind() == AssertTMState.AssertStateKind.ABBREV_RANGE && (((AssertTMState.AssertTMAbbrevRangeDelay)this.currentState).isDelayAboveLimit(this.abbrevDelayCounter + 1) || this.abbrevRangeResult != null && this.abbrevRangeResult.get())) {
                this.abbrevDelayCounter = 0;
                this.abbrevRangeResult = null;
                this.removeFlag(16);
                transition = this.assertTM.transitionTable.get(this.currentState);
                this.currentState = transition.getNextState();
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public AssertTMCursor moveToJoinState() {
            void binaryTransition;
            void var3_2;
            AssertTMBinaryTransition assertTMBinaryTransition;
            AssertTMAbstractTransition nextTransition = this.assertTM.transitionTable.get(this.currentState);
            AssertTMAbstractTransition assertTMAbstractTransition = nextTransition;
            if (!(assertTMAbstractTransition instanceof AssertTMBinaryTransition) || (assertTMBinaryTransition = (AssertTMBinaryTransition)assertTMAbstractTransition) != (AssertTMBinaryTransition)var3_2) {
                throw new IllegalStateException("Next state transition is not binary");
            }
            this.currentState = binaryTransition.getNextState();
            return this;
        }

        public AssertTMCursor prevState() {
            if (this.previousState == null || this.previousState.getKind() != AssertTMState.AssertStateKind.DELAY_RANGE) {
                return null;
            }
            AssertTMState.AssertTMStateRangeDelay delayRange = (AssertTMState.AssertTMStateRangeDelay)this.previousState;
            if (delayRange.isDelayAboveLimit(this.delayCounter)) {
                return null;
            }
            this.currentState = this.previousState;
            this.setFlag(2);
            return this;
        }

        public void incrementDelayCounter() {
            if (this.currentState.getKind() == AssertTMState.AssertStateKind.ABBREV || this.currentState.getKind() == AssertTMState.AssertStateKind.ABBREV_RANGE) {
                ++this.abbrevDelayCounter;
            } else {
                ++this.delayCounter;
            }
        }

        public int getDelayCounter() {
            return this.delayCounter;
        }

        public int getAbbrevDelayCounter() {
            return this.abbrevDelayCounter;
        }

        public void resetDelayCounter() {
            this.delayCounter = 0;
        }

        public void resetAbbrevDelayCoounter() {
            this.abbrevDelayCounter = 0;
        }

        public void setFlag(int option) {
            this.flags = AssertTMCursorOptions.set(this.flags, option);
        }

        public void removeFlag(int option) {
            this.flags = AssertTMCursorOptions.remove(this.flags, option);
        }

        public boolean hasFlag(int option) {
            return AssertTMCursorOptions.contains(this.flags, option);
        }

        public void setStartSimTime(BigDecimal currentSimTime) {
            this.startSimTime = currentSimTime;
        }

        public XThread getXThread() {
            return this.xThread;
        }

        public void consume(boolean result, IHidEvaluationGuardian guardian) {
        }

        public AtomicBoolean getChildResult() {
            return this.childResult;
        }

        public void resetChildResult() {
            this.childResult = null;
        }

        public List<AssertTMCursor> getChildrenCursors() {
            return this.childrenCursors;
        }

        public void removeChildren() {
            if (this.childrenCursors == null || this.childrenCursors.isEmpty()) {
                return;
            }
            for (AssertTMCursor childCursor : this.childrenCursors) {
                this.assertTM.removeCursor(childCursor);
            }
            this.childrenCursors.clear();
        }

        public AssertTM getAssertTM() {
            return this.assertTM;
        }

        public int getUniqueId() {
            return this.uniqueId;
        }

        public void activateAbbrev() {
            this.abbrevRangeResult = new AtomicBoolean(true);
        }

        public void storeAbbrevResult(boolean isFalse) {
            if (this.abbrevRangeResult == null) {
                return;
            }
            this.abbrevRangeResult.set(this.abbrevRangeResult.get() && !isFalse);
        }

        public String toString() {
            return "C(" + (Object)((Object)this.kind) + ")@" + this.uniqueId;
        }

        public String getCursorHierarchy(int indent) {
            AssertTMCursor assertTMCursor = this;
            if (assertTMCursor instanceof AssertTMCursorNot && (var2_3 = (AssertTMCursorNot)assertTMCursor) == (AssertTMCursorNot)var3_2) {
                List<AssertTMCursor> childrenCursor = notCursor.getChildrenCursors();
                if (this.childrenCursors == null || this.childrenCursors.isEmpty()) {
                    return DVTStringUtil.appendString("\t".repeat(indent), this.toString(), System.lineSeparator());
                }
                return childrenCursor.get(0).getCursorHierarchy(indent + 1);
            }
            if (this instanceof AssertTMCursorBinary childrenCursor) {
                List<AssertTMCursor> childrenCursors = binaryCursor.getChildrenCursors();
                if (childrenCursors == null || childrenCursors.isEmpty()) {
                    return DVTStringUtil.appendString("\t".repeat(indent), this.toString(), System.lineSeparator());
                }
                StringBuilder sb = new StringBuilder();
                for (AssertTMCursor assertTMCursor2 : childrenCursors) {
                    sb.append(assertTMCursor2.getCursorHierarchy(indent + 1));
                }
                return DVTStringUtil.appendString("\t".repeat(indent), this.toString(), System.lineSeparator(), sb.toString());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("\t".repeat(indent)).append(this.toString()).append(System.lineSeparator());
            if (this.childrenCursors != null && !this.childrenCursors.isEmpty()) {
                for (AssertTMCursor assertTMCursor3 : this.childrenCursors) {
                    sb.append(assertTMCursor3.getCursorHierarchy(indent + 1));
                }
            }
            return sb.toString();
        }

        public static enum AssertTMCursorKind {
            AND,
            OR,
            INTERSECT,
            NOT,
            NONE;

        }
    }

    public static class AssertTMCursorBinary
    extends AssertTMCursor {
        private AtomicBoolean result;
        private BigDecimal endTime;

        protected AssertTMCursorBinary(AssertTM assertTM, AssertTMCursor parentCursor, XThread xThread, BigDecimal startSimTime, AssertTMCursor.AssertTMCursorKind kind) {
            super(assertTM, parentCursor, xThread, startSimTime, kind);
        }

        @Override
        public void consume(boolean result, IHidEvaluationGuardian guardian) {
            this.result = new AtomicBoolean(result);
            this.endTime = guardian.getFactory().getCurrentSimTime();
            try {
                guardian.callbackKill(this.xThread.getId());
            }
            finally {
                guardian.callbackResumeThread(this.parentCursor.xThread);
            }
        }

        public AtomicBoolean getResult() {
            return this.result;
        }

        public BigDecimal getEndTime() {
            return this.endTime;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "/" + (this.result == null ? "<unknown>" : this.result);
        }
    }

    public static class AssertTMCursorNot
    extends AssertTMCursor {
        protected AssertTMCursorNot(AssertTM assertTM, AssertTMCursor parentCursor, XThread xThread, BigDecimal startSimTime, AssertTMCursor.AssertTMCursorKind kind) {
            super(assertTM, parentCursor, xThread, startSimTime, kind);
        }

        @Override
        public void consume(boolean result, IHidEvaluationGuardian guardian) {
            this.parentCursor.childResult = new AtomicBoolean(result);
            try {
                guardian.callbackKill(this.xThread.getId());
            }
            finally {
                guardian.callbackResumeThread(this.parentCursor.xThread);
            }
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "/" + (this.parentCursor.childResult == null ? "<unknown>" : this.parentCursor.childResult);
        }
    }

    public static final class AssertTMCursorOptions {
        public static final int RESET_DELAY_RANGE = 2;
        public static final int ZERO_DELAY_COMPUTATION = 4;
        public static final int REEXECUTE_STATE = 8;
        public static final int NO_REPORT_FAILURE = 16;

        public static boolean contains(int flag, int option) {
            return (flag & option) != 0;
        }

        public static int set(int flag, int option) {
            return flag | option;
        }

        public static int remove(int flag, int option) {
            return flag & ~option;
        }
    }
}

