/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.assertion;

import java.util.Arrays;
import java.util.Collection;
import ro.amiq.dvt.model.reflection.assertion.AssertTMAbstractTransition;
import ro.amiq.dvt.model.reflection.assertion.IAssertTMState;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.DVTStringUtil;

public class AssertTMBinaryTransition
extends AssertTMAbstractTransition {
    private IAssertTMState leftState;
    private IAssertTMState rightState;
    private IAssertTMState joinState;

    public AssertTMBinaryTransition(IHidOperator operator, IAssertTMState previousState, IAssertTMState failState) {
        super(operator, previousState, failState);
    }

    @Override
    public void addNextState(IAssertTMState nextState) {
        if (this.leftState == null) {
            this.leftState = nextState;
            return;
        }
        if (this.rightState == null) {
            this.rightState = nextState;
            return;
        }
        throw new IllegalStateException(DVTStringUtil.appendString("Fail to add next state ", nextState.toString(), " in binary transition '", HidUtils.toNiceString(this.operator), "'"));
    }

    @Override
    public Collection<IAssertTMState> getNextStates() {
        return Arrays.asList(this.leftState, this.rightState, this.joinState, this.failState);
    }

    @Override
    public IAssertTMState getNextState() {
        return this.joinState;
    }

    public void setJoinState(IAssertTMState joinState) {
        this.joinState = joinState;
    }

    public IAssertTMState getLeftState() {
        return this.leftState;
    }

    public IAssertTMState getRightState() {
        return this.rightState;
    }
}

