/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.assertion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.assertion.IAssertTMState;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.XGlobalCache;

public class AssertTMState
implements IAssertTMState {
    protected final AssertStateKind kind;
    private final AssertTM assertTM;
    private final int uniqueId;
    private final IHidObject object;
    private final IAssertTMState prevState;
    private String additionalText = "";

    public static String combineEndCount(AssertTMStateDelay firstState, AssertTMStateDelay secondState) {
        int delay2;
        boolean isAtLeastOneRange;
        boolean bl = isAtLeastOneRange = firstState.getKind() == AssertStateKind.DELAY_RANGE || secondState.getKind() == AssertStateKind.DELAY_RANGE;
        if (!isAtLeastOneRange) {
            throw new UnsupportedOperationException();
        }
        int delay1 = firstState.getKind() == AssertStateKind.DELAY_RANGE ? ((AssertTMStateRangeDelay)firstState).endCycleCount : firstState.getCycleCount();
        int n = delay2 = secondState.getKind() == AssertStateKind.DELAY_RANGE ? ((AssertTMStateRangeDelay)secondState).endCycleCount : secondState.getCycleCount();
        if (delay1 == -1 || delay2 == -1) {
            return "$";
        }
        return String.valueOf(delay1 + delay2);
    }

    public static int computeDelayConst(IHidObject value) {
        if (!HidUtils.isHidImplicit(value)) {
            throw new UnsupportedOperationException("Fail to compute const value of '" + HidUtils.toNiceString(value) + "'");
        }
        String valueStr = ((IHidImplicit)value).getName();
        if ("$".equals(valueStr)) {
            return -1;
        }
        if ("*".equals(valueStr)) {
            return 0;
        }
        if ("+".equals(valueStr)) {
            return 1;
        }
        return Integer.valueOf(valueStr);
    }

    protected AssertTMState(AssertStateKind kind, IHidObject hidObject, IAssertTMState prevState, AssertTM assertTM) {
        this.kind = kind;
        this.object = hidObject;
        this.prevState = prevState;
        this.assertTM = assertTM;
        this.uniqueId = assertTM.getStateUniqueId();
    }

    public static AssertTMState createHead(AssertTM assertTM) {
        return new AssertTMState(AssertStateKind.HEAD, null, null, assertTM);
    }

    public static AssertTMState createSuccess(AssertTM assertTM) {
        return new AssertTMState(AssertStateKind.SUCCESS, null, null, assertTM);
    }

    protected static AssertTMStateExecute createExecuteState(AssertStateKind kind, AssertTM assertTM) {
        return new AssertTMStateExecute(kind, assertTM){

            @Override
            public IHidObject execute(IHidObject hidObject, IHidEvaluator evaluator, AssertTM.AssertTMCursor cursor, IHidEvaluationGuardian guardian) {
                if (!(hidObject instanceof HidEvalCenter.ConcurrentAssertStatement)) {
                    guardian.logError(DVTStringUtil.appendString("Fail to evaluate expression '", hidObject, "' in context '", evaluator, "' as concurrent assertion final state"));
                    return null;
                }
                HidEvalCenter.ConcurrentAssertStatement statement = (HidEvalCenter.ConcurrentAssertStatement)hidObject;
                IRfNamedElement namedElement = statement.getNamedElement();
                AssertTM assertTM = statement.getAssertTM();
                boolean isTrueBranch = this.kind == AssertStateKind.SUCCESS;
                XValueHolderFactory factory = guardian.getFactory();
                try {
                    factory.addEvent(XSimRegion.XRegionKind.ReActive, () -> {
                        if (guardian.isAddExtraDebugInfo() || !isTrueBranch) {
                            BigDecimal startSimTimeDecimal = cursor.getStartSimTime();
                            BigDecimal currentSimTimeDecimal = guardian.getFactory().getCurrentSimTime();
                            XGlobalCache.TimeScale timeScale = XUtils.getTimeScale((XValueHolder)evaluator);
                            BigInteger startSimTimeInteger = startSimTimeDecimal == null ? BigInteger.ZERO : startSimTimeDecimal.divide(timeScale.unit).setScale(0, RoundingMode.HALF_UP).toBigInteger();
                            BigInteger currentSimTimeInteger = currentSimTimeDecimal == null ? BigInteger.ZERO : currentSimTimeDecimal.divide(timeScale.unit).setScale(0, RoundingMode.HALF_UP).toBigInteger();
                            String precisionText = XUtils.reverseTimeUnitExponent(timeScale.getPrecision(), false);
                            String displayString = String.valueOf(namedElement.isAnonymous() ? "Assertion " + (isTrueBranch ? "passed " : "error ") : "Assertion '" + namedElement.getName() + "' " + (isTrueBranch ? "passed " : "error ")) + "started at " + startSimTimeInteger + precisionText + " failed at " + currentSimTimeInteger + precisionText;
                            if (isTrueBranch) {
                                guardian.logWarning(displayString, namedElement.getDeclaration());
                            } else {
                                IHidObject failureObject = cursor.getCurrentState().getHidObject();
                                String failingMessage = "";
                                if (failureObject != null && !HidUtils.isHidImplicit(failureObject)) {
                                    failingMessage = DVTStringUtil.appendString(" Failing '", HidUtils.toNiceString(failureObject), "'");
                                }
                                guardian.logError(DVTStringUtil.appendString(displayString, ".", failingMessage), namedElement.getDeclaration());
                            }
                        }
                        statement.evaluateBranch(evaluator, BitVectorContext.of(BitVectorContext.NO_CONTEXT, namedElement), guardian.copy(), isTrueBranch);
                    });
                }
                finally {
                    assertTM.removeCursor(cursor);
                    cursor.getXThread().localTerminate(false);
                }
                return null;
            }
        };
    }

    public static AssertTMState createAtom(IHidObject object, IAssertTMState prevState, AssertTM assertTM) {
        return new AssertTMState(AssertStateKind.ATOM, object, prevState, assertTM);
    }

    public static AssertTMState createConstDelay(IHidOperator operator, IHidOperator clockingEvent, IAssertTMState prevState, AssertTM assertTM) {
        if (clockingEvent == null) {
            return null;
        }
        return new AssertTMStateDelay(AssertStateKind.DELAY, operator, prevState, AssertTMState.computeDelayConst(operator.getLHValue()), clockingEvent, assertTM);
    }

    public static AssertTMState createRangeDelay(IHidOperator object, IHidOperator clockingEvent, IAssertTMState prevState, AssertTM assertTM) {
        if (clockingEvent == null) {
            return null;
        }
        return new AssertTMStateRangeDelay(object, clockingEvent, prevState, assertTM);
    }

    public static IAssertTMState createRangeAbbrev(IHidOperator operator, IHidOperator clockingEvent, IAssertTMState prevState, AssertTM assertTM) {
        if (clockingEvent == null) {
            return null;
        }
        return new AssertTMAbbrevRangeDelay(operator, clockingEvent, prevState, assertTM);
    }

    public static IAssertTMState createConstAbbrev(IHidOperator operator, IHidOperator clockingEvent, IAssertTMState prevState, AssertTM assertTM) {
        if (clockingEvent == null) {
            return null;
        }
        return new AssertTMAbbrevDelay(AssertStateKind.ABBREV, operator, prevState, AssertTMState.computeDelayConst(operator.getLHValue()), clockingEvent, assertTM);
    }

    @Override
    public IHidObject getHidObject() {
        return this.object;
    }

    @Override
    public AssertStateKind getKind() {
        return this.kind;
    }

    @Override
    public IAssertTMState getPrevState() {
        return this.prevState;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String name = HidUtils.isOperator(this.object) && (((IHidOperator)this.object).isAssertBinary() || ((IHidOperator)this.object).isAssertSequential()) ? ((IHidOperator)this.object).getOperatorText() : HidUtils.toNiceString(this.object);
        sb.append((Object)this.kind).append("(").append(String.valueOf(this.additionalText) + name).append(")").append("@").append(this.uniqueId);
        return sb.toString();
    }

    @Override
    public void setAdditionalText(String additionalText) {
        this.additionalText = additionalText;
    }

    public static enum AssertStateKind {
        HEAD,
        ATOM,
        SUCCESS,
        FAIL,
        DELAY,
        DELAY_RANGE,
        NOT,
        OR,
        AND,
        INTERSECT,
        ABBREV,
        ABBREV_RANGE;

    }

    public static class AssertTMAbbrevDelay
    extends AssertTMStateDelay {
        private final AssertAbbrevKind abbrevKind;
        private IAssertTMState originState;

        protected AssertTMAbbrevDelay(AssertStateKind kind, IHidOperator operator, IAssertTMState prevState, int cycleCount, IHidOperator clockingEvent, AssertTM assertTM) {
            super(kind, operator, prevState, cycleCount, clockingEvent, assertTM);
            this.abbrevKind = AssertTMAbbrevDelay.getAbbreKind(operator.getOperatorText());
        }

        private static final AssertAbbrevKind getAbbreKind(String operatorText) {
            if (operatorText == null) {
                throw new IllegalStateException("Null operator text when creating abbrev state");
            }
            if (operatorText.indexOf("*") >= 0) {
                return AssertAbbrevKind.CONSECUTIVE;
            }
            if (operatorText.indexOf("->") >= 0) {
                return AssertAbbrevKind.GOTO;
            }
            if (operatorText.indexOf("=") >= 0) {
                return AssertAbbrevKind.NONCONSECUTIVE;
            }
            throw new UnsupportedOperationException("Unknown operator text '" + operatorText + "' when creating abbrev state");
        }

        public final void setOriginState(IAssertTMState originState) {
            this.originState = originState;
        }

        public final IAssertTMState getOriginState() {
            return this.originState;
        }

        public static enum AssertAbbrevKind {
            CONSECUTIVE,
            GOTO,
            NONCONSECUTIVE;

        }
    }

    public static class AssertTMAbbrevRangeDelay
    extends AssertTMAbbrevDelay {
        private final int endCount;

        protected AssertTMAbbrevRangeDelay(IHidOperator operator, IHidOperator clockingEvent, IAssertTMState prevState, AssertTM assertTM) {
            super(AssertStateKind.ABBREV_RANGE, operator, prevState, AssertTMAbbrevRangeDelay.computeDelayConst(((IHidOperator)operator.getLHValue()).getLHValue()), clockingEvent, assertTM);
            this.endCount = AssertTMAbbrevRangeDelay.computeDelayConst(((IHidOperator)operator.getLHValue()).getFirstRHValue());
        }

        public boolean isDelayAboveLimit(int delay) {
            if (this.endCount == -1) {
                return false;
            }
            return delay >= this.endCount;
        }

        public boolean isDelayBelowLimit(int delay) {
            if (this.endCount == -1) {
                return false;
            }
            return delay < this.endCount;
        }
    }

    public static class AssertTMStateDelay
    extends AssertTMState {
        protected final IHidOperator clockingEvent;
        protected final int cycleCount;

        protected AssertTMStateDelay(AssertStateKind kind, IHidObject hidObject, IAssertTMState prevState, int cycleCount, IHidOperator clockingEvent, AssertTM assertTM) {
            super(kind, hidObject, prevState, assertTM);
            this.clockingEvent = clockingEvent;
            this.cycleCount = cycleCount;
        }

        public final boolean isNoDelay() {
            return this.cycleCount == 0;
        }

        @Override
        public final IHidObject getHidObject() {
            return this.clockingEvent;
        }

        public final int getCycleCount() {
            return this.cycleCount;
        }
    }

    public static abstract class AssertTMStateExecute
    extends AssertTMState {
        protected AssertTMStateExecute(AssertStateKind kind, AssertTM assertTM) {
            super(kind, null, null, assertTM);
        }

        public abstract IHidObject execute(IHidObject var1, IHidEvaluator var2, AssertTM.AssertTMCursor var3, IHidEvaluationGuardian var4);
    }

    public static class AssertTMStateRangeDelay
    extends AssertTMStateDelay {
        private final int endCycleCount;

        protected AssertTMStateRangeDelay(IHidOperator operator, IHidOperator clockingEvent, IAssertTMState prevState, AssertTM assertTM) {
            super(AssertStateKind.DELAY_RANGE, operator, prevState, AssertTMStateRangeDelay.computeDelayConst(((IHidOperator)operator.getLHValue()).getLHValue()), clockingEvent, assertTM);
            this.endCycleCount = AssertTMStateRangeDelay.computeDelayConst(((IHidOperator)operator.getLHValue()).getFirstRHValue());
        }

        public boolean isDelayBelowLimit(int delayCounter) {
            if (this.endCycleCount == -1) {
                return true;
            }
            return delayCounter <= this.endCycleCount;
        }

        public boolean isDelayAboveLimit(int delayCounter) {
            if (this.endCycleCount == -1) {
                return false;
            }
            return delayCounter >= this.endCycleCount;
        }

        public String combineEndCount(int delay) {
            if (this.endCycleCount == -1) {
                return "$";
            }
            return String.valueOf(delay + this.endCycleCount);
        }
    }
}

