/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.constraints.XCModel;
import ro.amiq.dvt.interpreter.constraints.XCValue;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.DataTypeChunk;
import ro.amiq.dvt.model.reflection.DummyField;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidNameAndSelects;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.SkippedHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMemberSelectable;
import ro.amiq.dvt.utils.OptimizedUtils;

public abstract class Hid
implements IHid,
Serializable {
    private static final long serialVersionUID = 11L;
    protected static final int default_VO = -1;
    protected static final IReparseInfo default_RI = null;
    public static final String UNRESOLVED_HID = "[Unresolved Hid]";
    protected final String name;
    protected ListContainer<HidAccess> accessesContainer;
    protected HidAccess parentAccess;
    protected IRfNamedElement secondaryScope;
    protected long qualifierSet;
    protected final int line;
    protected final int offset;
    protected transient IRfNamedElement element;
    private static final long SPLIT_QUALIFIERS = HidQualifierCache.POTENTIAL_METHOD_CALL_QUALIFIER | HidQualifierCache.TYPE_QUALIFIER | HidQualifierCache.NON_ANSI_PORT_REFERENCE | HidQualifierCache.POTENTIAL_COVERPOINT_QUALIFIER;
    private static final long UNIQUENESS_QUALIFIERS = HidQualifierCache.FORMAL_PART_QUALIFIER | HidQualifierCache.NON_ANSI_PORT_REFERENCE;
    public static final Hid EVALUATE_SKIP_HID = new Hid("[evaluate skip]", null, -1, -1, 0L){
        private static final long serialVersionUID = 1L;

        @Override
        public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        @Override
        public ELParamValueScope evaluateInterpreter(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            return null;
        }
    };

    protected Hid(String name, IRfNamedElement secondaryScope, int offset, int line, long qualifiers) {
        this.name = DVTStringUtil.intern(name);
        this.secondaryScope = secondaryScope;
        this.qualifierSet |= qualifiers;
        this.line = line;
        this.offset = offset;
    }

    public HidAccess getParentAccess() {
        return this.parentAccess;
    }

    public boolean hasUniqueQualifiers() {
        return this.hasOccurrence(UNIQUENESS_QUALIFIERS);
    }

    public int hashCode() {
        if (this.hasOccurrence(UNIQUENESS_QUALIFIERS)) {
            return System.identityHashCode(this);
        }
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.isEscaped() ? 1231 : 1237);
        result = 31 * result + (this.parentAccess == null ? 0 : this.parentAccess.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Hid)) {
            return false;
        }
        Hid other = (Hid)obj;
        if (this.hasOccurrence(UNIQUENESS_QUALIFIERS) || other.hasOccurrence(UNIQUENESS_QUALIFIERS)) {
            return false;
        }
        if ((this.qualifierSet & SPLIT_QUALIFIERS) != (other.qualifierSet & SPLIT_QUALIFIERS)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (AssociationUtils.isConnectedType(this) && this.offset != other.offset) {
            return false;
        }
        if (this.isEscaped() != other.isEscaped()) {
            return false;
        }
        return !(this.parentAccess == null ? other.parentAccess != null : !this.parentAccess.equals(other.parentAccess));
    }

    @Override
    public int getUsageIndex() {
        return -1;
    }

    @Override
    public int getInvocNumber() {
        return -1;
    }

    public void addQualifier(long qualifiers) {
        this.qualifierSet |= qualifiers;
    }

    public void removeQualifier(long qualifiers) {
        this.qualifierSet &= qualifiers ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public boolean hasQualifier(long qualifiers) {
        return (this.qualifierSet & qualifiers) != 0L;
    }

    public boolean hasSameQualifier(Hid other, long qualifiers) {
        return ((this.qualifierSet ^ other.qualifierSet ^ 0xFFFFFFFFFFFFFFFFL) & qualifiers) == qualifiers;
    }

    public long getQualifiers() {
        return this.qualifierSet;
    }

    public void setQualifiers(long qualifiers) {
        this.qualifierSet = qualifiers;
    }

    @Override
    public IRfNamedElement getElement() {
        return this.element;
    }

    @Override
    public IRfNamedElement xGetElement(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        if (this.element == null || this.hasQualifier(HidQualifierCache.INTR_RE_RESOLVE)) {
            this.evaluateInterpreter(evaluator, null, guardian.copy());
        }
        return this.element;
    }

    public void setElement(IRfNamedElement element) {
        this.element = element;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isEscaped() {
        return false;
    }

    public boolean isExternalName() {
        return false;
    }

    @Override
    public Hid getParentHid() {
        return this.parentAccess == null ? null : this.parentAccess.getParentHid();
    }

    public Hid getParentHidIgnoreAccess(int ignoreAccessKind) {
        return this.parentAccess == null || this.parentAccess.getAccessKind() == ignoreAccessKind ? null : this.parentAccess.getParentHid();
    }

    @NotNull
    public Hid getAncestorHid() {
        Hid parentHid = this;
        while (parentHid != null) {
            HidAccess currParentAccess;
            int accessKind;
            if (parentHid.getParentHid() == null) {
                return parentHid;
            }
            if (parentHid.getParentAccess() != null && ((accessKind = (currParentAccess = parentHid.getParentAccess()).getAccessKind()) == 3 || accessKind == 4)) {
                return parentHid;
            }
            parentHid = parentHid.getParentHid();
        }
        return parentHid;
    }

    public void removeAncestorHid() {
        Hid parentHid = this;
        Hid grandParentHid = parentHid.getParentHid();
        if (grandParentHid == null) {
            return;
        }
        Hid grandGrandParentHid = grandParentHid.getParentHid();
        while (grandGrandParentHid != null) {
            parentHid = grandParentHid;
            grandParentHid = grandGrandParentHid;
            grandGrandParentHid = grandGrandParentHid.getParentHid();
        }
        parentHid.parentAccess = null;
    }

    @Override
    public void markElaborated() {
        Hid parentHid = this;
        while (parentHid != null) {
            parentHid.addQualifier(HidQualifierCache.ELABORATED_HID_QUALIFIER);
            ListContainer<HidAccess> accesses = parentHid.getAccesses();
            if (accesses != null) {
                for (HidAccess hidAccess : accesses) {
                    List<? extends IHidObject> argumentValues;
                    List<IHidObject> selects = hidAccess.getSelects();
                    if (selects != null) {
                        for (IHidObject select : selects) {
                            if (select == null) continue;
                            select.markElaborated();
                        }
                    }
                    List<? extends IHidObject> list = argumentValues = hidAccess instanceof IHidAccessArgs ? ((IHidAccessArgs)((Object)hidAccess)).getArgumentValues() : null;
                    if (argumentValues == null) continue;
                    for (IHidObject iHidObject : argumentValues) {
                        if (iHidObject == null) continue;
                        iHidObject.markElaborated();
                    }
                }
            }
            parentHid = parentHid.getParentHid();
        }
    }

    public <T extends IRfNamedElement> T firstResolvedParent(Class<T> clazz) {
        Hid parentHid = this.getParentHid();
        while (parentHid != null) {
            if (clazz.isInstance(parentHid.getElement())) {
                return (T)parentHid.getElement();
            }
            parentHid = parentHid.getParentHid();
        }
        return null;
    }

    @Override
    @NotNull
    public ElementPath getHierarchicalPath() {
        ElementPath result = ElementPath.EMPTY_PATH;
        if (this.parentAccess == null || this.parentAccess.getParentHid() == null) {
            return result;
        }
        Hid parentHid = this.parentAccess.getParentHid();
        result = parentHid.getHierarchicalPath();
        result = ElementPath.join(result, parentHid.getName());
        return result;
    }

    public List<HidNameAndSelects> getHidAccessList(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        ArrayList<HidNameAndSelects> result = new ArrayList<HidNameAndSelects>();
        this.getHidAccessListArray(result, evaluator, guardian);
        return result;
    }

    private void getHidAccessListArray(List<HidNameAndSelects> result, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        if (result == null) {
            return;
        }
        if (this.parentAccess == null || this.parentAccess.getParentHid() == null) {
            result.add(new HidNameAndSelects(this.name, this.getAccesses(), evaluator, guardian));
            return;
        }
        Hid parentHid = this.parentAccess.getParentHid();
        parentHid.getHidAccessListArray(result, evaluator, guardian);
        result.add(new HidNameAndSelects(this.name, this.getAccesses(), evaluator, guardian));
    }

    public List<DataTypeChunk> getHidNameAsStringList() {
        ArrayList<DataTypeChunk> result = new ArrayList<DataTypeChunk>();
        this.getHierarchicalPathAsArray(result);
        result.add(new DataTypeChunk(this.name, this.line, this.offset));
        return result;
    }

    private void getHierarchicalPathAsArray(List<DataTypeChunk> result) {
        if (this.parentAccess == null || this.parentAccess.getParentHid() == null || result == null) {
            return;
        }
        Hid parentHid = this.parentAccess.getParentHid();
        parentHid.getHierarchicalPathAsArray(result);
        result.add(new DataTypeChunk(parentHid.getName(), parentHid.line, parentHid.offset));
    }

    public void addParentAccess(HidAccess access) {
        this.parentAccess = access;
    }

    @Override
    public boolean hasOccurrence(HidQualifier qualifier) {
        if (qualifier == null) {
            return this.qualifierSet == 0L;
        }
        return (this.qualifierSet & qualifier.value()) != 0L;
    }

    @Override
    public boolean hasOccurrence(long qualifiers) {
        return (this.qualifierSet & qualifiers) != 0L;
    }

    @Override
    public int getVirtualOffset() {
        return -1;
    }

    @Override
    public IReparseInfo getReparseInfo() {
        return default_RI;
    }

    @Override
    @NotNull
    public HidOccurrence getOccurrence() {
        return new HidOccurrence(this.offset, this.getVirtualOffset(), this.line, this.qualifierSet, this.getReparseInfo());
    }

    @Override
    public int xGetLine() {
        return this.line;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public HidOccurrence getOccurrence(long qualifier) {
        if (this.hasQualifier(qualifier)) {
            return this.getOccurrence();
        }
        return null;
    }

    public ListContainer<HidAccess> getAccesses() {
        return this.accessesContainer;
    }

    public HidAccess getFirstAccess() {
        if (!this.hasAccesses()) {
            return null;
        }
        if (this.accessesContainer instanceof List) {
            return (HidAccess)((List)((Object)this.accessesContainer)).get(0);
        }
        return this.accessesContainer.get(0);
    }

    @Override
    public void deepClean() {
        this.secondaryScope = null;
        this.element = null;
        this.parentAccess = null;
        if (this.accessesContainer == null) {
            return;
        }
        for (HidAccess access : this.accessesContainer) {
            access.deepClean();
        }
    }

    public Hid shallowCopy(boolean addResolved) {
        return null;
    }

    public Hid deepCopy() {
        return null;
    }

    public Hid upwardsCopy(boolean addResolved) {
        return null;
    }

    public boolean hasAccesses() {
        return this.accessesContainer != null && !this.accessesContainer.isEmpty();
    }

    public IRfNamedElement getSecondaryScope() {
        return this.secondaryScope;
    }

    public void setSecondaryScope(IRfNamedElement secondaryScope) {
        this.secondaryScope = secondaryScope;
    }

    public void removeAccess(HidAccess access) {
        if (this.accessesContainer == null) {
            return;
        }
        if (this.accessesContainer instanceof List) {
            Iterator iterator = ((List)((Object)this.accessesContainer)).iterator();
            while (iterator.hasNext()) {
                HidAccess existentAccess = (HidAccess)iterator.next();
                if (!existentAccess.equals(access)) continue;
                iterator.remove();
                break;
            }
            if (this.accessesContainer.isEmpty()) {
                this.accessesContainer = null;
            }
        } else if (this.accessesContainer.get(0).equals(access)) {
            this.accessesContainer = null;
        }
    }

    public HidAccess addAccess(HidAccess access) {
        if (access.getAccessKind() != Integer.MIN_VALUE) {
            this.removeQualifier(HidQualifierCache.LAST_QUALIFIER);
        }
        access.setParentHid(this);
        this.accessesContainer = OptimizedUtils.listContainerAdd(this.accessesContainer, access);
        return access;
    }

    protected boolean useExistingAccess(HidAccess access) {
        return !(access instanceof IHidAccessArgs);
    }

    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor visitor) {
        if (visitor.getType().isInstance(this) && !visitor.visit(this)) {
            return false;
        }
        if (this.accessesContainer == null) {
            return true;
        }
        for (HidAccess access : this.accessesContainer) {
            if (access.visitHidObject(rfProject, visitor)) continue;
            return false;
        }
        return true;
    }

    public IRfNamedElement getDesignSignal(DesignUtils.DesignRequest request, ELInstance closestAncestorInstance, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        ArrayDeque<IRfNamedElement> builderList = new ArrayDeque<IRfNamedElement>();
        return this.getHierarchicalElement(builderList, false);
    }

    public IRfNamedElement getHierarchicalElement(ArrayDeque<IRfNamedElement> builderList, boolean allowUnresolved) {
        IRfNamedElement segElement = this.getElement();
        if (!allowUnresolved && segElement == null) {
            return null;
        }
        if (segElement == null) {
            segElement = new HierarchicalElement.UnresolvedSegment(this);
        }
        if (!(segElement instanceof DummyField)) {
            builderList.addFirst(segElement);
            if (segElement instanceof IRfFieldElement var4_5) {
                fieldElement.setHidden(this.hasQualifier(HidQualifierCache.HIDDEN));
            }
        }
        if ((parent = this.getParentAccess()) == null) {
            return HierarchicalElement.of(builderList.toArray(new IRfNamedElement[0]));
        }
        return parent.getHierarchicalElement(builderList, allowUnresolved);
    }

    public HidAccess getFirstDotHidAccess() {
        HidAccess pAccess = this.getParentAccess();
        if (pAccess == null || pAccess.getAccessKind() != 0) {
            return null;
        }
        Hid phid = null;
        while ((phid = pAccess.getParentHid()) != null && phid.getParentAccess() != null && phid.getParentAccess().getAccessKind() == 0) {
            pAccess = phid.getParentAccess();
        }
        return pAccess;
    }

    public SelectKind hasSelect(StringBuilder rangeResult, String defaultRange) {
        if (defaultRange == null) {
            defaultRange = "";
        }
        rangeResult.append(defaultRange);
        if (this.accessesContainer == null || this.accessesContainer.isEmpty()) {
            return SelectKind.SELECT_NONE;
        }
        for (HidAccess access : this.accessesContainer) {
            if (access.getSelects() == null) continue;
            SelectKind rangeKind = SelectKind.SELECT_BIT;
            for (IHidObject select : access.getSelects()) {
                if (select instanceof HidOperator && ((HidOperator)select).isRangeOrPartSelect()) {
                    String selectText = select.toString();
                    selectText = selectText.length() > 2 && selectText.charAt(0) == '[' ? selectText.substring(1, selectText.length() - 1) : selectText;
                    rangeResult.replace(0, defaultRange.length(), selectText);
                    rangeKind = SelectKind.SELECT_RANGE;
                    continue;
                }
                rangeKind = SelectKind.SELECT_BIT;
            }
            return rangeKind;
        }
        return SelectKind.SELECT_NONE;
    }

    public Map<IRfNamedElement, List<? extends IRfFieldElement>> getMethodsWithArguments() {
        return null;
    }

    public String toString() {
        StringJoiner inner = new StringJoiner(", ");
        inner.add(Integer.toString(this.offset));
        return String.valueOf(this.name) + "@[" + inner.toString() + "]";
    }

    @Override
    public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
        if (guardian.shouldSkip(this)) {
            throw new SkippedHidObjectEvaluationException(this);
        }
        guardian.checkBuildCanceled();
        IHidEvaluator currentEvaluator = evaluator;
        if (currentEvaluator.isInterpreter()) {
            IRfNamedElement valueFormalType;
            if (this.parentAccess != null) {
                Hid parentHid = this.parentAccess.parentHid;
                if (!(this.parentAccess.accessKind == 2 && "local".equals(parentHid.getName()) || this.parentAccess.accessKind == 3 && this.hasQualifier(HidQualifierCache.SECONDARY_SCOPE_QUALIFIER))) {
                    currentEvaluator = XUtils.getValue(ELUtils.evaluate(this.parentAccess, currentEvaluator, null, guardian));
                    if (this.parentAccess.isMethodCall(false)) {
                        guardian.cacheMethodCall(this.parentAccess, ELParamValueScope.of((IELParamValue)currentEvaluator));
                    }
                }
            }
            currentEvaluator = this.resolveHidInterpreter(evaluator, currentEvaluator);
            if (this.element instanceof IRfMethodElement) {
                return this.evaluateFunctionCallForSize(this.element, currentEvaluator);
            }
            ELParamValueScope value = currentEvaluator.getValue(this, null, guardian);
            if (XUtils.getValue(value) instanceof XValueHolder && (valueFormalType = ((XValueHolder)XUtils.getValue(value)).getXNamedElement().getNamedElement()) instanceof IRfMethodElement) {
                return this.evaluateFunctionCallForSize(valueFormalType, currentEvaluator);
            }
            return value;
        }
        ELParamValueScope value = currentEvaluator.getValue(this, BitVectorContext.of(origin, true), guardian);
        if (this.element instanceof IRfMethodElement) {
            return this.evaluateFunctionCallForSize(this.element, currentEvaluator);
        }
        if (ELUtils.isUnsuccessfulEval(value) && this.parentAccess != null) {
            if (this.parentAccess.getAccessKind() == 5) {
                return ELUtils.evaluateForSize(this.parentAccess, currentEvaluator, origin, guardian);
            }
            if (this.parentAccess.getAccessKind() == 0 && !ELUtils.isVLOGConstant(this.element)) {
                if (this.parentAccess.getAssociatedType() instanceof IRfPackageElement) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                Hid ancestorHid = this.getAncestorHid();
                IRfNamedElement ancestorElement = ancestorHid.getElement();
                if (ancestorElement instanceof IRfDesignElement || ancestorElement instanceof IRfInstanceElement) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                IELParamValue parentAccessSize = XUtils.getValue(ELUtils.evaluateForSize(this.parentAccess, currentEvaluator, origin, guardian));
                if (ELUtils.isUnsuccessfulEval(parentAccessSize)) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                if (!(parentAccessSize.getDVTNumber() instanceof IDVTMemberSelectable)) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                DVTNumber memberSelect = ((IDVTMemberSelectable)((Object)parentAccessSize.getDVTNumber())).getMemberSelect(this, true);
                return DVTNumber.isUndefined(memberSelect) ? ELParamValueScope.UNDEFINED_VALUE : ELParamValueScope.of(ELParamValues.ParamValueNumber.of(memberSelect));
            }
        }
        return XUtils.getValue(value) != null ? ELParamValueScope.of(ELParamValues.ParamValueNumber.of(XUtils.getValue(value).getDVTNumber()), XUtils.getScope(value)) : ELParamValueScope.UNDEFINED_VALUE;
    }

    private ELParamValueScope evaluateFunctionCallForSize(IRfNamedElement functionCall, IHidEvaluator evaluator) {
        ELManager manager = evaluator instanceof ELParamValuesHidEvaluator ? ((ELParamValuesHidEvaluator)evaluator).getManager() : null;
        BitVectorContext returnContext = ((IRfMethodElement)functionCall).getDataTypeBitVectorContext(evaluator, false, this.getHierarchicalPath(), manager);
        return returnContext != null ? ELParamValueScope.of(ELParamValues.ParamValueNumber.of(returnContext.getContextNumber())) : ELParamValueScope.UNDEFINED_VALUE;
    }

    public IHidEvaluator resolveHidInterpreter(IHidEvaluator originalEvaluator, IHidEvaluator currentEvaluator) {
        IRfNamedElement namedElement = currentEvaluator.getNamedElement();
        if ((this.element == null || UNRESOLVED_HID.equals(this.element.getName()) || this.hasQualifier(HidQualifierCache.INTR_RE_RESOLVE)) && namedElement != null) {
            this.addQualifier(HidQualifierCache.INTR_RE_RESOLVE);
            IRfNamedElement newElement = namedElement.semanticGetMember(this.name, this, null, namedElement, null, true, true, false);
            if (newElement == null && this.getSecondaryScope() != null && (newElement = (namedElement = this.getSecondaryScope()).semanticGetMember(this.name, this, null, namedElement, null, true, true, false)) != null) {
                currentEvaluator = originalEvaluator;
            }
            if (newElement != null) {
                this.element = newElement;
            }
        }
        return currentEvaluator;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public XCValue collectConstraints(XCModel model, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        try {
            ELParamValueScope value = this.evaluateInterpreter(evaluator, context, guardian);
            if (value == null) {
                return null;
            }
            IRfNamedElement oldElement = this.element;
            try {
                IRfNamedElement iRfNamedElement = this.element = value.value instanceof XValueHolder ? value.value.getElement() : this.element;
                if (value.value instanceof XValueHolder && XValueHolderFactory.xIsClass(value.value.getNamedElement())) {
                    XCValue xCValue = model.createVariable(this.name, value, false, guardian);
                    return xCValue;
                }
                if (this.isRand(model, value, evaluator, context, guardian) || model.isRandListSizeVariable(this.name, value, this)) {
                    if (value.value instanceof ELParamValues.ParamValueNumber.PackedStructMember && ((ELParamValues.ParamValueNumber.PackedStructMember)value.value).getRawSelectProxy() != null) {
                        XCValue createSelectVariable;
                        IELParamValue valueBeforeSelect;
                        XSelectProxy rawSelectProxy = ((ELParamValues.ParamValueNumber.PackedStructMember)value.value).getRawSelectProxy();
                        IELParamValue parentValue = valueBeforeSelect = rawSelectProxy.getValueBeforeSelect();
                        XSelectProxy parentProxy = rawSelectProxy.getParentSelectProxy(valueBeforeSelect);
                        if (parentProxy != null) {
                            parentValue = XValueHolderFactory.createSelectProxyValue(valueBeforeSelect, parentProxy, false, true, LanguageKind.VLOG);
                        }
                        while (valueBeforeSelect.getElement() == null && valueBeforeSelect.getSelectProxy() != null && valueBeforeSelect instanceof XArrayValueHolder) {
                            valueBeforeSelect = ((XArrayValueHolder)valueBeforeSelect).getEnclosingValue();
                        }
                        String variableNameSuffix = XCModel.variableNameSuffix(valueBeforeSelect.getElement().getName(), rawSelectProxy);
                        XCValue xCValue = createSelectVariable = model.createSelectVariable(variableNameSuffix, ELParamValueScope.of(parentValue, value.scope), value, true, guardian);
                        return xCValue;
                    }
                    value.value = context != null ? context.transform(value.value) : value.value;
                    XCValue xCValue = model.createVariable(this.name, value, true, guardian);
                    return xCValue;
                }
            }
            finally {
                this.element = oldElement;
            }
            value.value = context != null ? context.transform(value.value) : value.value;
            return model.createConstant(value.value, guardian);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private boolean isRand(XCModel model, ELParamValueScope value, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (ELUtils.isUnsuccessfulEval(value)) {
            return false;
        }
        if (this.parentAccess == null) {
            return model.isRand(value.value);
        }
        IRfNamedElement associatedType = this.parentAccess.associatedType;
        if (associatedType instanceof IRfCompositeTypeElement && (((IRfCompositeTypeElement)associatedType).isStruct() || ((IRfCompositeTypeElement)associatedType).isUnion())) {
            if (((IRfCompositeTypeElement)associatedType).isPacked()) {
                Hid parentHid = this.parentAccess.getParentHid();
                value = parentHid.evaluateInterpreter(evaluator, context, guardian.copy());
                return parentHid.isRand(model, value, evaluator, context, guardian);
            }
            return model.isRandCandidate(this.getElement(), (XValueHolder)value.scope);
        }
        return model.isRand(value.value);
    }

    public ELParamValueScope evaluateInterpreter(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (guardian.shouldSkip(this)) {
            return null;
        }
        IHidEvaluator argumentsEvaluator = evaluator;
        IHidEvaluator currentEvaluator = evaluator;
        ELParamValueScope currentEvaluatorScope = null;
        if (this.parentAccess != null) {
            if (this.parentAccess.getAccessKind() == 5) {
                ELParamValueScope parentValue = ELUtils.evaluate(this.parentAccess, evaluator, BitVectorContext.of(context != null ? context.getOrigin() : null, false), guardian);
                return parentValue;
            }
            Hid parentHid = this.parentAccess.parentHid;
            if (!(this.parentAccess.accessKind == 2 && "local".equals(parentHid.getName()) || this.parentAccess.accessKind == 3 && this.hasQualifier(HidQualifierCache.SECONDARY_SCOPE_QUALIFIER) || (currentEvaluator = XUtils.getValue(currentEvaluatorScope = guardian.getMethodCallFromCache(this.parentAccess))) != null)) {
                boolean isFuncVarStaticAccess = parentHid.getElement() instanceof IRfMethodElement && this.element != null && this.element.isStorageStatic();
                try {
                    parentHid.addQualifier(isFuncVarStaticAccess ? HidQualifierCache.INTR_FUNC_VAR_STATIC_ACCESS : 0L);
                    currentEvaluatorScope = ELUtils.evaluate(this.parentAccess, evaluator, null, guardian);
                    currentEvaluator = XUtils.getValue(currentEvaluatorScope);
                }
                catch (Throwable throwable) {
                    parentHid.removeQualifier(isFuncVarStaticAccess ? HidQualifierCache.INTR_FUNC_VAR_STATIC_ACCESS : 0L);
                    throw throwable;
                }
                parentHid.removeQualifier(isFuncVarStaticAccess ? HidQualifierCache.INTR_FUNC_VAR_STATIC_ACCESS : 0L);
            }
        }
        currentEvaluator = this.resolveHidInterpreter(evaluator, currentEvaluator);
        ELParamValueScope value = null;
        if (evaluator.isInterpreter() && this.element instanceof IRfBlockElement && ((IRfBlockElement)this.element).isLoopGenerate()) {
            value = ELParamValueScope.of((IELParamValue)currentEvaluator);
        } else if (this.element instanceof IRfMethodElement && (!this.hasAccesses() || this.element.isPredefined() && this.element.getEnclosingScope() instanceof IRfEnumElement)) {
            value = this.internalEvaluateFunctionCall((IRfMethodElement)this.element, currentEvaluator, argumentsEvaluator, guardian);
        } else {
            if (this.parentAccess == null) {
                value = guardian.getMethodCallFromCache(this);
            }
            if (value == null) {
                IRfNamedElement valueFormalType;
                if (DVTRfUtils.isTypeElement(this.element) && !(this.element instanceof IRfDesignElement) && !(this.element instanceof IRfModportElement) && !this.hasQualifier(HidQualifierCache.TYPE_QUALIFIER)) {
                    this.addQualifier(HidQualifierCache.TYPE_QUALIFIER);
                }
                if (currentEvaluator.isBBox()) {
                    return ELParamValueScope.of((IELParamValue)currentEvaluator);
                }
                value = currentEvaluator.getValue(this, evaluator, context, false, guardian);
                if (value != null && currentEvaluatorScope != null && currentEvaluatorScope.scope instanceof XInstValueHolder.XClockingValueHolder) {
                    value.scope = currentEvaluatorScope.scope;
                } else if (value != null && value.value instanceof ELParamValues.ParamValueNumber.PackedStructMember && currentEvaluatorScope != null && currentEvaluatorScope.scope instanceof XValueHolder.XForIndexHolder) {
                    value.scope = currentEvaluatorScope.value.getValueBeforeSelect();
                } else if (value != null && value.value instanceof ELParamValues.ParamValueNumber.PackedStructMember && currentEvaluatorScope != null) {
                    value.scope = currentEvaluatorScope.scope;
                }
                if (guardian.isInterpreter() && !guardian.isDisableNullChecks() && this.parentAccess != null && value != null && !(value.value instanceof XMethodValueHolder) && currentEvaluator instanceof XValueHolder && ((XValueHolder)currentEvaluator).isNull() && ((XValueHolder)currentEvaluator).isClass() && value != null && value.scope instanceof XValueHolder && !((XValueHolder)value.scope).isStaticHolder()) {
                    HidUtils.performNullCheck(this, guardian);
                }
                if (XUtils.getValue(value) instanceof XValueHolder && !this.hasAccesses() && (valueFormalType = ((XValueHolder)XUtils.getValue(value)).getXNamedElement().getNamedElement()) instanceof IRfMethodElement) {
                    value = this.internalEvaluateFunctionCall((IRfMethodElement)valueFormalType, currentEvaluator, argumentsEvaluator, guardian);
                }
            }
            if (ELUtils.isUnsuccessfulEval(value)) {
                boolean isException;
                IHidEvaluator finalEvaluator = currentEvaluator;
                boolean bl = isException = finalEvaluator.isInterpreter() && (this.name.startsWith("struct/") || this.name.startsWith("union/") || this.name.startsWith("enum/") || this.name.equals("enum") || "event".equals(this.name) || this.name.indexOf(46) >= 0 || XUtils.getValue(value) instanceof IELParamValue.BBoxValue);
                if (!isException) {
                    guardian.logError(DVTStringUtil.appendString("Fail to evaluate '", this.name, "' in scope of '", XUtils.getEnclosingNamedScope(finalEvaluator), "' (id:0014)"));
                }
            }
        }
        if (guardian.isLinterStaticAnalysisMode() && value != null) {
            guardian.guardValueAccess(this.element, this, XUtils.getValue(value));
        }
        guardian.callbackValueAccessed(this.element);
        return value;
    }

    @Override
    public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (guardian.shouldSkip(this)) {
            throw new SkippedHidObjectEvaluationException(this);
        }
        guardian.checkBuildCanceled();
        guardian.incrementStepCount();
        guardian.markEvaluated(this);
        if (evaluator.isInterpreter()) {
            ELParamValueScope value = this.evaluateInterpreter(evaluator, context, guardian);
            if (value != null) {
                return context != null ? context.transform(value) : value;
            }
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        ELParamValueScope value = evaluator.getValue(this, context, guardian);
        if (this.element instanceof IRfMethodElement && !(XUtils.getValue(value) instanceof ELParamValues.ParamValueType)) {
            if (this.hasAccesses()) {
                for (HidAccess access : this.getAccesses()) {
                    List<? extends IHidObject> args;
                    List<? extends IHidObject> list = args = access instanceof IHidAccessArgs ? ((IHidAccessArgs)((Object)access)).getArgumentValues() : null;
                    if (args != IHidAccessArgs.EMPTY_PARENTHESES && (args == null || args.isEmpty())) continue;
                    return context != null ? context.transform(value) : value;
                }
            }
            ELParamValueScope functionCallResult = this.internalEvaluateFunctionCall((IRfMethodElement)this.element, evaluator, evaluator, guardian);
            return context != null ? context.transform(functionCallResult) : functionCallResult;
        }
        if (ELUtils.isUnsuccessfulEval(value) && this.parentAccess != null) {
            if (this.parentAccess.getAccessKind() == 5) {
                return ELUtils.evaluate(this.parentAccess, evaluator, null, guardian);
            }
            if (this.parentAccess.getAccessKind() == 0 && !ELUtils.isVLOGConstant(this.element)) {
                if (this.parentAccess.getAssociatedType() instanceof IRfPackageElement) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                Hid ancestorHid = this.getAncestorHid();
                IRfNamedElement ancestorElement = ancestorHid.getElement();
                if (ancestorElement instanceof IRfDesignElement || ancestorElement instanceof IRfInstanceElement) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                ELParamValueScope parentValue = ELUtils.evaluate(this.parentAccess, evaluator, null, guardian);
                if (ELUtils.isUnsuccessfulEval(parentValue)) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                DVTNumber parentNumber = parentValue.getDVTNumber();
                if (!(parentNumber instanceof IDVTMemberSelectable)) {
                    throw new UnknownHidObjectEvaluationException(this);
                }
                value = ELParamValueScope.of(ELParamValues.ParamValueNumber.of(((IDVTMemberSelectable)((Object)parentNumber)).getMemberSelect(this, false)), XUtils.getValue(parentValue));
            }
        }
        return context != null ? context.transform(value) : value;
    }

    protected ELParamValueScope internalEvaluateFunctionCall(IRfMethodElement element, IHidEvaluator evaluator, IHidEvaluator argumentsEvaluator, IHidEvaluationGuardian guardian) {
        MethodCall methodCall = new MethodCall(this, element, null, null, this.getOccurrence());
        return HidAccess.evaluateFunctionCall(this, methodCall, evaluator, argumentsEvaluator, guardian);
    }

    public IHidBuilders getHidBuilders() {
        return HidUtils.DEFAULT_BUILDERS;
    }

    @Override
    public IHidObject.HidKind getHidKind() {
        return IHidObject.HidKind.HID;
    }

    @Override
    public Hid internalThis() {
        return this;
    }

    public ELParamValues getAccessHidEvaluator(ELParamValuesHidEvaluator evaluator, ELManager manager, IHidEvaluationGuardian guardian) {
        HidAccess parentAccess = this.getParentAccess();
        while (parentAccess != null) {
            Hid parentHid = parentAccess.getParentHid();
            if (parentHid == null) {
                return null;
            }
            IRfNamedElement associatedType = parentAccess.getAssociatedType();
            if (DesignUtils.toGenericDesignElement(associatedType) instanceof IRfDesignElement) {
                ElementPath specified = ElementPath.from(HidUtils.toStringBuilder(parentHid, true, true, false, true, true, false).toString(), ".");
                ELInstance instanceFor = manager.getMemory().instanceFor(specified);
                if (instanceFor == null && guardian.getHierarchyPath() != null) {
                    ElementPath newPath = ElementPath.join(guardian.getHierarchyPath(), specified);
                    instanceFor = manager.getMemory().instanceFor(newPath);
                }
                if (instanceFor == null) {
                    return ELParamValues.EMPTY;
                }
                return instanceFor.getParamValues();
            }
            if (!(associatedType instanceof IRfCompositeTypeElement)) {
                return ELParamValues.EMPTY;
            }
            parentAccess = parentHid.getParentAccess();
        }
        return null;
    }

    public IRfNamedElement xRecomputeElementType(IHidEvaluator initialScope) {
        return this.getElement();
    }

    public static enum SelectKind {
        SELECT_NONE,
        SELECT_BIT,
        SELECT_RANGE;

    }

    public static enum UndeclaredKind {
        UNDECLARED_IDENTIFIER,
        UNDECLARED_TYPE_1,
        UNDECLARED_TYPE_2;

    }
}

