/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidMethodEvaluator;
import ro.amiq.dvt.elaboration.model.ELWidthCheckContext;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPropertySequence;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.DisabledMethodEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidScopeResetWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public abstract class HidAccess
implements IHidHolder,
Serializable {
    private static final long serialVersionUID = 6L;
    public static final String VLOG_SELECTS_SYMBOL = "[]";
    public static final String VHDL_SELECTS_SYMBOL = "()";
    protected int accessKind;
    protected Hid parentHid;
    protected ListContainer<Hid> hidsContainer;
    protected ListContainer<IHidObject> selectsContainer;
    protected transient IRfNamedElement associatedType;

    protected HidAccess(int accessKind, List<IHidObject> selects) {
        this.accessKind = accessKind;
        this.selectsContainer = OptimizedUtils.listContainerCreate(selects, true);
    }

    protected HidAccess(int accessKind, ListContainer<IHidObject> selectsContainer) {
        this.accessKind = accessKind;
        this.selectsContainer = selectsContainer;
    }

    public boolean isNoAccess() {
        return this.accessKind == Integer.MIN_VALUE && !this.isSelect();
    }

    public ELWidthCheckContext getElabDesignContext() {
        return null;
    }

    public IHidObject getAccessedHidObject() {
        if (this.selectsContainer.size() <= 1) {
            return this.parentHid;
        }
        HidAccess result = this.upwardsCopy(true);
        if (this.selectsContainer.size() == 2) {
            result.selectsContainer = this.selectsContainer.get(0);
            return result;
        }
        result.selectsContainer = new ArrayListContainer<IHidObject>(this.selectsContainer.size() - 1);
        int i = 0;
        while (i < this.selectsContainer.size() - 1) {
            ((ArrayListContainer)result.selectsContainer).add(this.selectsContainer.get(i));
            ++i;
        }
        return result;
    }

    public IHidObject getSelectInAccessedHidObject() {
        return XUtils.last(this.selectsContainer);
    }

    public boolean isSelect() {
        return this.selectsContainer != null && !this.selectsContainer.isEmpty();
    }

    public boolean isRangeSelect() {
        if (this.selectsContainer == null || this.selectsContainer.isEmpty()) {
            return false;
        }
        IHidObject lastSelect = this.selectsContainer.get(this.selectsContainer.size() - 1);
        return HidUtils.isOperator(lastSelect) && ((HidOperator)lastSelect).isRangeOrPartSelect();
    }

    public boolean isBitSelect() {
        if (this.selectsContainer == null || this.selectsContainer.isEmpty()) {
            return false;
        }
        IHidObject lastSelect = this.selectsContainer.get(this.selectsContainer.size() - 1);
        return !HidUtils.isOperator(lastSelect) || !((HidOperator)lastSelect).isRangeOrPartSelect();
    }

    public boolean isMethodCall(boolean stopAtAlias) {
        return this instanceof IHidAccessArgs && this.parentHid != null && this.parentHid.isMethodCall(stopAtAlias);
    }

    public boolean isPackageScopeAccess() {
        return this.getAccessKind() == 2 && this.parentHid != null && this.parentHid.getElement() instanceof IRfPackageElement;
    }

    public Hid getParentHid() {
        return this.parentHid;
    }

    public void setParentHid(Hid hid) {
        this.parentHid = hid;
    }

    public List<IHidObject> getSelects() {
        return OptimizedUtils.asList(this.selectsContainer, false);
    }

    public ListContainer<IHidObject> getSelectsContainer() {
        return this.selectsContainer;
    }

    public void setSelectsContainer(ListContainer<IHidObject> selectsContainer) {
        this.selectsContainer = selectsContainer;
    }

    public IRfNamedElement getAssociatedType() {
        return this.associatedType;
    }

    public void setAssociatedType(IRfNamedElement associatedType) {
        this.associatedType = associatedType;
    }

    public ListContainer<Hid> getHids() {
        return this.hidsContainer;
    }

    public Hid getFirstHid() {
        if (this.isHidObjectsEmpty()) {
            return null;
        }
        if (this.hidsContainer instanceof List) {
            return (Hid)((List)((Object)this.hidsContainer)).get(0);
        }
        return this.hidsContainer.get(0);
    }

    public HidOccurrence getOccurrence() {
        if (this.parentHid == null) {
            return null;
        }
        return this.parentHid.getOccurrence();
    }

    @Override
    public int getUsageIndex() {
        return this.parentHid == null ? -1 : this.parentHid.getUsageIndex();
    }

    @Override
    public int xGetLine() {
        if (this.parentHid == null) {
            return -1;
        }
        return this.parentHid.getLine();
    }

    public boolean isExternalName() {
        return this.parentHid != null && this.parentHid.isExternalName();
    }

    @Override
    public boolean isHidObjectsEmpty() {
        return this.hidsContainer == null || this.hidsContainer.isEmpty();
    }

    public int getAccessKind() {
        return this.accessKind;
    }

    public void setAccessKind(int accessKind) {
        this.accessKind = accessKind;
    }

    @Override
    public boolean isRegisterHid(boolean noReparseStack, int idType, IDVTFileInstance fileInstance) {
        return true;
    }

    @Override
    public boolean removeIdentifier(String name) {
        return false;
    }

    public void addSelect(IHidObject select) {
        this.selectsContainer = OptimizedUtils.listContainerAdd(this.selectsContainer, select);
    }

    @Override
    public HidOperator addOperator(IHidHolderConstants.OperatorRequest operatorRequest) {
        if (operatorRequest == null) {
            return null;
        }
        return operatorRequest.operator;
    }

    @Override
    public IHidHolder addIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
        if (hidRequest == null) {
            return null;
        }
        HidOccurrence occurrence = hidRequest.occurrence;
        if (access == null || access.getAccessKind() == Integer.MIN_VALUE) {
            occurrence.addQualifier(HidQualifierCache.LAST_QUALIFIER);
        }
        hidRequest.hid.addQualifier(occurrence.getQualifiers());
        Hid hid = this.addHid(hidRequest.hid);
        if (access == null) {
            return HidScopeResetWrapper.of(hid);
        }
        HidAccess addedAccess = hid.addAccess(access);
        return addedAccess;
    }

    @NotNull
    public Hid addHid(Hid hid) {
        hid.addParentAccess(this);
        this.hidsContainer = OptimizedUtils.listContainerAdd(this.hidsContainer, hid);
        return hid;
    }

    @Override
    public void updateHolder(IHidHolder updater) {
        this.addIdentifiers(updater);
        this.addOperators(updater);
    }

    @Override
    public void addIdentifiers(IHidHolder updater) {
        if (updater == null || updater.isHidObjectsEmpty()) {
            return;
        }
        if (updater instanceof HidHolder) {
            for (ListContainer<IHidObject> hidsContainer : ((HidHolder)updater).getHidObjectsMap().values()) {
                this.addIdentifiers(hidsContainer);
            }
        } else if (updater instanceof HidAccess) {
            this.addIdentifiers(((HidAccess)updater).getHids());
        }
    }

    @Override
    public void addOperators(IHidHolder updater) {
    }

    private void addIdentifiers(ListContainer<? extends IHidObject> hidsContainer) {
        if (hidsContainer == null || hidsContainer.isEmpty()) {
            return;
        }
        for (IHidObject iHidObject : hidsContainer) {
            if (!(iHidObject instanceof Hid)) continue;
            this.addHid((Hid)iHidObject);
        }
    }

    public void updateSelects(List<IHidObject> selects) {
        if (selects == null) {
            return;
        }
        this.selectsContainer = OptimizedUtils.listContainerCreate(selects, true);
    }

    @Override
    public void markElaborated() {
        if (this.parentHid != null) {
            this.parentHid.markElaborated();
        }
    }

    @Override
    public void deepClean() {
        this.parentHid = null;
        this.selectsContainer = null;
        if (!this.isHidObjectsEmpty()) {
            for (Hid hid : this.hidsContainer) {
                hid.deepClean();
            }
        }
        this.hidsContainer = null;
    }

    public IHidObject getTypeConversionValue() {
        if (!HidUtils.isResolved(this.parentHid) || !DVTRfUtils.MEMBERS_TYPES.contains(this.parentHid.getElement().getClass())) {
            return null;
        }
        if (!this.isSelect()) {
            return null;
        }
        return this.selectsContainer.get(0);
    }

    public IRfNamedElement getHierarchicalElement(ArrayDeque<IRfNamedElement> builderList, boolean allowUnresolved) {
        if (this.parentHid == null) {
            return HierarchicalElement.of(builderList.toArray(new IRfNamedElement[0]));
        }
        return this.parentHid.getHierarchicalElement(builderList, allowUnresolved);
    }

    public HidAccess deepCopy() {
        return null;
    }

    public HidAccess upwardsCopy(boolean addResolved) {
        return null;
    }

    public abstract LanguageKind getLanguageKind();

    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor visitor) {
        if (visitor.getType().isInstance(this) && !visitor.visit(this)) {
            return false;
        }
        if (!this.isHidObjectsEmpty()) {
            for (Hid hid : this.hidsContainer) {
                if (hid.visitHidObject(rfProject, visitor)) continue;
                return false;
            }
        } else {
            this.hidsContainer = null;
        }
        return true;
    }

    public boolean isAttributeAccess() {
        return false;
    }

    public static ELParamValueScope evaluateFunctionCall(IHidObject object, MethodCall methodCall, IHidEvaluator evaluator, IHidEvaluator argumentsEvaluator, IHidEvaluationGuardian guardian) {
        ELParamValueScope result;
        guardian.checkBuildCanceled();
        guardian.incrementStepCount();
        ELManager manager = evaluator.getManager();
        if (manager != null) {
            manager.state.incrementUserMethodCalls();
            if (manager.isMethodEvalDisabled()) {
                throw new DisabledMethodEvaluationException(object);
            }
        }
        if (methodCall == null || methodCall.method == null) {
            throw new UnknownHidObjectEvaluationException(object);
        }
        IHidEvaluator methodEvaluator = evaluator.isInterpreter() ? evaluator : ELParamValuesHidMethodEvaluator.of(evaluator);
        boolean isTask = methodCall.method instanceof IRfMethodElement && ((IRfMethodElement)methodCall.method).isTask();
        boolean isConstructor = methodCall.method instanceof IRfMethodElement && ((IRfMethodElement)methodCall.method).isConstructor();
        boolean isPredefined = methodCall.method.isPredefined();
        if (guardian.isInterpreter() && !guardian.isDisableNullChecks() && methodCall.methodValueHolder instanceof XValueHolder && ((XValueHolder)methodCall.methodValueHolder).getEnclosingValue().isNull() && !isConstructor) {
            HidUtils.performNullCheck(object, guardian);
        }
        IHidObject methodCallOperator = null;
        if (guardian.isRunMode() && manager != null && methodCall.methodValueHolder instanceof XMethodValueHolder && !isTask && !isConstructor && !isPredefined && (methodCall.argumentValuesMapRaw == null || methodCall.argumentValuesMapRaw.isEmpty())) {
            IHidOperator methodBody = manager.computeIfAbsentResolvedMethodBody((IRfMethodElement)methodCall.method, guardian, methodEvaluator);
            if (methodBody instanceof HidEvalCenter.SeqBlockStatement && ((HidEvalCenter.SeqBlockStatement)methodBody).hasRHValues() && ((HidEvalCenter.SeqBlockStatement)methodBody).rhValues.size() == 1) {
                IHidObject rhValue = (IHidObject)((HidEvalCenter.SeqBlockStatement)methodBody).rhValues.get(0);
                if (rhValue instanceof IHidOperator && ((IHidOperator)rhValue).isReturnStatement()) {
                    methodCallOperator = ((IHidOperator)rhValue).getFirstRHValue();
                    methodEvaluator = ((XValueHolder)methodCall.methodValueHolder).getEnclosingValue();
                    XUtils.inlineIncrement("inline single return statement method");
                    if (methodCallOperator instanceof HidAccess && ((HidAccess)methodCallOperator).isMethodCall(true)) {
                        XUtils.inlineIncrement("inline single return statement method recursive");
                        ELParamValueScope result2 = ELUtils.evaluate(methodCallOperator, methodEvaluator, null, guardian);
                        manager.state.incrementUserMethodCallsSuccEvals(XUtils.getValue(result2));
                        return result2;
                    }
                }
            } else if (methodBody instanceof HidEvalCenter.SeqBlockStatement && ((HidEvalCenter.SeqBlockStatement)methodBody).hasRHValues() && ((HidEvalCenter.SeqBlockStatement)methodBody).rhValues.size() > 1) {
                IHidObject rhValue1;
                int index = XUtils.getStatementIndex(((HidEvalCenter.SeqBlockStatement)methodBody).rhValues, 2);
                IHidObject rhValue0 = index < 0 ? null : (IHidObject)((HidEvalCenter.SeqBlockStatement)methodBody).rhValues.get(index);
                IHidObject iHidObject = rhValue1 = index < 0 ? null : (IHidObject)((HidEvalCenter.SeqBlockStatement)methodBody).rhValues.get(index + 1);
                if (rhValue1 instanceof IHidOperator && ((IHidOperator)rhValue1).isReturnStatement()) {
                    IHidObject returnHidObject = ((IHidOperator)rhValue1).getFirstRHValue();
                    if (HidUtils.isHid(returnHidObject) && rhValue0 instanceof HidEvalCenter.IfElseStatement && ((HidEvalCenter.IfElseStatement)rhValue0).lhValue instanceof HidOperator && ((HidOperator)((HidEvalCenter.IfElseStatement)rhValue0).lhValue).isNullTest(returnHidObject) && ((HidEvalCenter.IfElseStatement)rhValue0).rhValues instanceof HidEvalCenter.SeqBlockStatement && !((HidEvalCenter.SeqBlockStatement)((HidEvalCenter.IfElseStatement)rhValue0).rhValues).rhValues.isEmpty()) {
                        Hid returnHid = (Hid)((IHidOperator)rhValue1).getFirstRHValue();
                        ELParamValueScope result3 = ELUtils.evaluate(returnHid, methodEvaluator = ((XValueHolder)methodCall.methodValueHolder).getEnclosingValue(), null, guardian);
                        IELParamValue value = XUtils.getValue(result3);
                        if (value instanceof XValueHolder && !value.isNull()) {
                            XUtils.inlineIncrement("inline singleton method (null test)");
                            manager.state.incrementUserMethodCallsSuccEvals(XUtils.getValue(result3));
                            return result3;
                        }
                        XUtils.inlineIncrement("unsuccessful inline singleton method (null test)");
                    }
                } else if (rhValue0 instanceof HidEvalCenter.IfElseStatement && ((HidEvalCenter.IfElseStatement)rhValue0).lhValue instanceof HidOperator && ((HidEvalCenter.IfElseStatement)rhValue0).rhValues instanceof HidEvalCenter.SeqBlockStatement) {
                    IHidObject lhValue = ((HidEvalCenter.IfElseStatement)rhValue0).lhValue;
                    ListContainer rhValues = ((HidEvalCenter.SeqBlockStatement)((HidEvalCenter.IfElseStatement)rhValue0).rhValues).rhValues;
                    if (rhValues.size() == 1 && rhValues.get(0) instanceof HidOperator && ((HidOperator)rhValues.get(0)).isReturnStatement() && ((HidOperator)lhValue).isNotNullTest(((HidOperator)rhValues.get(0)).getFirstRHValue())) {
                        Hid returnHid = (Hid)((HidOperator)rhValues.get(0)).getFirstRHValue();
                        ELParamValueScope result4 = ELUtils.evaluate(returnHid, methodEvaluator = ((XValueHolder)methodCall.methodValueHolder).getEnclosingValue(), null, guardian);
                        IELParamValue value = XUtils.getValue(result4);
                        if (value instanceof XValueHolder && !value.isNull()) {
                            XUtils.inlineIncrement("inline singleton method (non-null test)");
                            manager.state.incrementUserMethodCallsSuccEvals(XUtils.getValue(result4));
                            return result4;
                        }
                        XUtils.inlineIncrement("unsuccessful inline singleton method (non-null test)");
                    }
                }
            } else if (methodBody != null && methodBody.isReturnStatement()) {
                methodCallOperator = methodBody.getFirstRHValue();
                methodEvaluator = ((XValueHolder)methodCall.methodValueHolder).getEnclosingValue();
                XUtils.inlineIncrement("inline single return statement method");
                if (methodCallOperator instanceof HidAccess && ((HidAccess)methodCallOperator).isMethodCall(true)) {
                    XUtils.inlineIncrement("inline single return statement method recursive");
                    ELParamValueScope result5 = ELUtils.evaluate(methodCallOperator, methodEvaluator, null, guardian);
                    manager.state.incrementUserMethodCallsSuccEvals(XUtils.getValue(result5));
                    return result5;
                }
            }
        }
        if (methodCallOperator == null) {
            Hid parentHid = XUtils.getParentHid(object);
            boolean fromExpression = !parentHid.hasOccurrence(HidQualifierCache.METHOD_CALL_PLACEHOLDER);
            methodCallOperator = HidEvalCenter.INSTANCE.createMethodCall(methodCall, object, argumentsEvaluator, fromExpression);
        }
        XValueHolderFactory factory = guardian.getFactory();
        BitVectorContext dataTypeBitVectorContext = null;
        if (evaluator instanceof XValueHolder && !isConstructor) {
            IRfNamedElement resultVariable = methodCall.method.getLocalMember(null, methodCall.method.getName(), null);
            if (resultVariable != null && methodCall.methodValueHolder instanceof XMethodValueHolder) {
                IELParamValue returnValue = ((XValueHolder)methodCall.methodValueHolder).createValue(resultVariable);
                dataTypeBitVectorContext = XValueHolderFactory.getRightOpContext(returnValue, methodCallOperator, methodCall.method, factory);
            } else if (methodCall.method instanceof IRfPropertySequence) {
                dataTypeBitVectorContext = BitVectorContext.of(BitVectorContext.NO_CONTEXT, methodCall.method);
            } else {
                IRfNamedElement associatedType = factory.xGetAssociatedType((IRfAssociatedTypeElement)methodCall.method, (XValueHolder)evaluator);
                if (associatedType != null && !XValueHolderFactory.xIsClass(associatedType, true)) {
                    dataTypeBitVectorContext = ((IRfMethodElement)methodCall.method).getDataTypeBitVectorContext(evaluator, false, null, manager);
                }
            }
        }
        try {
            result = ELUtils.evaluate(methodCallOperator, methodEvaluator, dataTypeBitVectorContext, guardian);
        }
        catch (StackOverflowError e) {
            if (manager != null) {
                manager.state.setStackOverflowMethod(methodCall.method);
            }
            throw e;
        }
        if (manager != null) {
            manager.state.incrementUserMethodCallsSuccEvals(XUtils.getValue(result));
        }
        return result;
    }

    public String toString() {
        return HidUtils.toString(this, true, true);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.accessKind;
        result = 31 * result + (this.parentHid == null ? 0 : this.parentHid.hashCode());
        result = 31 * result + (this.selectsContainer == null ? 0 : this.selectsContainer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HidAccess)) {
            return false;
        }
        HidAccess other = (HidAccess)obj;
        if (this.accessKind != other.accessKind) {
            return false;
        }
        if (this.parentHid == null ? other.parentHid != null : !this.parentHid.equals(other.parentHid)) {
            return false;
        }
        return !(this.selectsContainer == null ? other.selectsContainer != null : !this.selectsContainer.equals(other.selectsContainer));
    }

    @Override
    public boolean checkEquals(Object obj) {
        int otherSize;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HidAccess)) {
            return false;
        }
        HidAccess other = (HidAccess)obj;
        if (this.accessKind != other.accessKind) {
            return false;
        }
        if (this.parentHid == null ? other.parentHid != null : !this.parentHid.equals(other.parentHid)) {
            return false;
        }
        int size = this.selectsContainer != null ? this.selectsContainer.size() : 0;
        int n = otherSize = other.selectsContainer != null ? other.selectsContainer.size() : 0;
        if (size != otherSize) {
            return false;
        }
        if (size != 0) {
            Iterator<IHidObject> othersSelectsIterator = other.selectsContainer.iterator();
            for (IHidObject select : this.selectsContainer) {
                IHidObject otherSelect;
                if (select.checkEquals(otherSelect = othersSelectsIterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public IHidObject.HidKind getHidKind() {
        return IHidObject.HidKind.ACCESS;
    }

    @Override
    public HidAccess internalThis() {
        return this;
    }

    public IDataType getDataType() {
        return null;
    }

    public IRfNamedElement xRecomputeAssociatedType(IHidEvaluator initialScope) {
        return this.getAssociatedType();
    }

    public IHidObject xGetRangeObject() {
        return null;
    }
}

