/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.MinTypMax;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.BoolVariable;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.csp.variables.ReifBoolVariable;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidMethodEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XCGroupValueHolder;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XCaseEvalScope;
import ro.amiq.dvt.interpreter.XDoWhileEvalScope;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XEvalScopeWithParserPath;
import ro.amiq.dvt.interpreter.XForEvalScope;
import ro.amiq.dvt.interpreter.XForeachEvalScope;
import ro.amiq.dvt.interpreter.XForeverEvalScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XIfElseEvalScope;
import ro.amiq.dvt.interpreter.XMethodBlockEvalScope;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XRepeatEvalScope;
import ro.amiq.dvt.interpreter.XSeqBlockEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.XWhileEvalScope;
import ro.amiq.dvt.interpreter.constraints.XCModel;
import ro.amiq.dvt.interpreter.constraints.XCValue;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfCoverbin;
import ro.amiq.dvt.model.reflection.IRfCovergroup;
import ro.amiq.dvt.model.reflection.IRfCoverpoint;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalJumpStatementException;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrenceBounds;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.SkippedHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.optimized.collections.fast.IdentityHSet;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.XGlobalCache;

public enum HidEvalCenter {
    INSTANCE;

    public static final ParserPath EC_NBA_ASSIGN_PARSER_PATH;
    private static final BitVectorContext NO_CONTEXT;

    static {
        EC_NBA_ASSIGN_PARSER_PATH = new ParserPath("[event controlled NBA assign]");
        NO_CONTEXT = BitVectorContext.of(null, false);
    }

    public HidOperator createStatement(IRfNamedElement blockNamedElement, int operatorType, int startOffset, int startVirtualOffset, int startLine, boolean isCaseSensitive, ListContainer<IHidObject> statements) {
        if (operatorType == IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id) {
            return new SeqBlockStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, statements, isCaseSensitive);
        }
        throw new IllegalArgumentException("Cannot create statement operator of type " + operatorType);
    }

    public HidOperator createIfStatement(IHidObject condition, ListContainer<IHidObject> rhValues) {
        IHidObject sequence = rhValues.size() == 1 ? rhValues.get(0) : new SeqBlockStatement(null, -1, -1, -1, rhValues, true);
        return new IfElseStatement(null, -1, -1, -1, condition, sequence, null, true);
    }

    @NotNull
    public HidOperator createStatement(IRfNamedElement blockNamedElement, int operatorType, ParserPath parserPath, int startOffset, int startVirtualOffset, int startLine, IRfActionBlockElement.BlockQualifier caseBlockQualifier, boolean isCaseSensitive, IHidObject ... members) {
        if (operatorType == IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id) {
            return new IfElseStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[0], members[1], members.length > 2 ? members[2] : null, isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.WHILE_LOOP_STATEMENT.id) {
            return new WhileLoopStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[0], members[1], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.DO_WHILE_LOOP_STATEMENT.id) {
            return new DoWhileLoopStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[0], members[1], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.REPEAT_CONDITION.id) {
            return new RepeatLoopStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[0], members[1], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.FOREACH_LOOP_STATEMENT.id) {
            return new ForeachLoopStatement(blockNamedElement, operatorType, parserPath, startOffset, startVirtualOffset, startLine, members[0], members[1], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.FOREACH_LOOP_CONSTRAINT_STATEMENT.id) {
            ListContainer<IHidObject> selectsContainer = ((HidAccess)members[0]).getSelectsContainer();
            ListContainer<IHidObject> foreachIndexes = XUtils.last(selectsContainer);
            if (foreachIndexes.size() == 1 && HidUtils.isOperator((IHidObject)foreachIndexes.get(0)) && ((HidOperator)foreachIndexes.get(0)).getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                foreachIndexes = XUtils.reverse(((HidOperator)foreachIndexes.get(0)).getRHValues());
            }
            if (foreachIndexes.size() == 1 && HidUtils.isHid((IHidObject)foreachIndexes.get(0))) {
                return new ForeachLoopStatement(blockNamedElement, operatorType, parserPath, startOffset, startVirtualOffset, startLine, members[0], members[1], isCaseSensitive);
            }
            IHidObject tempStatement = members[1];
            int i = 0;
            while (i < foreachIndexes.size()) {
                HidAccess hidAccess = ((HidAccess)members[0]).upwardsCopy(true);
                ArrayListContainer<IHidObject> tempSelectsContainer = new ArrayListContainer<IHidObject>(selectsContainer.size() - 1 + foreachIndexes.size());
                int j = 0;
                while (j < selectsContainer.size() - 1) {
                    tempSelectsContainer.add(selectsContainer.get(j));
                    ++j;
                }
                j = 0;
                while (j < foreachIndexes.size() - i) {
                    tempSelectsContainer.add(foreachIndexes.get(j));
                    ++j;
                }
                hidAccess.setSelectsContainer(tempSelectsContainer);
                tempStatement = new ForeachLoopStatement(blockNamedElement, operatorType, parserPath, startOffset, startVirtualOffset, startLine, hidAccess, tempStatement, isCaseSensitive);
                ++i;
            }
            return (HidOperator)tempStatement;
        }
        if (operatorType == IHidOperatorConstants.OperatorType.FOR_LOOP_STATEMENT.id) {
            return new ForLoopStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[0], members[1], members[2], members[3], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.FOREVER_LOOP_STATEMENT.id) {
            return new ForeverLoopStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[1], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.FORK_JOIN_NONE_STATEMENT.id) {
            return new ForkJoinStatement(IHidOperatorConstants.OperatorType.FORK_JOIN_NONE_STATEMENT.id, "fork join_none", blockNamedElement, parserPath, startOffset, startVirtualOffset, startLine, members[0], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.FORK_JOIN_ANY_STATEMENT.id) {
            return new ForkJoinStatement(IHidOperatorConstants.OperatorType.FORK_JOIN_ANY_STATEMENT.id, "fork join_any", blockNamedElement, parserPath, startOffset, startVirtualOffset, startLine, members[0], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.FORK_JOIN_STATEMENT.id) {
            return new ForkJoinStatement(IHidOperatorConstants.OperatorType.FORK_JOIN_STATEMENT.id, "fork join", blockNamedElement, parserPath, startOffset, startVirtualOffset, startLine, members[0], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.RANDCASE_STATEMENT.id) {
            return new RandcaseStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[0], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.RANDCASE_ITEM_STATEMENT.id) {
            return new RandcaseItemStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[0], members[1], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.CASE_STATEMENT.id) {
            return new CaseStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, caseBlockQualifier, members[0], members[1], isCaseSensitive);
        }
        if (operatorType == IHidOperatorConstants.OperatorType.CASE_ITEM_STATEMENT.id) {
            return new CaseItemStatement(blockNamedElement, startOffset, startVirtualOffset, startLine, members[0], members[1], isCaseSensitive);
        }
        throw new IllegalArgumentException("Cannot create statement operator of type " + operatorType);
    }

    @NotNull
    public HidOperator createCovergroup(IRfCovergroup namedElement, int startOffset, int startVirtualOffset, int startLine, List<CoverpointStatement> coverpoints, Map<String, IHidOperator> covergroupOptions, List<IHidOperator> covergroupEvents) {
        if (namedElement == null) {
            throw new IllegalArgumentException("Must specify the covergroup");
        }
        return new CovergroupStatement(namedElement, startOffset, startVirtualOffset, startLine, coverpoints, covergroupOptions, covergroupEvents);
    }

    @NotNull
    CoverpointStatement createCoverpoint(IRfCoverpoint namedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject coverpointExpression, List<BinAssignmentStatement> coverpointBins, BinAssignmentStatement coverpointDefaultBin, Map<String, IHidOperator> coverpointOptions) {
        if (namedElement == null) {
            throw new IllegalArgumentException("Must specify the coverpoint");
        }
        return new CoverpointStatement(namedElement, startOffset, startVirtualOffset, startLine, coverpointExpression, coverpointBins, coverpointDefaultBin, coverpointOptions);
    }

    @NotNull
    BinAssignmentStatement createBinAssignment(IHidOperator binAssignment, IRfCoverpoint coverPoint) {
        if (binAssignment == null) {
            throw new IllegalArgumentException("Must specify the bin assignment");
        }
        IHidObject lhValue = binAssignment.getLHValue();
        if (!(lhValue instanceof IHidOperator)) {
            return null;
        }
        IHidObject binHid = ((IHidOperator)lhValue).getLHValue();
        while (binHid instanceof IHidOperator && !(binHid instanceof IHidImplicit)) {
            binHid = ((IHidOperator)binHid).getLHValue();
        }
        if (!(binHid instanceof IHidImplicit)) {
            return null;
        }
        String binName = ((IHidImplicit)binHid).getName();
        IRfNamedElement xGetMember = coverPoint.xGetMember(binName);
        if (!(xGetMember instanceof IRfCoverbin)) {
            return null;
        }
        return new BinAssignmentStatement(binAssignment, (IRfCoverbin)xGetMember);
    }

    @NotNull
    public HidOperator createMethodCall(MethodCall call, IHidObject hidObject, IHidEvaluator argumentsEvaluator, boolean fromExpression) {
        if (call == null) {
            throw new IllegalArgumentException("Must specify the method");
        }
        return new MethodCallStatement(call, hidObject, argumentsEvaluator, fromExpression);
    }

    @NotNull
    public HidOperator createDeclaration(IRfFieldElement field) {
        if (field == null || field.getDeclaration() == null) {
            throw new IllegalArgumentException("Must specify the argument");
        }
        return new DeclarationStatement(field);
    }

    @NotNull
    public HidOperator createDeclarationWithInitialValue(IRfFieldElement field, IHidObject initialValue, HidOperatorOccurrence occurrence) {
        if (field == null || field.getDeclaration() == null || initialValue == null) {
            throw new IllegalArgumentException("Must specify the argument");
        }
        return field.xMakeInitDeclarationOperator(initialValue, occurrence);
    }

    @NotNull
    public HidOperator createDelayedAssignment(HidOperator delay, HidOperatorOccurrence occurrence) {
        if (delay == null || occurrence == null) {
            throw new IllegalArgumentException("Must specify the argument");
        }
        return new DelayedProceduralAssignment(delay, occurrence);
    }

    @NotNull
    public HidOperator createDelayedContinuousAssign(HidOperator delay, HidOperator continuousAssign, HidOperatorOccurrence occurrence) {
        if (delay == null || continuousAssign == null || occurrence == null) {
            throw new IllegalArgumentException("Must specify the argument");
        }
        return new DelayedContinuousAssign(delay, continuousAssign, occurrence);
    }

    @NotNull
    public HidOperator createDelayedTriggerEvent(HidOperator delay, HidOperatorOccurrence occurrence) {
        if (delay == null || occurrence == null) {
            throw new IllegalArgumentException("Must specify the argument");
        }
        return new DelayedTriggerEvent(delay, occurrence);
    }

    @NotNull
    public HidOperator createEventControlledAssignment(HidOperator eventControl, HidOperatorOccurrence occurrence, boolean isCaseSensitive) {
        if (eventControl == null || occurrence == null) {
            throw new IllegalArgumentException("Must specify the argument");
        }
        return new EventControlledAssignment(eventControl, occurrence, isCaseSensitive);
    }

    @NotNull
    public HidOperator createEventControlledTriggerEvent(HidOperator eventControl, HidOperatorOccurrence occurrence, boolean isCaseSensitive) {
        if (eventControl == null || occurrence == null) {
            throw new IllegalArgumentException("Must specify the argument");
        }
        return new EventControlledTriggerEvent(eventControl, occurrence, isCaseSensitive);
    }

    @NotNull
    public HidOperator createDriveStrengthContinuousAssign(HidOperator driveStrength, HidOperator continuousAssign, HidOperatorOccurrence occurrence) {
        if (driveStrength == null || continuousAssign == null || occurrence == null) {
            throw new IllegalArgumentException("Must specify the argument");
        }
        IHidObject lhValue = driveStrength.getLHValue();
        IHidObject rhValue = driveStrength.getFirstRHValue();
        if (!HidUtils.isHidImplicit(lhValue) || !HidUtils.isHidImplicit(rhValue)) {
            throw new IllegalArgumentException("Wrong drive strength spec");
        }
        String lhName = ((HidImplicit)lhValue).getName();
        String rhName = ((HidImplicit)rhValue).getName();
        MaskType lhStrength = MaskType.getDriveStrength(lhName);
        if (lhStrength == null) {
            return continuousAssign;
        }
        MaskType rhStrength = MaskType.getDriveStrength(rhName);
        if (rhStrength == null) {
            return continuousAssign;
        }
        MaskType[] strength = new MaskType[2];
        if (MaskType.ZeroDriveStrengths.contains((Object)lhStrength)) {
            strength[0] = lhStrength;
            strength[1] = rhStrength;
        } else {
            strength[0] = rhStrength;
            strength[1] = lhStrength;
        }
        return continuousAssign.shallowCopy(strength);
    }

    @NotNull
    public HidOperator createMethodCallPlaceholder(IHidObject hidOrAccess, int offset, int virtualOffset, int line) {
        if (hidOrAccess == null) {
            throw new IllegalArgumentException("Must specify the method identifier");
        }
        return new MethodCallPlaceholder(hidOrAccess, offset, virtualOffset, line);
    }

    public static boolean testCondition(IHidObject condition, IHidEvaluator evaluator, BitVectorContext noContext, IHidEvaluationGuardian guardian) {
        return HidEvalCenter.testCondition(condition, evaluator, noContext, guardian, true);
    }

    public static boolean testCondition(IHidObject condition, IHidEvaluator evaluator, BitVectorContext noContext, IHidEvaluationGuardian guardian, boolean isCallbackStartStatement) {
        IELParamValue result = null;
        XThread xThread = guardian.getActiveThread();
        try {
            if (isCallbackStartStatement) {
                guardian.callbackStartStatement(xThread, XUtils.toOperator(condition));
            }
            if (xThread == null || !xThread.isHotSwap()) {
                result = XUtils.getValue(ELUtils.evaluate(condition, evaluator, noContext, guardian));
            }
        }
        finally {
            guardian.callbackEndStatement(xThread, condition);
        }
        if ((xThread == null || !xThread.isHotSwap()) && ELUtils.isUnsuccessfulEval(result)) {
            throw new UnknownHidObjectEvaluationException(condition);
        }
        if (ELUtils.isParamValueNumber(result)) {
            return !ELUtils.isFalse(result);
        }
        return xThread != null && xThread.isHotSwap() || result == null || !result.isNull();
    }

    public IHidOperator createConcurrentAssertStatement(IRfNamedElement namedElement, IHidObject condition, IHidObject ifProg, IHidObject elseProg, int startOffset, int startVirtualOffset, int startLine) {
        return new ConcurrentAssertStatement(namedElement, condition, ifProg, elseProg, startOffset, startVirtualOffset, startLine);
    }

    public IHidOperator createAssertStatement(IRfNamedElement namedElement, IHidObject condition, IHidObject ifProg, IHidObject elseProg, int startOffset, int startVirtualOffset, int startLine) {
        return new AssertStatement(namedElement, condition, ifProg, elseProg, startOffset, startVirtualOffset, startLine);
    }

    public HidOperator createSpecialAssign(XSimRegion.XRegionKind regionKind, HidOperator assignOperator) {
        return new SpecialProceduralAssign(regionKind, assignOperator);
    }

    public static class AssertStatement
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        protected IRfNamedElement namedElement;
        protected int virtualOffset;
        protected IHidObject ifProg;
        protected IHidObject elseProg;

        private AssertStatement(IRfNamedElement namedElement, IHidObject condition, IHidObject ifProg, IHidObject elseProg, int startOffset, int startVirtualOffset, int startLine) {
            super(IHidOperatorConstants.OperatorType.ASSERT_STATEMENT.id, IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR, "assert_statement", startOffset, startLine, -1, -1, 0L);
            this.namedElement = namedElement;
            this.virtualOffset = startVirtualOffset;
            this.addLHValue(condition, false);
            this.ifProg = ifProg;
            this.elseProg = elseProg;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            IHidObject statement;
            guardian.checkBuildCanceled();
            IHidObject condition = this.getLHValue();
            if (condition == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            BitVectorContext noContext = BitVectorContext.of(context != null ? context.getOrigin() : null, false);
            boolean assertionPassed = HidEvalCenter.testCondition(condition, evaluator, noContext, guardian.copy());
            if (assertionPassed) {
                if (this.ifProg == null) {
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                statement = this.ifProg;
            } else {
                if (this.elseProg == null) {
                    String displayString = this.namedElement.isAnonymous() ? "Assertion error." : "Assertion '" + this.namedElement.getName() + "' error.";
                    guardian.logError(displayString);
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                statement = this.elseProg;
            }
            XThread activeThread = guardian.getActiveThread();
            XValueHolderFactory factory = guardian.getFactory();
            IRfAssertExpectElement.AssertKind assertKind = ((IRfAssertExpectElement)this.namedElement).getAssertKind();
            try {
                if (factory != null && (assertKind == IRfAssertExpectElement.AssertKind.DEFFERED_FINAL || assertKind == IRfAssertExpectElement.AssertKind.DEFFERED_POUND_0)) {
                    factory.setDeferredReporting(assertKind, activeThread);
                }
                ELUtils.evaluate(statement, evaluator, noContext, guardian.copy());
            }
            finally {
                if (factory != null && (assertKind == IRfAssertExpectElement.AssertKind.DEFFERED_FINAL || assertKind == IRfAssertExpectElement.AssertKind.DEFFERED_POUND_0)) {
                    factory.resetDeferredReporting();
                }
            }
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        @Override
        public HidOperatorOccurrence getOccurrence() {
            if (this.namedElement != null) {
                return new HidOperatorOccurrence(this.offset, this.virtualOffset, this.line, 0L, this.namedElement.xGetReparseInfo());
            }
            return super.getOccurrence();
        }

        @Override
        public int getVirtualOffset() {
            return this.virtualOffset;
        }

        @Override
        public int getUsageIndex() {
            if (this.namedElement != null) {
                return this.namedElement.getDeclarationIndex();
            }
            return super.getUsageIndex();
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }

        public IRfNamedElement getNamedElement() {
            return this.namedElement;
        }
    }

    public static class BinAssignmentStatement
    extends HidOperator {
        private IHidOperator binAssignment;
        private IRfCoverbin namedElement;
        private boolean hasWildcard;
        private CoverpointStatement cpStatement;
        private BinQualifier binQualifier;
        private IHidObject withExpression;
        private IHidObject enableExpression;
        private IHidObject covergroupExpression;
        private IHidOperator covergroupRangeList;
        private boolean isArray;

        private BinAssignmentStatement(IHidOperator binAssignment, IRfCoverbin namedElement) {
            super(IHidOperatorConstants.OperatorType.BIN_ASSIGNMENT_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "bin_assignment_statement", binAssignment.getOccurrence().getOffset(), binAssignment.getOccurrence().getLine(), -1, -1, 0L);
            IHidObject binAssignmentRHValue;
            this.namedElement = namedElement;
            this.isArray = namedElement.isArray();
            if (binAssignment.getLHValue() instanceof IHidOperator) {
                IHidOperator lhOp = (IHidOperator)binAssignment.getLHValue();
                IHidObject leftLhOp = lhOp.getLHValue();
                this.binQualifier = BinQualifier.fromString(lhOp);
                if (leftLhOp instanceof IHidImplicit) {
                    this.hasWildcard = ((IHidImplicit)leftLhOp).isLiteralWildcard();
                    IHidObject rightLhOp = lhOp.getFirstRHValue();
                    if (rightLhOp instanceof IHidOperator) {
                        this.covergroupExpression = ((IHidOperator)rightLhOp).getFirstRHValue();
                    }
                } else if (leftLhOp instanceof IHidOperator) {
                    this.covergroupExpression = ((IHidOperator)leftLhOp).getFirstRHValue();
                }
            }
            if ((binAssignmentRHValue = binAssignment.getFirstRHValue()) instanceof IHidOperator) {
                IHidObject unwrapIff;
                IHidOperator rhWithIffOp = (IHidOperator)binAssignmentRHValue;
                if (rhWithIffOp.isIffExpression()) {
                    this.enableExpression = rhWithIffOp.getFirstRHValue();
                    unwrapIff = rhWithIffOp.getLHValue();
                } else {
                    unwrapIff = rhWithIffOp;
                }
                if (unwrapIff instanceof IHidOperator) {
                    IHidObject rhOp;
                    IHidOperator rhWithOp = unwrapIff;
                    if (rhWithOp.isWithCoverpointBinsExpression()) {
                        this.withExpression = rhWithOp.getFirstRHValue();
                        rhOp = rhWithOp.getLHValue();
                    } else {
                        rhOp = rhWithOp;
                    }
                    if (rhOp instanceof IHidOperator && (rhOp.isCovergroupRangeList() || rhOp.isTransList())) {
                        this.covergroupRangeList = (IHidOperator)rhOp;
                    }
                }
            }
            this.binAssignment = binAssignment;
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }

        @Override
        public int getVirtualOffset() {
            return this.binAssignment == null || this.binAssignment.getOccurrence() == null ? -1 : this.binAssignment.getOccurrence().virtualOffset;
        }

        @Override
        public int getUsageIndex() {
            return this.binAssignment == null ? -1 : this.binAssignment.getUsageIndex();
        }

        @Override
        public boolean isBins() {
            return this.binQualifier == BinQualifier.BINS;
        }

        @Override
        public boolean isIllegalBins() {
            return this.binQualifier == BinQualifier.BINS_ILLEGAL;
        }

        @Override
        public boolean isIgnoreBins() {
            return this.binQualifier == BinQualifier.BINS_IGNORE;
        }

        public IHidOperator getCovergroupRangeList() {
            return this.covergroupRangeList;
        }

        public List<IHidObject> getBinsExpressions() {
            return this.namedElement.getBinExpressions();
        }

        public IRfCoverbin getNamedElement() {
            return this.namedElement;
        }

        public String getName() {
            String label = this.getLabel();
            if (label != null) {
                return label;
            }
            return this.namedElement.getName();
        }

        @Override
        public String getLabel() {
            IHidObject lhValue = this.binAssignment.getLHValue();
            if (!(lhValue instanceof IHidOperator)) {
                return null;
            }
            IHidOperator lhOperator = (IHidOperator)lhValue;
            IHidObject binHid = lhOperator.getLHValue();
            if (!(binHid instanceof IHidImplicit)) {
                return null;
            }
            return ((IHidImplicit)binHid).getName();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj.hashCode() == this.hashCode();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean isArray() {
            return this.isArray;
        }

        public IHidOperator getBinAssignment() {
            return this.binAssignment;
        }

        public static enum BinQualifier {
            BINS,
            BINS_ILLEGAL,
            BINS_IGNORE,
            UNKNOWN;


            public static BinQualifier fromString(IHidOperator op) {
                if (op == null) {
                    return UNKNOWN;
                }
                if (op.isBins()) {
                    return BINS;
                }
                if (op.isIllegalBins()) {
                    return BINS_ILLEGAL;
                }
                if (op.isIgnoreBins()) {
                    return BINS_IGNORE;
                }
                return UNKNOWN;
            }
        }
    }

    public static abstract class BlockStatement
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        protected IRfNamedElement blockNamedElement;
        protected boolean isCaseSensitive;
        private int virtualOffset;

        protected BlockStatement(IRfNamedElement blockNamedElement, int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int startOffset, int startVirtualOffset, int startLine, boolean isCaseSensitive) {
            super(operatorType, operatorKind, operatorText, startOffset, startLine, startOffset, -1, 0L);
            this.blockNamedElement = blockNamedElement;
            this.virtualOffset = startVirtualOffset;
            this.isCaseSensitive = isCaseSensitive;
        }

        @Override
        public HidOperatorOccurrence getOccurrence() {
            if (this.blockNamedElement != null) {
                return new HidOperatorOccurrence(this.offset, this.virtualOffset, this.line, new HidOccurrenceBounds(this.offset, this.virtualOffset, -1, -1), 0L, this.blockNamedElement.xGetReparseInfo());
            }
            return super.getOccurrence();
        }

        @Override
        public int getVirtualOffset() {
            return this.virtualOffset;
        }

        @Override
        public int getUsageIndex() {
            if (this.blockNamedElement != null) {
                return this.blockNamedElement.getDeclarationIndex();
            }
            return super.getUsageIndex();
        }

        @Override
        public String getLabel() {
            return XUtils.getName(this.blockNamedElement);
        }

        public void setNamedElement(IRfNamedElement blockNamedElement) {
            this.blockNamedElement = blockNamedElement;
        }

        public IRfNamedElement getNamedElement() {
            return this.blockNamedElement;
        }

        @Override
        public LanguageKind getLanguageKind() {
            return this.blockNamedElement != null ? this.blockNamedElement.getLanguageKind() : LanguageKind.VLOG;
        }

        public boolean hasLocalMembers() {
            if (this.blockNamedElement == null) {
                return false;
            }
            if (!this.blockNamedElement.isAnonymous()) {
                return true;
            }
            int hasMembers = XGlobalCache.INSTANCE.hasMambers(this.blockNamedElement);
            if (hasMembers >= 0) {
                return hasMembers > 0;
            }
            boolean result = XUtils.hasLocalMembers(this.blockNamedElement);
            XGlobalCache.INSTANCE.hasMambers(this.blockNamedElement, result);
            return result;
        }
    }

    public static class CaseItemStatement
    extends BlockStatement {
        private static final long serialVersionUID = 1L;

        private CaseItemStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject condition, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.CASE_ITEM_STATEMENT.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(condition, false);
            this.addRHValue(statement, false);
        }

        public IHidObject getCondition() {
            return this.getLHValue();
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            return ELUtils.evaluate(this.getFirstRHValue(), evaluator, context, guardian);
        }
    }

    public static class CaseStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private final IRfActionBlockElement.BlockQualifier caseBlockQualifier;
        private final boolean isVLOG;

        private CaseStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IRfActionBlockElement.BlockQualifier caseBlockQualifier, IHidObject condition, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.CASE_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "case_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.caseBlockQualifier = caseBlockQualifier;
            this.addLHValue(condition, false);
            if (HidUtils.isOperator(statement) && ((HidOperator)statement).getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                ListContainer<IHidObject> items = ((HidOperator)statement).getRHValues();
                if (items == null || items.isEmpty()) {
                    throw new IllegalArgumentException("Case statement with no items");
                }
                for (IHidObject item : items) {
                    this.internalAddSingleCaseItem(item);
                }
            } else if (statement != null) {
                this.internalAddSingleCaseItem(statement);
            }
            this.isVLOG = blockNamedElement != null && blockNamedElement.getLanguageKind() == LanguageKind.VLOG;
        }

        private void internalAddSingleCaseItem(IHidObject statement) {
            if (!(statement instanceof CaseItemStatement)) {
                throw new IllegalArgumentException("Invalid case item statement");
            }
            CaseItemStatement itemStatement = (CaseItemStatement)statement;
            IHidObject itemCondition = itemStatement.getLHValue();
            if (HidUtils.isOperator(itemCondition) && ((IHidOperator)itemCondition).isComma()) {
                IHidObject commonStatement = itemStatement.getFirstRHValue();
                HidOperatorOccurrence occurrence = itemStatement.getOccurrence();
                ListContainer<IHidObject> rhValues = ((HidOperator)itemCondition).getRHValues();
                int i = rhValues.size() - 1;
                while (i >= 0) {
                    IHidObject newItemCondition = rhValues.get(i);
                    HidOperator singularItemCondition = INSTANCE.createStatement(itemStatement.blockNamedElement, IHidOperatorConstants.OperatorType.CASE_ITEM_STATEMENT.id, null, occurrence.getOffset(), occurrence.getVirtualOffset(), occurrence.getLine(), null, true, newItemCondition, commonStatement);
                    if (!(singularItemCondition instanceof CaseItemStatement)) {
                        throw new IllegalArgumentException("Invalid case item statement");
                    }
                    this.addRHValue(singularItemCondition, false);
                    --i;
                }
            } else {
                this.addRHValue(itemStatement, false);
            }
        }

        private IHidObject getCondition() {
            return this.getLHValue();
        }

        private List<IHidObject> getItems() {
            return OptimizedUtils.asList(this.getRHValues(), false);
        }

        private BitVectorContext getTestContext(IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            boolean isVLOG;
            IHidObject caseCondition = this.getLHValue();
            if (caseCondition == null) {
                return null;
            }
            ListContainer<IHidObject> items = this.getRHValues();
            if (items == null || items.isEmpty()) {
                return null;
            }
            BitVectorContext testContext = null;
            boolean bl = isVLOG = this.blockNamedElement != null && this.blockNamedElement.getLanguageKind() == LanguageKind.VLOG;
            if (isVLOG) {
                IELParamValue caseSize = XUtils.getValue(ELUtils.evaluateForSize(caseCondition, evaluator, this.blockNamedElement, guardian));
                if (ELUtils.isUnsuccessfulEval(caseSize) || !(caseSize.getDVTNumber() instanceof VlogBitVector)) {
                    testContext = BitVectorContext.of((IRfNamedElement)this.blockNamedElement.getEnclosingScope(), false);
                } else {
                    testContext = BitVectorContext.flexibleDefault(0, false, null);
                    testContext.transform(caseSize);
                    for (IHidObject item : items) {
                        if (!(item instanceof CaseItemStatement)) {
                            return null;
                        }
                        IHidObject itemCondition = ((CaseItemStatement)item).getCondition();
                        if (HidUtils.isHidImplicit(itemCondition) && ((IHidImplicit)itemCondition).isOthers()) continue;
                        IELParamValue itemValue = XUtils.getValue(ELUtils.evaluateForSize(itemCondition, evaluator, this.blockNamedElement, guardian));
                        if (ELUtils.isUnsuccessfulEval(itemValue) || !(itemValue.getDVTNumber() instanceof VlogBitVector) && !(itemValue.getDVTNumber() instanceof VlogAbstractRealNumber)) {
                            testContext = BitVectorContext.of((IRfNamedElement)this.blockNamedElement.getEnclosingScope(), false);
                            break;
                        }
                        testContext.transform(itemValue);
                    }
                }
            } else {
                testContext = BitVectorContext.of(this.blockNamedElement != null ? (IRfNamedElement)this.blockNamedElement.getEnclosingScope() : null, false);
            }
            return testContext;
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            guardian.checkBuildCanceled();
            this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XCaseEvalScope) {
                ((XCaseEvalScope)xEvalScope).hotSwap(this.getCondition(), this.getItems(), this.caseBlockQualifier, this.isVLOG);
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            BitVectorContext testContext = this.getTestContext(evaluator, guardian);
            if (testContext == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            XCaseEvalScope xEvalScope = new XCaseEvalScope(this.blockNamedElement, this, evaluator, testContext, guardian, this.getCondition(), this.getItems(), this.caseBlockQualifier, this.isVLOG);
            guardian.startEvalScope(xEvalScope);
            return xEvalScope.execute(guardian.getActiveThread());
        }
    }

    public static class ConcurrentAssertStatement
    extends AssertStatement {
        private static final long serialVersionUID = 1L;
        private AssertTM assertTM;

        private ConcurrentAssertStatement(IRfNamedElement namedElement, IHidObject condition, IHidObject ifProg, IHidObject elseProg, int startOffset, int startVirtualOffset, int startLine) {
            super(namedElement, condition, ifProg, elseProg, startOffset, startVirtualOffset, startLine);
        }

        @Override
        public AssertTM transformConcurrentAssert(ConcurrentAssertStatement statement, IHidEvaluator evaluator, IRfAssertExpectElement assertElement, HidOperator alwaysEventControlOperator, IHidEvaluationGuardian guardian) {
            if (!guardian.isInterpreter()) {
                return null;
            }
            IHidObject condition = this.getLHValue();
            if (!HidUtils.isOperator(condition)) {
                return null;
            }
            XValueHolderFactory factory = guardian.getFactory();
            if (factory == null) {
                return null;
            }
            this.assertTM = ((IHidOperator)condition).transformConcurrentAssert(this, evaluator, assertElement, alwaysEventControlOperator, guardian);
            if (this.assertTM == null) {
                return null;
            }
            for (IHid hid : this.assertTM.hids) {
                IRfNamedElement resolvedElement = HidUtils.getResolvedElement(hid);
                if (resolvedElement instanceof IRfFieldElement && ((IRfFieldElement)resolvedElement).isVariable()) continue;
                ELParamValueScope result = ELUtils.evaluate(hid, evaluator, BitVectorContext.of(BitVectorContext.NO_CONTEXT, null), guardian);
                factory.registerPreponedVar(result);
            }
            return this.assertTM;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            IRfDefElement declaration = this.namedElement.getDeclaration();
            if (declaration == null) {
                guardian.logError("Fail to evaluate assertion '" + this.namedElement.getName() + "'");
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            guardian.callbackStartThread(this, this.namedElement.getName(), this, evaluator, declaration.getParserPath(), "assertion", XThreadDefinition.ThreadKind.ASSERTION);
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        public void evaluateBranch(IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, boolean isConditionTrue) {
            boolean prevEvalAssert = guardian.setEvalAssert(false);
            try {
                if (!(evaluator instanceof XValueHolder)) {
                    return;
                }
                guardian.getFactory().registerAssertResult(((XValueHolder)evaluator).getInstanceScope().getInstancePath(), (IRfAssertExpectElement)this.namedElement, isConditionTrue ? AssertTM.AssertResult.FINISH : AssertTM.AssertResult.FAILED);
                ELUtils.evaluate(isConditionTrue ? this.ifProg : this.elseProg, evaluator, bvContext, guardian);
            }
            finally {
                guardian.setEvalAssert(prevEvalAssert);
            }
        }

        public boolean isComputed() {
            return this.assertTM != null && this.assertTM.getClockingEvent() != null && !this.assertTM.transitionTable.isEmpty();
        }

        public IHidOperator getFirstClockEvent() {
            if (!this.isComputed()) {
                return null;
            }
            return this.assertTM.getClockingEvent();
        }

        public AssertTM getAssertTM() {
            return this.assertTM;
        }
    }

    public static class CovergroupStatement
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        private IRfCovergroup namedElement;
        private List<CoverpointStatement> coverpoints;
        private Map<String, IHidOperator> options;
        private List<IHidOperator> events;
        private XCGroupValueHolder valueHolder;
        private int virtualOffset;

        private CovergroupStatement(IRfCovergroup namedElement, int startOffset, int startVirtualOffset, int startLine, List<CoverpointStatement> coverpoints, Map<String, IHidOperator> options, List<IHidOperator> events) {
            super(IHidOperatorConstants.OperatorType.COVERGROUP_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "covergroup_statement", startOffset, startLine, startOffset, -1, 0L);
            this.namedElement = namedElement;
            this.coverpoints = coverpoints;
            this.options = options;
            this.events = events;
            this.virtualOffset = startVirtualOffset;
        }

        @Override
        public HidOperatorOccurrence getOccurrence() {
            if (this.namedElement != null) {
                return new HidOperatorOccurrence(this.offset, this.virtualOffset, this.line, new HidOccurrenceBounds(this.offset, this.virtualOffset, -1, -1), 0L, this.namedElement.xGetReparseInfo());
            }
            return super.getOccurrence();
        }

        @Override
        public int getVirtualOffset() {
            return this.virtualOffset;
        }

        @Override
        public int getUsageIndex() {
            if (this.namedElement != null) {
                return this.namedElement.getDeclarationIndex();
            }
            return super.getUsageIndex();
        }

        @Override
        public String getLabel() {
            return XUtils.getName(this.namedElement);
        }

        public void setNamedElement(IRfNamedElement namedElement) {
            if (namedElement instanceof IRfCovergroup) {
                this.namedElement = (IRfCovergroup)namedElement;
            }
        }

        public IRfCovergroup getNamedElement() {
            return this.namedElement;
        }

        @Override
        public LanguageKind getLanguageKind() {
            return this.namedElement != null ? this.namedElement.getLanguageKind() : LanguageKind.VLOG;
        }

        public boolean hasLocalMembers() {
            if (this.namedElement == null) {
                return false;
            }
            if (!this.namedElement.isAnonymous()) {
                return true;
            }
            int hasMembers = XGlobalCache.INSTANCE.hasMambers(this.namedElement);
            if (hasMembers >= 0) {
                return hasMembers > 0;
            }
            boolean result = XUtils.hasLocalMembers(this.namedElement);
            XGlobalCache.INSTANCE.hasMambers(this.namedElement, result);
            return result;
        }

        public List<CoverpointStatement> getCoverpoints() {
            return this.coverpoints;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            if (this.valueHolder != null) {
                this.valueHolder.sample(null, guardian);
            }
            return ELParamValueScope.UNDEFINED_VALUE;
        }

        public XCGroupValueHolder getValueHolder() {
            return this.valueHolder;
        }

        public void setValueHolder(XCGroupValueHolder valueHolder) {
            this.valueHolder = valueHolder;
        }

        public List<IHidOperator> getEvents() {
            return this.events;
        }

        public Map<String, IHidOperator> getOptions() {
            return this.options;
        }
    }

    public static class CoverpointStatement
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        private IRfCoverpoint namedElement;
        private IHidObject enableExpression;
        private IHidObject expression;
        private List<BinAssignmentStatement> bins;
        private Map<String, IHidOperator> options;
        private BinAssignmentStatement defaultBin;
        private int virtualOffset;

        private CoverpointStatement(IRfCoverpoint namedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject expression, List<BinAssignmentStatement> bins, BinAssignmentStatement defaultBin, Map<String, IHidOperator> options) {
            super(IHidOperatorConstants.OperatorType.COVERPOINT_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "coverpoint_statement", startOffset, startLine, startOffset, -1, 0L);
            this.namedElement = namedElement;
            this.bins = bins;
            this.options = options;
            this.defaultBin = defaultBin;
            if (expression instanceof HidOperator) {
                this.expression = ((HidOperator)expression).lhValue;
                this.enableExpression = ((HidOperator)expression).rhValues.get(0);
            } else {
                this.expression = expression;
            }
            this.virtualOffset = startVirtualOffset;
        }

        @Override
        public HidOperatorOccurrence getOccurrence() {
            if (this.namedElement != null) {
                return new HidOperatorOccurrence(this.offset, this.virtualOffset, this.line, new HidOccurrenceBounds(this.offset, this.virtualOffset, -1, -1), 0L, this.namedElement.xGetReparseInfo());
            }
            return super.getOccurrence();
        }

        @Override
        public int getVirtualOffset() {
            return this.virtualOffset;
        }

        @Override
        public int getUsageIndex() {
            if (this.namedElement != null) {
                return this.namedElement.getDeclarationIndex();
            }
            return super.getUsageIndex();
        }

        @Override
        public String getLabel() {
            return XUtils.getName(this.namedElement);
        }

        public void setNamedElement(IRfNamedElement namedElement) {
            if (namedElement instanceof IRfCoverpoint) {
                this.namedElement = (IRfCoverpoint)namedElement;
            }
        }

        public IRfCoverpoint getNamedElement() {
            return this.namedElement;
        }

        @Override
        public LanguageKind getLanguageKind() {
            return this.namedElement != null ? this.namedElement.getLanguageKind() : LanguageKind.VLOG;
        }

        public boolean hasLocalMembers() {
            if (this.namedElement == null) {
                return false;
            }
            if (!this.namedElement.isAnonymous()) {
                return true;
            }
            int hasMembers = XGlobalCache.INSTANCE.hasMambers(this.namedElement);
            if (hasMembers >= 0) {
                return hasMembers > 0;
            }
            boolean result = XUtils.hasLocalMembers(this.namedElement);
            XGlobalCache.INSTANCE.hasMambers(this.namedElement, result);
            return result;
        }

        public boolean isCross() {
            return this.namedElement.isCross();
        }

        public void addCovergroupOptions(Map<String, IHidOperator> cgOptions) {
            if (cgOptions == null || cgOptions.isEmpty()) {
                return;
            }
            for (Map.Entry<String, IHidOperator> cgOptionsEntry : cgOptions.entrySet()) {
                this.options.putIfAbsent(cgOptionsEntry.getKey(), cgOptionsEntry.getValue());
            }
        }

        public List<BinAssignmentStatement> getBins() {
            return this.bins;
        }

        public IHidObject getExpression() {
            return this.expression;
        }

        public IHidObject getEnableExpression() {
            return this.enableExpression;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj.hashCode() == this.hashCode();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        public BinAssignmentStatement getDefaultBin() {
            return this.defaultBin;
        }

        public Map<String, IHidOperator> getOptions() {
            return this.options;
        }
    }

    public static class DeclarationStatement
    extends HidOperator
    implements IDeclarationStatement {
        private static final long serialVersionUID = 2L;
        private IRfFieldElement field;
        private int virtualOffset;

        private DeclarationStatement(IRfFieldElement field) {
            super(IHidOperatorConstants.OperatorType.DECLARATION_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "declaration", field.getDeclaration().getStartOffset(), -1, -1, -1, 0L);
            this.field = field;
            this.addLHValue(HidUtils.makeStandInHid(field.getName(), field, HidOccurrence.DUMMY_OCCURRENCE, 0L), false);
            IRfDefElement declaration = field.getDeclaration();
            this.virtualOffset = declaration != null ? declaration.getStartVirtualOffset() : -1;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            String name = this.field.getName();
            if (guardian.isInterpreter()) {
                if (!(this.field.getEnclosingScope() instanceof IRfActionBlockElement)) {
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                XValueHolderFactory factory = guardian.getFactory();
                IHidEvaluator enclosingEvaluator = evaluator;
                while (enclosingEvaluator instanceof XValueHolder) {
                    if (factory.hasMember(enclosingEvaluator.getNamedElement(), name)) {
                        if (evaluator.getValueDirectly(name) != null) {
                            ((XValueHolder)evaluator).getValues().getEntries().remove(name);
                        }
                        return ELParamValueScope.IMPLICIT_RESULT;
                    }
                    enclosingEvaluator = ((XValueHolder)enclosingEvaluator).getEnclosingValue();
                }
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            if (!(evaluator instanceof ELParamValuesHidEvaluator)) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            ELParamValues lastContainer = evaluator.getLastValueContainer();
            if (lastContainer.containsKey(name)) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            BitVectorContext dataTypeBitVectorContext = this.field.getDataTypeBitVectorContext(evaluator, false, null, evaluator.getManager());
            IELParamValue value = ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
            if (dataTypeBitVectorContext != null) {
                DVTNumber contextNumber = dataTypeBitVectorContext.getContextNumber();
                if (DVTNumber.isUndefined(contextNumber)) {
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                value = ELParamValues.ParamValueNumber.of(contextNumber.getDefaultValue(false));
            }
            lastContainer.putDirectly(name, value);
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }

        @Override
        public IRfFieldElement getField() {
            return this.field;
        }

        @Override
        public String getFieldName() {
            return this.field.getName();
        }

        @Override
        public int getVirtualOffset() {
            return this.virtualOffset;
        }

        @Override
        public int getUsageIndex() {
            return this.field.getDeclarationIndex();
        }
    }

    static abstract class DelayedAssign
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        protected BigDecimal delayRising;
        protected BigDecimal delayFalling;
        protected BigDecimal delayTurnoff;
        protected HidOperatorOccurrence occurrence;

        protected DelayedAssign(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, HidOperatorOccurrence occurrence) {
            super(operatorType, operatorKind, operatorText, occurrence.getOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getCloseBoundary(), occurrence.getQualifiers());
            this.occurrence = occurrence;
        }

        protected BigDecimal getRisingDelay(IHidObject hidOperator, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            IHidObject delayHidObject;
            IHidObject iHidObject = delayHidObject = HidUtils.isOperator(hidOperator) ? ((HidOperator)hidOperator).lhValue : hidOperator;
            if (this.delayRising == null || !HidUtils.isHidImplicit(delayHidObject)) {
                this.delayRising = this.computeDelay(delayHidObject, evaluator, null, guardian);
            }
            return this.delayRising;
        }

        protected BigDecimal getFallingDelay(HidOperator hidOperator, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            IHidObject delayHidObject;
            IHidObject iHidObject = delayHidObject = hidOperator.rhValues.size() == 2 ? hidOperator.rhValues.get(1) : hidOperator.rhValues.get(0);
            if (this.delayFalling == null || !HidUtils.isHidImplicit(delayHidObject)) {
                this.delayFalling = this.computeDelay(delayHidObject, evaluator, null, guardian);
            }
            return this.delayFalling;
        }

        protected BigDecimal getTurnoffDelay(HidOperator hidOperator, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            if (hidOperator.rhValues.size() == 2) {
                IHidObject delayHidObject = hidOperator.rhValues.get(0);
                if (this.delayTurnoff == null || !HidUtils.isHidImplicit(delayHidObject)) {
                    this.delayTurnoff = this.computeDelay(delayHidObject, evaluator, null, guardian);
                }
                return this.delayTurnoff;
            }
            this.delayTurnoff = this.getMinimumDelay(hidOperator, evaluator, guardian);
            return this.delayTurnoff;
        }

        protected BigDecimal getMinimumDelay(HidOperator hidOperator, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            BigDecimal risingDelay = this.getRisingDelay(hidOperator, evaluator, guardian);
            BigDecimal fallingDelay = this.getFallingDelay(hidOperator, evaluator, guardian);
            BigDecimal turnoffDelay = hidOperator.rhValues.size() == 2 ? this.getTurnoffDelay(hidOperator, evaluator, guardian) : null;
            BigDecimal delay = fallingDelay;
            if (risingDelay.compareTo(fallingDelay) < 0) {
                delay = risingDelay;
            }
            if (turnoffDelay != null && turnoffDelay.compareTo(delay) < 0) {
                delay = turnoffDelay;
            }
            return delay;
        }

        private BigDecimal computeDelay(IHidObject delayHidObject, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            ELParamValueScope delayValue;
            if (HidUtils.isOperator(delayHidObject) && ((HidOperator)delayHidObject).isMinTypMax()) {
                MinTypMax minTypMax = guardian.getManager().getMinTypMaxSelection();
                delayHidObject = XUtils.selectMinTypMax(delayHidObject, minTypMax);
            }
            if (ELUtils.isUnsuccessfulEval(delayValue = ELUtils.evaluate(delayHidObject, evaluator, context, guardian.copy()))) {
                guardian.logError("Fail to evaluate timing delay expression '" + delayHidObject + "'");
                return BigDecimal.ZERO;
            }
            DVTNumber delayNumber = delayValue.getDVTNumber();
            if (DVTNumber.isUndefined(delayNumber)) {
                guardian.logError("Fail to evaluate timing delay expression '" + delayHidObject + "'");
                return BigDecimal.ZERO;
            }
            BigDecimal convertedDelay = XUtils.getDelay(delayNumber.doubleValue(), (XValueHolder)evaluator);
            return convertedDelay;
        }

        @Override
        public HidOperatorOccurrence getOccurrence() {
            return this.occurrence;
        }

        @Override
        public int getVirtualOffset() {
            return this.occurrence.getVirtualOffset();
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }
    }

    public static class DelayedContinuousAssign
    extends DelayedAssign {
        private static final long serialVersionUID = 2L;

        private DelayedContinuousAssign(HidOperator delayControl, HidOperator netDeclaration, HidOperatorOccurrence occurrence) {
            super(IHidOperatorConstants.OperatorType.DELAYED_CONTINUOUS_ASSIGN.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "delayed_continuous_assign", occurrence);
            this.addLHValue(delayControl, false);
            this.addRHValue(netDeclaration, false);
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            ELParamValueScope leftValueScope;
            guardian.checkBuildCanceled();
            HidOperator delayControl = (HidOperator)this.getLHValue();
            HidOperator assignOperator = (HidOperator)this.getFirstRHValue();
            IHidObject assignLHSide = assignOperator.getLHValue();
            IHidObject assignRHSide = assignOperator.getFirstRHValue();
            IRfNamedElement origin = context == null ? null : context.getOrigin();
            BitVectorContext noContext = context == null ? BitVectorContext.of(origin, false) : context;
            boolean prevLHS = guardian.setLHS(true);
            try {
                leftValueScope = this.evaluateAsLHValue(assignLHSide, evaluator, noContext, guardian);
                if (ELUtils.isUnsuccessfulEval(leftValueScope)) {
                    ELParamValueScope eLParamValueScope = ELParamValueScope.UNDEFINED_VALUE;
                    return eLParamValueScope;
                }
            }
            finally {
                guardian.setLHS(prevLHS);
            }
            BitVectorContext rightOpContext = XValueHolderFactory.getRightOpContext(XUtils.getValue(leftValueScope), assignRHSide, origin, guardian.getFactory());
            IELParamValue rightValue = XUtils.getValue(this.evaluateOperand(assignRHSide, evaluator, rightOpContext, guardian));
            if (ELUtils.isUnsuccessfulEval(rightValue)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            boolean isRisingFallingDelay = XUtils.isRisingFallingDelay(delayControl);
            XUtils.TransitionKind transitionKind = isRisingFallingDelay ? XUtils.getTransitionKind(rightValue) : XUtils.TransitionKind.NONE;
            BigDecimal delay = switch (transitionKind) {
                case XUtils.TransitionKind.RISING -> this.getRisingDelay(delayControl.lhValue, evaluator, guardian);
                case XUtils.TransitionKind.FALLING -> this.getFallingDelay((HidOperator)delayControl.lhValue, evaluator, guardian);
                case XUtils.TransitionKind.TURN_OFF -> this.getTurnoffDelay((HidOperator)delayControl.lhValue, evaluator, guardian);
                case XUtils.TransitionKind.MINIMUM -> this.getMinimumDelay((HidOperator)delayControl.lhValue, evaluator, guardian);
                default -> this.getRisingDelay(delayControl, evaluator, guardian);
            };
            BigDecimal convertedDelay = guardian.getFactory().getCurrentSimTime().signum() <= 0 && delay.signum() == 0 ? XUtils.MINUS_ONE_DECIMAL : delay;
            XValueHolderFactory factory = guardian.getFactory();
            ParserPath parserPath = factory.getCurrentParserPath();
            guardian.callbackDelayedAssign(convertedDelay, XSimRegion.XRegionKind.Active, () -> {
                factory.setCurrentParserPath(parserPath);
                factory.setCurrentLineNumber(this.line);
                leftValueScope.doUpdate(this, rightValue, 1, evaluator, assignLHSide, guardian.copy());
            });
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        public HidOperator getAssignOperator() {
            return (HidOperator)this.getFirstRHValue();
        }

        @Override
        public int getUsageIndex() {
            HidOperator assign = this.getAssignOperator();
            return assign != null ? assign.getUsageIndex() : super.getUsageIndex();
        }

        @Override
        public IHidObject xGetAssignmentLHS() {
            HidOperator assign = this.getAssignOperator();
            return assign != null ? assign.getLHValue() : null;
        }
    }

    public static class DelayedProceduralAssignment
    extends DelayedAssign {
        private static final long serialVersionUID = 2L;

        private DelayedProceduralAssignment(HidOperator delayOperator, HidOperatorOccurrence occurrence) {
            super(IHidOperatorConstants.OperatorType.DELAYED_ASSIGNMENT_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "delayed_assign", occurrence);
            this.addLHValue(delayOperator, false);
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            ELParamValueScope leftValueScope;
            guardian.checkBuildCanceled();
            final HidOperator delayControlAndAssign = (HidOperator)this.getLHValue();
            ListContainer<IHidObject> assignSides = delayControlAndAssign.getRHValues();
            if (assignSides == null || assignSides.size() != 2) {
                throw new UnknownHidObjectEvaluationException(delayControlAndAssign);
            }
            final IHidObject assignLHSide = assignSides.get(0);
            IHidObject assignRHSide = assignSides.get(1);
            IRfNamedElement origin = context == null ? null : context.getOrigin();
            BitVectorContext noContext = context == null ? BitVectorContext.of(origin, false) : context;
            boolean prevLHS = guardian.setLHS(true);
            try {
                leftValueScope = this.evaluateAsLHValue(assignLHSide, evaluator, noContext, guardian);
                if (ELUtils.isUnsuccessfulEval(leftValueScope)) {
                    ELParamValueScope eLParamValueScope = ELParamValueScope.UNDEFINED_VALUE;
                    return eLParamValueScope;
                }
            }
            finally {
                guardian.setLHS(prevLHS);
            }
            BitVectorContext rightOpContext = XValueHolderFactory.getRightOpContext(XUtils.getValue(leftValueScope), assignRHSide, origin, guardian.getFactory());
            final IELParamValue rightValue = XUtils.getValue(this.evaluateOperand(assignRHSide, evaluator, rightOpContext, guardian));
            if (ELUtils.isUnsuccessfulEval(rightValue)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            boolean isRisingFallingDelay = XUtils.isRisingFallingDelay(delayControlAndAssign);
            XUtils.TransitionKind transitionKind = isRisingFallingDelay ? XUtils.getTransitionKind(rightValue) : XUtils.TransitionKind.NONE;
            final BigDecimal convertedDelay = switch (transitionKind) {
                case XUtils.TransitionKind.RISING -> this.getRisingDelay(delayControlAndAssign.lhValue, evaluator, guardian);
                case XUtils.TransitionKind.FALLING -> this.getFallingDelay((HidOperator)delayControlAndAssign.lhValue, evaluator, guardian);
                case XUtils.TransitionKind.TURN_OFF -> this.getTurnoffDelay((HidOperator)delayControlAndAssign.lhValue, evaluator, guardian);
                case XUtils.TransitionKind.MINIMUM -> this.getMinimumDelay((HidOperator)delayControlAndAssign.lhValue, evaluator, guardian);
                default -> this.getRisingDelay(delayControlAndAssign, evaluator, guardian);
            };
            boolean isNBAssignment = this.isNBAssignment();
            if (isNBAssignment) {
                XValueHolderFactory factory = guardian.getFactory();
                ParserPath parserPath = factory.getCurrentParserPath();
                guardian.callbackDelayedAssign(convertedDelay, XSimRegion.XRegionKind.NBA, () -> {
                    factory.setCurrentParserPath(parserPath);
                    factory.setCurrentLineNumber(this.line);
                    leftValueScope.doUpdate(this, rightValue, 1, evaluator, assignLHSide, guardian.copy());
                });
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            ArrayListContainer<IHidObject> statements = new ArrayListContainer<IHidObject>(2);
            HidOperator statement = new HidOperator(IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "[#delay]", this.occurrence.getOffset(), this.occurrence.getLine(), -1, -1, 0L){
                private static final long serialVersionUID = 1L;

                @Override
                public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                    guardian.callbackYieldThread(convertedDelay);
                    return ELParamValueScope.IMPLICIT_RESULT;
                }

                @Override
                public LanguageKind getLanguageKind() {
                    return delayControlAndAssign.getLanguageKind();
                }

                @Override
                public int getVirtualOffset() {
                    return occurrence.getVirtualOffset();
                }

                @Override
                public int getUsageIndex() {
                    return delayControlAndAssign.getUsageIndex();
                }
            };
            statements.add(statement);
            statement = new HidOperator(IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "[assign]", this.occurrence.getOffset(), this.occurrence.getLine(), -1, -1, 0L){
                private static final long serialVersionUID = 1L;

                @Override
                public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                    leftValueScope.doUpdate(this, rightValue, 1, evaluator, assignLHSide, guardian);
                    return ELParamValueScope.IMPLICIT_RESULT;
                }

                @Override
                public LanguageKind getLanguageKind() {
                    return delayControlAndAssign.getLanguageKind();
                }

                @Override
                public int getVirtualOffset() {
                    return occurrence.getVirtualOffset();
                }

                @Override
                public int getUsageIndex() {
                    return delayControlAndAssign.getUsageIndex();
                }
            };
            statements.add(statement);
            XSeqBlockEvalScope xEvalScope = new XSeqBlockEvalScope(this, evaluator, null, guardian, statements);
            guardian.startEvalScope(xEvalScope);
            return xEvalScope.execute(guardian.getActiveThread());
        }

        @Override
        public boolean isNBAssignment() {
            HidOperator original = (HidOperator)this.getLHValue();
            return original.hasQualifier(HidQualifierCache.IS_CONTROLLED_NON_BLOCKING_ASSIGN_QUALIFIER);
        }

        @Override
        public IHidObject xGetAssignmentLHS() {
            HidOperator delayControlAndAssign = (HidOperator)this.getLHValue();
            ListContainer<IHidObject> assignSides = delayControlAndAssign.getRHValues();
            return assignSides != null && assignSides.size() == 2 ? assignSides.get(0) : null;
        }

        @Override
        public int getUsageIndex() {
            HidOperator delayControl = (HidOperator)this.getLHValue();
            return delayControl != null ? delayControl.getUsageIndex() : super.getUsageIndex();
        }
    }

    public static class DelayedTriggerEvent
    extends DelayedAssign {
        private static final long serialVersionUID = 2L;

        private DelayedTriggerEvent(HidOperator delay, HidOperatorOccurrence occurrence) {
            super(IHidOperatorConstants.OperatorType.DELAYED_TRIGGER_EVENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "delayed_trigger_event", occurrence);
            this.addLHValue(delay, false);
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            HidOperator delayControl = (HidOperator)this.getLHValue();
            ListContainer<IHidObject> triggerSides = delayControl.getRHValues();
            if (triggerSides == null || triggerSides.size() != 1) {
                throw new UnknownHidObjectEvaluationException(delayControl);
            }
            IHidObject triggerSide = triggerSides.get(0);
            ELParamValueScope value = this.evaluateOperand(triggerSide, evaluator, null, guardian);
            if (ELUtils.isUnsuccessfulEval(value)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            BigDecimal convertedDelay = this.getRisingDelay(delayControl, evaluator, guardian);
            XValueHolderFactory factory = guardian.getFactory();
            ParserPath parserPath = factory.getCurrentParserPath();
            guardian.callbackDelayedAssign(convertedDelay, XSimRegion.XRegionKind.Active, () -> {
                factory.setCurrentParserPath(parserPath);
                factory.setCurrentLineNumber(this.line);
                ((XValueHolder.XEventValueHolder)eLParamValueScope.value).trigger();
                Hid hid = XUtils.getParentHid(triggerSide);
                int uniqueId = -1;
                if (HidUtils.isHid(triggerSide)) {
                    IELParamValue original1 = XUtils.getOriginal(eLParamValueScope.value, true);
                    uniqueId = factory.getUniqueId(original1, false);
                } else {
                    ELParamValueScope hidValue = ELUtils.evaluate(hid, evaluator, null, guardian);
                    IELParamValue original2 = XUtils.getOriginal(hidValue.value, true);
                    uniqueId = factory.getUniqueId(original2, false);
                }
                guardian.callbackValueChanged(uniqueId, this, evaluator, hid, null, ELParamValues.ParamValueNumber.of(VlogBitVector.ZERO), ELParamValues.ParamValueNumber.of(VlogBitVector.ONE));
                factory.scheduleWaitingThreads(uniqueId, XSimRegion.XRegionKind.Active);
            });
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        @Override
        public int getVirtualOffset() {
            HidOperator delayControl = (HidOperator)this.getLHValue();
            return delayControl.getVirtualOffset();
        }

        @Override
        public int getUsageIndex() {
            HidOperator delayControl = (HidOperator)this.getLHValue();
            return delayControl.getUsageIndex();
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }
    }

    public static class DoWhileLoopStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private final BitVectorContext bvContext;

        private DoWhileLoopStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject condition, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.DO_WHILE_LOOP_STATEMENT.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "do_while_loop_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(condition, false);
            this.addRHValue(statement, false);
            this.bvContext = BitVectorContext.of(blockNamedElement != null ? (IRfNamedElement)blockNamedElement.getEnclosingScope() : null, false);
        }

        private IHidObject getCondition() {
            return this.getLHValue();
        }

        private IHidObject getStatement() {
            ListContainer<IHidObject> rhValues = this.getRHValues();
            return rhValues != null && !rhValues.isEmpty() ? rhValues.get(0) : null;
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            guardian.checkBuildCanceled();
            this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XDoWhileEvalScope) {
                ((XDoWhileEvalScope)xEvalScope).hotSwap(this.getStatement(), this.getCondition());
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            XDoWhileEvalScope xEvalScope = new XDoWhileEvalScope(this.blockNamedElement, this, evaluator, this.bvContext, guardian.copy(), this.getStatement(), this.getCondition());
            guardian.startEvalScope(xEvalScope);
            return xEvalScope.execute(guardian.getActiveThread());
        }
    }

    public static class EventControlledAssignment
    extends HidOperator {
        private static final long serialVersionUID = 2L;
        private HidOperatorOccurrence occurrence;
        private final boolean isCaseSensitive;
        private IHidObject cachedEventControl;

        private EventControlledAssignment(HidOperator eventControl, HidOperatorOccurrence occurrence, boolean isCaseSensitive) {
            super(IHidOperatorConstants.OperatorType.EVENT_CONTROLLED_ASSIGNMENT_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "event_cntrl_assign", occurrence.getOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getCloseBoundary(), occurrence.getQualifiers());
            this.addLHValue(eventControl, false);
            this.isCaseSensitive = isCaseSensitive;
            this.occurrence = occurrence;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            ELParamValueScope leftValueScope;
            IHidObject eventControlOp;
            guardian.checkBuildCanceled();
            final HidOperator original = (HidOperator)this.getLHValue();
            IHidObject iHidObject = eventControlOp = this.cachedEventControl == null ? original.getLHValue() : this.cachedEventControl;
            if (eventControlOp == null) {
                throw new UnknownHidObjectEvaluationException(original);
            }
            ListContainer<IHidObject> assignSides = original.getRHValues();
            if (assignSides == null || assignSides.size() != 2) {
                throw new UnknownHidObjectEvaluationException(original);
            }
            final ArrayListContainer<IHidObject> statements = new ArrayListContainer<IHidObject>(2);
            statements.add(null);
            final IHidObject assignLHSide = assignSides.get(0);
            final IHidObject assignRHSide = assignSides.get(1);
            IRfNamedElement origin = context == null ? null : context.getOrigin();
            BitVectorContext noContext = context == null ? BitVectorContext.of(origin, false) : context;
            boolean prevLHS = guardian.setLHS(true);
            try {
                leftValueScope = this.evaluateAsLHValue(assignLHSide, evaluator, noContext, guardian);
                if (ELUtils.isUnsuccessfulEval(leftValueScope)) {
                    ELParamValueScope eLParamValueScope = ELParamValueScope.UNDEFINED_VALUE;
                    return eLParamValueScope;
                }
            }
            finally {
                guardian.setLHS(prevLHS);
            }
            BitVectorContext rightOpContext = XValueHolderFactory.getRightOpContext(XUtils.getValue(leftValueScope), assignRHSide, origin, guardian.getFactory());
            final IELParamValue rightValue = XUtils.getValue(this.evaluateOperand(assignRHSide, evaluator, rightOpContext, guardian));
            if (ELUtils.isUnsuccessfulEval(rightValue)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            HidOperator assignStatement = new HidOperator(IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "[assign]", this.occurrence.getOffset(), this.occurrence.getLine(), -1, -1, 0L){
                private static final long serialVersionUID = 1L;

                @Override
                public IHidObject getLHValue() {
                    return assignLHSide;
                }

                @Override
                public ListContainer<IHidObject> getRHValues() {
                    return assignRHSide;
                }

                @Override
                public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                    leftValueScope.doUpdate(this, rightValue, 1, evaluator, assignLHSide, guardian);
                    return ELParamValueScope.IMPLICIT_RESULT;
                }

                @Override
                public LanguageKind getLanguageKind() {
                    return original.getLanguageKind();
                }

                @Override
                public int getVirtualOffset() {
                    return occurrence.getVirtualOffset();
                }

                @Override
                public int getUsageIndex() {
                    return original.getUsageIndex();
                }
            };
            assignStatement.addQualifier(HidQualifierCache.IS_BLOCKING_ASSIGN_QUALIFIER);
            statements.add(assignStatement);
            if (XUtils.isSensitiveAll(eventControlOp)) {
                HidOperator edgeOperator = guardian.getFactory().transformEdgeControl(original, assignStatement, evaluator, guardian);
                eventControlOp = this.cachedEventControl = edgeOperator.getLHValue();
            }
            IHidObject repeatCountOp = null;
            if (HidUtils.isOperator(eventControlOp) && ((HidOperator)eventControlOp).isRepeat()) {
                repeatCountOp = ((HidOperator)eventControlOp).getLHValue();
                eventControlOp = ((HidOperator)eventControlOp).getRHValues().get(0);
            }
            HidOperator statement = original.shallowCopy();
            statement.setLHValue(eventControlOp);
            statement.setRHValues(null);
            if (repeatCountOp != null) {
                statement = new RepeatLoopStatement(null, this.occurrence.getOffset(), this.occurrence.getVirtualOffset(), this.occurrence.getLine(), repeatCountOp, statement, this.isCaseSensitive);
            }
            statements.set(0, statement);
            if (evaluator.isInterpreter() && this.isNBAssignment()) {
                statement = new HidOperator(IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "[statements]", this.occurrence.getOffset(), this.occurrence.getLine(), -1, -1, 0L){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                        XSeqBlockEvalScope xEvalScope = new XSeqBlockEvalScope(this, evaluator, context, guardian, statements);
                        guardian.startEvalScope(xEvalScope);
                        return xEvalScope.execute(guardian.getActiveThread());
                    }

                    @Override
                    public LanguageKind getLanguageKind() {
                        return original.getLanguageKind();
                    }

                    @Override
                    public int getVirtualOffset() {
                        return occurrence.getVirtualOffset();
                    }

                    @Override
                    public int getUsageIndex() {
                        return original.getUsageIndex();
                    }
                };
                guardian.callbackNbaThread(statement, evaluator, EC_NBA_ASSIGN_PARSER_PATH);
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            XSeqBlockEvalScope xEvalScope = new XSeqBlockEvalScope(this, evaluator, null, guardian, statements);
            guardian.startEvalScope(xEvalScope);
            return xEvalScope.execute(guardian.getActiveThread());
        }

        @Override
        public boolean isNBAssignment() {
            HidOperator original = (HidOperator)this.getLHValue();
            return original.hasQualifier(HidQualifierCache.IS_CONTROLLED_NON_BLOCKING_ASSIGN_QUALIFIER);
        }

        @Override
        public IHidObject xGetAssignmentLHS() {
            HidOperator original = (HidOperator)this.getLHValue();
            ListContainer<IHidObject> assignSides = original.getRHValues();
            return assignSides != null && assignSides.size() == 2 ? assignSides.get(0) : null;
        }

        @Override
        public int getVirtualOffset() {
            return this.occurrence.getVirtualOffset();
        }

        @Override
        public int getUsageIndex() {
            HidOperator original = (HidOperator)this.getLHValue();
            return original.getUsageIndex();
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }
    }

    public static class EventControlledTriggerEvent
    extends HidOperator {
        private static final long serialVersionUID = 2L;
        private HidOperatorOccurrence occurrence;

        private EventControlledTriggerEvent(HidOperator eventControl, HidOperatorOccurrence occurrence, boolean isCaseSensitive) {
            super(IHidOperatorConstants.OperatorType.EVENT_CONTROLLED_TRIGGER_EVENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "event_cntrl_trigger_event", occurrence.getOffset(), occurrence.getLine(), occurrence.getOpenBoundary(), occurrence.getCloseBoundary(), occurrence.getQualifiers());
            this.addLHValue(eventControl, false);
            this.occurrence = occurrence;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            final HidOperator original = (HidOperator)this.getLHValue();
            IHidObject eventControlOp = original.getLHValue();
            if (eventControlOp == null) {
                throw new UnknownHidObjectEvaluationException(original);
            }
            ListContainer<IHidObject> triggerSides = original.getRHValues();
            if (triggerSides == null || triggerSides.size() != 1) {
                throw new UnknownHidObjectEvaluationException(original);
            }
            final IHidObject triggerSide = triggerSides.get(0);
            final ELParamValueScope value = this.evaluateOperand(triggerSide, evaluator, null, guardian);
            if (ELUtils.isUnsuccessfulEval(value)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            final ArrayListContainer<HidOperator> statements = new ArrayListContainer<HidOperator>(2);
            HidOperator statement = original.shallowCopy();
            statement.lhValue = eventControlOp;
            statement.rhValues = null;
            statements.add(statement);
            statement = new HidOperator(IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "[statements]", this.occurrence.getOffset(), this.occurrence.getLine(), -1, -1, 0L){
                private static final long serialVersionUID = 1L;

                @Override
                public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                    ((XValueHolder.XEventValueHolder)value.value).trigger();
                    Hid hid = XUtils.getParentHid(triggerSide);
                    XValueHolderFactory factory = guardian.getFactory();
                    int uniqueId = -1;
                    if (HidUtils.isHid(triggerSide)) {
                        IELParamValue original1 = XUtils.getOriginal(value.value, true);
                        uniqueId = factory.getUniqueId(original1, false);
                    } else {
                        ELParamValueScope hidValue = ELUtils.evaluate(hid, evaluator, null, guardian);
                        IELParamValue original2 = XUtils.getOriginal(hidValue.value, true);
                        uniqueId = factory.getUniqueId(original2, false);
                    }
                    guardian.callbackValueChanged(uniqueId, this, evaluator, hid, null, ELParamValues.ParamValueNumber.of(VlogBitVector.ZERO), ELParamValues.ParamValueNumber.of(VlogBitVector.ONE));
                    factory.scheduleWaitingThreads(uniqueId, XSimRegion.XRegionKind.Active);
                    return ELParamValueScope.IMPLICIT_RESULT;
                }

                @Override
                public LanguageKind getLanguageKind() {
                    return original.getLanguageKind();
                }

                @Override
                public int getVirtualOffset() {
                    return occurrence.getVirtualOffset();
                }

                @Override
                public int getUsageIndex() {
                    return original.getUsageIndex();
                }
            };
            statements.add(statement);
            statement = new HidOperator(IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "[statements]", this.occurrence.getOffset(), this.occurrence.getLine(), -1, -1, 0L){
                private static final long serialVersionUID = 1L;

                @Override
                public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                    XSeqBlockEvalScope xEvalScope = new XSeqBlockEvalScope(this, evaluator, context, guardian, statements);
                    guardian.startEvalScope(xEvalScope);
                    return xEvalScope.execute(guardian.getActiveThread());
                }

                @Override
                public LanguageKind getLanguageKind() {
                    return original.getLanguageKind();
                }

                @Override
                public int getVirtualOffset() {
                    return occurrence.getVirtualOffset();
                }

                @Override
                public int getUsageIndex() {
                    return original.getUsageIndex();
                }
            };
            guardian.callbackNbaThread(statement, evaluator, EC_NBA_ASSIGN_PARSER_PATH);
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        @Override
        public int getVirtualOffset() {
            return this.occurrence.getVirtualOffset();
        }

        @Override
        public int getUsageIndex() {
            HidOperator original = (HidOperator)this.getLHValue();
            return original.getUsageIndex();
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }
    }

    public static class ForLoopStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private final BitVectorContext bvContext;
        private IHidObject stepHidObject;
        private IHidObject condition;

        private ForLoopStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject init, IHidObject condition, IHidObject step, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.FOR_LOOP_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "for_loop_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(init, false);
            this.addRHValue(statement, false);
            this.stepHidObject = step;
            this.condition = condition;
            this.bvContext = BitVectorContext.of(blockNamedElement, false);
        }

        private IHidObject getInit() {
            IHidObject initHidObject = this.getLHValue();
            if (initHidObject != null) {
                if (!HidUtils.isOperator(initHidObject)) {
                    return null;
                }
                IHidObject genVarHid = ((HidOperator)initHidObject).getLHValue();
                if (!HidUtils.isHid(genVarHid) && !HidUtils.isHidImplicit(genVarHid)) {
                    return null;
                }
            }
            return initHidObject;
        }

        public IHidObject getCondition() {
            return this.condition;
        }

        public IHidObject getStep() {
            if (!HidUtils.isOperator(this.stepHidObject)) {
                return null;
            }
            return this.stepHidObject;
        }

        private IHidObject getStatement() {
            return this.getFirstRHValue();
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            guardian.checkBuildCanceled();
            this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XForEvalScope) {
                ((XForEvalScope)xEvalScope).hotSwap(this.getStatement(), this.getInit(), this.getStep(), this.getCondition());
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            IHidEvaluator currentEvaluator = evaluator;
            if (currentEvaluator.isInterpreter() && this.hasLocalMembers()) {
                currentEvaluator = currentEvaluator.createEnclosedValueHolder(this.blockNamedElement);
            }
            currentEvaluator.pushScope(this.isCaseSensitive);
            try {
                XForEvalScope xEvalScope = new XForEvalScope(this.blockNamedElement, this, currentEvaluator, this.bvContext, guardian.copy(), this.getStatement(), this.getInit(), this.getStep(), this.getCondition());
                guardian.startEvalScope(xEvalScope);
                ELParamValueScope eLParamValueScope = xEvalScope.execute(guardian.getActiveThread());
                return eLParamValueScope;
            }
            finally {
                currentEvaluator.popScope();
            }
        }
    }

    public static class ForeachLoopStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private BitVectorContext bvContext;
        private ParserPath parserPath;

        private ForeachLoopStatement(IRfNamedElement blockNamedElement, int operatorType, ParserPath parserPath, int startOffset, int startVirtualOffset, int startLine, IHidObject condition, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, operatorType, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "foreach_loop_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(condition, false);
            this.addRHValue(statement, false);
            this.bvContext = BitVectorContext.of(blockNamedElement, false);
            this.parserPath = parserPath;
        }

        @Override
        public void setNamedElement(IRfNamedElement blockNamedElement) {
            super.setNamedElement(blockNamedElement);
            this.bvContext = BitVectorContext.of(blockNamedElement, false);
            ListContainer<IHidObject> rhValues = this.getRHValues();
            if (rhValues instanceof ForeachLoopStatement && ((ForeachLoopStatement)rhValues).getNamedElement() == null && this.getOperatorType() == IHidOperatorConstants.OperatorType.FOREACH_LOOP_CONSTRAINT_STATEMENT.id) {
                ((ForeachLoopStatement)rhValues).setNamedElement(blockNamedElement);
            }
        }

        private IHidObject getStatement() {
            ListContainer<IHidObject> rhValues = this.getRHValues();
            return rhValues != null && !rhValues.isEmpty() ? rhValues.get(0) : null;
        }

        private List<IHidObject> getIndexes() {
            IHidObject condition = this.getLHValue();
            if (!(condition instanceof HidAccess)) {
                return null;
            }
            ListContainer<IHidObject> indexes = ((HidAccess)condition).getSelectsContainer();
            if (indexes == null || indexes.isEmpty()) {
                return null;
            }
            IHidObject lastIndex = indexes.get(indexes.size() - 1);
            if (lastIndex instanceof HidOperator) {
                HidOperator hidOperator = (HidOperator)lastIndex;
                if (IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR != hidOperator.getOperatorKind()) {
                    return null;
                }
                List<IHidObject> resultIndexes = OptimizedUtils.asList(hidOperator.getRHValues(), true);
                Collections.reverse(resultIndexes);
                return resultIndexes;
            }
            return OptimizedUtils.asList(lastIndex, true);
        }

        private IELParamValue getValueToIterate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            BitVectorContext defaultContext;
            IHidObject condition = this.getLHValue();
            if (!(condition instanceof HidAccess)) {
                return null;
            }
            List<IHidObject> indexes = ((HidAccess)condition).getSelects();
            if (indexes == null || indexes.isEmpty()) {
                return null;
            }
            IHidObject hidToIterate = ((HidAccess)condition).getAccessedHidObject();
            IELParamValue valueToIterate = XUtils.getValue(ELUtils.evaluate(hidToIterate, evaluator, defaultContext = BitVectorContext.of(context != null ? context.getOrigin() : null, true), guardian.copy()));
            if (ELUtils.isUnsuccessfulEval(valueToIterate)) {
                throw new UnknownHidObjectEvaluationException(hidToIterate);
            }
            return valueToIterate;
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            guardian.checkBuildCanceled();
            this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XForeachEvalScope) {
                ((XForeachEvalScope)xEvalScope).hotSwap(this.getStatement());
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            ListContainer<IHidObject> statements = this.getRHValues();
            if (statements == null || statements.isEmpty()) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            guardian.checkBuildCanceled();
            IELParamValue valueToIterate = this.getValueToIterate(evaluator, context, guardian);
            if (valueToIterate == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            IHidEvaluator currentEvaluator = evaluator;
            if (currentEvaluator.isInterpreter() && this.hasLocalMembers()) {
                currentEvaluator = currentEvaluator.createEnclosedValueHolder(this.blockNamedElement);
            }
            List<IHidObject> indexes = this.getIndexes();
            XForeachEvalScope xEvalScope = new XForeachEvalScope(this.blockNamedElement, this, currentEvaluator, this.bvContext, guardian, this.getStatement(), valueToIterate, indexes);
            guardian.startEvalScope(xEvalScope);
            return xEvalScope.execute(guardian.getActiveThread());
        }

        @Override
        public XCValue collectConstraints(final XCModel model, final IHidEvaluator evaluator, final BitVectorContext context, final IHidEvaluationGuardian guardian) {
            List<IHidObject> indexes;
            IELParamValue listValue;
            ListContainer<IHidObject> statements;
            block11: {
                block10: {
                    block9: {
                        try {
                            statements = this.getRHValues();
                            if (statements != null && !statements.isEmpty()) break block9;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    listValue = this.getValueToIterate(evaluator, context, guardian);
                    if (listValue != null) break block10;
                    return null;
                }
                indexes = this.getIndexes();
                if (indexes != null) break block11;
                return null;
            }
            final String indexName = ((Hid)indexes.get(0)).getName();
            if (listValue instanceof XArrayValueHolder) {
                int size = ((XArrayValueHolder)listValue).size();
                if (size > 0) {
                    XCValue result = this.collectConstraint(model, indexName, (XArrayValueHolder)listValue, statements, context, evaluator, guardian);
                    if (result != null) {
                        result.setIntVar((IntVariable)result.getIntVar().ne(model.getCachedConstant(true, 32, BigInteger.ZERO)).reify());
                    }
                    return result;
                }
                final XCValue sizeXCValue = model.getListSizeVariable((XArrayValueHolder)listValue, guardian);
                final XCValue sumXCValue = model.getListSumVariableIfExists((XArrayValueHolder)listValue, guardian);
                final IntVariable foreachVar = model.boolVar(null);
                Model.IForeachExpander expander = new Model.IForeachExpander(){

                    /*
                     * Exception decompiling
                     */
                    public void expand() {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 3[TRYBLOCK]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }

                    public Variable getVariable() {
                        return sizeXCValue.getIntVar();
                    }

                    private /* synthetic */ String lambda$0() {
                        return HidUtils.toConstraintString(this);
                    }
                };
                model.addForeachExpander(expander);
                return model.createVariable(foreachVar, true, this);
            }
            int size = ((VlogBitVector)listValue.getDVTNumber()).getFirstDimensionSize();
            XCValue result = this.collectConstraint(model, indexName, size, statements, context, evaluator, guardian);
            if (result != null) {
                result.setIntVar((IntVariable)result.getIntVar().ne(model.getCachedConstant(true, 32, BigInteger.ZERO)).reify());
            }
            return result;
        }

        private XCValue collectConstraint(XCModel model, String indexName, XArrayValueHolder listValue, ListContainer<IHidObject> statements, BitVectorContext context, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            XCValue[] result = new XCValue[1];
            listValue.foreach((indexValue, value) -> {
                xCValueArray[0] = this.collectItemConstraint(model, result[0], indexName, indexValue, statements, context, evaluator, guardian);
                return true;
            });
            return result[0];
        }

        private XCValue collectConstraint(XCModel model, String indexName, int size, ListContainer<IHidObject> statements, BitVectorContext context, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            XCValue result = null;
            int i = 0;
            while (i < size) {
                IELParamValue indexValue = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(i));
                result = this.collectItemConstraint(model, result, indexName, indexValue, statements, context, evaluator, guardian);
                ++i;
            }
            return result;
        }

        private XCValue collectItemConstraint(XCModel model, XCValue result, String indexName, IELParamValue indexValue, ListContainer<IHidObject> statements, BitVectorContext context, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            IntVariable zeroConstant = model.getCachedConstant(true, 32, BigInteger.ZERO);
            XValueHolder.XForIndexHolder currentEvaluator = new XValueHolder.XForIndexHolder((XValueHolder)evaluator, indexName, indexValue);
            boolean isRand = false;
            for (IHidObject statement : statements) {
                XCValue statementXCValue = statement.collectConstraints(model, currentEvaluator, context, guardian.copy());
                if (statementXCValue == null) continue;
                isRand |= statementXCValue.isRand();
                IntVariable statementIntVar = statementXCValue.getIntVar();
                if (!(statementIntVar instanceof BoolVariable)) {
                    statementIntVar = statementIntVar.ne(zeroConstant).reify();
                    statementXCValue.setIntVar(statementIntVar);
                }
                statementXCValue.setHidOperator((IHidOperator)statement);
                result = result == null ? statementXCValue : model.createVariable(result.getIntVar().and(statementIntVar), isRand, this);
            }
            return result;
        }

        @Override
        public ParserPath getParserPath() {
            return this.parserPath;
        }

        @Override
        public String toConstraintString() {
            if (this.lhValue == null || this.rhValues == null) {
                return this.toString();
            }
            return DVTStringUtil.appendString("foreach (", this.lhValue, ") ", this.rhValues);
        }
    }

    public static class ForeverLoopStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private final BitVectorContext bvContext;

        private ForeverLoopStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.FOREVER_LOOP_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "forever_loop_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addRHValue(statement, false);
            this.bvContext = BitVectorContext.of(blockNamedElement, false);
        }

        private IHidObject getStatement() {
            ListContainer<IHidObject> members = this.getRHValues();
            return members != null && members.size() == 1 ? members.get(0) : null;
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            guardian.checkBuildCanceled();
            this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XForeverEvalScope) {
                ((XForeverEvalScope)xEvalScope).hotSwap(this.getStatement());
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            IHidEvaluator currentEvaluator = evaluator;
            IHidObject statement = this.getStatement();
            if (currentEvaluator.isInterpreter() && this.hasLocalMembers()) {
                statement = INSTANCE.createStatement(this.blockNamedElement, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, this.offset, this.getVirtualOffset(), this.line, this.isCaseSensitive, statement);
            }
            currentEvaluator.pushScope(this.isCaseSensitive);
            try {
                XForeverEvalScope xEvalScope = new XForeverEvalScope(this.blockNamedElement, this, currentEvaluator, this.bvContext, guardian, statement);
                guardian.startEvalScope(xEvalScope);
                ELParamValueScope eLParamValueScope = xEvalScope.execute(guardian.getActiveThread());
                return eLParamValueScope;
            }
            finally {
                currentEvaluator.popScope();
            }
        }
    }

    private static class ForkJoinEndStatement
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        private IRfNamedElement blockNamedElement;
        private int virtualOffset;
        protected Set<XThread> forkedThreads;

        protected ForkJoinEndStatement(IRfNamedElement blockNamedElement, Set<XThread> forkedThreads, int operatorType, String operatorText, int startOffset, int startVirtualOffset, int startLine) {
            super(operatorType, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, operatorText, startOffset, startLine, -1, -1, 0L);
            this.blockNamedElement = blockNamedElement;
            this.forkedThreads = forkedThreads;
            this.virtualOffset = startVirtualOffset;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            if (IHidOperatorConstants.OperatorType.FORK_JOIN_NONE_STATEMENT.id == this.operatorType) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            if (IHidOperatorConstants.OperatorType.FORK_JOIN_ANY_STATEMENT.id == this.operatorType) {
                guardian.callbackWaitJoin(this.forkedThreads, false);
            } else if (IHidOperatorConstants.OperatorType.FORK_JOIN_STATEMENT.id == this.operatorType) {
                guardian.callbackWaitJoin(this.forkedThreads, true);
            }
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        @Override
        public int getVirtualOffset() {
            return this.virtualOffset;
        }

        @Override
        public HidOperatorOccurrence getOccurrence() {
            if (this.blockNamedElement != null) {
                return new HidOperatorOccurrence(this.offset, this.virtualOffset, this.line, new HidOccurrenceBounds(this.offset, this.virtualOffset, -1, -1), 0L, this.blockNamedElement.xGetReparseInfo());
            }
            return super.getOccurrence();
        }

        @Override
        public int getUsageIndex() {
            if (this.blockNamedElement != null) {
                this.blockNamedElement.getDeclarationIndex();
            }
            return super.getUsageIndex();
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }
    }

    public static class ForkJoinStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private ParserPath parserPath;
        private IHidObject endStatement;

        private ForkJoinStatement(int operatorType, String operatorText, IRfNamedElement blockNamedElement, ParserPath parserPath, int startOffset, int startVirtualOffset, int startLine, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, operatorType, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, operatorText, startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addRHValue(statement, false);
            this.parserPath = parserPath;
            IRfDefElement declaration = blockNamedElement.getDeclaration();
            this.endStatement = operatorType == IHidOperatorConstants.OperatorType.FORK_JOIN_NONE_STATEMENT.id ? new ForkJoinEndStatement(blockNamedElement, null, IHidOperatorConstants.OperatorType.FORK_JOIN_NONE_STATEMENT.id, "join_none", declaration.getEndOffset() - "join_none".length(), declaration.getStartVirtualOffset(), declaration.getEndLine()) : (operatorType == IHidOperatorConstants.OperatorType.FORK_JOIN_ANY_STATEMENT.id ? new ForkJoinEndStatement(blockNamedElement, null, IHidOperatorConstants.OperatorType.FORK_JOIN_ANY_STATEMENT.id, "join_any", declaration.getEndOffset() - "join_any".length(), declaration.getStartVirtualOffset(), declaration.getEndLine()) : new ForkJoinEndStatement(blockNamedElement, null, IHidOperatorConstants.OperatorType.FORK_JOIN_STATEMENT.id, "join", declaration.getEndOffset() - "join".length(), declaration.getStartVirtualOffset(), declaration.getEndLine()));
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            if (!(xEvalScope instanceof XFrameBlockEvalScope)) {
                return;
            }
            ListContainer<IHidObject> executeStatements = this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (executeStatements.get(0) instanceof ForkJoinStatement && ((XFrameBlockEvalScope)xEvalScope).getStatements() instanceof SeqBlockStatement) {
                SeqBlockStatement statements = (SeqBlockStatement)((XFrameBlockEvalScope)xEvalScope).getStatements();
                int forkProcessNumber = statements.getForkProcessNumber();
                ListContainer<IHidObject> rhValues = this.getRHValues();
                if (rhValues.size() != 1 || !(rhValues.get(0) instanceof ForkJoinStatement)) {
                    return;
                }
                if ((rhValues = ((ForkJoinStatement)rhValues.get(0)).getRHValues()).size() == 1 && rhValues.get(0) instanceof SeqBlockStatement && forkProcessNumber != -1 && forkProcessNumber < ((SeqBlockStatement)rhValues.get((int)0)).rhValues.size()) {
                    IHidObject forkProcess = (IHidObject)((SeqBlockStatement)rhValues.get((int)0)).rhValues.get(forkProcessNumber);
                    ((XFrameBlockEvalScope)xEvalScope).setStatements(forkProcess);
                }
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            ListContainer<IHidObject> statements;
            guardian.checkBuildCanceled();
            ListContainer<IHidObject> members = this.getRHValues();
            if (members == null || members.size() != 1 || guardian.isLinterStaticAnalysisMode()) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            IHidObject statement = members.get(0);
            IdentityHSet<XThread> forkedThreads = new IdentityHSet<XThread>(16);
            IHidEvaluator currentEvaluator = evaluator;
            if (statement instanceof SeqBlockStatement && (statements = ((SeqBlockStatement)statement).getRHValues()) != null) {
                if (currentEvaluator.isInterpreter() && this.hasLocalMembers()) {
                    currentEvaluator = currentEvaluator.createEnclosedValueHolder(this.blockNamedElement);
                }
                String blockName = XUtils.getName(this.blockNamedElement);
                boolean isCaseSensitive = this.blockNamedElement != null && LanguageKind.VLOG == this.blockNamedElement.getLanguageKind();
                int i = 0;
                while (i < statements.size()) {
                    IHidObject hidObject = statements.get(i);
                    if (hidObject instanceof IInitialValueDeclarationStatement) {
                        ELUtils.evaluate(hidObject, currentEvaluator, context, guardian);
                    } else if (!(hidObject instanceof DeclarationStatement)) {
                        if (!(hidObject instanceof SeqBlockStatement)) {
                            hidObject = INSTANCE.createStatement(this.blockNamedElement, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, this.offset, this.getVirtualOffset(), this.line, isCaseSensitive, hidObject);
                        }
                        if (hidObject instanceof SeqBlockStatement) {
                            ((SeqBlockStatement)hidObject).setForkProcessNumber(i);
                        }
                        forkedThreads.add(guardian.callbackStartThread(this, blockName, hidObject, currentEvaluator, this.parserPath, "forked", XThreadDefinition.ThreadKind.FORKED));
                    }
                    ++i;
                }
            }
            ForkJoinEndStatement originalEndStatement = (ForkJoinEndStatement)this.endStatement;
            this.endStatement = new ForkJoinEndStatement(originalEndStatement.blockNamedElement, forkedThreads, originalEndStatement.operatorType, originalEndStatement.operatorText, originalEndStatement.offset, originalEndStatement.virtualOffset, originalEndStatement.line);
            XSeqBlockEvalScope xEvalScope = new XSeqBlockEvalScope(this, currentEvaluator, context, guardian, this.endStatement);
            xEvalScope.setForkEvalScope(true);
            guardian.startEvalScope(xEvalScope);
            return xEvalScope.execute(guardian.getActiveThread());
        }
    }

    public static interface IDeclarationStatement
    extends IHidOperator {
        public String getFieldName();

        public IRfFieldElement getField();
    }

    public static interface IHotSwapElement {
        default public ListContainer<IHidObject> hotSwapHids(IRfNamedElement namedElement, HidOperator originalStatement, IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope) {
            IRfScopeElement enclosing;
            List<IHidOperator> blockBodyStatements;
            IHidOperator blockBody = HidEvalConverter.INSTANCE.convertElement(namedElement, guardian.copy(), evaluator);
            if (blockBody == null) {
                return null;
            }
            List<IHidObject> list = blockBodyStatements = blockBody instanceof SeqBlockStatement ? OptimizedUtils.asList(blockBody.getRHValues(), false) : Collections.singletonList(blockBody);
            if (blockBodyStatements == null || blockBodyStatements.isEmpty()) {
                return null;
            }
            ArrayListContainer<IHidObject> executeStatements = new ArrayListContainer<IHidObject>(blockBodyStatements.size());
            int i = 0;
            while (i < blockBodyStatements.size()) {
                block12: {
                    IHidObject statement;
                    block13: {
                        statement = blockBodyStatements.get(i);
                        if (statement == null) break block12;
                        if (!(statement instanceof IInitialValueDeclarationStatement)) break block13;
                        IInitialValueDeclarationStatement initStatement = (IInitialValueDeclarationStatement)statement;
                        if (evaluator.isInterpreter() && initStatement.getField().xIsStaticMember()) break block12;
                    }
                    executeStatements.add(statement);
                }
                ++i;
            }
            if (xEvalScope instanceof XFrameBlockEvalScope || namedElement instanceof IRfActionBlockElement && ((IRfActionBlockElement)namedElement).isAlways()) {
                originalStatement.lhValue = HidOperator.SEQ_BLOCK_IMPLICIT;
                originalStatement.rhValues = null;
                originalStatement.rhValues = executeStatements;
                return executeStatements;
            }
            if (namedElement instanceof IRfActionBlockElement && (enclosing = namedElement.getEnclosingScope()) instanceof IRfActionBlockElement && ((IRfActionBlockElement)enclosing).isForEach()) {
                originalStatement.rhValues = null;
                originalStatement.rhValues = executeStatements;
                return executeStatements;
            }
            for (IHidObject hid : executeStatements) {
                if (!(hid instanceof HidOperator)) continue;
                HidOperator statement = (HidOperator)hid;
                ListContainer<IHidObject> newRhValues = null;
                IHidObject newLhValue = null;
                newRhValues = statement.rhValues;
                newLhValue = statement.lhValue;
                originalStatement.rhValues = null;
                if (newRhValues != null) {
                    for (IHidObject newRhValue : newRhValues) {
                        originalStatement.addRHValue(newRhValue, false);
                    }
                }
                originalStatement.lhValue = null;
                if (newLhValue != null) {
                    originalStatement.addLHValue(newLhValue, false);
                }
                if (!(hid instanceof ForLoopStatement) || !(originalStatement instanceof ForLoopStatement)) continue;
                ((ForLoopStatement)originalStatement).stepHidObject = ((ForLoopStatement)hid).stepHidObject;
                ((ForLoopStatement)originalStatement).condition = ((ForLoopStatement)hid).condition;
            }
            return executeStatements;
        }

        public void hotSwap(IHidEvaluationGuardian var1, IHidEvaluator var2, XEvalScope var3, BitVectorContext var4);

        default public ParserPath getParserPath() {
            IRfNamedElement namedElement = this.getNamedElement();
            return namedElement != null && namedElement.getDeclaration() != null ? namedElement.getDeclaration().getParserPath() : null;
        }

        public IRfNamedElement getNamedElement();
    }

    public static interface IInitialValueDeclarationStatement
    extends IDeclarationStatement {
        public IInitialValueDeclarationStatement createOutputCopy();
    }

    public static class IfElseStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private BitVectorContext bvContext;

        private IfElseStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject condition, IHidObject ifStatement, IHidObject elseStatement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id, IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR, "if_else_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(condition, false);
            this.addRHValue(ifStatement, false);
            if (elseStatement != null) {
                this.addRHValue(elseStatement, false);
            }
            this.bvContext = BitVectorContext.of(blockNamedElement != null ? (IRfNamedElement)blockNamedElement.getEnclosingScope() : null, false);
        }

        @Override
        public void setNamedElement(IRfNamedElement blockNamedElement) {
            super.setNamedElement(blockNamedElement);
            this.bvContext = BitVectorContext.of(blockNamedElement != null ? (IRfNamedElement)blockNamedElement.getEnclosingScope() : null, false);
        }

        @Override
        public int getUsageIndex() {
            if (this.blockNamedElement != null) {
                return this.blockNamedElement.getDeclarationIndex();
            }
            IHidObject firstRHValue = this.getFirstRHValue();
            if (firstRHValue != null) {
                return firstRHValue.getUsageIndex();
            }
            return super.getUsageIndex();
        }

        private IHidObject getCondition() {
            return this.getLHValue();
        }

        private IHidObject getTrueCondStatement() {
            ListContainer<IHidObject> statements = this.getRHValues();
            return statements != null && !statements.isEmpty() ? statements.get(0) : null;
        }

        private IHidObject getFalseCondStatement() {
            ListContainer<IHidObject> statements = this.getRHValues();
            return statements != null && statements.size() > 1 ? statements.get(1) : null;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public XCValue collectConstraints(XCModel model, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            try {
                boolean bl;
                void var12_16;
                boolean isRand;
                IHidObject elseHidObject;
                XCValue condXCValue = this.lhValue.collectConstraints(model, evaluator, context, guardian.copy());
                if (condXCValue == null) {
                    return null;
                }
                ListContainer<IHidObject> statements = this.getRHValues();
                IHidObject thenHidObject = statements.get(0);
                IHidObject iHidObject = elseHidObject = statements.size() > 1 ? statements.get(1) : null;
                if (!condXCValue.isRand()) {
                    ELParamValueScope condValue = ELUtils.evaluate(this.lhValue, evaluator, null, guardian.copy());
                    if (ELUtils.isUnsuccessfulEval(condValue)) {
                        guardian.logError("Fail to evaluate constraint condition");
                        return null;
                    }
                    if (!ELUtils.isFalse(condValue.value)) {
                        return thenHidObject.collectConstraints(model, evaluator, null, guardian.copy());
                    }
                    if (elseHidObject != null) return elseHidObject.collectConstraints(model, evaluator, null, guardian.copy());
                    return null;
                }
                XCValue thenXCValue = thenHidObject.collectConstraints(model, evaluator, null, guardian.copy());
                if (thenXCValue == null) {
                    return null;
                }
                IntVariable zeroIntVar = model.getCachedConstant(true, 32, BigInteger.ZERO);
                IntVariable condIntVar = condXCValue.getIntVar();
                if (condIntVar instanceof BoolVariable) {
                    IntVariable intVariable = condIntVar.not();
                } else {
                    ReifBoolVariable reifBoolVariable = condIntVar.eq(zeroIntVar).reify();
                }
                IntVariable thenIntVar = thenXCValue.getIntVar();
                if (!(thenIntVar instanceof BoolVariable)) {
                    thenIntVar = thenIntVar.ne(zeroIntVar).reify();
                }
                boolean bl2 = isRand = condXCValue.isRand() || thenXCValue.isRand();
                if (elseHidObject == null) {
                    IntVariable result = var12_16.or(thenIntVar);
                    return model.createVariable(result, isRand, this);
                }
                XCValue elseXCValue = elseHidObject.collectConstraints(model, evaluator, null, guardian.copy());
                if (elseXCValue == null) {
                    return null;
                }
                IntVariable elseIntVar = elseXCValue.getIntVar();
                if (!(elseIntVar instanceof BoolVariable)) {
                    elseIntVar = elseIntVar.ne(zeroIntVar).reify();
                }
                if (!(condIntVar instanceof BoolVariable)) {
                    condIntVar = condIntVar.ne(zeroIntVar).reify();
                }
                IntVariable result = var12_16.or(thenIntVar).and(condIntVar.or(elseIntVar));
                if (!isRand && !elseXCValue.isRand()) {
                    bl = false;
                    return model.createVariable(result, bl, this);
                }
                bl = true;
                return model.createVariable(result, bl, this);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            guardian.checkBuildCanceled();
            this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XIfElseEvalScope) {
                ((XIfElseEvalScope)xEvalScope).hotSwap(this.getCondition(), this.getTrueCondStatement(), this.getFalseCondStatement());
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            XIfElseEvalScope xEvalScope = new XIfElseEvalScope(this.blockNamedElement, this, evaluator, this.bvContext, guardian, this.getCondition(), this.getTrueCondStatement(), this.getFalseCondStatement());
            guardian.startEvalScope(xEvalScope);
            return xEvalScope.execute(guardian.getActiveThread());
        }
    }

    public static class MethodCallPlaceholder
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        private final IHidObject hidOrAccess;
        private int virtualOffset;

        private MethodCallPlaceholder(IHidObject hidOrAccess, int offset, int virtualOffset, int line) {
            super(IHidOperatorConstants.OperatorType.METHOD_CALL_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "method_call", offset, line, -1, -1, 0L);
            this.addLHValue(METHOD_CALL_IMPLICIT, false);
            this.hidOrAccess = hidOrAccess;
            this.virtualOffset = virtualOffset;
        }

        public IHidObject getHidOrAccess() {
            return this.hidOrAccess;
        }

        public Hid getParentHid() {
            return XUtils.getParentHid(this.hidOrAccess);
        }

        public boolean isSuperCall() {
            Hid parentHid = this.getParentHid();
            return this.isSuperCall(parentHid);
        }

        private boolean isSuperCall(Hid parentHid) {
            HidAccess parentAccess;
            if (parentHid == null) {
                return false;
            }
            return "new".equals(XUtils.getName(parentHid)) && (parentAccess = parentHid.getParentAccess()) != null && parentAccess.getAccessKind() == 0 && (parentHid = parentAccess.getParentHid()) != null && "super".equals(XUtils.getName(parentHid));
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            Hid parentHid = this.getParentHid();
            String name = XUtils.getName(parentHid);
            IRfNamedElement methodElement = parentHid.getElement();
            if (methodElement instanceof IRfMethodElement && ((IRfMethodElement)methodElement).isUserDefinedSystemFunction()) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            if (name.startsWith("$strobe") || name.startsWith("$fstrobe")) {
                boolean isStrobe;
                boolean bl = isStrobe = "$strobe".equals(name) || "$strobeb".equals(name) || "$strobeo".equals(name) || "$strobeh".equals(name) || "$fstrobe".equals(name) || "$fstrobeb".equals(name) || "$fstrobeo".equals(name) || "$fstrobeh".equals(name);
                if (isStrobe) {
                    XValueHolderFactory factory = guardian.getFactory();
                    factory.addEvent(XSimRegion.XRegionKind.Postponed, () -> {
                        ELParamValueScope eLParamValueScope = ELUtils.evaluate(this.hidOrAccess, evaluator, context, guardian);
                    });
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
            }
            try {
                parentHid.addQualifier(HidQualifierCache.METHOD_CALL_PLACEHOLDER);
                ELParamValueScope eLParamValueScope = ELUtils.evaluate(this.hidOrAccess, evaluator, context, guardian);
                return eLParamValueScope;
            }
            finally {
                parentHid.removeQualifier(HidQualifierCache.METHOD_CALL_PLACEHOLDER);
            }
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }

        @Override
        public String toString() {
            return "method_call " + (this.hidOrAccess != null ? this.hidOrAccess.toString() : "");
        }

        @Override
        public HidOperatorOccurrence getOccurrence() {
            Hid parentHid = this.getParentHid();
            HidOccurrence hidOccurence = parentHid.getOccurrence();
            return new HidOperatorOccurrence(hidOccurence.offset, hidOccurence.getVirtualOffset(), hidOccurence.line, hidOccurence.qualifierSet, hidOccurence.getReparseInfo());
        }

        @Override
        public int getVirtualOffset() {
            return this.virtualOffset;
        }

        @Override
        public int getUsageIndex() {
            if (this.hidOrAccess instanceof HidAccess) {
                return ((HidAccess)this.hidOrAccess).getUsageIndex();
            }
            if (this.hidOrAccess instanceof Hid) {
                return ((Hid)this.hidOrAccess).getUsageIndex();
            }
            return super.getUsageIndex();
        }

        /*
         * WARNING - void declaration
         */
        public boolean isFunctionCall() {
            void method;
            IRfMethodElement iRfMethodElement;
            Hid parentHid = this.getParentHid();
            IRfNamedElement methodElement = parentHid.getElement();
            IRfNamedElement iRfNamedElement = methodElement;
            return iRfNamedElement instanceof IRfMethodElement && (iRfMethodElement = (IRfMethodElement)iRfNamedElement) == (IRfMethodElement)iRfNamedElement && !method.isTask();
        }
    }

    public static class MethodCallStatement
    extends HidOperator
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private MethodCall methodCall;
        private IHidObject hidObject;
        private IHidEvaluator argumentsEvaluator;
        private boolean fromExpression;
        private ELParamValues onlyArgumentValues;
        private IHidEvaluator currentEvaluator;
        private IHidEvaluator methodValueHolder;
        private IRfMethodElement methodElement;
        private Map<String, ArgumentInfo> specifiedArgumentValues;
        private List<ArgumentInfo> outputArguments;

        private MethodCallStatement(MethodCall methodCall, IHidObject hidObject, IHidEvaluator argumentsEvaluator, boolean fromExpression) {
            super(IHidOperatorConstants.OperatorType.METHOD_CALL_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "method_call", methodCall.getOccurrence().getOffset(), methodCall.getOccurrence().getLine(), -1, -1, 0L);
            this.addLHValue(METHOD_CALL_IMPLICIT, false);
            this.methodCall = methodCall;
            this.hidObject = hidObject;
            this.argumentsEvaluator = argumentsEvaluator;
            this.fromExpression = fromExpression;
        }

        public IHidObject getHidObject() {
            return this.hidObject;
        }

        public IHidEvaluator getCurrentEvaluator() {
            return this.currentEvaluator;
        }

        @Override
        public IRfNamedElement getNamedElement() {
            return this.methodElement;
        }

        @Override
        public int getVirtualOffset() {
            return this.methodCall == null || this.methodCall.occurrence == null ? -1 : this.methodCall.occurrence.virtualOffset;
        }

        @Override
        public int getUsageIndex() {
            if (this.methodCall == null) {
                return -1;
            }
            IHidObject hidObject = this.methodCall.methodHidObject;
            if (hidObject instanceof HidAccess) {
                return ((HidAccess)hidObject).getUsageIndex();
            }
            if (hidObject instanceof Hid) {
                return ((Hid)hidObject).getUsageIndex();
            }
            return super.getUsageIndex();
        }

        @NotNull
        private ELManager getManager() {
            ELManager manager = null;
            if (this.currentEvaluator != null) {
                manager = this.currentEvaluator.getManager();
            }
            if (manager == null && this.argumentsEvaluator != null) {
                manager = this.argumentsEvaluator.getManager();
            }
            if (manager == null) {
                throw new UnknownHidObjectEvaluationException(this.methodCall.methodHidObject);
            }
            return manager;
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext returnTypeContext) {
            boolean isInterpreter = this.currentEvaluator.isInterpreter();
            if (!isInterpreter && !(this.currentEvaluator instanceof ELParamValuesHidMethodEvaluator)) {
                throw new UnknownHidObjectEvaluationException(this.methodCall.methodHidObject);
            }
            this.methodElement = (IRfMethodElement)this.methodCall.method;
            String methodName = this.methodCall.getMethodName();
            this.specifiedArgumentValues = new LinkedHashMap<String, ArgumentInfo>();
            ELManager manager = this.getManager();
            if (this.methodCall.argumentValuesMapRaw != null) {
                this.computeSpecifiedArgumentValues(guardian, isInterpreter, methodName, manager);
            }
            if (guardian.shouldSkip(this)) {
                throw new SkippedHidObjectEvaluationException(this);
            }
            IHidOperator methodBody = HidEvalConverter.INSTANCE.convertMethod(this.methodElement, guardian.copy(), this.methodValueHolder);
            ListContainer<IHidObject> methodBodyStatements = methodBody instanceof SeqBlockStatement ? methodBody.getRHValues() : (methodBody != null ? methodBody : ListContainer.emptyContainer());
            BitVectorContext noContext = BitVectorContext.of(returnTypeContext != null ? returnTypeContext.getOrigin() : this.methodElement, false);
            int startStatementIndex = 0;
            if (this.methodElement.isConstructor()) {
                startStatementIndex = this.constructorCall(guardian, methodBodyStatements, noContext, startStatementIndex);
            }
            if (methodBodyStatements != null) {
                ArrayListContainer<IHidObject> executeStatements = this.computeExecuteStatements(evaluator, isInterpreter, methodBodyStatements, startStatementIndex);
                ((XMethodBlockEvalScope)xEvalScope).hotSwap(executeStatements);
            }
        }

        /*
         * Exception decompiling
         */
        private ELParamValueScope evaluateNonRunMode(IHidEvaluator evaluator, BitVectorContext returnTypeContext, IHidEvaluationGuardian guardian) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private IELParamValue executeElabPredefinedMethodCall(IHidObject hidObject, IRfMethodElement methodElement, IHidEvaluator methodEnclosingEvaluator, Map<String, ArgumentInfo> specifiedArgumentValues, IHidEvaluationGuardian guardian) {
            Hid parentHid = null;
            if (hidObject instanceof HidAccess) {
                parentHid = ((HidAccess)hidObject).getParentHid();
            } else if (hidObject instanceof Hid) {
                parentHid = (Hid)hidObject;
            }
            HidAccess parentAccess = parentHid == null ? null : parentHid.getParentAccess();
            ELParamValueScope resolvedParent = ELUtils.evaluate(parentAccess, methodEnclosingEvaluator, NO_CONTEXT, guardian);
            if (ELUtils.isUnsuccessfulEval(resolvedParent)) {
                return null;
            }
            IELParamValue parentParamValue = XUtils.getValue(resolvedParent);
            if (parentParamValue == null) {
                return null;
            }
            IRfScopeElement enclosingScope = methodElement.getEnclosingScope();
            if (methodEnclosingEvaluator instanceof ELParamValuesHidMethodEvaluator && enclosingScope instanceof IRfEnumElement && parentParamValue instanceof ELParamValues.ParamValueNumber) {
                ELEnumTypeWrapper enumTypeWrapper = ELEnumTypeWrapper.create((IRfEnumElement)enclosingScope, (ELParamValuesHidMethodEvaluator)methodEnclosingEvaluator, methodEnclosingEvaluator.getManager());
                if (enumTypeWrapper == null) {
                    return null;
                }
                return enumTypeWrapper.executePredefinedMethod(parentParamValue, methodElement.getName(), specifiedArgumentValues);
            }
            return null;
        }

        private final ELParamValueScope evaluateRunMode(IHidEvaluator evaluator, BitVectorContext returnTypeContext, IHidEvaluationGuardian guardian) {
            IELParamValue result;
            IELParamValue result2;
            guardian.checkBuildCanceled();
            ELManager manager = this.getManager();
            String methodName = this.methodCall.getMethodName();
            if (!(this.methodCall.method instanceof IRfMethodElement)) {
                throw new UnknownHidObjectEvaluationException(this.methodCall.methodHidObject);
            }
            this.methodElement = (IRfMethodElement)this.methodCall.method;
            this.currentEvaluator = evaluator;
            this.methodValueHolder = this.methodCall.methodValueHolder;
            if (this.methodValueHolder == null && !((IELParamValue)evaluator).isString()) {
                Hid hid = XUtils.getParentHid(this.hidObject);
                this.methodCall.methodValueHolder = this.methodValueHolder = XUtils.getMethodValue(hid, this.currentEvaluator, guardian);
            }
            if (this.methodValueHolder instanceof XValueHolder) {
                this.handlePolymorphism();
            }
            if (this.methodCall.argumentValuesMapRaw != null) {
                boolean isVlog = ELUtils.isVLOG(this.methodElement);
                this.specifiedArgumentValues = new LinkedHashMap<String, ArgumentInfo>();
                this.onlyArgumentValues = ELParamValues.create(isVlog);
                this.computeSpecifiedArgumentValues(guardian, true, methodName, manager);
            } else {
                this.specifiedArgumentValues = Collections.emptyMap();
                this.onlyArgumentValues = ELParamValues.of(Collections.emptyMap(), true);
            }
            if (this.methodValueHolder instanceof XValueHolder && this.currentEvaluator instanceof XArrayValueHolder) {
                IHidObject rangeObject = null;
                if (this.hidObject instanceof HidAccess) {
                    rangeObject = ((HidAccess)this.hidObject).xGetRangeObject();
                }
                if (rangeObject != null) {
                    IELParamValue rangeObjectValue = XUtils.getValue(ELUtils.evaluate(rangeObject, this.argumentsEvaluator, null, guardian.copy()));
                    ((XValueHolder)this.methodValueHolder).putValue("__rov__", rangeObjectValue);
                }
            }
            if (this.methodValueHolder instanceof XMethodValueHolder && (result2 = ((XMethodValueHolder)this.methodValueHolder).execute(this, this.argumentsEvaluator, this.specifiedArgumentValues)) != null) {
                return this.xPostMethodExecute(result2, returnTypeContext, guardian);
            }
            if ((this.methodElement.isPredefined() || evaluator instanceof XCGroupValueHolder || evaluator instanceof XCPointValueHolder) && (result = guardian.executeMethodCall(this.hidObject, this.methodElement, evaluator, this.methodValueHolder, this.argumentsEvaluator, this.specifiedArgumentValues)) != null) {
                return this.xPostMethodExecute(result, returnTypeContext, guardian);
            }
            if (this.methodValueHolder == null) {
                guardian.logError("Fail to evaluate '" + this + "' function call");
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            IHidOperator methodBody = manager.computeIfAbsentResolvedMethodBody(this.methodElement, guardian, this.methodValueHolder);
            BitVectorContext noContext = BitVectorContext.of(returnTypeContext != null ? returnTypeContext.getOrigin() : this.methodElement, false);
            XMethodBlockEvalScope xEvalScope = new XMethodBlockEvalScope(this, this.methodValueHolder, noContext, returnTypeContext, guardian.copy(this.methodElement), null);
            guardian.startEvalScope(xEvalScope);
            boolean disableEndEvalScope = false;
            boolean prevEvalAssert = guardian.setEvalAssert(false);
            try {
                ListContainer<IHidObject> methodBodyStatements;
                int startStatementIndex = 0;
                ListContainer<IHidObject> listContainer = methodBody instanceof SeqBlockStatement ? methodBody.getRHValues() : (methodBodyStatements = methodBody != null ? methodBody : ListContainer.emptyContainer());
                if (this.methodElement.isConstructor()) {
                    startStatementIndex = this.constructorCall(guardian, methodBodyStatements, noContext, startStatementIndex);
                }
                if (methodBodyStatements == null) {
                    ELParamValueScope eLParamValueScope = this.xPostMethodExecute(null, returnTypeContext, guardian);
                    return eLParamValueScope;
                }
                ArrayListContainer<IHidObject> executeStatements = this.computeExecuteStatements(evaluator, true, methodBodyStatements, startStatementIndex);
                if (executeStatements.isEmpty()) {
                    ELParamValueScope eLParamValueScope = this.xPostMethodExecute(null, returnTypeContext, guardian);
                    return eLParamValueScope;
                }
                disableEndEvalScope = true;
                xEvalScope.setStatements(executeStatements);
                ELParamValueScope eLParamValueScope = xEvalScope.execute(guardian.getActiveThread());
                return eLParamValueScope;
            }
            finally {
                guardian.setEvalAssert(prevEvalAssert);
                if (!disableEndEvalScope) {
                    guardian.endEvalScope(xEvalScope);
                }
            }
        }

        private void handlePolymorphism() {
            IELParamValue newValue;
            IRfNamedElement methodElementFromEvaluator = this.methodValueHolder.getNamedElement();
            if (methodElementFromEvaluator instanceof IRfMethodElement) {
                this.methodElement = (IRfMethodElement)methodElementFromEvaluator;
            }
            if (this.methodElement.isConstructor() && (newValue = ((XMethodValueHolder)this.methodValueHolder).getEnclosingValue()) != null) {
                this.currentEvaluator = newValue;
            }
        }

        private ELParamValueScope fastEvalArrayNoArgsMethods(IHidEvaluationGuardian guardian, String methodName) {
            boolean isPushFront;
            boolean isExists = "exists".equals(methodName);
            XArrayValueHolder localEvaluator = (XArrayValueHolder)this.currentEvaluator;
            if (isExists) {
                Set<Map.Entry<IRfFieldElement, IHidObject>> argumentEntries = this.methodCall.argumentValuesMapRaw.entrySet();
                Map.Entry<IRfFieldElement, IHidObject> argument = argumentEntries.iterator().next();
                if (localEvaluator.isEmpty() && argument.getValue() instanceof IHid) {
                    return ELParamValueScope.of(ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO), this.currentEvaluator);
                }
                ELParamValueScope argumentValue = ELUtils.evaluate(argument.getValue(), this.argumentsEvaluator, localEvaluator.getIndexElementContext(), guardian);
                if (localEvaluator.isEmpty()) {
                    return ELParamValueScope.of(ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO), this.currentEvaluator);
                }
                IELParamValue existsValue = localEvaluator.exists(argumentValue.value);
                return ELParamValueScope.of(existsValue, this.currentEvaluator);
            }
            boolean isPushBack = "push_back".equals(methodName) && !XUtils.isNullArgument("item", this.methodCall.argumentValuesMapRaw);
            boolean bl = isPushFront = "push_front".equals(methodName) && !XUtils.isNullArgument("item", this.methodCall.argumentValuesMapRaw);
            if (isPushBack || isPushFront) {
                Set<Map.Entry<IRfFieldElement, IHidObject>> argumentEntries = this.methodCall.argumentValuesMapRaw.entrySet();
                Map.Entry<IRfFieldElement, IHidObject> argument = argumentEntries.iterator().next();
                BitVectorContext argContext = localEvaluator.getItemElementContext();
                if (argContext == null || argument.getValue() instanceof HidOperator && (((HidOperator)argument.getValue()).isAssignmentPattern() || ((HidOperator)argument.getValue()).isAggregate())) {
                    argContext = XValueHolderFactory.getRightOpContext(localEvaluator.createElementValueHolder(), argument.getValue(), localEvaluator.getItemElementField(), guardian.getFactory());
                    localEvaluator.setItemElementContext(argContext);
                }
                ELParamValueScope argumentValue = ELUtils.evaluate(argument.getValue(), this.argumentsEvaluator, argContext, guardian);
                IELParamValue argValue = argumentValue.value;
                if (!argument.getKey().isRef()) {
                    if (argumentValue.value instanceof ELParamValues.ParamValueNumber) {
                        argValue = argumentValue.value.shallowCopy();
                    } else if (argumentValue.value instanceof XValueHolder) {
                        argValue = ((XValueHolder)argumentValue.value).newHolder();
                        ((XValueHolder)argValue).updateValue(argumentValue.value, guardian);
                    }
                }
                if (isPushBack) {
                    localEvaluator.push_back(argValue);
                } else {
                    localEvaluator.push_front(argValue);
                }
                localEvaluator.notifyWaitingThreads(this, this.currentEvaluator);
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            boolean isPopBack = "pop_back".equals(methodName);
            if (isPopBack) {
                IELParamValue popValue = localEvaluator.pop_back();
                localEvaluator.notifyWaitingThreads(this, this.currentEvaluator);
                return ELParamValueScope.of(popValue, this.currentEvaluator);
            }
            boolean isPopFront = "pop_front".equals(methodName);
            if (isPopFront) {
                IELParamValue popValue = localEvaluator.pop_front();
                localEvaluator.notifyWaitingThreads(this, this.currentEvaluator);
                return ELParamValueScope.of(popValue, this.currentEvaluator);
            }
            return null;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext returnTypeContext, IHidEvaluationGuardian guardian) {
            boolean isInterpreter = evaluator.isInterpreter();
            boolean isLinterStaticAnalysisMode = guardian.isLinterStaticAnalysisMode();
            if (isInterpreter && !isLinterStaticAnalysisMode && guardian.simulatorMode() == IXSim.XSimMode.SIMULATOR && guardian.isRunMode()) {
                return this.evaluateRunMode(evaluator, returnTypeContext, guardian);
            }
            return this.evaluateNonRunMode(evaluator, returnTypeContext, guardian);
        }

        /*
         * Unable to fully structure code
         */
        private ArrayListContainer<IHidObject> computeExecuteStatements(IHidEvaluator evaluator, boolean isInterpreter, ListContainer<IHidObject> methodBodyStatements, int startStatementIndex) {
            executeStatements = new ArrayListContainer<IHidObject>(methodBodyStatements.size() - startStatementIndex);
            evaluateLastStatements = new ArrayList<IInitialValueDeclarationStatement>();
            i = startStatementIndex;
            while (i < methodBodyStatements.size()) {
                block10: {
                    statement = methodBodyStatements.get(i);
                    if (statement == null) break block10;
                    if (!(statement instanceof IInitialValueDeclarationStatement)) ** GOTO lbl19
                    initStatement = (IInitialValueDeclarationStatement)statement;
                    namedElement = initStatement.getField();
                    isArgument = MethodCallUtils.isValidMethodArgument(namedElement);
                    if (isArgument && this.specifiedArgumentValues.containsKey(initStatement.getFieldName()) || isInterpreter && namedElement.xIsStaticMember() && !isArgument) break block10;
                    if (isArgument && namedElement.isOutput()) {
                        evaluateLastStatements.add(initStatement);
                    } else {
                        if (isArgument && namedElement.isInout()) {
                            evaluateLastStatements.add(initStatement.createOutputCopy());
                        }
lbl19:
                        // 4 sources

                        if (statement instanceof SeqBlockStatement && !((SeqBlockStatement)statement).hasLocalMembers()) {
                            ((SeqBlockStatement)statement).unfoldStatements(evaluator, executeStatements);
                        } else {
                            executeStatements.add(statement);
                        }
                    }
                }
                ++i;
            }
            if (!evaluateLastStatements.isEmpty()) {
                executeStatements.addAll(evaluateLastStatements);
            }
            return executeStatements;
        }

        private void computeSpecifiedArgumentValues(IHidEvaluationGuardian guardian, boolean isInterpreter, String methodName, ELManager manager) {
            for (Map.Entry<IRfFieldElement, IHidObject> argValuePair : this.methodCall.argumentValuesMapRaw.entrySet()) {
                IRfFieldElement formalArgument = argValuePair.getKey();
                IHidObject argHidObject = argValuePair.getValue();
                if (argHidObject == null && !XUtils.isSystemFunctionOrTask(this.methodElement)) continue;
                String formalArgName = formalArgument.getName();
                ArgumentInfo argumentInfo = new ArgumentInfo(formalArgName, formalArgument, argHidObject, null);
                this.specifiedArgumentValues.put(formalArgName, argumentInfo);
                boolean isListFuncWithIteratorArg = XArrayValueHolder.isListFuncWithIteratorArg(this.methodElement);
                if (isListFuncWithIteratorArg && "iterator".equals(formalArgName)) {
                    argumentInfo.argValueScope = ELParamValueScope.UNDEFINED_VALUE;
                    continue;
                }
                BitVectorContext argContext = isInterpreter && this.methodValueHolder instanceof XMethodValueHolder ? (((XMethodValueHolder)this.methodValueHolder).isNoContextArgs() ? NO_CONTEXT : (((XMethodValueHolder)this.methodValueHolder).getNamedElement().getLanguageKind() == LanguageKind.VHDL ? argumentInfo.formalArg.getDataTypeBitVectorContext(this.currentEvaluator, false, null, manager) : ((XMethodValueHolder)this.methodValueHolder).getArgumentContext(formalArgument, argHidObject))) : argumentInfo.formalArg.getDataTypeBitVectorContext(this.currentEvaluator, false, null, manager);
                argumentInfo.argContext = argContext;
                argumentInfo.argValueScope = ELUtils.evaluate(argHidObject, this.argumentsEvaluator, argContext, guardian.copy());
                IELParamValue argValue = XUtils.getValue(argumentInfo.argValueScope);
                if (argHidObject != null || argValue != null) {
                    if (ELUtils.isUnsuccessfulEval(argValue)) {
                        guardian.logError("Fail to evaluate '" + argHidObject + "' as '" + methodName + "." + formalArgName + "' method argument.");
                    } else if (!(argValue instanceof XValueHolder) && !(argValue instanceof IELParamValue.NullXValue) && !(argValue instanceof ELParamValues.ParamValueType) && DVTNumber.isUndefined(argValue.getDVTNumber())) {
                        guardian.logError("Fail to evaluate '" + argHidObject + "' as '" + methodName + "." + formalArgName + "' method argument.");
                    }
                }
                if (!isInterpreter) {
                    if (ELUtils.isUnsuccessfulEval(argValue)) {
                        throw new UnknownHidObjectEvaluationException(argHidObject);
                    }
                    if (argValue != null && DVTNumber.isUndefined(argValue.getDVTNumber())) {
                        throw new UnknownHidObjectEvaluationException(argHidObject);
                    }
                    if (!ELUtils.isParamValueNumber(argValue)) {
                        throw new UnknownHidObjectEvaluationException(argHidObject);
                    }
                }
                boolean isOutput = argumentInfo.formalArg.isOutput();
                boolean isInout = argumentInfo.formalArg.isInout();
                if (isOutput || isInout) {
                    argumentInfo.isRefOrOutput = true;
                    if (this.outputArguments == null) {
                        this.outputArguments = new ArrayList<ArgumentInfo>();
                    }
                    this.outputArguments.add(argumentInfo);
                }
                argumentInfo.isRef = argumentInfo.formalArg.isRef();
                argumentInfo.isOutputAndStatic = isOutput && argumentInfo.formalArg.xIsStaticMember();
                argumentInfo.isRefOrOutput = argumentInfo.isRefOrOutput | (argumentInfo.isRef || argContext == null);
                this.onlyArgumentValues.put(argumentInfo.formalArgName, argValue);
            }
            if (this.methodValueHolder == null) {
                return;
            }
            for (ArgumentInfo argumentInfo : this.specifiedArgumentValues.values()) {
                String formalArgName = argumentInfo.formalArgName;
                IELParamValue argValue = XUtils.getValue(argumentInfo.argValueScope);
                if (argValue instanceof ELParamValues.ParamValueType) {
                    this.methodValueHolder.putValueDirectly(formalArgName, argValue);
                    continue;
                }
                if (argumentInfo.isRef) {
                    this.methodValueHolder.putValueDirectly(formalArgName, argValue);
                    continue;
                }
                if (argumentInfo.formalArg.isOutput() && argValue != null && !argumentInfo.formalArg.xIsStaticMember()) {
                    this.methodValueHolder.updateValue(formalArgName, argumentInfo.formalArg, argValue.getDefaultValue(), true);
                    continue;
                }
                if (argumentInfo.isOutputAndStatic) continue;
                this.methodValueHolder.updateValue(formalArgName, argumentInfo.formalArg, argValue, true);
            }
        }

        private int constructorCall(IHidEvaluationGuardian guardian, ListContainer<IHidObject> methodBodyStatements, BitVectorContext noContext, int startStatementIndex) {
            HidAccess superNewCall;
            boolean hasExplicitSuperCall = false;
            int i = 0;
            while (i < methodBodyStatements.size()) {
                IHidObject statement = methodBodyStatements.get(i);
                if (statement != null) {
                    if (statement instanceof DeclarationStatement) {
                        startStatementIndex = i + 1;
                        this.evaluateStatement(guardian, noContext, statement);
                    } else if (statement instanceof IInitialValueDeclarationStatement) {
                        startStatementIndex = i + 1;
                        IInitialValueDeclarationStatement initStatement = (IInitialValueDeclarationStatement)statement;
                        if (!this.specifiedArgumentValues.containsKey(initStatement.getFieldName()) || !MethodCallUtils.isValidMethodArgument(initStatement.getField())) {
                            this.evaluateStatement(guardian, noContext, statement);
                        }
                    } else {
                        if (!(statement instanceof MethodCallPlaceholder) || !((MethodCallPlaceholder)statement).isSuperCall()) break;
                        startStatementIndex = i + 1;
                        hasExplicitSuperCall = true;
                        this.evaluateStatement(guardian, noContext, statement);
                        break;
                    }
                }
                ++i;
            }
            if (!hasExplicitSuperCall && (superNewCall = ((IRfNamedElement)this.methodElement.getEnclosingScope()).xGetImplicitSuperNewCall(this.getOccurrence(), guardian)) != null) {
                ELUtils.evaluate(superNewCall, this.methodValueHolder, noContext, guardian);
            }
            if (this.currentEvaluator instanceof XValueHolder) {
                ((XValueHolder)this.currentEvaluator).initLocalVariables(false);
            }
            return startStatementIndex;
        }

        private void markArgumentValuesOperators(IHidEvaluationGuardian guardian, ELManager manager) {
            if (!manager.markElabHidObjects()) {
                return;
            }
            if (this.hidObject instanceof HidAccess) {
                guardian.markEvaluated(((HidAccess)this.hidObject).getParentHid());
            }
            if (!(this.hidObject instanceof IHidAccessArgs)) {
                return;
            }
            List<? extends IHidObject> argumentValues = ((IHidAccessArgs)((Object)this.hidObject)).getArgumentValues();
            if (argumentValues == null || argumentValues.isEmpty()) {
                return;
            }
            for (IHidObject iHidObject : argumentValues) {
                if (!(iHidObject instanceof HidOperator)) continue;
                guardian.markEvaluated((HidOperator)iHidObject);
            }
        }

        private boolean isXVMConfigDBGetEnclosingScope(XThread activeThread) {
            XEvalScopeWithParserPath firstBlockEvalScopeWithParserPathFromStack = activeThread.getFirstBlockEvalScopeWithParserPathFromStack();
            if (firstBlockEvalScopeWithParserPathFromStack == null) {
                return false;
            }
            IHidOperator parentOperator = firstBlockEvalScopeWithParserPathFromStack.getParentOperator();
            if (!(parentOperator instanceof MethodCallStatement)) {
                return false;
            }
            IRfNamedElement rfFunction = ((MethodCallStatement)parentOperator).getNamedElement();
            if (rfFunction == null) {
                return false;
            }
            return "get".equals(rfFunction.getName()) && rfFunction.getEnclosingScope() != null && "uvm_config_db".equals(rfFunction.getEnclosingScope().getName());
        }

        private void evaluateStatement(IHidEvaluationGuardian guardian, BitVectorContext noContext, IHidObject statement) {
            if (guardian.isRunMode()) {
                ELUtils.evaluate(statement, this.methodValueHolder, noContext, guardian.copy(this.methodElement));
            } else {
                XThread xThread = guardian.getActiveThread();
                try {
                    guardian.callbackStartStatement(xThread, statement);
                    ELUtils.evaluate(statement, this.methodValueHolder, noContext, guardian.copy(this.methodElement));
                }
                finally {
                    guardian.callbackEndStatement(xThread, statement);
                }
            }
        }

        @Override
        public Map<String, ArgumentInfo> getSpecifiedArgumentValues() {
            return this.specifiedArgumentValues;
        }

        public MethodCall getMethodCall() {
            return this.methodCall;
        }

        @Override
        public ELParamValueScope xPostMethodExecute(IELParamValue returnResult, BitVectorContext context, IHidEvaluationGuardian guardian) {
            boolean isInterpreter = this.currentEvaluator.isInterpreter();
            if (this.methodElement.isUserDefinedSystemFunction()) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            if (returnResult == null) {
                if (isInterpreter && this.methodCall.methodHidObject instanceof IHid) {
                    if (this.methodValueHolder instanceof XValueHolder) {
                        returnResult = ((XValueHolder)this.methodValueHolder).getResult(context);
                    } else {
                        guardian.logError("Undefined result for '" + this.methodCall.toString() + "' function call.");
                        returnResult = IELParamValue.UNDEFINED_VALUE;
                    }
                } else {
                    String methodName = this.methodCall.getMethodName();
                    IELParamValue iELParamValue = returnResult = this.methodElement.isTask() ? ELParamValues.ParamValueNumber.IMPLICIT_RESULT : this.methodValueHolder.getValueDirectly(methodName);
                }
            }
            if (ELUtils.isUnsuccessfulEval(returnResult)) {
                throw new UnknownHidObjectEvaluationException(this.methodCall.methodHidObject);
            }
            if (!isInterpreter) {
                if (this.methodElement.isTask() && returnResult != ELParamValues.ParamValueNumber.IMPLICIT_RESULT) {
                    throw new UnknownHidObjectEvaluationException(this.methodCall.methodHidObject);
                }
                if (!this.methodElement.isTask() && returnResult == ELParamValues.ParamValueNumber.IMPLICIT_RESULT) {
                    throw new UnknownHidObjectEvaluationException(this.methodCall.methodHidObject);
                }
            }
            boolean isVhdlMethod = ELUtils.isVHDL(this.methodCall.method);
            if ((isInterpreter || isVhdlMethod) && this.outputArguments != null) {
                for (ArgumentInfo argumentInfo : this.outputArguments) {
                    if (argumentInfo.formalArg instanceof DummyPort) continue;
                    boolean prevLHS = guardian.setLHS(true);
                    try {
                        BitVectorContext noContext = BitVectorContext.of(argumentInfo.argContext == null ? null : argumentInfo.argContext.getOrigin(), false);
                        argumentInfo.argValueScope = ELUtils.evaluate(argumentInfo.argHidObject, this.argumentsEvaluator, noContext, guardian.copy());
                    }
                    finally {
                        guardian.setLHS(prevLHS);
                    }
                    IELParamValue newArgValue = this.methodValueHolder.getValueDirectly(argumentInfo.formalArgName);
                    if (isInterpreter && this.methodValueHolder instanceof XMethodValueHolder) {
                        IELParamValue actualArgValue = XUtils.getValue(argumentInfo.argValueScope);
                        BitVectorContext memberContext = BitVectorContext.of(actualArgValue.getDVTNumber(), actualArgValue.getElement());
                        newArgValue = memberContext.transform(newArgValue);
                    }
                    argumentInfo.argValueScope.doUpdate(this, newArgValue, 1, this.argumentsEvaluator, argumentInfo.argHidObject, guardian);
                }
            }
            if (this.methodValueHolder instanceof XMethodValueHolder) {
                ((XMethodValueHolder)this.methodValueHolder).postExecute(this.argumentsEvaluator);
            }
            if (!isInterpreter && this.onlyArgumentValues != null && (this.methodElement.getEnclosingScope() instanceof IRfPackageElement || this.methodValueHolder.hasParamReferences() != null && !this.methodValueHolder.hasParamReferences().get()) && !this.methodElement.isTask() && this.outputArguments == null) {
                ELManager manager = this.getManager();
                manager.addMethodCallResult(this.methodElement, this.onlyArgumentValues, returnResult);
            }
            return ELParamValueScope.of(returnResult, this.methodValueHolder);
        }

        @Override
        public String toString() {
            return this.methodCall.toString();
        }

        @Override
        public LanguageKind getLanguageKind() {
            return LanguageKind.VLOG;
        }

        @Override
        public HidOperatorOccurrence getOccurrence() {
            if (this.hidObject instanceof HidAccess) {
                HidOccurrence hidOccurence = ((HidAccess)this.hidObject).getOccurrence();
                if (hidOccurence == null) {
                    return super.getOccurrence();
                }
                return new HidOperatorOccurrence(hidOccurence.offset, hidOccurence.getVirtualOffset(), hidOccurence.line, hidOccurence.qualifierSet, hidOccurence.getReparseInfo());
            }
            return super.getOccurrence();
        }

        @Override
        public HidOperatorWrapper xGetWithClause() {
            if (this.hidObject != null) {
                return this.hidObject.xGetWithClause();
            }
            return null;
        }

        @Override
        public String getOperatorText() {
            return HidUtils.toNiceString(HidUtils.getHidFrom(this.hidObject));
        }

        public static class ArgumentInfo {
            public IHidObject argHidObject;
            public ELParamValueScope argValueScope;
            public boolean isRefOrOutput;
            public String formalArgName;
            public IRfFieldElement formalArg;
            public boolean isRef;
            public boolean isOutputAndStatic;
            public BitVectorContext argContext;

            public ArgumentInfo(String formalArgName, IRfFieldElement formalArg, IHidObject argHidObject, ELParamValueScope argValueScope) {
                this.formalArgName = formalArgName;
                this.formalArg = formalArg;
                this.argHidObject = argHidObject;
                this.argValueScope = argValueScope;
            }
        }
    }

    private static class RandcaseItemStatement
    extends BlockStatement {
        private static final long serialVersionUID = 1L;

        private RandcaseItemStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject weight, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.RANDCASE_ITEM_STATEMENT.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, ":", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(weight, false);
            this.addRHValue(statement, false);
        }

        public BigInteger getWeight(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            ELParamValueScope weight = ELUtils.evaluate(this.lhValue, evaluator, context, guardian);
            if (ELUtils.isUnsuccessfulEval(weight)) {
                guardian.logError("Fail to evaluate randcase item weight.");
                return BigInteger.ZERO;
            }
            return XUtils.getValue(weight).getDVTNumber().bigIntegerValue();
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            return ELUtils.evaluate((IHidObject)this.rhValues.get(0), evaluator, context, guardian);
        }
    }

    private static class RandcaseStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;

        private RandcaseStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.RANDCASE_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "randcase_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(RANDCASE_BLOCK_IMPLICIT, false);
            if (HidUtils.isOperator(statement) && ((HidOperator)statement).getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR) {
                ListContainer<IHidObject> items = ((HidOperator)statement).getRHValues();
                if (items != null) {
                    for (IHidObject item : items) {
                        this.addRHValue(item, false);
                    }
                }
            } else if (statement != null) {
                this.addRHValue(statement, false);
            }
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            if (this.rhValues == null || this.rhValues.isEmpty()) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            BigInteger[] weights = new BigInteger[this.rhValues.size()];
            BigInteger totalPlusOne = BigInteger.ONE;
            int i = 0;
            while (i < this.rhValues.size()) {
                BigInteger weight;
                RandcaseItemStatement statement = (RandcaseItemStatement)this.rhValues.get(i);
                weights[i] = weight = statement.getWeight(evaluator, context, guardian);
                totalPlusOne = totalPlusOne.add(weight);
                ++i;
            }
            if (BigInteger.ONE.equals(totalPlusOne)) {
                guardian.logWarning("No randcase branch executed because sum of weigths is 0");
            }
            Random random = guardian.getFactory().getRandcaseRandom();
            BigInteger randValue = new BigInteger(totalPlusOne.bitLength() + 6, random).mod(totalPlusOne);
            BigInteger total = BigInteger.ZERO;
            int i2 = 0;
            while (i2 < this.rhValues.size()) {
                if (weights[i2].signum() != 0) {
                    RandcaseItemStatement statement = (RandcaseItemStatement)this.rhValues.get(i2);
                    if (randValue.compareTo(total = total.add(weights[i2])) <= 0) {
                        return ELUtils.evaluate(statement, evaluator, context, guardian);
                    }
                }
                ++i2;
            }
            return ELParamValueScope.IMPLICIT_RESULT;
        }
    }

    public static class RepeatLoopStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private final BitVectorContext bvContext;

        private RepeatLoopStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject repeatCount, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.REPEAT_CONDITION.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "repeat_loop_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(repeatCount, false);
            this.addRHValue(statement, false);
            this.bvContext = BitVectorContext.of(blockNamedElement, false);
        }

        private IHidObject getStatement() {
            ListContainer<IHidObject> rhValues = this.getRHValues();
            return rhValues != null && !rhValues.isEmpty() ? rhValues.get(0) : null;
        }

        private DVTNumber getRepeatNumber(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            IHidObject repeatCount = this.getLHValue();
            if (repeatCount == null) {
                return null;
            }
            BitVectorContext noContext = BitVectorContext.of(context != null ? context.getOrigin() : null, false);
            IELParamValue repeatValue = XUtils.getValue(ELUtils.evaluate(repeatCount, evaluator, noContext, guardian));
            if (ELUtils.isUnsuccessfulEval(repeatValue)) {
                throw new UnknownHidObjectEvaluationException(repeatCount);
            }
            if (!ELUtils.isParamValueNumber(repeatValue)) {
                throw new UnknownHidObjectEvaluationException(repeatCount);
            }
            DVTNumber repeatNumber = repeatValue.getDVTNumber();
            if (DVTNumber.isUndefined(repeatNumber) || repeatNumber.isUnknown()) {
                throw new UnknownHidObjectEvaluationException(repeatCount);
            }
            if (repeatNumber.intValue() <= 0) {
                return null;
            }
            return repeatNumber;
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            guardian.checkBuildCanceled();
            this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XRepeatEvalScope) {
                ((XRepeatEvalScope)xEvalScope).hotSwap(this.getStatement());
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            DVTNumber repeatNumber = this.getRepeatNumber(evaluator, context, guardian);
            if (repeatNumber == null) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            IHidEvaluator currentEvaluator = evaluator;
            IHidObject statement = this.getStatement();
            if (currentEvaluator.isInterpreter() && this.hasLocalMembers()) {
                statement = INSTANCE.createStatement(this.blockNamedElement, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, this.offset, this.getVirtualOffset(), this.line, this.isCaseSensitive, statement);
            }
            currentEvaluator.pushScope(this.isCaseSensitive);
            try {
                XRepeatEvalScope xEvalScope = new XRepeatEvalScope(this.blockNamedElement, this, currentEvaluator, this.bvContext, guardian.copy(), statement, repeatNumber.intValue(), this.line);
                guardian.startEvalScope(xEvalScope);
                ELParamValueScope eLParamValueScope = xEvalScope.execute(guardian.getActiveThread());
                return eLParamValueScope;
            }
            finally {
                currentEvaluator.popScope();
            }
        }
    }

    public static class SeqBlockStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private BitVectorContext bvContext;
        private int forkProcessNumber = -1;

        private SeqBlockStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, ListContainer<IHidObject> statements, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR, "begin_end_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(SEQ_BLOCK_IMPLICIT, false);
            if (statements == null) {
                throw new NullPointerException("Sequential block must contain statements");
            }
            this.rhValues = statements;
            this.bvContext = BitVectorContext.of(blockNamedElement, false);
        }

        @Override
        public void setNamedElement(IRfNamedElement blockNamedElement) {
            super.setNamedElement(blockNamedElement);
            this.bvContext = BitVectorContext.of(blockNamedElement, false);
        }

        public int getForkProcessNumber() {
            return this.forkProcessNumber;
        }

        public void setForkProcessNumber(int forkProcessNumber) {
            this.forkProcessNumber = forkProcessNumber;
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            ListContainer executeStatements = this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XSeqBlockEvalScope && executeStatements.size() == 1) {
                ListContainer<IHidObject> rhValues;
                if (executeStatements.get(0) instanceof IfElseStatement && this.rhValues != null && this.rhValues.size() == 1 && this.rhValues.get(0) instanceof SeqBlockStatement) {
                    executeStatements = ((SeqBlockStatement)this.rhValues.get((int)0)).rhValues;
                }
                if (executeStatements.get(0) instanceof ForkJoinStatement && (rhValues = this.getRHValues()).size() == 1 && rhValues.get(0) instanceof SeqBlockStatement && this.forkProcessNumber != -1 && this.forkProcessNumber < ((SeqBlockStatement)rhValues.get((int)0)).rhValues.size()) {
                    IHidObject forkProcess = (IHidObject)((SeqBlockStatement)rhValues.get((int)0)).rhValues.get(this.forkProcessNumber);
                    ((SeqBlockStatement)rhValues.get((int)0)).rhValues = forkProcess;
                    ArrayListContainer<IHidObject> newStatements = new ArrayListContainer<IHidObject>(1);
                    newStatements.add(forkProcess);
                    executeStatements = newStatements;
                }
                if (this.blockNamedElement instanceof IRfActionBlockElement && ((IRfActionBlockElement)this.blockNamedElement).isForOrForeach() && (executeStatements.get(0) instanceof ForLoopStatement || executeStatements.get(0) instanceof ForeachLoopStatement)) {
                    IHidObject forStatements;
                    rhValues = null;
                    IHidObject iHidObject = forStatements = executeStatements.get(0) instanceof ForLoopStatement ? ((ForLoopStatement)executeStatements.get(0)).getStatement() : ((ForeachLoopStatement)executeStatements.get(0)).getStatement();
                    if (forStatements instanceof SeqBlockStatement) {
                        rhValues = ((SeqBlockStatement)forStatements).getRHValues();
                    }
                    if (rhValues != null && !rhValues.isEmpty()) {
                        for (IHidObject rhValue : rhValues) {
                            if (!(rhValue instanceof SeqBlockStatement) || (executeStatements = ((SeqBlockStatement)rhValue).rhValues) == null || executeStatements.size() != 1 || !(executeStatements.get(0) instanceof SeqBlockStatement)) continue;
                            executeStatements = ((SeqBlockStatement)executeStatements.get((int)0)).rhValues;
                            break;
                        }
                    }
                }
            }
            if (xEvalScope instanceof XFrameBlockEvalScope) {
                return;
            }
            if (xEvalScope instanceof XSeqBlockEvalScope) {
                ((XSeqBlockEvalScope)xEvalScope).hotSwap(executeStatements);
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            if (this.rhValues == null || this.rhValues.isEmpty()) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            IHidEvaluator currentEvaluator = evaluator;
            currentEvaluator.pushScope(this.isCaseSensitive);
            XSeqBlockEvalScope xEvalScope = null;
            boolean hasLocalMembers = this.hasLocalMembers();
            try {
                boolean isHotSwap = false;
                while (true) {
                    block15: {
                        try {
                            ArrayListContainer<IHidObject> statements = new ArrayListContainer<IHidObject>(this.rhValues == null ? 0 : Math.min(10, this.rhValues.size()));
                            this.unfoldStatements(evaluator, statements);
                            currentEvaluator = evaluator;
                            if (currentEvaluator.isInterpreter() && hasLocalMembers) {
                                currentEvaluator = currentEvaluator.createEnclosedValueHolder(this.blockNamedElement);
                            }
                            xEvalScope = new XSeqBlockEvalScope(this, currentEvaluator, this.bvContext, guardian, statements);
                            guardian.startEvalScope(xEvalScope);
                            boolean disableEndEvalScope = false;
                            if (!isHotSwap) break block15;
                            isHotSwap = false;
                            try {
                                currentEvaluator = evaluator;
                                if (currentEvaluator.isInterpreter() && hasLocalMembers) {
                                    currentEvaluator = currentEvaluator.createEnclosedValueHolder(this.blockNamedElement);
                                }
                                this.hotSwap(guardian, currentEvaluator, xEvalScope, context);
                                disableEndEvalScope = true;
                                ELParamValueScope eLParamValueScope = xEvalScope.execute(guardian.getActiveThread());
                                return eLParamValueScope;
                            }
                            finally {
                                if (!disableEndEvalScope) {
                                    guardian.endEvalScope(xEvalScope);
                                }
                            }
                        }
                        catch (HidEvalJumpStatementException.HidEvalHotSwapRerunException hidEvalHotSwapRerunException) {
                            isHotSwap = true;
                            guardian.callbackStartHotSwap();
                            currentEvaluator.prepareHotSwap();
                            guardian.endEvalScope(xEvalScope);
                            currentEvaluator.popScope();
                            currentEvaluator.pushScope(this.isCaseSensitive);
                            continue;
                        }
                    }
                    ELParamValueScope eLParamValueScope = xEvalScope.execute(guardian.getActiveThread());
                    return eLParamValueScope;
                }
            }
            finally {
                currentEvaluator.popScope();
            }
        }

        @Override
        public XCValue collectConstraints(XCModel model, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            ListContainer<IHidObject> statements;
            block5: {
                statements = this.getRHValues();
                if (statements != null && !statements.isEmpty()) break block5;
                return null;
            }
            try {
                IntVariable zeroConstant = model.getCachedConstant(true, 32, BigInteger.ZERO);
                XCValue result = null;
                boolean isRand = false;
                for (IHidObject statement : statements) {
                    XCValue statementXCValue = statement.collectConstraints(model, evaluator, context, guardian.copy());
                    if (statementXCValue == null) continue;
                    isRand |= statementXCValue.isRand();
                    IntVariable statementIntVar = statementXCValue.getIntVar();
                    if (!(statementIntVar instanceof BoolVariable)) {
                        statementIntVar = statementIntVar.ne(zeroConstant).reify();
                        statementXCValue.setIntVar(statementIntVar);
                    }
                    statementXCValue.setHidOperator((IHidOperator)statement);
                    result = result == null ? statementXCValue : model.createVariable(result.getIntVar().and(statementIntVar), isRand, this);
                }
                return result;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }

        public void unfoldStatements(IHidEvaluator evaluator, List<IHidObject> statements) {
            if (this.rhValues == null || this.rhValues.isEmpty()) {
                return;
            }
            for (IHidObject statement : this.rhValues) {
                if (evaluator.isInterpreter() && statement instanceof IInitialValueDeclarationStatement && ((IInitialValueDeclarationStatement)statement).getField().xIsStaticMember()) continue;
                if (statement instanceof SeqBlockStatement && !((SeqBlockStatement)statement).hasLocalMembers()) {
                    ((SeqBlockStatement)statement).unfoldStatements(evaluator, statements);
                    continue;
                }
                statements.add(statement);
            }
        }
    }

    static class SpecialProceduralAssign
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        private XSimRegion.XRegionKind regionKind;
        private HidOperator assignOperator;

        protected SpecialProceduralAssign(XSimRegion.XRegionKind regionKind, HidOperator assignOperator) {
            super(assignOperator.getOperatorType(), assignOperator.getOperatorKind(), assignOperator.getOperatorText(), assignOperator.getOffset(), assignOperator.getLine(), -1, -1, assignOperator.getQualifiers());
            this.regionKind = regionKind;
            this.assignOperator = assignOperator;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            if (evaluator.isInterpreter()) {
                XValueHolderFactory factory = guardian.getFactory();
                ParserPath parserPath = factory.getCurrentParserPath();
                guardian.callbackDelayedAssign(XUtils.MINUS_ONE_DECIMAL, this.regionKind, () -> {
                    factory.setCurrentParserPath(parserPath);
                    factory.setCurrentLineNumber(this.line);
                    this.assignOperator.evaluate(evaluator, context, guardian);
                });
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            return this.assignOperator.evaluate(evaluator, context, guardian);
        }

        public HidOperator getAssignOperator() {
            return this.assignOperator;
        }

        @Override
        public int getUsageIndex() {
            return this.assignOperator.getUsageIndex();
        }

        @Override
        public int getVirtualOffset() {
            return this.assignOperator.getVirtualOffset();
        }

        @Override
        public IHidObject xGetAssignmentLHS() {
            return this.assignOperator.getLHValue();
        }

        @Override
        public LanguageKind getLanguageKind() {
            return this.assignOperator.getLanguageKind();
        }
    }

    public static class WhileLoopStatement
    extends BlockStatement
    implements IHotSwapElement {
        private static final long serialVersionUID = 1L;
        private BitVectorContext bvContext;

        private WhileLoopStatement(IRfNamedElement blockNamedElement, int startOffset, int startVirtualOffset, int startLine, IHidObject condition, IHidObject statement, boolean isCaseSensitive) {
            super(blockNamedElement, IHidOperatorConstants.OperatorType.WHILE_LOOP_STATEMENT.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "while_loop_statement", startOffset, startVirtualOffset, startLine, isCaseSensitive);
            this.addLHValue(condition, false);
            this.addRHValue(statement, false);
            this.bvContext = BitVectorContext.of(blockNamedElement != null ? (IRfNamedElement)blockNamedElement.getEnclosingScope() : null, false);
        }

        private IHidObject getCondition() {
            return this.getLHValue();
        }

        private IHidObject getStatement() {
            ListContainer<IHidObject> rhValues = this.getRHValues();
            return rhValues != null && !rhValues.isEmpty() ? rhValues.get(0) : null;
        }

        @Override
        public void hotSwap(IHidEvaluationGuardian guardian, IHidEvaluator evaluator, XEvalScope xEvalScope, BitVectorContext context) {
            guardian.checkBuildCanceled();
            this.hotSwapHids(this.blockNamedElement, this, guardian, evaluator, xEvalScope);
            if (xEvalScope instanceof XWhileEvalScope) {
                ((XWhileEvalScope)xEvalScope).hotSwap(this.getStatement(), null, null, this.getCondition());
            }
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.checkBuildCanceled();
            XWhileEvalScope xEvalScope = new XWhileEvalScope(this.blockNamedElement, this, evaluator, this.bvContext, guardian.copy(), this.getStatement(), this.getCondition());
            guardian.startEvalScope(xEvalScope);
            return xEvalScope.execute(guardian.getActiveThread());
        }
    }
}

