/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IResultImplicitVariable;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfConstraintElement;
import ro.amiq.dvt.model.reflection.IRfCovergroup;
import ro.amiq.dvt.model.reflection.IRfCoverpoint;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPropertySequence;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfWaitElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownScopeEvaluationException;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedUtils;

public enum HidEvalConverter {
    INSTANCE;


    public IHidOperator convertMethod(IRfMethodElement method, IHidEvaluationGuardian guardian, IHidEvaluator evaluator) {
        if (method == null) {
            throw new NullPointerException("Must specify method");
        }
        if (guardian == null) {
            throw new NullPointerException("Must specify guardian");
        }
        return new HidEvalElementConverter(guardian, evaluator).convertScope(method, new ArrayDeque<ActionBlockHeader>(), null, new ArrayDeque<ActionBlockHeader>(), false);
    }

    public IHidOperator convertElement(IRfNamedElement element, IHidEvaluationGuardian guardian, IHidEvaluator evaluator) {
        if (element == null) {
            throw new NullPointerException("Must specify element");
        }
        if (guardian == null) {
            throw new NullPointerException("Must specify guardian");
        }
        return new HidEvalElementConverter(guardian, evaluator).convertScope(element, new ArrayDeque<ActionBlockHeader>(), null, new ArrayDeque<ActionBlockHeader>(), false);
    }

    public IHidOperator convertConstraint(IRfNamedElement element, IHidEvaluationGuardian guardian, IHidEvaluator evaluator) {
        if (element == null) {
            throw new NullPointerException("Must specify element");
        }
        if (guardian == null) {
            throw new NullPointerException("Must specify guardian");
        }
        return new HidEvalElementConverter(guardian, evaluator).convertConstraint(element);
    }

    public IHidOperator convertConcurrentAssertion(IRfAssertExpectElement element, IHidEvaluationGuardian guardian, IHidEvaluator evaluator) {
        if (!XUtils.isConcurrentAssertion(element)) {
            throw new NullPointerException("Must specify concurrent assert");
        }
        if (guardian == null) {
            throw new NullPointerException("Must specify guardian");
        }
        return new HidEvalElementConverter(guardian, evaluator).convertConcurrentAssertion(element);
    }

    public IHidOperator convertConstraintWithClause(IHidOperator withClause, IRfNamedElement functionCall) {
        IRfDefElement declaration;
        if (withClause == null || !withClause.isWithClauseConstraint()) {
            throw new NullPointerException("Must with clause operator");
        }
        ParserPath parserPath = null;
        if (functionCall != null && (declaration = functionCall.getDeclaration()) != null) {
            parserPath = declaration.getParserPath();
        }
        IdentityHashMap<IHidOperator, IHidOperator> conversionMap = new IdentityHashMap<IHidOperator, IHidOperator>();
        IHidObject hidObject = HidEvalConverter.recursiveConvertContraintOperator(withClause.getLHValue(), conversionMap, parserPath);
        if (functionCall != null) {
            functionCall.visitHidObject(null, new HidEvalConstraintMappingVisitor(conversionMap));
        }
        return hidObject instanceof IHidOperator ? (IHidOperator)hidObject : null;
    }

    public IHidOperator convertCovergroup(IRfNamedElement element, IHidEvaluationGuardian guardian, IHidEvaluator evaluator) {
        if (element == null) {
            throw new NullPointerException("Must specify element");
        }
        if (guardian == null) {
            throw new NullPointerException("Must specify guardian");
        }
        return new HidEvalElementConverter(guardian, evaluator).convertCovergroup(element);
    }

    private static IHidOperator convertConstraintOperator(IHidOperator operator, Map<IHidOperator, IHidOperator> conversionMap, ParserPath parserPath) {
        if (!operator.isComplete()) {
            return null;
        }
        IHidObject hidObject = HidEvalConverter.recursiveConvertContraintOperator(operator, conversionMap, parserPath);
        return hidObject instanceof IHidOperator ? (IHidOperator)hidObject : null;
    }

    private static IHidObject recursiveConvertContraintOperator(IHidObject hidObject, Map<IHidOperator, IHidOperator> conversionMap, ParserPath parserPath) {
        if (!HidUtils.isOperator(hidObject)) {
            return hidObject;
        }
        if (((HidOperator)hidObject).hasQualifier(HidQualifierCache.IS_ASSOCIATION_QUALIFIER)) {
            return null;
        }
        HidOperator operator = (HidOperator)hidObject;
        if (operator.isIfElseStatement()) {
            IHidObject convertedLHSide = HidEvalConverter.recursiveConvertContraintOperator(operator.getLHValue(), conversionMap, parserPath);
            ListContainer<IHidObject> rhValues = operator.getRHValues();
            IHidObject convertedThenSide = HidEvalConverter.recursiveConvertContraintOperator(rhValues.get(0), conversionMap, parserPath);
            IHidObject convertedElseSide = HidEvalConverter.recursiveConvertContraintOperator(rhValues.size() > 1 ? rhValues.get(1) : null, conversionMap, parserPath);
            HidOperatorOccurrence occurrence = operator.getOccurrence();
            HidOperator convertedOperator = HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id, parserPath, occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getLine(), null, true, convertedLHSide, convertedThenSide);
            if (convertedOperator != null && convertedElseSide != null) {
                convertedOperator.addRHValue(convertedElseSide, false);
            }
            if (conversionMap != null) {
                conversionMap.put(operator, convertedOperator);
            }
            return convertedOperator;
        }
        if (operator.isForeachStatement()) {
            IHidObject convertedLHSide = HidEvalConverter.recursiveConvertContraintOperator(operator.getLHValue(), conversionMap, parserPath);
            ListContainer<IHidObject> rhValues = operator.getRHValues();
            IHidObject convertedRHSide = HidEvalConverter.recursiveConvertContraintOperator(rhValues.get(0), conversionMap, parserPath);
            HidOperatorOccurrence occurrence = operator.getOccurrence();
            HidOperator convertedOperator = HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.FOREACH_LOOP_CONSTRAINT_STATEMENT.id, parserPath, occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getLine(), null, true, convertedLHSide, convertedRHSide);
            if (conversionMap != null) {
                conversionMap.put(operator, convertedOperator);
            }
            return convertedOperator;
        }
        if (operator.isConstraintSeqBlock()) {
            IHidOperator convertedOperator;
            ListContainer<IHidObject> rhValues = operator.getRHValues();
            ArrayListContainer<IHidObject> result = new ArrayListContainer<IHidObject>(rhValues.size());
            int i = rhValues.size() - 1;
            while (i >= 0) {
                IHidObject convertedRHValue = HidEvalConverter.recursiveConvertContraintOperator(rhValues.get(i), conversionMap, parserPath);
                if (convertedRHValue != null) {
                    result.add(convertedRHValue);
                }
                --i;
            }
            HidOperatorOccurrence occurrence = operator.getOccurrence();
            IHidOperator iHidOperator = convertedOperator = result.size() == 1 ? (IHidOperator)result.get(0) : HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, occurrence.getOpenBoundary(), occurrence.getOpenVirtualBoundary(), occurrence.getLine(), true, result);
            if (conversionMap != null) {
                conversionMap.put(operator, convertedOperator);
            }
            return convertedOperator;
        }
        return operator;
    }

    private static class ActionBlockHeader {
        public final IRfActionBlockElement.BlockQualifier qualifier;
        public final IHidObject condition;
        public final boolean isCaseSensitive;
        public IHidOperator statement;
        public IHidObject forInit;
        public IHidObject forStep;
        public IRfActionBlockElement.BlockQualifier caseQualifier;

        public ActionBlockHeader(IRfActionBlockElement.BlockQualifier qualifier, IHidObject condition, boolean isCaseSensitive) {
            this.qualifier = qualifier;
            this.condition = condition;
            this.isCaseSensitive = isCaseSensitive;
        }

        public boolean isForkJoin() {
            return this.qualifier == IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE || this.qualifier == IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY || this.qualifier == IRfActionBlockElement.BlockQualifier.FORK_JOIN;
        }

        public String toString() {
            return (Object)((Object)this.qualifier) + " " + this.condition + " (" + this.statement + ") " + this.forInit + " " + this.forStep;
        }
    }

    private static class HidEvalConstraintMappingVisitor
    implements IHidVisitor<HidOperator> {
        private IRfNamedElement scope;
        private Map<IHidOperator, IHidOperator> conversionMap;

        public HidEvalConstraintMappingVisitor(Map<IHidOperator, IHidOperator> conversionMap) {
            this.conversionMap = conversionMap;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.scope = ((HidHolder)holder).getScope();
            }
        }

        @Override
        public boolean visit(HidOperator operator) {
            IHidOperator converted;
            if (this.scope == null) {
                return true;
            }
            if ((operator.isIfElseStatement() || operator.isForeachStatement() || operator.isConstraintSeqBlock()) && (converted = this.conversionMap.get(operator)) instanceof HidEvalCenter.BlockStatement) {
                ((HidEvalCenter.BlockStatement)converted).setNamedElement(this.scope);
            }
            return true;
        }

        @Override
        public Class<HidOperator> getType() {
            return HidOperator.class;
        }
    }

    private static class HidEvalElementConverter {
        private static final long CASE_BLOCK_WITH_DEFAULT_QUALIFIER = IRfActionBlockElement.BlockQualifier.CASE.value() + IRfActionBlockElement.BlockQualifier.CASEX.value() + IRfActionBlockElement.BlockQualifier.CASEZ.value();
        private static final long LOOP_BLOCK_QUALIFIER = IRfActionBlockElement.BlockQualifier.FOR.value() | IRfActionBlockElement.BlockQualifier.FOREACH.value() | IRfActionBlockElement.BlockQualifier.FOREVER.value() | IRfActionBlockElement.BlockQualifier.WHILE.value() | IRfActionBlockElement.BlockQualifier.REPEAT.value() | IRfActionBlockElement.BlockQualifier.DO.value();
        private IHidEvaluationGuardian guardian;
        private IHidEvaluator evaluator;

        protected HidEvalElementConverter(IHidEvaluationGuardian guardian, IHidEvaluator evaluator) {
            this.guardian = guardian;
            this.evaluator = evaluator;
        }

        public IHidOperator convertConcurrentAssertion(IRfAssertExpectElement assertElement) {
            if (assertElement == null) {
                return null;
            }
            if (!this.evaluator.isInterpreter()) {
                this.guardian.logError("Fail to evaluate concurrent assert (not supported yet)");
                return null;
            }
            IHidOperator assertStatement = this.convertVlogAssert(assertElement, null);
            if (!(assertStatement instanceof HidEvalCenter.ConcurrentAssertStatement)) {
                return null;
            }
            return assertStatement;
        }

        public IHidOperator convertScope(IRfNamedElement namedElement, ArrayDeque<ActionBlockHeader> ifConditions, Supplier<HidOperator> alwaysBlockEventControl, ArrayDeque<ActionBlockHeader> caseItemConditions, boolean forceForkJoinConversion) {
            ActionBlockHeader header;
            this.guardian.checkBuildCanceled();
            if (!HidEvalElementConverter.isValidScope(namedElement)) {
                return null;
            }
            if (!this.evaluator.isInterpreter() && namedElement instanceof IRfActionBlockElement && ((IRfActionBlockElement)namedElement).hasForkJoin()) {
                this.guardian.logError("Fail to evaluate fork block (not supported yet)");
                return null;
            }
            if (namedElement == null) {
                return null;
            }
            IRfDefElement declaration = namedElement.xGetDeclaration();
            if (declaration == null) {
                return null;
            }
            ParserPath parserPath = declaration.getParserPath();
            int startOffset = declaration.getStartOffset();
            int startVirtualOffset = declaration.getStartVirtualOffset();
            int startLine = declaration.getStartLine();
            XValueHolderFactory factory = this.guardian.getFactory();
            if (this.guardian.isInterpreter() && factory != null) {
                factory.setCurrentParserPath(parserPath);
                factory.setCurrentLineNumber(startLine);
            }
            ArrayListContainer<IHidObject> progs = new ArrayListContainer<IHidObject>(16);
            IRfActionBlockElement actionBlock = namedElement instanceof IRfActionBlockElement ? (IRfActionBlockElement)namedElement : null;
            ActionBlockHeader actionBlockHeader = header = !forceForkJoinConversion ? this.extractActionBlockHeader(actionBlock, ifConditions, caseItemConditions) : this.extractForkJoinHeader(actionBlock);
            if (!forceForkJoinConversion && header != null && !header.isForkJoin() && actionBlock != null && actionBlock.hasForkJoin()) {
                IHidOperator prog = this.convertScope(actionBlock, new ArrayDeque<ActionBlockHeader>(), alwaysBlockEventControl, new ArrayDeque<ActionBlockHeader>(), true);
                if (prog == null) {
                    return null;
                }
                progs.add(prog);
                IHidOperator statement = HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, startOffset, startVirtualOffset, startLine, true, progs);
                statement = this.internalCreateHeaderStatement(header, statement, namedElement, parserPath, startOffset, startVirtualOffset, startLine);
                return statement;
            }
            this.visitHidHolder(namedElement, header, progs);
            this.visitMembers(namedElement, progs, alwaysBlockEventControl, this.internalNewCaseItemConditions(caseItemConditions));
            this.guardian.checkBuildCanceled();
            boolean isCaseSensitive = header == null || header.isCaseSensitive;
            int progSize = progs.size();
            if (progSize > 1) {
                if (header == null || header.qualifier != IRfActionBlockElement.BlockQualifier.CASE && header.qualifier != IRfActionBlockElement.BlockQualifier.CASEZ && header.qualifier != IRfActionBlockElement.BlockQualifier.CASEX) {
                    Collections.sort(progs, (o1, o2) -> HidOperator.OPERATOR_COMPARATOR.compare((HidOperator)o1, (HidOperator)o2));
                }
                if (this.guardian.isInterpreter() && factory != null) {
                    int i = 0;
                    while (i < progSize) {
                        HidOperator candidate = (HidOperator)progs.get(i);
                        if (i != 0 && !candidate.hasOccurrence(HidQualifierCache.IS_STATEMENT_QUALIFIER) && XUtils.isSensitiveAllEdgeControl(candidate)) {
                            HidOperator eventControl = factory.transformEdgeControl(candidate, i + 1 < progSize ? (IHidObject)progs.get(i + 1) : null, null, this.guardian);
                            progs.set(i, eventControl);
                        }
                        ++i;
                    }
                }
                if (header != null && (header.qualifier == IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE || header.qualifier == IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY || header.qualifier == IRfActionBlockElement.BlockQualifier.FORK_JOIN)) {
                    ArrayListContainer<IHidOperator> newProgs = new ArrayListContainer<IHidOperator>(progSize);
                    int i = 0;
                    while (i < progSize) {
                        ArrayListContainer<IHidObject> grouped = new ArrayListContainer<IHidObject>(2);
                        while (i < progSize - 1) {
                            HidOperator candidate = (HidOperator)progs.get(i);
                            if (candidate.hasQualifier(HidQualifierCache.IS_STATEMENT_QUALIFIER) || !candidate.hasQualifier(HidQualifierCache.IS_DELAY_CONTROL_QUALIFIER) && !candidate.hasQualifier(HidQualifierCache.IS_EVENT_CONTROL_QUALIFIER) && !candidate.isWaitEventControl() && !candidate.isPoundPound()) break;
                            grouped.add(candidate);
                            ++i;
                        }
                        IHidOperator prog = (IHidOperator)progs.get(i);
                        if (!grouped.isEmpty()) {
                            grouped.add(prog);
                            IHidOperator controledStatement = grouped.size() == 1 ? (IHidOperator)grouped.get(0) : HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, prog.getOffset(), prog.getVirtualOffset(), prog.getLine(), isCaseSensitive, grouped);
                            newProgs.add(controledStatement);
                        } else {
                            newProgs.add(prog);
                        }
                        ++i;
                    }
                    if (newProgs.size() < progSize) {
                        progs = newProgs;
                        progSize = progs.size();
                    }
                }
            }
            this.guardian.checkBuildCanceled();
            IHidOperator statement = HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, startOffset, startVirtualOffset, startLine, isCaseSensitive, progs);
            statement = this.internalCreateHeaderStatement(header, statement, namedElement, parserPath, startOffset, startVirtualOffset, startLine);
            return statement;
        }

        private IHidOperator internalCreateHeaderStatement(ActionBlockHeader header, IHidOperator statement, IRfNamedElement namedElement, ParserPath parserPath, int startOffset, int startVirtualOffset, int startLine) {
            if (header == null) {
                return statement;
            }
            switch (header.qualifier) {
                case IF: {
                    HidOperator ifStatement = HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                    header.statement = ifStatement;
                    return ifStatement;
                }
                case ELSE: {
                    if (header.statement == null) {
                        return null;
                    }
                    header.statement.addRHValue(statement, false);
                    return null;
                }
                case ELSIF: {
                    if (header.statement == null) {
                        return null;
                    }
                    HidOperator elsifStatement = HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                    header.statement.addRHValue(elsifStatement, false);
                    header.statement = elsifStatement;
                    return null;
                }
                case RANDCASE_ITEM: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.RANDCASE_ITEM_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                }
                case CASE_ITEM: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.CASE_ITEM_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                }
                case RANDCASE: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.RANDCASE_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, statement);
                }
                case CASE: 
                case CASEX: 
                case CASEZ: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.CASE_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, header.caseQualifier, header.isCaseSensitive, header.condition, statement);
                }
                case WHILE: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.WHILE_LOOP_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                }
                case DO: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.DO_WHILE_LOOP_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                }
                case FOREACH: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.FOREACH_LOOP_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                }
                case FOREVER: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.FOREVER_LOOP_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                }
                case FOR: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.FOR_LOOP_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.forInit, header.condition, header.forStep, statement);
                }
                case REPEAT: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.REPEAT_CONDITION.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, header.condition, statement);
                }
                case FORK_JOIN_NONE: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.FORK_JOIN_NONE_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, statement);
                }
                case FORK_JOIN_ANY: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.FORK_JOIN_ANY_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, statement);
                }
                case FORK_JOIN: {
                    return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.FORK_JOIN_STATEMENT.id, parserPath, startOffset, startVirtualOffset, startLine, null, header.isCaseSensitive, statement);
                }
            }
            return null;
        }

        private void visitMembers(IRfNamedElement namedElement, BiConsumer<IRfNamedElement, IHidObject> collector, Supplier<HidOperator> alwaysBlockEventControl, ArrayDeque<ActionBlockHeader> caseConditions) {
            IHidOperator iHidOperator;
            this.guardian.checkBuildCanceled();
            Collection<? extends IRfNamedElement> members = namedElement.getMembers(true, true);
            if (members == null || members.isEmpty()) {
                return;
            }
            boolean hasDefaultCaseItemMember = namedElement instanceof IRfActionBlockElement && namedElement.getLanguageKind() == LanguageKind.VLOG && ((IRfActionBlockElement)namedElement).hasBlockQualifier(CASE_BLOCK_WITH_DEFAULT_QUALIFIER);
            IRfNamedElement defaultCaseItemMember = null;
            ArrayDeque<ActionBlockHeader> ifConditions = new ArrayDeque<ActionBlockHeader>();
            for (IRfNamedElement iRfNamedElement : members) {
                IHidOperator prog2;
                IHidObject condition;
                List<IHidObject> conditions;
                this.guardian.checkBuildCanceled();
                if (hasDefaultCaseItemMember && defaultCaseItemMember == null && iRfNamedElement instanceof IRfActionBlockElement && (conditions = ((IRfActionBlockElement)iRfNamedElement).computeConditionOperator(this.evaluator, this.guardian)) != null && !conditions.isEmpty() && HidUtils.isHidImplicit(condition = conditions.get(0)) && ((IHidImplicit)condition).isOthers()) {
                    defaultCaseItemMember = iRfNamedElement;
                    continue;
                }
                if (iRfNamedElement instanceof IRfAssertExpectElement) {
                    IRfAssertExpectElement assertElement = (IRfAssertExpectElement)iRfNamedElement;
                    if (assertElement.isImmediateAssert() || assertElement.isImmediateAssume() || assertElement.isConcurrentAssertionStatement()) {
                        IHidOperator prog3 = this.convertVlogAssert((IRfAssertExpectElement)iRfNamedElement, alwaysBlockEventControl);
                        if (prog3 != null) {
                            collector.accept(iRfNamedElement, prog3);
                            continue;
                        }
                    } else if (assertElement.isImmediateCover()) {
                        this.guardian.setLineNumber(assertElement.getLine());
                        this.guardian.logError("Fail to evaluate immediate cover (not supported yet)");
                    }
                    if (this.guardian.isInterpreter()) continue;
                    throw new UnknownScopeEvaluationException("assert/assume/cover/expect/restrict", iRfNamedElement.getOffset(), iRfNamedElement.getLine());
                }
                if (iRfNamedElement instanceof IRfActionBlockElement) {
                    if (((IRfActionBlockElement)iRfNamedElement).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.RANDSEQUENCE)) {
                        this.guardian.setLineNumber(iRfNamedElement.getLine());
                        this.guardian.logError("Fail to evaluate randsequence (not supported yet)");
                        if (this.guardian.isInterpreter()) continue;
                        throw new UnknownScopeEvaluationException("randsequence", iRfNamedElement.getOffset(), iRfNamedElement.getLine());
                    }
                    if (!this.guardian.isInterpreter() && ((IRfActionBlockElement)iRfNamedElement).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.RANDCASE)) {
                        this.guardian.setLineNumber(iRfNamedElement.getLine());
                        this.guardian.logError("Fail to evaluate randcase (not supported yet)");
                        throw new UnknownScopeEvaluationException("randcase", iRfNamedElement.getOffset(), iRfNamedElement.getLine());
                    }
                }
                if ((prog2 = this.convertScope(iRfNamedElement, ifConditions, alwaysBlockEventControl, caseConditions, false)) != null) {
                    collector.accept(iRfNamedElement, prog2);
                    continue;
                }
                prog2 = this.convertFieldWithoutInitialValue(iRfNamedElement);
                if (prog2 != null) {
                    collector.accept(iRfNamedElement, prog2);
                    continue;
                }
                prog2 = this.convertVHDLFieldAlias(iRfNamedElement);
                if (prog2 != null) {
                    collector.accept(iRfNamedElement, prog2);
                    continue;
                }
                if (!this.guardian.isInterpreter() || iRfNamedElement instanceof IRfFieldElement || iRfNamedElement instanceof IRfActionBlockElement || iRfNamedElement instanceof IRfTypeAliasElement || iRfNamedElement instanceof IRfCompositeTypeElement) continue;
                this.guardian.logWarning("Unsupported scope '" + iRfNamedElement + "'", iRfNamedElement.getDeclaration());
            }
            if (defaultCaseItemMember != null && (iHidOperator = this.convertScope(defaultCaseItemMember, ifConditions, alwaysBlockEventControl, caseConditions, false)) != null) {
                collector.accept(defaultCaseItemMember, iHidOperator);
            }
        }

        private void visitMembers(IRfNamedElement namedElement, List<IHidObject> progs, Supplier<HidOperator> alwaysBlockEventControl, ArrayDeque<ActionBlockHeader> caseConditions) {
            if (namedElement instanceof IRfActionBlockElement && ((IRfActionBlockElement)namedElement).isAlways() && !progs.isEmpty()) {
                for (IHidObject prog2 : progs) {
                    if (!(prog2 instanceof HidOperator) || !((HidOperator)prog2).isVlogEventControl()) continue;
                    alwaysBlockEventControl = () -> (HidOperator)prog2;
                    break;
                }
            }
            this.visitMembers(namedElement, (IRfNamedElement _ignore, IHidObject prog) -> {
                boolean bl = progs.add((IHidObject)prog);
            }, alwaysBlockEventControl, caseConditions);
        }

        private ArrayDeque<ActionBlockHeader> internalNewCaseItemConditions(ArrayDeque<ActionBlockHeader> prevCaseItemConditions) {
            ArrayDeque<ActionBlockHeader> newCaseItemConditions = new ArrayDeque<ActionBlockHeader>();
            if (prevCaseItemConditions != null && !prevCaseItemConditions.isEmpty()) {
                ActionBlockHeader lastCaseItemCondition = prevCaseItemConditions.getLast();
                if (lastCaseItemCondition.qualifier == IRfActionBlockElement.BlockQualifier.CASE || lastCaseItemCondition.qualifier == IRfActionBlockElement.BlockQualifier.CASEX || lastCaseItemCondition.qualifier == IRfActionBlockElement.BlockQualifier.CASEZ || lastCaseItemCondition.qualifier == IRfActionBlockElement.BlockQualifier.RANDCASE) {
                    newCaseItemConditions.add(lastCaseItemCondition);
                }
            }
            return newCaseItemConditions;
        }

        private IHidOperator convertVlogAssert(IRfAssertExpectElement member, Supplier<HidOperator> alwaysBlockEventControl) {
            boolean isImmediate;
            boolean bl = isImmediate = member.isImmediateAssert() || member.isImmediateAssume();
            if (!isImmediate && !this.guardian.isConcurrentAssertionEnabled()) {
                return null;
            }
            IRfDefElement declaration = member.getDeclaration();
            if (declaration == null) {
                return null;
            }
            int startOffset = declaration.getStartOffset();
            int startVirtualOffset = declaration.getStartVirtualOffset();
            int startLine = declaration.getStartLine();
            IHidObject[] ifProg = new IHidObject[1];
            IHidObject[] elseProg = new IHidObject[1];
            this.visitMembers((IRfNamedElement)member, (IRfNamedElement assertMember, IHidObject prog) -> {
                if (assertMember instanceof IRfActionBlockElement && ((IRfActionBlockElement)assertMember).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ASSERT_ELSE)) {
                    iHidObjectArray[0] = prog;
                } else {
                    iHidObjectArray2[0] = prog;
                }
            }, null, new ArrayDeque<ActionBlockHeader>());
            if (ifProg[0] == null && isImmediate) {
                ArrayList<IHidObject> progs = new ArrayList<IHidObject>();
                this.visitHidHolder(member, null, progs);
                if (!progs.isEmpty()) {
                    ifProg[0] = (IHidObject)progs.get(0);
                }
            }
            if (isImmediate) {
                return HidEvalCenter.INSTANCE.createAssertStatement(member, member.xGetVlogAssertionCondition(), ifProg[0], elseProg[0], startOffset, startVirtualOffset, startLine);
            }
            HidOperator alwaysEventControlOperator = alwaysBlockEventControl != null ? alwaysBlockEventControl.get() : null;
            HidEvalCenter.ConcurrentAssertStatement qAssertStatement = (HidEvalCenter.ConcurrentAssertStatement)HidEvalCenter.INSTANCE.createConcurrentAssertStatement(member, member.xGetVlogAssertionCondition(), ifProg[0], elseProg[0], startOffset, startVirtualOffset, startLine);
            IHidObject condition = qAssertStatement.getLHValue();
            if (!HidUtils.isOperator(condition)) {
                return null;
            }
            qAssertStatement.transformConcurrentAssert(qAssertStatement, this.evaluator, member, alwaysEventControlOperator, this.guardian);
            return qAssertStatement;
        }

        private IHidOperator convertVHDLFieldAlias(IRfNamedElement member) {
            if (member.getLanguageKind() != LanguageKind.VHDL) {
                return null;
            }
            if (!(member instanceof IRfTypeAliasElement)) {
                return null;
            }
            IRfNamedElement translatedCandidate = ((IRfTypeAliasElement)member).getTranslatedType();
            if (!(translatedCandidate instanceof IRfFieldElement)) {
                return null;
            }
            List<IHidOperator> operators = member.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_ALIAS_DECLARATION}, true);
            if (operators == null || operators.isEmpty()) {
                return null;
            }
            IHidOperator operator = operators.get(0);
            return HidEvalCenter.INSTANCE.createDeclarationWithInitialValue((IRfFieldElement)member, operator.getLHValue(), operator.getOccurrence());
        }

        private IHidOperator convertFieldWithoutInitialValue(IRfNamedElement member) {
            if (!(member instanceof IRfFieldElement) || ((IRfFieldElement)member).getInitialValue(false) != null || member instanceof IRfTypeAliasElement) {
                return null;
            }
            if (member instanceof IResultImplicitVariable) {
                return null;
            }
            if (((IRfFieldElement)member).getFieldKind() == 524288) {
                return null;
            }
            IRfScopeElement enclosingScope = member.getEnclosingScope();
            if (enclosingScope instanceof IRfActionBlockElement && ((IRfActionBlockElement)enclosingScope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FOREACH)) {
                return null;
            }
            return HidEvalCenter.INSTANCE.createDeclaration((IRfFieldElement)member);
        }

        public IHidOperator convertConstraint(IRfNamedElement namedElement) {
            Collection<? extends IRfNamedElement> members;
            this.guardian.checkBuildCanceled();
            if (!(namedElement instanceof IRfConstraintElement)) {
                return null;
            }
            IRfDefElement declaration = namedElement.xGetDeclaration();
            if (declaration == null) {
                return null;
            }
            ArrayListContainer<IHidObject> progs = new ArrayListContainer<IHidObject>(16);
            IdentityHashMap<IHidOperator, IHidOperator> conversionMap = new IdentityHashMap<IHidOperator, IHidOperator>();
            HidEvalHidObjectConstraintVisitor visitor = new HidEvalHidObjectConstraintVisitor(progs, conversionMap, this.guardian);
            IHidHolder ownHidHolder = namedElement.getHidHolder();
            if (ownHidHolder != null) {
                ownHidHolder.visitHidObject(null, visitor);
            }
            if ((members = namedElement.xGetLocalMembers()) != null) {
                for (IRfNamedElement iRfNamedElement : members) {
                    IHidHolder memberHidHolder = iRfNamedElement.getHidHolder();
                    if (memberHidHolder == null) continue;
                    memberHidHolder.visitHidObject(null, visitor);
                }
            }
            namedElement.visitHidObject(null, new HidEvalConstraintMappingVisitor(conversionMap));
            int startOffset = declaration.getStartOffset();
            int startVirtualOffset = declaration.getStartVirtualOffset();
            int startLine = declaration.getStartLine();
            return HidEvalCenter.INSTANCE.createStatement(namedElement, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, startOffset, startVirtualOffset, startLine, true, progs);
        }

        public IHidOperator convertCovergroup(IRfNamedElement namedElement) {
            IRfDefElement iRfDefElement;
            this.guardian.checkBuildCanceled();
            if (!(namedElement instanceof IRfCovergroup)) {
                return null;
            }
            final HashMap<String, IHidOperator> covergroupOptions = new HashMap<String, IHidOperator>();
            final ArrayList<IHidOperator> covergroupEvents = new ArrayList<IHidOperator>();
            IHidHolder hidHolder = namedElement.getHidHolder();
            if (hidHolder != null) {
                hidHolder.visitHidObject(null, new IHidVisitor<HidOperator>(){

                    @Override
                    public boolean visit(HidOperator hidOperator) {
                        guardian.checkBuildCanceled();
                        if (hidOperator.isVlogEventControl()) {
                            covergroupEvents.add(hidOperator);
                        } else if (hidOperator.isCoverageOptionAssignment() && hidOperator.lhValue instanceof IHid) {
                            covergroupOptions.put(HidUtils.toNiceString(hidOperator.lhValue), hidOperator);
                        }
                        return true;
                    }

                    @Override
                    public Class<HidOperator> getType() {
                        return HidOperator.class;
                    }
                });
            }
            ArrayList<HidEvalCenter.CoverpointStatement> coverpoints = new ArrayList<HidEvalCenter.CoverpointStatement>();
            Collection<? extends IRfNamedElement> members = namedElement.getMembers(true, true);
            if (members != null && !members.isEmpty()) {
                for (IRfNamedElement iRfNamedElement : members) {
                    IHidOperator sampleFunctionEvent;
                    if (iRfNamedElement instanceof IRfCoverpoint) {
                        HidEvalCenter.CoverpointStatement coverpoint = this.convertCoverpoint(iRfNamedElement);
                        if (coverpoint == null) continue;
                        coverpoints.add(coverpoint);
                        continue;
                    }
                    if (!(iRfNamedElement instanceof IRfMethodElement) || iRfNamedElement.isPredefined() || !covergroupEvents.isEmpty() || (sampleFunctionEvent = this.convertScope(iRfNamedElement, new ArrayDeque<ActionBlockHeader>(), null, new ArrayDeque<ActionBlockHeader>(), false)) == null) continue;
                    covergroupEvents.add(sampleFunctionEvent);
                }
            }
            if ((iRfDefElement = namedElement.xGetDeclaration()) == null) {
                return HidEvalCenter.INSTANCE.createCovergroup((IRfCovergroup)namedElement, -1, -1, -1, coverpoints, covergroupOptions, covergroupEvents);
            }
            int startOffset = iRfDefElement.getStartOffset();
            int startVirtualOffset = iRfDefElement.getStartVirtualOffset();
            int startLine = iRfDefElement.getStartLine();
            return HidEvalCenter.INSTANCE.createCovergroup((IRfCovergroup)namedElement, startOffset, startVirtualOffset, startLine, coverpoints, covergroupOptions, covergroupEvents);
        }

        private HidEvalCenter.CoverpointStatement convertCoverpoint(final IRfNamedElement namedElement) {
            this.guardian.checkBuildCanceled();
            if (!(namedElement instanceof IRfCoverpoint)) {
                return null;
            }
            IRfDefElement declaration = namedElement.xGetDeclaration();
            if (declaration == null) {
                return null;
            }
            final ArrayList<HidEvalCenter.BinAssignmentStatement> coverpointBins = new ArrayList<HidEvalCenter.BinAssignmentStatement>();
            final HashMap<String, IHidOperator> coverpointOptions = new HashMap<String, IHidOperator>();
            final HidEvalCenter.BinAssignmentStatement[] coverpointDefaultBin = new HidEvalCenter.BinAssignmentStatement[1];
            final IHidObject[] coverpointExpression = new IHidObject[1];
            IHidHolder hidHolder = namedElement.getHidHolder();
            if (hidHolder != null) {
                hidHolder.visitHidObject(null, new IHidVisitor<HidOperator>(){

                    @Override
                    public boolean visit(HidOperator hidOperator) {
                        guardian.checkBuildCanceled();
                        if (hidOperator.isBinAssignment()) {
                            if (hidOperator.rhValues instanceof IHidImplicit && ((IHidImplicit)hidOperator.rhValues).isOthers()) {
                                coverpointDefaultBin[0] = HidEvalCenter.INSTANCE.createBinAssignment(hidOperator, (IRfCoverpoint)namedElement);
                            } else {
                                coverpointBins.add(HidEvalCenter.INSTANCE.createBinAssignment(hidOperator, (IRfCoverpoint)namedElement));
                            }
                        } else if (hidOperator.isCoverageOptionAssignment() && hidOperator.lhValue instanceof IHid) {
                            coverpointOptions.put(HidUtils.toNiceString(hidOperator.lhValue), hidOperator);
                        } else if (hidOperator.isCoverpointExpression()) {
                            coverpointExpression[0] = hidOperator.lhValue;
                        }
                        return true;
                    }

                    @Override
                    public Class<HidOperator> getType() {
                        return HidOperator.class;
                    }
                });
            }
            int startOffset = declaration.getStartOffset();
            int startVirtualOffset = declaration.getStartVirtualOffset();
            int startLine = declaration.getStartLine();
            return HidEvalCenter.INSTANCE.createCoverpoint((IRfCoverpoint)namedElement, startOffset, startVirtualOffset, startLine, coverpointExpression[0], coverpointBins, coverpointDefaultBin[0], coverpointOptions);
        }

        private void visitHidHolder(IRfNamedElement namedElement, ActionBlockHeader header, List<IHidObject> progs) {
            this.guardian.checkBuildCanceled();
            IHidHolder ownHidHolder = namedElement.getHidHolder();
            if (ownHidHolder == null) {
                return;
            }
            ownHidHolder.visitHidObject(null, new HidEvalHidObjectFilterVisitor(progs, header, ELUtils.isVHDL(namedElement), this.guardian));
        }

        private static boolean isValidScope(IRfNamedElement namedElement) {
            if (namedElement instanceof IRfActionBlockElement) {
                return true;
            }
            if (namedElement instanceof IRfMethodElement) {
                return true;
            }
            if (namedElement instanceof IRfWaitElement && !((IRfWaitElement)namedElement).isWaitOrder()) {
                return true;
            }
            if (namedElement instanceof IRfAssertExpectElement && ((IRfAssertExpectElement)namedElement).isImmediateAssert()) {
                return true;
            }
            if (namedElement instanceof IRfAssertExpectElement && ((IRfAssertExpectElement)namedElement).isImmediateAssume()) {
                return true;
            }
            if (namedElement instanceof IRfAssertExpectElement && ((IRfAssertExpectElement)namedElement).isConcurrentAssertionStatement()) {
                return true;
            }
            return namedElement instanceof IRfPropertySequence;
        }

        private ActionBlockHeader extractActionBlockHeader(IRfActionBlockElement actionBlock, ArrayDeque<ActionBlockHeader> ifConditions, ArrayDeque<ActionBlockHeader> caseItemConditions) {
            boolean isCaseSensitive;
            if (actionBlock == null) {
                return null;
            }
            boolean bl = isCaseSensitive = LanguageKind.VLOG == actionBlock.getLanguageKind();
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.IF)) {
                List<IHidObject> conditions = actionBlock.computeConditionOperator(this.evaluator, this.guardian);
                if (conditions == null || conditions.isEmpty()) {
                    return null;
                }
                IHidObject condition = conditions.get(0);
                ActionBlockHeader ifHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.IF, condition, isCaseSensitive);
                ifConditions.addLast(ifHeader);
                return ifHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ELSIF)) {
                ActionBlockHeader ifHeader = ifConditions.pollLast();
                if (ifHeader == null) {
                    return null;
                }
                List<IHidObject> conditions = actionBlock.computeConditionOperator(this.evaluator, this.guardian);
                if (conditions == null || conditions.isEmpty()) {
                    return null;
                }
                IHidObject condition = conditions.get(0);
                ActionBlockHeader elsifHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.ELSIF, condition, isCaseSensitive);
                elsifHeader.statement = ifHeader.statement;
                ifConditions.addLast(elsifHeader);
                return elsifHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ELSE)) {
                ActionBlockHeader ifHeader = ifConditions.pollLast();
                if (ifHeader == null) {
                    return null;
                }
                ActionBlockHeader elseHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.ELSE, null, isCaseSensitive);
                elseHeader.statement = ifHeader.statement;
                return elseHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.CASE)) {
                List<IHidObject> conditions = actionBlock.computeConditionOperator(this.evaluator, this.guardian);
                if (conditions == null || conditions.isEmpty()) {
                    return null;
                }
                IHidObject condition = conditions.get(0);
                ActionBlockHeader caseHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.CASE, condition, isCaseSensitive);
                caseHeader.caseQualifier = IRfActionBlockElement.BlockQualifier.CASE;
                caseItemConditions.addLast(caseHeader);
                return caseHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.CASEZ)) {
                List<IHidObject> conditions = actionBlock.computeConditionOperator(this.evaluator, this.guardian);
                if (conditions == null || conditions.isEmpty()) {
                    return null;
                }
                IHidObject condition = conditions.get(0);
                ActionBlockHeader caseHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.CASEZ, condition, isCaseSensitive);
                caseHeader.caseQualifier = IRfActionBlockElement.BlockQualifier.CASEZ;
                caseItemConditions.addLast(caseHeader);
                return caseHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.CASEX)) {
                List<IHidObject> conditions = actionBlock.computeConditionOperator(this.evaluator, this.guardian);
                if (conditions == null || conditions.isEmpty()) {
                    return null;
                }
                IHidObject condition = conditions.get(0);
                ActionBlockHeader caseHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.CASEX, condition, isCaseSensitive);
                caseHeader.caseQualifier = IRfActionBlockElement.BlockQualifier.CASEX;
                caseItemConditions.addLast(caseHeader);
                return caseHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.RANDCASE)) {
                ActionBlockHeader caseHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.RANDCASE, null, isCaseSensitive);
                caseHeader.caseQualifier = IRfActionBlockElement.BlockQualifier.RANDCASE;
                caseItemConditions.addLast(caseHeader);
                return caseHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.CASE_ITEM)) {
                boolean isOthers;
                ActionBlockHeader prevCaseItemHeader = caseItemConditions.pollLast();
                if (prevCaseItemHeader == null) {
                    return null;
                }
                List<IHidObject> conditions = actionBlock.computeConditionOperator(this.evaluator, this.guardian);
                if (conditions == null) {
                    return null;
                }
                IHidObject condition = conditions.get(0);
                ActionBlockHeader caseItemHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.CASE_ITEM, condition, isCaseSensitive);
                caseItemHeader.caseQualifier = prevCaseItemHeader.caseQualifier;
                caseItemHeader.statement = prevCaseItemHeader.statement;
                boolean bl2 = isOthers = HidUtils.isHidImplicit(condition) && ((IHidImplicit)condition).isOthers();
                if (!isOthers) {
                    caseItemConditions.addLast(caseItemHeader);
                }
                return caseItemHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.RANDCASE_ITEM)) {
                ActionBlockHeader prevCaseItemHeader = caseItemConditions.pollLast();
                if (prevCaseItemHeader == null) {
                    return null;
                }
                List<IHidObject> conditions = actionBlock.computeConditionOperator(this.evaluator, this.guardian);
                if (conditions == null) {
                    return null;
                }
                IHidObject weight = conditions.get(0);
                if (weight == null) {
                    return null;
                }
                ActionBlockHeader caseItemHeader = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.RANDCASE_ITEM, weight, isCaseSensitive);
                caseItemHeader.caseQualifier = prevCaseItemHeader.caseQualifier;
                caseItemHeader.statement = prevCaseItemHeader.statement;
                caseItemConditions.addLast(caseItemHeader);
                return caseItemHeader;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FOREVER)) {
                return new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.FOREVER, null, isCaseSensitive);
            }
            if (actionBlock.hasBlockQualifier(LOOP_BLOCK_QUALIFIER)) {
                List<IHidObject> conditions = actionBlock.computeConditionOperator(this.evaluator, this.guardian);
                if (conditions == null || conditions.isEmpty()) {
                    return null;
                }
                if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.REPEAT)) {
                    return new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.REPEAT, conditions.get(1), isCaseSensitive);
                }
                if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.WHILE)) {
                    return new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.WHILE, conditions.get(1), isCaseSensitive);
                }
                if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.DO)) {
                    return new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.DO, conditions.get(1), isCaseSensitive);
                }
                if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FOREACH)) {
                    return new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.FOREACH, conditions.get(1), isCaseSensitive);
                }
                ActionBlockHeader header = new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.FOR, conditions.get(1), isCaseSensitive);
                header.forInit = conditions.get(0);
                header.forStep = conditions.get(2);
                return header;
            }
            ActionBlockHeader header = this.extractForkJoinHeader(actionBlock);
            if (header != null) {
                return header;
            }
            return null;
        }

        private ActionBlockHeader extractForkJoinHeader(IRfActionBlockElement actionBlock) {
            if (actionBlock == null) {
                return null;
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE)) {
                return new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE, null, true);
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY)) {
                return new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY, null, true);
            }
            if (actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN)) {
                return new ActionBlockHeader(IRfActionBlockElement.BlockQualifier.FORK_JOIN, null, true);
            }
            return null;
        }
    }

    private static class HidEvalHidObjectConstraintVisitor
    implements IHidVisitor<IHidObject> {
        private List<IHidObject> collected;
        private Map<IHidOperator, IHidOperator> conversionMap;
        private IHidEvaluationGuardian guardian;
        private ParserPath parserPath;
        private boolean isInterpreter;

        public HidEvalHidObjectConstraintVisitor(List<IHidObject> collected, Map<IHidOperator, IHidOperator> conversionMap, IHidEvaluationGuardian guardian) {
            this.collected = collected;
            this.conversionMap = conversionMap;
            this.guardian = guardian;
            if (guardian != null) {
                this.isInterpreter = guardian.isInterpreter();
            }
        }

        @Override
        public boolean visit(IHidObject hidObject) {
            this.guardian.checkBuildCanceled();
            switch (hidObject.getHidKind()) {
                case HID: {
                    if (!this.isInterpreter) {
                        return true;
                    }
                    Hid hid = (Hid)hidObject;
                    if (!hid.hasQualifier(HidQualifierCache.STATEMENT_QUALIFIER) || hid.hasAccesses()) {
                        return true;
                    }
                    HidOperator hidMethodPlaceholder = HidEvalCenter.INSTANCE.createMethodCallPlaceholder(hid, hid.getOffset(), hid.getVirtualOffset(), hid.getLine());
                    if (hidMethodPlaceholder != null) {
                        this.collected.add(hidMethodPlaceholder);
                    }
                    return true;
                }
                case ACCESS: {
                    if (!this.isInterpreter) {
                        return true;
                    }
                    Hid parentHid = ((HidAccess)hidObject).getParentHid();
                    if (!parentHid.hasQualifier(HidQualifierCache.STATEMENT_QUALIFIER) || !(hidObject instanceof IHidAccessArgs)) {
                        return true;
                    }
                    HidOperator hidAccessMethodPlaceHolder = HidEvalCenter.INSTANCE.createMethodCallPlaceholder(hidObject, parentHid.getOffset(), parentHid.getVirtualOffset(), parentHid.getLine());
                    if (hidAccessMethodPlaceHolder != null) {
                        this.collected.add(hidAccessMethodPlaceHolder);
                    }
                    return true;
                }
                case OPERATOR: {
                    IHidOperator operator = (IHidOperator)hidObject;
                    if (operator.isIfCondition() || operator.isForeachCondition() || operator.isRangeOrPartSelect() || operator.isExprOrBitSelect()) {
                        return true;
                    }
                    IHidOperator converted = HidEvalConverter.convertConstraintOperator(operator, this.conversionMap, this.parserPath);
                    if (converted != null) {
                        this.collected.add(converted);
                    }
                    return true;
                }
            }
            return true;
        }

        @Override
        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        @Override
        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private static class HidEvalHidObjectFilterVisitor
    implements IHidVisitor<IHidObject> {
        private List<IHidObject> collected;
        private ActionBlockHeader header;
        private IHidEvaluationGuardian guardian;
        private boolean isInterpreter;
        private IRfNamedElement scope;
        private boolean isVhdl;
        private ParserPath parserPath;
        private IRfDefElement nonExternFunctionScopeDef;

        public HidEvalHidObjectFilterVisitor(List<IHidObject> collected, ActionBlockHeader header, boolean isVhdl, IHidEvaluationGuardian guardian) {
            this.collected = collected;
            this.header = header;
            this.guardian = guardian;
            this.isVhdl = isVhdl;
            if (guardian != null) {
                this.isInterpreter = guardian.isInterpreter();
            }
        }

        boolean isInsideDef(HidOccurrence occ, int useIndex) {
            int useOffset;
            int defFileIndex;
            IRfDefElement declaration = this.nonExternFunctionScopeDef;
            if (declaration == null || this.scope == null) {
                return false;
            }
            IRfSingleLangProject rfProject = this.scope.getRfProject();
            ParserPath defParserPath = declaration.getParserPath();
            if (defParserPath == null) {
                return false;
            }
            int defIndex = this.scope.getDeclarationIndex();
            if (defIndex < 0) {
                return false;
            }
            if (useIndex > defIndex) {
                return false;
            }
            if (useIndex != defIndex) {
                return false;
            }
            int useFileIndex = rfProject.getFileIndex(this.parserPath);
            if (useFileIndex != (defFileIndex = rfProject.getFileIndex(defParserPath))) {
                return false;
            }
            int defStartLine = declaration.getStartLine();
            int defEndLine = declaration.getEndLine();
            int defEndOffset = declaration.getEndOffset();
            int defStartOffset = declaration.getStartOffset();
            int useLine = occ.getLine();
            int n = useOffset = occ.getVirtualOffset() > 0 ? -1 : occ.getOffset();
            if (useLine > defEndLine || useLine < defStartLine) {
                return false;
            }
            return useOffset == -1 || useOffset <= defEndOffset && useOffset >= defStartOffset;
        }

        @Override
        public boolean visit(IHidObject hidObject) {
            this.guardian.checkBuildCanceled();
            switch (hidObject.getHidKind()) {
                case HID: {
                    if (!this.isInterpreter) {
                        return true;
                    }
                    Hid hid = (Hid)hidObject;
                    if (!hid.hasQualifier(HidQualifierCache.STATEMENT_QUALIFIER) || hid.hasAccesses()) {
                        return true;
                    }
                    HidOperator hidMethodPlaceholder = HidEvalCenter.INSTANCE.createMethodCallPlaceholder(hid, hid.getOffset(), hid.getVirtualOffset(), hid.getLine());
                    if (hidMethodPlaceholder != null) {
                        this.collected.add(hidMethodPlaceholder);
                    }
                    return true;
                }
                case ACCESS: {
                    if (!this.isInterpreter && !this.isVhdl) {
                        return true;
                    }
                    Hid parentHid = ((HidAccess)hidObject).getParentHid();
                    if (!parentHid.hasQualifier(HidQualifierCache.STATEMENT_QUALIFIER) || !(hidObject instanceof IHidAccessArgs)) {
                        return true;
                    }
                    HidOperator hidAccessMethodPlaceHolder = HidEvalCenter.INSTANCE.createMethodCallPlaceholder(hidObject, parentHid.getOffset(), parentHid.getVirtualOffset(), parentHid.getLine());
                    if (hidAccessMethodPlaceHolder != null) {
                        this.collected.add(hidAccessMethodPlaceHolder);
                    }
                    return true;
                }
                case OPERATOR: {
                    HidOperator operator = (HidOperator)hidObject;
                    this.filterOperator(operator);
                    return true;
                }
            }
            return true;
        }

        private void filterOperator(HidOperator operator) {
            if (operator == null) {
                return;
            }
            if (operator.hasOccurrence(HidQualifierCache.ALL_DECLARATION_QUALIFIERS)) {
                List<IHidOperator> accepted = this.internalFilterDeclOperator(operator);
                if (accepted == null || accepted.isEmpty()) {
                    return;
                }
                int index = this.indexOfOperator(this.header == null ? null : this.header.forInit, operator);
                if (index >= 0) {
                    if (this.header.forInit instanceof HidEvalCenter.SeqBlockStatement) {
                        ((ArrayListContainer)((HidEvalCenter.SeqBlockStatement)this.header.forInit).getRHValues()).set(index, (IHidObject)accepted.get(0));
                    } else {
                        this.header.forInit = accepted.get(0);
                    }
                    return;
                }
                this.collected.addAll(accepted);
                return;
            }
            IHidOperator accepted = this.internalFilterOperator(operator);
            if (accepted == null) {
                return;
            }
            if (this.header != null) {
                if (this.header.condition == operator) {
                    return;
                }
                int index = this.indexOfOperator(this.header.forStep, operator);
                if (index >= 0) {
                    return;
                }
                index = this.indexOfOperator(this.header.forInit, operator);
                if (index >= 0) {
                    if (this.header.forInit instanceof HidEvalCenter.SeqBlockStatement) {
                        ((ArrayListContainer)((HidEvalCenter.SeqBlockStatement)this.header.forInit).getRHValues()).set(index, accepted);
                    } else {
                        this.header.forInit = accepted;
                    }
                    return;
                }
            }
            this.guardian.markEvaluated(accepted);
            this.collected.add(accepted);
        }

        private int indexOfOperator(IHidObject forInitOrStep, HidOperator operator) {
            if (forInitOrStep == null) {
                return -1;
            }
            if (forInitOrStep == operator) {
                return 0;
            }
            if (!(forInitOrStep instanceof HidEvalCenter.SeqBlockStatement)) {
                return -1;
            }
            ListContainer<IHidObject> rhValues = ((HidEvalCenter.SeqBlockStatement)forInitOrStep).getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return -1;
            }
            int i = 0;
            while (i < rhValues.size()) {
                IHidObject rhValue = rhValues.get(i);
                if (rhValue == operator) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private List<IHidOperator> internalFilterDeclOperator(HidOperator operator) {
            if (this.nonExternFunctionScopeDef != null && !this.isInsideDef(operator.getOccurrence(), operator.getUsageIndex())) {
                return null;
            }
            if (this.scope == null) {
                return Collections.singletonList(operator);
            }
            this.guardian.markEvaluated(operator);
            IHidObject lhValue = operator.getLHValue();
            List<IHidObject> initializations = null;
            if (HidUtils.isOperator(lhValue) && ((IHidOperator)lhValue).isDeclarationList()) {
                initializations = OptimizedUtils.asList(((IHidOperator)lhValue).getRHValues(), false);
            } else if (lhValue instanceof IHid) {
                initializations = Collections.singletonList(lhValue);
            }
            if (initializations == null || initializations.isEmpty()) {
                return Collections.singletonList(operator);
            }
            IHidObject initialValue = operator.getFirstRHValue();
            ArrayList<IHidOperator> collected = new ArrayList<IHidOperator>(initializations.size());
            for (IHidObject init : initializations) {
                IRfNamedElement field = this.scope.getLocalMember(null, HidUtils.toNiceString(init), null);
                if (!(field instanceof IRfFieldElement)) continue;
                HidOperator fieldDeclaration = HidEvalCenter.INSTANCE.createDeclarationWithInitialValue((IRfFieldElement)field, initialValue, operator.getOccurrence());
                collected.add(fieldDeclaration);
            }
            return collected;
        }

        private IHidOperator internalFilterOperator(IHidOperator operator) {
            IHidObject rhValue;
            if (this.isInterpreter && operator.hasOccurrence(HidQualifierCache.IS_WITH_CONTROL_QUALIFIER)) {
                return null;
            }
            if (operator.isAssignment() && (rhValue = operator.getFirstRHValue()) instanceof HidOperator && ((HidOperator)rhValue).isConditionalTernary()) {
                IHidObject assignLhValue = operator.getLHValue();
                ListContainer<IHidObject> assignRhValues = ((HidOperator)rhValue).getRHValues();
                IHidObject condition = ((HidOperator)rhValue).getLHValue();
                HidOperatorOccurrence occurrence = operator.getOccurrence();
                HidOperator assignOperator = operator.shallowCopy();
                if (assignRhValues != null && assignRhValues.size() == 2 && assignLhValue.checkEquals(assignRhValues.get(0))) {
                    assignOperator.setRHValues(assignRhValues.get(1));
                    XUtils.inlineIncrement("changed ternary operator to imply operator");
                    return HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id, null, occurrence.offset, occurrence.virtualOffset, occurrence.line, null, true, condition, assignOperator, null);
                }
                if (assignRhValues != null && assignRhValues.size() == 2 && assignLhValue.checkEquals(assignRhValues.get(1))) {
                    IHidBuilders builders = ((HidOperator)rhValue).getHidBuilders();
                    HidOperator notCondition = builders.buildNotOperator(condition, occurrence);
                    assignOperator.setRHValues(assignRhValues.get(0));
                    XUtils.inlineIncrement("changed ternary operator to imply operator");
                    return HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.IF_ELSE_STATEMENT.id, null, occurrence.offset, occurrence.virtualOffset, occurrence.line, null, true, notCondition, assignOperator, null);
                }
            }
            if (operator.hasOccurrence(HidQualifierCache.IS_BLOCKING_ASSIGN_QUALIFIER)) {
                return operator;
            }
            if (operator.hasOccurrence(HidQualifierCache.IS_NONBLOCKING_ASSIGN_QUALIFIER)) {
                return operator;
            }
            if (operator.hasOccurrence(HidQualifierCache.IS_PROCEDURAL_CONTINUOUS_ASSIGN_QUALIFIER)) {
                return operator;
            }
            if (operator.hasOccurrence(HidQualifierCache.ALL_BLOCKING_SELECT_ASSIGN_QUALIFIERS)) {
                return operator;
            }
            if (operator.hasOccurrence(HidQualifierCache.IS_NONBLOCKING_SELECT_ASSIGN_QUALIFIER)) {
                return operator;
            }
            if (operator.isReturnStatement()) {
                return operator;
            }
            if (operator.isBreakStatement()) {
                return operator;
            }
            if (operator.isExit()) {
                return operator;
            }
            if (operator.isContinueStatement()) {
                return operator;
            }
            if (operator.isNext()) {
                return operator;
            }
            if (operator.isIncrementOrDecrement() && operator.isComplete() && operator.hasOccurrence(HidOperatorQualifier.IS_STATEMENT)) {
                return operator;
            }
            if (operator.isLetBody()) {
                return operator;
            }
            if (operator.isReport()) {
                return operator;
            }
            if (this.isInterpreter && operator.isVoidCast()) {
                return operator;
            }
            if (this.isInterpreter && operator.isWaitStatement()) {
                return operator;
            }
            if (this.isInterpreter && operator.isVlogDelayControlStatement()) {
                if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                    return operator;
                }
                if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                    return HidEvalCenter.INSTANCE.createDelayedTriggerEvent((HidOperator)operator, operator.getOccurrence());
                }
                return HidEvalCenter.INSTANCE.createDelayedAssignment((HidOperator)operator, operator.getOccurrence());
            }
            if (this.isInterpreter && operator.isVlogDisableForkStatement()) {
                return operator;
            }
            if (this.isInterpreter && operator.isDisableStatement()) {
                return operator;
            }
            if (this.isInterpreter && operator.isVlogEventControl()) {
                if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
                    return operator;
                }
                if (operator.getOperatorKind() == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR) {
                    return HidEvalCenter.INSTANCE.createEventControlledTriggerEvent((HidOperator)operator, operator.getOccurrence(), true);
                }
                return HidEvalCenter.INSTANCE.createEventControlledAssignment((HidOperator)operator, operator.getOccurrence(), true);
            }
            if (this.isInterpreter && operator.isVhdlEventControl()) {
                return operator;
            }
            if (this.isInterpreter && operator.isVlogEventTrigger()) {
                return operator;
            }
            if (this.isInterpreter && operator.isForce()) {
                return operator;
            }
            if (this.isInterpreter && operator.isIfElseStatement()) {
                return operator;
            }
            if (this.isInterpreter && operator.getOperatorType() == IHidOperatorConstants.OperatorType.PROPERTY_SPEC.id) {
                return operator;
            }
            return null;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                Collection<? extends IRfDefElement> declarations;
                this.scope = ((HidHolder)holder).getScope();
                if (this.isInterpreter && this.scope instanceof IRfMethodElement && (declarations = this.scope.getDeclarations()).size() > 1) {
                    for (IRfDefElement iRfDefElement : this.scope.getDeclarations()) {
                        if (!iRfDefElement.isOutOfClassDefinition()) continue;
                        this.nonExternFunctionScopeDef = iRfDefElement;
                        break;
                    }
                }
            }
        }

        @Override
        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        @Override
        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

