/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidScopeResetWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public abstract class HidExpressionBuilder
implements IHidHolder,
HidQualifierCache {
    protected IHidHolder workingHidHolder;
    protected final IHidHolder hidsHolder;
    protected IHidHolder operatorsHolder;
    protected final LinkedList<IHidObject> gatheredValues;
    protected final LinkedList<Integer> gatheredStarts;
    protected boolean isForced;
    protected boolean isSetSecondaryScope;
    protected long qualifierSet;

    protected HidExpressionBuilder(IHidHolder hidsHolder, IHidHolder operatorsHolder, boolean isForced) {
        this.hidsHolder = hidsHolder;
        this.workingHidHolder = hidsHolder;
        this.operatorsHolder = operatorsHolder;
        this.gatheredStarts = new LinkedList();
        this.gatheredValues = new LinkedList();
        this.isForced = isForced;
    }

    public final void setQualifiers(long qualifiers) {
        this.qualifierSet = qualifiers;
    }

    public final long addQualifier(long qualifiers) {
        long prev = this.qualifierSet;
        this.qualifierSet |= qualifiers;
        return prev;
    }

    public final long getQualifiers() {
        return this.qualifierSet;
    }

    public final void addFirstValue(IHidObject value, int startOffset) {
        if (value == null) {
            return;
        }
        this.addFirstStart(startOffset);
        this.gatheredValues.addFirst(HidScopeResetWrapper.unwrap(value));
    }

    private void addFirstStart(int startOffset) {
        this.gatheredStarts.addFirst(startOffset);
    }

    public final void addValue(IHidObject value, int startOffset) {
        if (value == null) {
            return;
        }
        this.addStart(startOffset);
        this.gatheredValues.add(HidScopeResetWrapper.unwrap(value));
    }

    private void addStart(int startOffset) {
        this.gatheredStarts.add(startOffset);
    }

    public final IHidObject removeLastValue() {
        if (this.gatheredValues.isEmpty()) {
            return null;
        }
        this.removeLastStart();
        return this.gatheredValues.removeLast();
    }

    private final int removeLastStart() {
        if (this.gatheredStarts.isEmpty()) {
            return -1;
        }
        return this.gatheredStarts.removeLast();
    }

    public final IHidObject getLastValue() {
        if (this.gatheredValues.isEmpty()) {
            return null;
        }
        return this.gatheredValues.getLast();
    }

    private final int getLastStart() {
        if (this.gatheredStarts.isEmpty()) {
            return -1;
        }
        return this.gatheredStarts.getLast();
    }

    public final IHidObject getFirstValue() {
        if (this.gatheredValues.isEmpty()) {
            return null;
        }
        return this.gatheredValues.getFirst();
    }

    public final String getLastValueName() {
        return HidUtils.toNiceString(this.getLastValue());
    }

    public final String getFirstValueName() {
        return HidUtils.toNiceString(this.getFirstValue());
    }

    @NotNull
    public final List<IHidObject> getGatheredValues() {
        if (this.gatheredValues.isEmpty()) {
            return Collections.emptyList();
        }
        return this.gatheredValues;
    }

    @NotNull
    public final List<Integer> getGatheredStarts() {
        if (this.gatheredStarts.isEmpty()) {
            return Collections.emptyList();
        }
        return this.gatheredStarts;
    }

    public final void clear() {
        this.gatheredValues.clear();
        this.gatheredStarts.clear();
        this.resetWorkingHidHolder();
    }

    public final void resetWorkingHidHolder() {
        this.workingHidHolder = this.hidsHolder;
    }

    public final void overrideWorkingHidHolder(IHidHolder override) {
        this.workingHidHolder = override;
    }

    public final IHidHolder getWorkingHidsHolder() {
        return this.workingHidHolder;
    }

    public final IHidHolder getHidsHolder() {
        return this.hidsHolder;
    }

    public final IHidHolder getOperatorsHolder() {
        return this.operatorsHolder;
    }

    public final void setOperatorsHolder(IHidHolder operatorHolder) {
        this.operatorsHolder = operatorHolder;
    }

    public final boolean setSecondaryScope(boolean value) {
        boolean prevValue = this.isSetSecondaryScope;
        this.isSetSecondaryScope = value;
        return prevValue;
    }

    public final boolean isSetSecondaryScope() {
        return this.isSetSecondaryScope;
    }

    @Override
    public final boolean isEmpty() {
        return this.gatheredValues.isEmpty();
    }

    public final boolean isForced() {
        return this.isForced;
    }

    @Override
    public final boolean isHidObjectsEmpty() {
        return true;
    }

    public final int gatheredValuesSize() {
        return this.gatheredValues.size();
    }

    private final boolean isCompleteHid(IHidHolder lastValue) {
        return HidOperator.isValidOperand(HidScopeResetWrapper.unwrap(lastValue));
    }

    protected boolean ignoreVariadicOperator(long qualifiers, int operatorType, IHidObject singleElement) {
        return qualifiers == 0L && operatorType > IHidOperatorConstants.OperatorType.NO_TYPE.id;
    }

    @Override
    public final boolean isRegisterHid(boolean noReparseStack, int idType, IDVTFileInstance fileInstance) {
        return this.isForced || this.workingHidHolder.isRegisterHid(noReparseStack, idType, fileInstance);
    }

    @Override
    public final HidOperator addOperator(IHidHolderConstants.OperatorRequest operatorRequest) {
        return this.finishExpression(operatorRequest);
    }

    private final HidOperator finishExpression(IHidHolderConstants.OperatorRequest operatorRequest) {
        if (operatorRequest == null) {
            return null;
        }
        HidOperator operator = operatorRequest.operator;
        HidOperatorOccurrence occurrence = operatorRequest.occurrence;
        switch (operator.getOperatorKind()) {
            case VARIADIC_OPERATOR: {
                do {
                    if (!HidUtils.isVariadicOperand(this.getLastValue())) continue;
                    if (operator.getOpenBoundary() < 0) {
                        operator.setOpenBoundary(this.getLastStart());
                    }
                    IHidObject value = this.removeLastValue();
                    ListContainer<IHidObject> rhValues = operator.getRHValues();
                    if (rhValues == null || rhValues.isEmpty()) {
                        return null;
                    }
                    if (rhValues.size() == 1 && this.ignoreVariadicOperator(occurrence.getQualifiers(), operator.getOperatorType(), rhValues.get(0))) {
                        IHidObject hidObject = rhValues.get(0);
                        if (hidObject.getHidKind() == IHidObject.HidKind.OPERATOR) {
                            ((HidOperator)hidObject).setComplete(true);
                        }
                        this.addValue(hidObject, operator.getOpenBoundary());
                        return null;
                    }
                    if (!operator.addLHValue(value)) {
                        HidExpressionBuilder.debug("VARIADIC LEFT", operatorRequest);
                        return null;
                    }
                    this.addValue(operator, (operator = this.operatorsHolder.addOperator(operatorRequest)) != null ? operator.getOpenBoundary() : -1);
                    return operator;
                } while (operator.addRHValue(this.removeLastValue()));
                HidExpressionBuilder.debug("VARIADIC RIGHT", operatorRequest);
                return null;
            }
            case TERNARY_OPERATOR: {
                if (!operator.addRHValue(this.removeLastValue())) {
                    HidExpressionBuilder.debug("TERNARY", operatorRequest);
                    return null;
                }
            }
            case BINARY_OPERATOR: {
                if (!operator.addRHValue(this.removeLastValue())) {
                    HidExpressionBuilder.debug("BINARY", operatorRequest);
                    return null;
                }
            }
            case UNARY_OPERATOR: {
                if (operator.getOpenBoundary() < 0) {
                    operator.setOpenBoundary(this.getLastStart());
                }
                if (!operator.addLHValue(this.removeLastValue())) {
                    HidExpressionBuilder.debug("UNARY", operatorRequest);
                    return null;
                }
                this.addValue(operator, (operator = this.operatorsHolder.addOperator(operatorRequest)) != null ? operator.getOpenBoundary() : -1);
                return operator;
            }
        }
        return null;
    }

    @Override
    public final IHidHolder addIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
        return this.finishIdentifier(hidRequest, access);
    }

    private final IHidHolder finishIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
        if (hidRequest == null) {
            return this;
        }
        this.addAdditionalQualifiersToOccurrence(hidRequest.occurrence, access);
        IHidHolder lastValue = this.workingHidHolder.addIdentifier(hidRequest, access);
        if (this.isCompleteHid(lastValue)) {
            this.addValue(lastValue, hidRequest.openBoundary != -1 ? hidRequest.openBoundary : hidRequest.occurrence.getOffset());
            this.addAdditionalQualifiersToHid(lastValue);
            this.resetWorkingHidHolder();
            return this;
        }
        this.workingHidHolder = lastValue != null ? lastValue : this.hidsHolder;
        return this;
    }

    private void addAdditionalQualifiersToHid(IHidHolder lastValue) {
        if (this.qualifierSet == 0L) {
            return;
        }
        IHidObject lastHidObject = HidScopeResetWrapper.unwrap(lastValue);
        if (HidUtils.isHid(lastHidObject)) {
            ((Hid)lastHidObject).addQualifier(this.qualifierSet);
        } else if (HidUtils.isHidAccess(lastHidObject) && ((HidAccess)lastHidObject).getParentHid() != null) {
            ((HidAccess)lastHidObject).getParentHid().addQualifier(this.qualifierSet);
        }
    }

    private void addAdditionalQualifiersToOccurrence(HidOccurrence occurrence, HidAccess access) {
        if (occurrence == null || this.qualifierSet == 0L) {
            return;
        }
        if ((this.qualifierSet & FORMAL_PART_QUALIFIER) != 0L) {
            occurrence.addQualifier(FORMAL_PART_QUALIFIER);
        }
        if ((this.qualifierSet & PORT_MAP_FORMAL_PART) != 0L) {
            occurrence.addQualifier(PORT_MAP_FORMAL_PART);
        }
        if ((this.qualifierSet & GENERIC_MAP_FORMAL_PART) != 0L) {
            occurrence.addQualifier(GENERIC_MAP_FORMAL_PART);
        }
        if ((this.qualifierSet & ACTUAL_PART_QUALIFIER) != 0L) {
            occurrence.addQualifier(ACTUAL_PART_QUALIFIER);
        }
        if ((this.qualifierSet & IF_CASE_LOOP_EXPR_QUALIFIER) != 0L) {
            occurrence.addQualifier(IF_CASE_LOOP_EXPR_QUALIFIER);
        }
        if ((this.qualifierSet & EVENT_CONTROL_EXPR_QUALIFIER) != 0L) {
            occurrence.addQualifier(EVENT_CONTROL_EXPR_QUALIFIER);
        }
        if ((this.qualifierSet & DISABLE_QUALIFIER) != 0L) {
            occurrence.addQualifier(DISABLE_QUALIFIER);
        }
        if ((this.qualifierSet & TIME_EXPR_QUALIFIER) != 0L) {
            occurrence.addQualifier(TIME_EXPR_QUALIFIER);
        }
        if ((this.qualifierSet & TYPE_QUALIFIER) != 0L) {
            occurrence.addQualifier(TYPE_QUALIFIER);
        }
        if ((access == null || access.getAccessKind() == Integer.MIN_VALUE) && (this.qualifierSet & POTENTIAL_METHOD_CALL_QUALIFIER) != 0L) {
            occurrence.addQualifier(POTENTIAL_METHOD_CALL_QUALIFIER);
        }
        if ((access == null || access.getAccessKind() == Integer.MIN_VALUE) && (this.qualifierSet & STATEMENT_QUALIFIER) != 0L) {
            occurrence.addQualifier(STATEMENT_QUALIFIER);
        }
        if ((this.qualifierSet & BIND_TARGET_QUALIFIER) != 0L) {
            occurrence.addQualifier(BIND_TARGET_QUALIFIER);
        }
        if ((this.qualifierSet & SIGNATURE_TYPE_QUALIFIER) != 0L) {
            occurrence.addQualifier(SIGNATURE_TYPE_QUALIFIER);
        }
        if ((this.qualifierSet & ALIAS_TARGET) != 0L) {
            occurrence.addQualifier(ALIAS_TARGET);
        }
        if ((this.qualifierSet & EXTERNAL_PATH_NAME) != 0L) {
            occurrence.addQualifier(EXTERNAL_PATH_NAME);
        }
        if ((this.qualifierSet & IS_WITHIN_ASSERT_CONTROL_SYSTEM_TASK) != 0L) {
            occurrence.addQualifier(IS_WITHIN_ASSERT_CONTROL_SYSTEM_TASK);
        }
        if ((this.qualifierSet & IS_IN_PARAM_ASSIGNMENT_RH_SIDE) != 0L) {
            occurrence.addQualifier(IS_IN_PARAM_ASSIGNMENT_RH_SIDE);
        }
    }

    @Override
    public final void updateHolder(IHidHolder updater) {
        this.workingHidHolder.updateHolder(updater);
        if (this.operatorsHolder != this.workingHidHolder && updater instanceof HidHolder) {
            ((HidHolder)updater).clearOnlyHids();
            this.operatorsHolder.updateHolder(updater);
        }
    }

    @Override
    public void addIdentifiers(IHidHolder updater) {
        this.workingHidHolder.addIdentifiers(updater);
    }

    @Override
    public void addOperators(IHidHolder updater) {
        this.operatorsHolder.addOperators(updater);
    }

    @Override
    public final boolean removeIdentifier(String name) {
        return this.workingHidHolder.removeIdentifier(name);
    }

    public final void copySetupTo(HidExpressionBuilder clone) {
        if (clone == null) {
            return;
        }
        clone.isForced = this.isForced;
        clone.qualifierSet = this.qualifierSet;
        clone.isSetSecondaryScope = this.isSetSecondaryScope;
    }

    @Override
    public final IHidObject.HidKind getHidKind() {
        return IHidObject.HidKind.HOLDER;
    }

    @Override
    public final boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        return false;
    }

    private static final void debug(String operandOrdinal, IHidHolderConstants.OperatorRequest operatorRequest) {
    }
}

