/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfConfiguration;
import ro.amiq.dvt.model.reflection.IRfConfigurationRule;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidScopeResetWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolderConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.OptimizedLinkedHashMap;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public abstract class HidHolder
implements IHidHolder,
Serializable {
    private static final long serialVersionUID = 80L;
    protected Map<ParserPath, ListContainer<IHidObject>> hidObjectsMap;
    protected IRfNamedElement scope;

    protected HidHolder(IRfNamedElement scope) {
        this.scope = scope;
    }

    public IRfNamedElement getScope() {
        return this.scope;
    }

    public boolean isPrecompiledDbRelevantScope() {
        if (this.scope instanceof IRfInstanceElement) {
            return true;
        }
        if (this.scope instanceof IRfBlockElement) {
            return true;
        }
        if (this.scope instanceof IRfConfiguration) {
            return true;
        }
        if (this.scope instanceof IRfConfigurationRule) {
            return true;
        }
        if (this.scope instanceof IRfPackageElement) {
            return true;
        }
        if (this.scope instanceof IRfLibraryElement) {
            return true;
        }
        if (this.scope instanceof IRfCompositeTypeElement) {
            return true;
        }
        return this.scope instanceof IRfClassElement;
    }

    public void invalidate(ParserPath parserPath) {
        if (parserPath == null) {
            this.hidObjectsMap = null;
            return;
        }
        if (this.isHidObjectsEmpty()) {
            return;
        }
        ListContainer<IHidObject> hidsContainer = this.hidObjectsMap.get(parserPath);
        if (hidsContainer != null) {
            for (IHidObject hidObject : hidsContainer) {
                if (!(hidObject instanceof Hid)) continue;
                ((Hid)hidObject).deepClean();
            }
        }
        if (hidsContainer instanceof List) {
            ((List)((Object)hidsContainer)).clear();
        }
        this.hidObjectsMap.remove(parserPath);
    }

    @Override
    public boolean removeIdentifier(String name) {
        if (name == null) {
            return false;
        }
        if (this.isHidObjectsEmpty()) {
            return false;
        }
        boolean[] result = new boolean[1];
        this.cleanHidObjectsKind(hidObject -> {
            boolean isHit = hidObject instanceof Hid && name.equals(((Hid)hidObject).getName()) && !((Hid)hidObject).hasAccesses();
            blArray[0] = result[0] | isHit;
            return isHit;
        });
        return result[0];
    }

    @Override
    public boolean isRegisterHid(boolean noReparseStack, int idType, IDVTFileInstance fileInstance) {
        return true;
    }

    public Map<ParserPath, ListContainer<IHidObject>> getHidObjectsMap() {
        return this.hidObjectsMap;
    }

    @Override
    public boolean isHidObjectsEmpty() {
        return this.hidObjectsMap == null || this.hidObjectsMap.isEmpty();
    }

    @Override
    public void updateHolder(IHidHolder updater) {
        this.addIdentifiers(updater);
        this.addOperators(updater);
    }

    @Override
    public void addIdentifiers(IHidHolder updater) {
        if (!(updater instanceof HidHolder) || ((HidHolder)updater).isHidObjectsEmpty()) {
            return;
        }
        for (Map.Entry<ParserPath, ListContainer<IHidObject>> entryHids : ((HidHolder)updater).hidObjectsMap.entrySet()) {
            ParserPath parserPath = entryHids.getKey();
            for (IHidObject hidObject : entryHids.getValue()) {
                if (!(hidObject instanceof Hid)) continue;
                this.addHid((Hid)hidObject, parserPath);
            }
        }
    }

    public void addIdentifiersWithScope(IHidHolder updater, IRfNamedElement secondaryScope) {
        if (!(updater instanceof HidHolder) || ((HidHolder)updater).isHidObjectsEmpty()) {
            return;
        }
        for (Map.Entry<ParserPath, ListContainer<IHidObject>> entryHids : ((HidHolder)updater).hidObjectsMap.entrySet()) {
            ParserPath parserPath = entryHids.getKey();
            for (IHidObject hidObject : entryHids.getValue()) {
                if (!(hidObject instanceof Hid)) continue;
                hidObject = this.addHid((Hid)hidObject, parserPath);
                ((Hid)hidObject).setSecondaryScope(secondaryScope);
            }
        }
    }

    @Override
    public void addOperators(IHidHolder updater) {
        if (!(updater instanceof HidHolder) || ((HidHolder)updater).isHidObjectsEmpty()) {
            return;
        }
        for (Map.Entry<ParserPath, ListContainer<IHidObject>> entryOperators : ((HidHolder)updater).hidObjectsMap.entrySet()) {
            ParserPath parserPath = entryOperators.getKey();
            for (IHidObject hidObject : entryOperators.getValue()) {
                if (!(hidObject instanceof HidOperator)) continue;
                this.addOpi((HidOperator)hidObject, parserPath);
            }
        }
    }

    @Override
    public HidOperator addOperator(IHidHolderConstants.OperatorRequest operatorRequest) {
        if (operatorRequest == null) {
            return null;
        }
        HidOperator operator = this.addOpi(operatorRequest.operator, operatorRequest.parserPath);
        return operator;
    }

    @Override
    public IHidHolder addIdentifier(IHidHolderConstants.HidRequest hidRequest, HidAccess access) {
        if (hidRequest == null) {
            return null;
        }
        HidOccurrence occurrence = hidRequest.occurrence;
        if (access == null || access.getAccessKind() == Integer.MIN_VALUE) {
            occurrence.addQualifier(HidQualifierCache.LAST_QUALIFIER);
        }
        hidRequest.hid.addQualifier(occurrence.getQualifiers());
        Hid hid = this.addHid(hidRequest.hid, hidRequest.parserPath);
        if (access == null) {
            return HidScopeResetWrapper.of(hid);
        }
        HidAccess addedAccess = hid.addAccess(access);
        return addedAccess;
    }

    public boolean removeHidAtParserPath(Hid hid, ParserPath parserPath) {
        return this.removeHidObjectAtParserPath(hid, parserPath);
    }

    public boolean removeOpiAtParserPath(HidOperator operator, ParserPath parserPath) {
        return this.removeHidObjectAtParserPath(operator, parserPath);
    }

    private final <T extends IHidObject> boolean removeHidObjectAtParserPath(T hidObject, ParserPath parserPath) {
        ListContainer<IHidObject> newHidsContainer;
        if (this.hidObjectsMap == null || this.hidObjectsMap.isEmpty()) {
            return false;
        }
        ListContainer<IHidObject> hidsContainer = this.hidObjectsMap.get(parserPath);
        if (hidsContainer == (newHidsContainer = OptimizedUtils.listContainerRemove(hidsContainer, hidObject))) {
            return false;
        }
        if (newHidsContainer == null) {
            this.hidObjectsMap.remove(parserPath);
        } else {
            this.hidObjectsMap.put(parserPath, newHidsContainer);
        }
        return true;
    }

    public Hid addHid(Hid hid, ParserPath parserPath) {
        return this.addHidObject(hid, parserPath);
    }

    public HidOperator addOpi(HidOperator operator, ParserPath parserPath) {
        return this.addHidObject(operator, parserPath);
    }

    private final <T extends IHidObject> T addHidObject(T hidObject, ParserPath parserPath) {
        ListContainer<IHidObject> newHidsContainer;
        ListContainer<IHidObject> hidsContainer;
        if (this.hidObjectsMap == null) {
            this.hidObjectsMap = new OptimizedLinkedHashMap<ParserPath, ListContainer<IHidObject>>();
        }
        if ((hidsContainer = this.hidObjectsMap.get(parserPath)) != (newHidsContainer = OptimizedUtils.listContainerAdd(hidsContainer, hidObject))) {
            this.hidObjectsMap.put(parserPath, newHidsContainer);
        }
        return hidObject;
    }

    @Override
    public void deepClean() {
        this.scope = null;
        if (!this.isHidObjectsEmpty()) {
            for (ListContainer<IHidObject> hidsContainer : this.hidObjectsMap.values()) {
                if (hidsContainer == null) continue;
                for (IHidObject hidObject : hidsContainer) {
                    hidObject.deepClean();
                }
            }
        }
        this.hidObjectsMap = null;
    }

    public void clearOnlyHids() {
        this.cleanHidObjectsKind(hidObject -> hidObject instanceof Hid);
    }

    public void clearOnlyHidOperators() {
        this.cleanHidObjectsKind(hidObject -> hidObject instanceof HidOperator);
    }

    public final void cleanHidObjectsKind(Predicate<ListContainer<IHidObject>> criteria) {
        if (!this.resolveHidsCheck()) {
            return;
        }
        Iterator<Map.Entry<ParserPath, ListContainer<IHidObject>>> entryIterator = this.hidObjectsMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<ParserPath, ListContainer<IHidObject>> hidsMapEntry = entryIterator.next();
            ListContainer<IHidObject> hidObjectsContainer = hidsMapEntry.getValue();
            if (hidObjectsContainer instanceof List) {
                Iterator<IHidObject> iterator = hidObjectsContainer.iterator();
                while (iterator.hasNext()) {
                    IHidObject hidObject = iterator.next();
                    if (!criteria.test(hidObject)) continue;
                    iterator.remove();
                }
                if (hidObjectsContainer.isEmpty()) {
                    entryIterator.remove();
                    continue;
                }
                if (hidObjectsContainer.size() != 1) continue;
                hidsMapEntry.setValue(hidObjectsContainer.get(0));
                continue;
            }
            if (!criteria.test(hidObjectsContainer)) continue;
            entryIterator.remove();
        }
        this.resolveHidsCheck();
    }

    protected boolean resolveHidsCheck() {
        if (this.isHidObjectsEmpty()) {
            this.hidObjectsMap = null;
            return false;
        }
        return true;
    }

    public abstract LanguageKind getLanguageKind();

    @Override
    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor<?> visitor) {
        ParserPath parserPath;
        visitor.setHolder(this);
        if (this.isHidObjectsEmpty()) {
            return true;
        }
        for (Map.Entry<ParserPath, ListContainer<IHidObject>> entryOperators : this.hidObjectsMap.entrySet()) {
            parserPath = entryOperators.getKey();
            if (!visitor.visitParserPath(parserPath)) continue;
            for (IHidObject hidObject : entryOperators.getValue()) {
                if (!(hidObject instanceof HidOperator)) continue;
                visitor.setParserPath(parserPath);
                if (((HidOperator)hidObject).visitHidObject(rfProject, (IHidVisitor)visitor)) continue;
                return false;
            }
        }
        for (Map.Entry<ParserPath, ListContainer<IHidObject>> entryHids : this.hidObjectsMap.entrySet()) {
            parserPath = entryHids.getKey();
            if (!visitor.visitParserPath(parserPath)) continue;
            for (IHidObject hidObject : entryHids.getValue()) {
                if (!(hidObject instanceof Hid)) continue;
                visitor.setParserPath(parserPath);
                if (hidObject.visitHidObject(rfProject, visitor)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public IHidObject.HidKind getHidKind() {
        return IHidObject.HidKind.HOLDER;
    }
}

