/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.optimized.collections.ListContainer;

public class HidNameAndSelects {
    public final String name;
    public final ListContainer<XComputedSelect> selects;

    public HidNameAndSelects(String name) {
        this(name, null, null, null);
    }

    public HidNameAndSelects(String name, ListContainer<XComputedSelect> selects) {
        this.name = name;
        this.selects = selects;
    }

    public HidNameAndSelects(String name, ListContainer<HidAccess> accesses, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        this.name = name;
        if (accesses != null && evaluator != null) {
            ArrayList<IHidObject> localSelects = new ArrayList<IHidObject>(accesses.size());
            for (HidAccess hidObject : accesses) {
                List<IHidObject> candidates = hidObject.getSelects();
                if (candidates == null) continue;
                localSelects.addAll(candidates);
            }
            this.selects = localSelects.isEmpty() ? null : XValueHolderFactory.computeSelects(localSelects, null, evaluator, false, guardian, null);
        } else {
            this.selects = null;
        }
    }

    public String toString() {
        return "(" + this.name + ", " + (this.selects != null ? this.selects.toString() : "null") + ")";
    }
}

