/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.io.Serializable;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;

public class HidOccurrence
implements Comparable<HidOccurrence>,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final int offset;
    protected final int line;
    protected final int virtualOffset;
    protected final IReparseInfo reparseInfo;
    protected long qualifierSet;
    public static final HidOccurrence DUMMY_OCCURRENCE = new HidOccurrence(-1, -1, -1, 0L, null);

    public HidOccurrence(int offset, int virtualOffset, int line, long qualifiers, IReparseInfo reparseInfo) {
        this.offset = offset;
        this.line = line;
        this.virtualOffset = virtualOffset;
        this.reparseInfo = reparseInfo;
        this.qualifierSet |= qualifiers;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLine() {
        return this.line;
    }

    public final long getQualifiers() {
        return this.qualifierSet;
    }

    public int getVirtualOffset() {
        return this.virtualOffset;
    }

    public IReparseInfo getReparseInfo() {
        return this.reparseInfo;
    }

    public int getOffsetOutsideMacro() {
        if (this.getVirtualOffset() >= 0) {
            return -1;
        }
        return this.offset;
    }

    public void addQualifier(long qualifiers) {
        this.qualifierSet |= qualifiers;
    }

    public void removeQualifier(long qualifiers) {
        if (this.hasQualifier(qualifiers)) {
            this.qualifierSet -= qualifiers;
        }
    }

    public boolean hasQualifier(HidOperatorQualifier qualifier) {
        if (qualifier == null) {
            return this.qualifierSet == 0L;
        }
        return (this.qualifierSet & qualifier.value()) != 0L;
    }

    public boolean hasQualifier(HidQualifier qualifier) {
        if (qualifier == null) {
            return this.qualifierSet == 0L;
        }
        return (this.qualifierSet & qualifier.value()) != 0L;
    }

    public boolean hasQualifier(long qualifier) {
        return (this.qualifierSet & qualifier) != 0L;
    }

    @Override
    public int compareTo(HidOccurrence o) {
        if (this.offset > o.offset) {
            return 1;
        }
        if (this.offset < o.offset) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.line;
        result = 31 * result + this.offset;
        result = 31 * result + (int)(this.qualifierSet ^ this.qualifierSet >>> 32);
        result = 31 * result + this.getVirtualOffset();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HidOccurrence other = (HidOccurrence)obj;
        if (this.line != other.line) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.getVirtualOffset() != other.getVirtualOffset()) {
            return false;
        }
        return this.qualifierSet == other.qualifierSet;
    }

    public boolean equalsWithMetadata(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        HidOccurrence other = (HidOccurrence)obj;
        return !(this.getReparseInfo() == null ? other.getReparseInfo() != null : !this.getReparseInfo().equals(other.getReparseInfo()));
    }

    public final boolean hasReparseInfo() {
        return this.getReparseInfo() != null;
    }

    public final <T> T getReparseInfo(Class<T> type) {
        return type.cast(this.getReparseInfo());
    }

    public static HidOccurrence from(IRfDefElement declaration) {
        if (declaration == null) {
            return DUMMY_OCCURRENCE;
        }
        return new HidOccurrence(declaration.getStartOffset(), declaration.getStartVirtualOffset(), declaration.getStartLine(), 0L, null);
    }
}

