/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidBuilders;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.OptimizedUtils;

public abstract class HidOperator
implements IHidOperator,
Serializable {
    private static final long serialVersionUID = 20L;
    protected static final HidImplicit METHOD_CALL_IMPLICIT = HidUtils.makeStandInImplicit("", IHidImplicitConstants.ImplicitType.METHOD_CALL_LIMIT.id);
    protected static final HidImplicit SEQ_BLOCK_IMPLICIT = HidUtils.makeStandInImplicit("{", IHidImplicitConstants.ImplicitType.SEQ_BLOCK_LIMIT.id);
    protected static final HidImplicit RANDCASE_BLOCK_IMPLICIT = HidUtils.makeStandInImplicit("{", IHidImplicitConstants.ImplicitType.RANDCASE_BLOCK_LIMIT.id);
    public static final Comparator<HidOperator> OPERATOR_COMPARATOR = (o1, o2) -> {
        HidOperatorOccurrence marker1 = o1.getOccurrence();
        HidOperatorOccurrence marker2 = o2.getOccurrence();
        if (marker1 == null && marker2 == null) {
            return 0;
        }
        if (marker1 == null) {
            return -1;
        }
        if (marker2 == null) {
            return 1;
        }
        int usageIndex = o1.getUsageIndex();
        int otherUsageIndex = o2.getUsageIndex();
        if (usageIndex == -1) {
            if (otherUsageIndex == -1) {
                if (marker1.getOffset() == marker2.getOffset()) {
                    return marker1.getVirtualOffset() - marker2.getVirtualOffset();
                }
                return marker1.getOffset() - marker2.getOffset();
            }
            return -1;
        }
        if (otherUsageIndex == -1) {
            return 1;
        }
        if (usageIndex < otherUsageIndex) {
            return -1;
        }
        if (usageIndex > otherUsageIndex) {
            return 1;
        }
        if (marker1.getOffset() == marker2.getOffset()) {
            return marker1.getVirtualOffset() - marker2.getVirtualOffset();
        }
        return marker1.getOffset() - marker2.getOffset();
    };
    protected static final int default_VO = -1;
    protected static final IReparseInfo default_RI = null;
    protected static final int default_OVB = -1;
    protected static final int default_CVB = -1;
    protected int operatorType;
    protected IHidOperatorConstants.OperatorKind operatorKind;
    protected IHidObject lhValue;
    protected ListContainer<IHidObject> rhValues;
    protected String operatorText;
    private long qualifierSet;
    protected transient ISDataAbstract resolvedType;
    protected int line;
    protected int offset;
    protected int openBoundary;
    protected int closeBoundary;

    protected HidOperator(int operatorType, IHidOperatorConstants.OperatorKind operatorKind, String operatorText, int offset, int line, int openBoundary, int closeBoundary, long qualifiers) {
        this.operatorType = operatorType;
        this.operatorKind = operatorKind;
        this.operatorText = DVTStringUtil.intern(operatorText);
        this.setDefaultQualifierSet();
        this.qualifierSet |= qualifiers;
        this.line = line;
        this.offset = offset;
        this.openBoundary = openBoundary;
        this.closeBoundary = closeBoundary;
    }

    private void setDefaultQualifierSet() {
        this.qualifierSet = HidQualifierCache.IS_OPERATOR_COMPLETE_QUALIFIER;
    }

    @Override
    public int getOperatorType() {
        return this.operatorType;
    }

    @Override
    public ISDataAbstract getOperatorResolvedType() {
        return this.resolvedType;
    }

    @Override
    public boolean isOperatorResolved() {
        return this.resolvedType != null;
    }

    public void setOperatorResolvedType(ISDataAbstract firstDataType) {
        this.resolvedType = firstDataType;
    }

    @Override
    public IHidOperatorConstants.OperatorKind getOperatorKind() {
        return this.operatorKind;
    }

    public void setOperatorKind(IHidOperatorConstants.OperatorKind operatorKind) {
        this.operatorKind = operatorKind;
    }

    @Override
    public String getOperatorText() {
        return this.operatorText;
    }

    @Override
    public boolean addLHValue(IHidObject value, boolean markOperandAsIncomplete) {
        if (!HidOperator.isValidOperand(value)) {
            return false;
        }
        if (markOperandAsIncomplete && value instanceof HidOperator) {
            ((HidOperator)value).setComplete(false);
        }
        this.lhValue = value;
        return true;
    }

    public void setLHValue(IHidObject value) {
        this.addLHValue(value);
    }

    @Override
    public boolean addRHValue(IHidObject value, boolean markOperandAsIncomplete) {
        if (!HidOperator.isValidOperand(value)) {
            return false;
        }
        if (this.operatorKind == IHidOperatorConstants.OperatorKind.UNARY_OPERATOR) {
            return false;
        }
        if (this.operatorKind == IHidOperatorConstants.OperatorKind.BINARY_OPERATOR && this.rhValues != null && !this.rhValues.isEmpty()) {
            return false;
        }
        if (this.operatorKind == IHidOperatorConstants.OperatorKind.TERNARY_OPERATOR && this.rhValues != null && this.rhValues.size() >= 2) {
            return false;
        }
        if (markOperandAsIncomplete && value instanceof HidOperator) {
            ((HidOperator)value).setComplete(false);
        }
        this.rhValues = OptimizedUtils.listContainerAdd(this.rhValues, value);
        return true;
    }

    @Override
    public IHidObject getLHValue() {
        return this.lhValue;
    }

    @Override
    public ListContainer<IHidObject> getRHValues() {
        return this.rhValues;
    }

    public void setRHValues(ListContainer<IHidObject> rhValues) {
        this.rhValues = rhValues;
    }

    public void addQualifier(long qualifiers) {
        this.qualifierSet |= qualifiers;
    }

    public void removeQualifier(long qualifier) {
        if (this.hasQualifier(qualifier)) {
            this.qualifierSet -= qualifier;
        }
    }

    public boolean hasQualifier(long qualifier) {
        return (this.qualifierSet & qualifier) != 0L;
    }

    public static boolean isValidOperand(IHidObject value) {
        if (value == null) {
            return false;
        }
        switch (value.getHidKind()) {
            case HID: 
            case IMPLICIT: 
            case OPERATOR: {
                return true;
            }
            case ACCESS: {
                return ((HidAccess)value).getAccessKind() == Integer.MIN_VALUE;
            }
        }
        return false;
    }

    @Override
    public int getVirtualOffset() {
        return -1;
    }

    public int getOpenVirtualBoundary() {
        return -1;
    }

    public int getCloseVirtualBoundary() {
        return -1;
    }

    public IReparseInfo getReparseInfo() {
        return default_RI;
    }

    public MaskType[] getDriveStrength() {
        return null;
    }

    @Override
    @NotNull
    public HidOperatorOccurrence getOccurrence() {
        return new HidOperatorOccurrence(this.offset, this.getVirtualOffset(), this.line, this.openBoundary, this.getOpenVirtualBoundary(), this.closeBoundary, this.getCloseVirtualBoundary(), this.qualifierSet, this.getReparseInfo());
    }

    @Override
    public int xGetLine() {
        return this.line;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public HidOperatorOccurrence getOccurrence(long qualifier) {
        if (this.line == -1) {
            return null;
        }
        if (this.hasQualifier(qualifier)) {
            return this.getOccurrence();
        }
        return null;
    }

    @Override
    public boolean hasOccurrence(HidOperatorQualifier qualifier) {
        if (qualifier == null) {
            return this.qualifierSet == 0L || this.qualifierSet == HidQualifierCache.IS_OPERATOR_COMPLETE_QUALIFIER;
        }
        return (this.qualifierSet & qualifier.value()) != 0L;
    }

    @Override
    public boolean hasOccurrence(long qualifiers) {
        return this.hasQualifier(qualifiers);
    }

    public long getQualifiers() {
        return this.qualifierSet;
    }

    @Override
    public boolean isComplete() {
        return (this.qualifierSet & HidQualifierCache.IS_OPERATOR_COMPLETE_QUALIFIER) != 0L;
    }

    public boolean isHidden() {
        return (this.qualifierSet & HidQualifierCache.IS_HIDDEN_QUALIFIER) != 0L;
    }

    public void setComplete(boolean isComplete) {
        if (isComplete) {
            this.qualifierSet |= HidQualifierCache.IS_OPERATOR_COMPLETE_QUALIFIER;
        } else if ((this.qualifierSet & HidQualifierCache.IS_OPERATOR_COMPLETE_QUALIFIER) != 0L) {
            this.qualifierSet -= HidQualifierCache.IS_OPERATOR_COMPLETE_QUALIFIER;
        }
    }

    @Override
    public void deepClean() {
        this.line = -1;
        this.setDefaultQualifierSet();
        this.operatorText = null;
        this.lhValue = null;
        this.rhValues = null;
    }

    public final void setOpenBoundary(int openBoundary) {
        this.openBoundary = openBoundary;
    }

    public int getOpenBoundary() {
        return this.openBoundary;
    }

    public int getCloseBoundary() {
        return this.closeBoundary;
    }

    @Override
    @NotNull
    public Set<IHid> getLHHids(Set<HidFlatteningOption> options) {
        return HidUtils.flattenToHids(this.getLHValue(), options);
    }

    @Override
    @NotNull
    public Set<IHid> getRHHids(Set<HidFlatteningOption> options) {
        return HidUtils.flattenToHids(OptimizedUtils.asList(this.getRHValues(), false), options);
    }

    @NotNull
    protected ELParamValueScope evaluateOperandForSize(IHidObject hidObject, IHidEvaluator evaluator, IHidEvaluationGuardian guardian, IRfNamedElement origin) {
        return ELUtils.evaluateForSize(hidObject, evaluator, origin, guardian);
    }

    @NotNull
    protected ELParamValueScope evaluateOperand(IHidObject hidObject, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        return ELUtils.evaluate(hidObject, evaluator, context, guardian);
    }

    public ELParamValueScope evaluateAsLHValue(IHidObject hidObject, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (HidUtils.isOperator(hidObject) && ((HidOperator)hidObject).isVLOGConcatenation(true)) {
            IHidObject candidate;
            ListContainer<IHidObject> operands = ((HidOperator)hidObject).getRHValues();
            if (operands == null) {
                throw new UnknownHidObjectEvaluationException(hidObject);
            }
            int operandsSize = operands.size();
            if (operandsSize > 2 && HidUtils.isHidImplicit(candidate = operands.get(operandsSize - 2)) && ((HidImplicit)candidate).isConcatenationReplication()) {
                throw new UnknownHidObjectEvaluationException(hidObject);
            }
            IRfNamedElement origin = context != null ? context.getOrigin() : null;
            ArrayList<ELParamValueScope> numberList = new ArrayList<ELParamValueScope>();
            int i = operands.size() - 1;
            while (i >= 0) {
                IHidObject concatOperand = operands.get(i);
                ELParamValueScope concatOperandValue = this.evaluateAsLHValue(concatOperand, evaluator, BitVectorContext.of(origin, false), guardian);
                if (ELUtils.isUnsuccessfulEval(concatOperandValue)) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                numberList.add(concatOperandValue);
                --i;
            }
            return ELParamValueScope.of(new ELParamValues.ParamValueNumber.ParamValueNumber_ConcatList(numberList));
        }
        return this.evaluateOperand(hidObject, evaluator, context, guardian);
    }

    @NotNull
    public ELParamValueScope evaluateRHValueForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
        if (!this.hasRHValues()) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        return this.evaluateOperandForSize(this.rhValues.get(0), evaluator, guardian, origin);
    }

    @NotNull
    public ELParamValueScope evaluateRHValue(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
        if (!this.hasRHValues()) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        return this.evaluateOperand(this.rhValues.get(0), evaluator, context, guardian);
    }

    @Override
    public int getUsageIndex() {
        return -1;
    }

    @Override
    public int getInvocNumber() {
        return -1;
    }

    public void reverseRHValues() {
        if (this.rhValues == null || this.rhValues.size() < 2) {
            return;
        }
        ListContainer<IHidObject> prev = this.rhValues;
        this.rhValues = null;
        int i = prev.size() - 1;
        while (i >= 0) {
            this.addRHValue(prev.get(i), false);
            --i;
        }
    }

    @Override
    public void markElaborated() {
        this.addQualifier(HidQualifierCache.IS_ELABORATED_OPI_QUALIFIER);
        if (this.lhValue != null) {
            this.lhValue.markElaborated();
        }
        if (this.rhValues == null) {
            return;
        }
        for (IHidObject rhValue : this.rhValues) {
            if (rhValue == null) continue;
            rhValue.markElaborated();
        }
    }

    public boolean visitHidObject(IRfSingleLangProject rfProject, IHidVisitor visitor) {
        return !visitor.getType().isInstance(this) || visitor.visit(this);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.operatorKind.hashCode();
        result = 31 * result + this.operatorType;
        result = 31 * result + (this.lhValue != null ? System.identityHashCode(this.lhValue) : 0);
        if (this.rhValues != null) {
            for (IHidObject rhValue : this.rhValues) {
                result = 31 * result + System.identityHashCode(rhValue);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        int otherRhSize;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HidOperator)) {
            return false;
        }
        HidOperator other = (HidOperator)obj;
        if (this.isAssociation() || other.isAssociation()) {
            return false;
        }
        if (this.operatorKind != other.operatorKind) {
            return false;
        }
        if (this.operatorType != other.operatorType) {
            return false;
        }
        if (this.lhValue != other.lhValue) {
            return false;
        }
        int rhSize = this.rhValues != null ? this.rhValues.size() : 0;
        int n = otherRhSize = other.rhValues != null ? other.rhValues.size() : 0;
        if (rhSize != otherRhSize) {
            return false;
        }
        if (rhSize != 0) {
            Iterator<IHidObject> othersRhValueIterator = other.rhValues.iterator();
            for (IHidObject rhValue : this.rhValues) {
                IHidObject othersRhValue;
                if (rhValue == (othersRhValue = othersRhValueIterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkEquals(Object obj) {
        int otherRhSize;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HidOperator)) {
            return false;
        }
        HidOperator other = (HidOperator)obj;
        if (this.isAssociation() || other.isAssociation()) {
            return false;
        }
        if (this.operatorKind != other.operatorKind) {
            return false;
        }
        if (this.operatorType != other.operatorType) {
            return false;
        }
        if (!this.lhValue.checkEquals(other.lhValue)) {
            return false;
        }
        int rhSize = this.rhValues != null ? this.rhValues.size() : 0;
        int n = otherRhSize = other.rhValues != null ? other.rhValues.size() : 0;
        if (rhSize != otherRhSize) {
            return false;
        }
        if (rhSize != 0) {
            Iterator<IHidObject> othersRhValueIterator = other.rhValues.iterator();
            for (IHidObject rhValue : this.rhValues) {
                IHidObject othersRhValue;
                if (rhValue.checkEquals(othersRhValue = othersRhValueIterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean xEventTriggered(List<IHidOperator.XEventControlValue> prevValues, List<IHidOperator.XEventControlValue> currValues, IHidEvaluationGuardian guardian) {
        int i = 0;
        while (i < prevValues.size()) {
            IHidOperator.XEventControlValue prevValue = prevValues.get(i);
            IHidOperator.XEventControlValue currValue = currValues.get(i);
            if (currValue.isIffCondTrue) {
                if (currValue.isEvent) {
                    boolean equals = currValue.value.equals(prevValue.value);
                    if (!equals) {
                        if (currValue.eventKind != IHidOperator.XEventControlKind.CHANGE) {
                            guardian.logWarning("Unsupported edge control on event type object (assumming change)");
                        }
                        return true;
                    }
                } else if (currValue.value instanceof XValueHolder) {
                    IELParamValue equals = currValue.value.vlogEq(prevValue.value, null);
                    if (ELUtils.isFalse(equals)) {
                        if (currValue.eventKind != IHidOperator.XEventControlKind.CHANGE) {
                            guardian.logWarning("Unsupported edge control on class type object (assumming change)");
                        }
                        return true;
                    }
                } else {
                    BitSet prevValueMaskXZ;
                    BitSet currValueMaskXZ;
                    BigInteger prevValueInt;
                    BigInteger currValueInt = currValue.value.getDVTNumber().bigIntegerValue();
                    if (HidOperator.checkEdge(currValue.eventKind, currValueInt, prevValueInt = prevValue.value.getDVTNumber().bigIntegerValue(), currValueMaskXZ = XUtils.getMaskXZ(currValue.value, currValue.eventKind == IHidOperator.XEventControlKind.CHANGE), prevValueMaskXZ = XUtils.getMaskXZ(prevValue.value, currValue.eventKind == IHidOperator.XEventControlKind.CHANGE))) {
                        return true;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean checkEdge(IHidOperator.XEventControlKind edgeKind, BigInteger currValueInt, BigInteger prevValueInt, BitSet currValueMaskXZ, BitSet prevValueMaskXZ) {
        boolean currBit0 = currValueInt.testBit(0);
        boolean prevBit0 = prevValueInt.testBit(0);
        boolean currXZBit0 = currValueMaskXZ.get(0);
        boolean prevXZBit0 = prevValueMaskXZ.get(0);
        if (edgeKind == IHidOperator.XEventControlKind.POSEDGE) {
            boolean posedge;
            boolean bl = posedge = (currBit0 || currXZBit0) && !prevBit0 && !prevXZBit0 || currBit0 && !currXZBit0 && (!prevBit0 || prevXZBit0);
            if (posedge) {
                return true;
            }
        } else if (edgeKind == IHidOperator.XEventControlKind.NEGEDGE) {
            boolean negedge;
            boolean bl = negedge = (prevBit0 || prevXZBit0) && !currBit0 && !currXZBit0 || prevBit0 && !prevXZBit0 && (!currBit0 || currXZBit0);
            if (negedge) {
                return true;
            }
        } else if (edgeKind == IHidOperator.XEventControlKind.EDGE) {
            boolean edge;
            boolean bl = edge = prevBit0 != currBit0 && !prevXZBit0 && !currXZBit0 || prevXZBit0 && !currXZBit0 || !prevXZBit0 && currXZBit0;
            if (edge) {
                return true;
            }
        } else {
            boolean change;
            boolean bl = change = !prevValueInt.equals(currValueInt) || !prevValueMaskXZ.equals(currValueMaskXZ);
            if (change) {
                return true;
            }
        }
        return false;
    }

    @Override
    public HidOperator internalThis() {
        return this;
    }

    public String toString() {
        return HidUtils.toString(this, true, true);
    }

    public IHidBuilders getHidBuilders() {
        return HidUtils.DEFAULT_BUILDERS;
    }

    @Override
    public IHidObject.HidKind getHidKind() {
        return IHidObject.HidKind.OPERATOR;
    }

    public HidAccess getHidAccess(IHidObject iHidObject, int i) {
        return null;
    }
}

