/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.model.reflection.semantic.extension;

import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrenceBounds;

public class HidOperatorOccurrence
extends HidOccurrence {
    private static final long serialVersionUID = 1L;
    protected final int openBoundary;
    protected final int closeBoundary;
    protected final int openVirtualBoundary;
    protected final int closeVirtualBoundary;
    public static final HidOperatorOccurrence DUMMY_OCCURRENCE = new HidOperatorOccurrence(-1, -1, -1, 0L, null);

    public HidOperatorOccurrence(int offset, int virtualOffset, int line, long qualifiers, IReparseInfo reparseInfo) {
        this(offset, virtualOffset, line, -1, -1, -1, -1, qualifiers, reparseInfo);
    }

    public HidOperatorOccurrence(int offset, int virtualOffset, int line, HidOccurrenceBounds bounds, long qualifiers, IReparseInfo reparseInfo) {
        this(offset, virtualOffset, line, bounds.openBoundary, bounds.openVirtualBoundary, bounds.closeBoundary, bounds.closeVirtualBoundary, qualifiers, reparseInfo);
    }

    public HidOperatorOccurrence(HidOperatorOccurrence other) {
        this(other.offset, other.getVirtualOffset(), other.line, other.openBoundary, other.getOpenVirtualBoundary(), other.closeBoundary, other.getCloseVirtualBoundary(), other.qualifierSet, other.getReparseInfo());
    }

    public HidOperatorOccurrence(int offset, int virtualOffset, int line, int openBoundary, int openVirtualBoundary, int closeBoundary, int closeVirtualBoundary, long qualifiers, IReparseInfo reparseInfo) {
        super(offset, virtualOffset, line, qualifiers, reparseInfo);
        this.openBoundary = openBoundary;
        this.closeBoundary = closeBoundary;
        this.openVirtualBoundary = openVirtualBoundary;
        this.closeVirtualBoundary = closeVirtualBoundary;
    }

    public int getCloseBoundary() {
        return this.closeBoundary;
    }

    public int getOpenVirtualBoundary() {
        return this.openVirtualBoundary;
    }

    public int getCloseVirtualBoundary() {
        return this.closeVirtualBoundary;
    }

    public boolean contains(int offset, int virtualOffset) {
        if (offset == this.openBoundary && offset == this.closeBoundary) {
            return this.getOpenVirtualBoundary() < virtualOffset && this.getCloseVirtualBoundary() > virtualOffset;
        }
        return this.openBoundary < offset && this.closeBoundary > offset;
    }

    public final int getOpenBoundary() {
        return this.openBoundary;
    }

    public final int getOpenBoundaryOutsideMacro() {
        return this.getVirtualOffset() == -1 ? this.openBoundary : -1;
    }

    public final int getCloseBoundaryOutsideMacro() {
        return this.getVirtualOffset() == -1 ? this.closeBoundary : -1;
    }

    public final HidOccurrenceBounds getBounds() {
        return new HidOccurrenceBounds(this.openBoundary, this.getOpenVirtualBoundary(), this.closeBoundary, this.getCloseVirtualBoundary());
    }

    public static HidOperatorOccurrence from(IRfDefElement declaration) {
        if (declaration == null) {
            return DUMMY_OCCURRENCE;
        }
        return new HidOperatorOccurrence(declaration.getStartOffset(), declaration.getStartVirtualOffset(), declaration.getStartLine(), 0L, null);
    }
}

